/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.realms;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.realms.ClientInfoModel;
import io.olvid.keycloak.classes.models.realms.KeyPropertiesModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RealmConfigModel {
    @JsonProperty(value="revocationAllowed")
    boolean revocationAllowed;
    @JsonProperty(value="transferRestricted")
    boolean transferRestricted;
    @JsonProperty(value="admin")
    boolean admin;
    @JsonProperty(value="olvid")
    boolean olvid;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="olvidClient")
    String olvidClient;
    @JsonProperty(value="clientsInfo")
    List<ClientInfoModel> clientsInfo;
    @JsonProperty(value="keyChoosen")
    String keyChoosen;
    @JsonProperty(value="keyId")
    List<KeyPropertiesModel> keyId;
    @JsonProperty(value="olvidServerUrl")
    String olvidServerUrl;
    @JsonProperty(value="keycloakApiKey")
    String keycloakApiKey;
    @JsonProperty(value="keycloakServerUrl")
    String keycloakServerUrl;

    public boolean isRevocationAllowed() {
        return this.revocationAllowed;
    }

    public void setRevocationAllowed(boolean revocationAllowed) {
        this.revocationAllowed = revocationAllowed;
    }

    public boolean isTransferRestricted() {
        return this.transferRestricted;
    }

    public void setTransferRestricted(boolean transferRestricted) {
        this.transferRestricted = transferRestricted;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isOlvid() {
        return this.olvid;
    }

    public void setOlvid(boolean olvid) {
        this.olvid = olvid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOlvidClient() {
        return this.olvidClient;
    }

    public void setOlvidClient(String olvidClient) {
        this.olvidClient = olvidClient;
    }

    public List<ClientInfoModel> getClientsInfo() {
        return this.sortClientsInfoList();
    }

    public void setClientsInfo(List<ClientInfoModel> clientsInfo) {
        this.clientsInfo = clientsInfo;
    }

    public String getKeyChoosen() {
        return this.keyChoosen;
    }

    public void setKeyChoosen(String keyChoosen) {
        this.keyChoosen = keyChoosen;
    }

    public List<KeyPropertiesModel> getKeyId() {
        return this.sortKeysList();
    }

    public void setKeyId(List<KeyPropertiesModel> keyId) {
        this.keyId = keyId;
    }

    public String getOlvidServerUrl() {
        return this.olvidServerUrl;
    }

    public void setOlvidServerUrl(String olvidServerUrl) {
        this.olvidServerUrl = olvidServerUrl;
    }

    public String getKeycloakApiKey() {
        return this.keycloakApiKey;
    }

    public void setKeycloakApiKey(String keycloakApiKey) {
        this.keycloakApiKey = keycloakApiKey;
    }

    public String getKeycloakServerUrl() {
        return this.keycloakServerUrl;
    }

    public void setKeycloakServerUrl(String keycloakServerUrl) {
        this.keycloakServerUrl = keycloakServerUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmConfigModel that = (RealmConfigModel)o;
        return this.revocationAllowed == that.revocationAllowed && this.transferRestricted == that.transferRestricted && this.admin == that.admin && this.olvid == that.olvid && Objects.equals(this.name, that.name) && Objects.equals(this.olvidClient, that.olvidClient) && Objects.equals(this.clientsInfo, that.clientsInfo) && Objects.equals(this.keyChoosen, that.keyChoosen) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.olvidServerUrl, that.olvidServerUrl) && Objects.equals(this.keycloakApiKey, that.keycloakApiKey) && Objects.equals(this.keycloakServerUrl, that.keycloakServerUrl);
    }

    public int hashCode() {
        return Objects.hash(this.revocationAllowed, this.transferRestricted, this.admin, this.olvid, this.name, this.olvidClient, this.clientsInfo, this.keyChoosen, this.keyId, this.olvidServerUrl, this.keycloakApiKey, this.keycloakServerUrl);
    }

    public List<KeyPropertiesModel> sortKeysList() {
        Collections.sort(this.keyId, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return this.keyId;
    }

    public List<ClientInfoModel> sortClientsInfoList() {
        Collections.sort(this.clientsInfo, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return this.clientsInfo;
    }

    public String toString() {
        return "RealmConfigModel{revocationAllowed=" + this.revocationAllowed + ", transferRestricted=" + this.transferRestricted + ", admin=" + this.admin + ", olvid=" + this.olvid + ", name='" + this.name + "', olvidClient='" + this.olvidClient + "', clientsInfo=" + String.valueOf(this.clientsInfo) + ", keyChoosen='" + this.keyChoosen + "', keyId=" + String.valueOf(this.keyId) + ", olvidServerUrl='" + this.olvidServerUrl + "', keycloakApiKey='" + this.keycloakApiKey + "', keycloakServerUrl='" + this.keycloakServerUrl + "'}";
    }
}

