/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.groups;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.groups.GroupAttributesModel;
import io.olvid.keycloak.classes.models.users.CustomUserModel;
import io.olvid.keycloak.rest.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.models.GroupModel;

public class GroupUserModel {
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="attributes")
    public GroupAttributesModel attributes;
    @JsonProperty(value="parentId")
    public String parentId;
    @JsonProperty(value="parentName")
    public String parentName;
    @JsonProperty(value="path")
    public List<String> path;
    @JsonProperty(value="pathString")
    public String pathString;
    @JsonProperty(value="olvidGroup")
    public Boolean olvidGroup;
    @JsonProperty(value="olvidManaged")
    public Boolean olvidManaged;
    @JsonProperty(value="duplicateGroup")
    public Boolean duplicateGroup;
    @JsonProperty(value="children")
    public List<GroupUserModel> children;
    @JsonProperty(value="hasChild")
    public Boolean hasChild;
    @JsonProperty(value="isGroupUser")
    public Boolean isGroupUser;
    @JsonProperty(value="groupMembers")
    public List<CustomUserModel> groupMembers;
    @JsonProperty(value="countGroupMembers")
    public long countGroupMembers;
    @JsonProperty(value="loadMoreOffset")
    public long loadMoreOffset;
    @JsonProperty(value="countGroupMembersFiltered")
    public long countGroupMembersFiltered;
    @JsonProperty(value="countMembersWithoutPassword")
    public long countMembersWithoutPassword;
    @JsonProperty(value="countMembersAwaitingActivation")
    public long countMembersAwaitingActivation;
    @JsonProperty(value="countMembersFederated")
    public long countMembersFederated;
    @JsonProperty(value="countMembersIdentityProvider")
    public long countMembersIdentityProvider;
    @JsonProperty(value="countMembersBots")
    public long countMembersBots;
    @JsonProperty(value="avatarUrl")
    public String avatarUrl;
    @JsonProperty(value="avatarUuid")
    public byte[] avatarUuid;
    @JsonIgnoreProperties
    @JsonProperty(value="_rowVariant")
    String _rowVariant;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupAttributesModel getAttributes() {
        return this.attributes;
    }

    public void setAttributes(GroupAttributesModel attributes) {
        this.attributes = attributes;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public String getPathString() {
        return this.pathString;
    }

    public void setPathString(String pathString) {
        this.pathString = pathString;
    }

    public Boolean getOlvidGroup() {
        return this.olvidGroup;
    }

    public void setOlvidGroup(Boolean olvidGroup) {
        this.olvidGroup = olvidGroup;
    }

    public Boolean getOlvidManaged() {
        return this.olvidManaged;
    }

    public void setOlvidManaged(Boolean olvidManaged) {
        this.olvidManaged = olvidManaged;
    }

    public Boolean getDuplicateGroup() {
        return this.duplicateGroup;
    }

    public void setDuplicateGroup(Boolean duplicateGroup) {
        this.duplicateGroup = duplicateGroup;
    }

    public List<GroupUserModel> getChildren() {
        return this.children;
    }

    public void setChildren(List<GroupUserModel> children) {
        this.children = children;
    }

    public Boolean getHasChild() {
        return this.hasChild;
    }

    public void setHasChild(Boolean hasChild) {
        this.hasChild = hasChild;
    }

    public List<CustomUserModel> getGroupMembers() {
        return this.groupMembers;
    }

    public void setGroupMembers(List<CustomUserModel> groupMembers) {
        this.groupMembers = groupMembers;
    }

    public long getCountGroupMembers() {
        return this.countGroupMembers;
    }

    public void setCountGroupMembers(long countGroupMembers) {
        this.countGroupMembers = countGroupMembers;
    }

    public long getCountMembersWithoutPassword() {
        return this.countMembersWithoutPassword;
    }

    public void setCountMembersWithoutPassword(long countMembersWithoutPassword) {
        this.countMembersWithoutPassword = countMembersWithoutPassword;
    }

    public long getCountMembersAwaitingActivation() {
        return this.countMembersAwaitingActivation;
    }

    public void setCountMembersAwaitingActivation(long countMembersAwaitingActivation) {
        this.countMembersAwaitingActivation = countMembersAwaitingActivation;
    }

    public long getCountMembersFederated() {
        return this.countMembersFederated;
    }

    public void setCountMembersFederated(long countMembersFederated) {
        this.countMembersFederated = countMembersFederated;
    }

    public long getCountMembersIdentityProvider() {
        return this.countMembersIdentityProvider;
    }

    public void setCountMembersIdentityProvider(long countMembersIdentityProvider) {
        this.countMembersIdentityProvider = countMembersIdentityProvider;
    }

    public long getCountMembersBots() {
        return this.countMembersBots;
    }

    public void setCountMembersBots(long countMembersBots) {
        this.countMembersBots = countMembersBots;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public byte[] getAvatarUuid() {
        return this.avatarUuid;
    }

    public void setAvatarUuid(byte[] avatarUuid) {
        this.avatarUuid = avatarUuid;
    }

    public long getCountGroupMembersFiltered() {
        return this.countGroupMembersFiltered;
    }

    public void setCountGroupMembersFiltered(long countGroupMembersFiltered) {
        this.countGroupMembersFiltered = countGroupMembersFiltered;
    }

    public Boolean getIsGroupUser() {
        return this.isGroupUser;
    }

    public void setIsGroupUser(Boolean groupUser) {
        this.isGroupUser = groupUser;
    }

    public long getLoadMoreOffset() {
        return this.loadMoreOffset;
    }

    public void setLoadMoreOffset(long loadMoreOffset) {
        this.loadMoreOffset = loadMoreOffset;
    }

    public Boolean getGroupUser() {
        return this.isGroupUser;
    }

    public void setGroupUser(Boolean groupUser) {
        this.isGroupUser = groupUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUserModel that = (GroupUserModel)o;
        return this.countGroupMembers == that.countGroupMembers && this.loadMoreOffset == that.loadMoreOffset && this.countGroupMembersFiltered == that.countGroupMembersFiltered && this.countMembersWithoutPassword == that.countMembersWithoutPassword && this.countMembersAwaitingActivation == that.countMembersAwaitingActivation && this.countMembersFederated == that.countMembersFederated && this.countMembersIdentityProvider == that.countMembersIdentityProvider && this.countMembersBots == that.countMembersBots && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.parentName, that.parentName) && Objects.equals(this.path, that.path) && Objects.equals(this.pathString, that.pathString) && Objects.equals(this.olvidGroup, that.olvidGroup) && Objects.equals(this.olvidManaged, that.olvidManaged) && Objects.equals(this.duplicateGroup, that.duplicateGroup) && Objects.equals(this.children, that.children) && Objects.equals(this.hasChild, that.hasChild) && Objects.equals(this.isGroupUser, that.isGroupUser) && Objects.equals(this.groupMembers, that.groupMembers) && Objects.equals(this.avatarUrl, that.avatarUrl) && Objects.deepEquals(this.avatarUuid, that.avatarUuid) && Objects.equals(this._rowVariant, that._rowVariant);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.attributes, this.parentId, this.parentName, this.path, this.pathString, this.olvidGroup, this.olvidManaged, this.duplicateGroup, this.children, this.hasChild, this.isGroupUser, this.groupMembers, this.countGroupMembers, this.loadMoreOffset, this.countGroupMembersFiltered, this.countMembersWithoutPassword, this.countMembersAwaitingActivation, this.countMembersFederated, this.countMembersIdentityProvider, this.countMembersBots, this.avatarUrl, Arrays.hashCode(this.avatarUuid), this._rowVariant);
    }

    public String toString() {
        return "GroupUserModel{id='" + this.id + "', name='" + this.name + "', attributes=" + String.valueOf(this.attributes) + ", parentId='" + this.parentId + "', parentName='" + this.parentName + "', path=" + String.valueOf(this.path) + ", pathString='" + this.pathString + "', olvidGroup=" + this.olvidGroup + ", olvidManaged=" + this.olvidManaged + ", duplicateGroup=" + this.duplicateGroup + ", children=" + String.valueOf(this.children) + ", hasChild=" + this.hasChild + ", isGroupUser=" + this.isGroupUser + ", groupMembers=" + String.valueOf(this.groupMembers) + ", countGroupMembers=" + this.countGroupMembers + ", loadMoreOffset=" + this.loadMoreOffset + ", countGroupMembersFiltered=" + this.countGroupMembersFiltered + ", countMembersWithoutPassword=" + this.countMembersWithoutPassword + ", countMembersAwaitingActivation=" + this.countMembersAwaitingActivation + ", countMembersFederated=" + this.countMembersFederated + ", countMembersIdentityProvider=" + this.countMembersIdentityProvider + ", countMembersBots=" + this.countMembersBots + ", avatarUrl='" + this.avatarUrl + "', avatarUuid=" + Arrays.toString(this.avatarUuid) + ", _rowVariant='" + this._rowVariant + "'}";
    }

    public static GroupUserModel initGroupUsers(GroupModel group) {
        GroupUserModel groupUsers = new GroupUserModel();
        groupUsers.setAttributes(new GroupAttributesModel());
        groupUsers.setChildren(null);
        groupUsers.setGroupMembers(null);
        groupUsers.setCountGroupMembers(0L);
        groupUsers.setCountMembersWithoutPassword(0L);
        groupUsers.setCountMembersAwaitingActivation(0L);
        groupUsers.setCountMembersFederated(0L);
        groupUsers.setCountMembersIdentityProvider(0L);
        groupUsers.setCountMembersBots(0L);
        groupUsers.setIsGroupUser(false);
        groupUsers.setLoadMoreOffset(0L);
        groupUsers.setId(group.getId());
        groupUsers.setName(group.getName());
        String description = Utils.getGroupAttribute(group, "olvid-description");
        groupUsers.attributes.setDescription(description != null ? Collections.singletonList(description) : Collections.emptyList());
        String customName = Utils.getGroupAttribute(group, "olvid-name");
        groupUsers.attributes.setOlvidName(customName != null ? Collections.singletonList(customName) : Collections.emptyList());
        groupUsers.setPath(Utils.computeGroupPath(group));
        groupUsers.setPathString(Utils.computeGroupPathString(groupUsers.path));
        groupUsers.setOlvidGroup(Utils.isOlvidGroup(group));
        groupUsers.setOlvidManaged(Utils.getGroupBooleanAttribute(group, "olvid-managed"));
        groupUsers.setHasChild(Utils.groupHasChildren(group));
        return groupUsers;
    }
}

