/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.externalLinks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidExternalLink;
import io.olvid.keycloak.rest.ConfigurationLinkHelper;
import jakarta.persistence.EntityManager;
import java.util.Objects;
import org.keycloak.models.RealmModel;

public class ExternalLinkModel {
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="tag")
    public String tag;
    @JsonProperty(value="key_value")
    public String key_value;
    @JsonProperty(value="link")
    public String link;
    @JsonProperty(value="isRevoked")
    public Boolean isRevoked;
    @JsonProperty(value="activatedDate")
    public long activatedDate;
    @JsonProperty(value="createDate")
    public long createDate;
    @JsonProperty(value="revokedDate")
    public long revokedDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getKey_value() {
        return this.key_value;
    }

    public void setKey_value(String key_value) {
        this.key_value = key_value;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Boolean getRevoked() {
        return this.isRevoked;
    }

    public void setRevoked(Boolean revoked) {
        this.isRevoked = revoked;
    }

    public long getActivatedDate() {
        return this.activatedDate;
    }

    public void setActivatedDate(long activatedDate) {
        this.activatedDate = activatedDate;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(long createDate) {
        this.createDate = createDate;
    }

    public long getRevokedDate() {
        return this.revokedDate;
    }

    public void setRevokedDate(long revokedDate) {
        this.revokedDate = revokedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalLinkModel that = (ExternalLinkModel)o;
        return this.activatedDate == that.activatedDate && this.createDate == that.createDate && this.revokedDate == that.revokedDate && Objects.equals(this.id, that.id) && Objects.equals(this.tag, that.tag) && Objects.equals(this.key_value, that.key_value) && Objects.equals(this.link, that.link) && Objects.equals(this.isRevoked, that.isRevoked);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.key_value, this.link, this.isRevoked, this.activatedDate, this.createDate, this.revokedDate);
    }

    public String toString() {
        return "ExternalLinkModel{id='" + this.id + "', tag='" + this.tag + "', key_value='" + this.key_value + "', link='" + this.link + "', isRevoked=" + this.isRevoked + ", activatedDate=" + this.activatedDate + ", createDate=" + this.createDate + ", revokedDate=" + this.revokedDate + "}";
    }

    public ExternalLinkModel initExternalLinkModel(EntityManager em, RealmModel realm, ObjectMapper objectMapper, OlvidExternalLink data) {
        ExternalLinkModel model = new ExternalLinkModel();
        model.setKey_value(data.getKey());
        String link = "";
        try {
            link = ConfigurationLinkHelper.generateConfigurationLink(em, realm, data.getKey());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        model.setId(data.getId());
        model.setLink(link);
        model.setTag(data.getTag());
        model.setCreateDate(data.getCreateDate());
        model.setRevoked(data.getRevoked());
        try {
            model.setActivatedDate(data.getActivatedDate());
        }
        catch (Exception e) {
            model.setActivatedDate(0L);
        }
        try {
            model.setRevokedDate(data.getRevokedDate());
        }
        catch (Exception e) {
            model.setRevokedDate(0L);
        }
        return model;
    }
}

