/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.circleVisibility;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.CirclesVisibilityRulesModel;
import io.olvid.keycloak.classes.models.users.CustomUserBasicModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserEntity;

public class OlvidCircleVisibilityRulesListByVisibilityModel {
    protected static final Logger logger = Logger.getLogger(OlvidCircleVisibilityRulesListByVisibilityModel.class);
    @JsonProperty(value="circleVisibilityRulesListFromNoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromNoContact;
    @JsonProperty(value="circleVisibilityRulesListFromSeeNoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeNoContact;
    @JsonProperty(value="circleVisibilityRulesListFromSeeContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeContact;
    @JsonProperty(value="circleVisibilityRulesListFromSeeAutoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeAutoContact;
    @JsonProperty(value="circleVisibilityRulesListToNoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListToNoContact;
    @JsonProperty(value="circleVisibilityRulesListToSeeNoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeNoContact;
    @JsonProperty(value="circleVisibilityRulesListToSeeContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeContact;
    @JsonProperty(value="circleVisibilityRulesListToSeeAutoContact")
    public List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeAutoContact;

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListFromNoContact() {
        return this.circleVisibilityRulesListFromNoContact;
    }

    public void setCircleVisibilityRulesListFromNoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromNoContact) {
        this.circleVisibilityRulesListFromNoContact = circleVisibilityRulesListFromNoContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListFromSeeNoContact() {
        return this.circleVisibilityRulesListFromSeeNoContact;
    }

    public void setCircleVisibilityRulesListFromSeeNoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeNoContact) {
        this.circleVisibilityRulesListFromSeeNoContact = circleVisibilityRulesListFromSeeNoContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListFromSeeContact() {
        return this.circleVisibilityRulesListFromSeeContact;
    }

    public void setCircleVisibilityRulesListFromSeeContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeContact) {
        this.circleVisibilityRulesListFromSeeContact = circleVisibilityRulesListFromSeeContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListFromSeeAutoContact() {
        return this.circleVisibilityRulesListFromSeeAutoContact;
    }

    public void setCircleVisibilityRulesListFromSeeAutoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListFromSeeAutoContact) {
        this.circleVisibilityRulesListFromSeeAutoContact = circleVisibilityRulesListFromSeeAutoContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListToNoContact() {
        return this.circleVisibilityRulesListToNoContact;
    }

    public void setCircleVisibilityRulesListToNoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListToNoContact) {
        this.circleVisibilityRulesListToNoContact = circleVisibilityRulesListToNoContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListToSeeNoContact() {
        return this.circleVisibilityRulesListToSeeNoContact;
    }

    public void setCircleVisibilityRulesListToSeeNoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeNoContact) {
        this.circleVisibilityRulesListToSeeNoContact = circleVisibilityRulesListToSeeNoContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListToSeeContact() {
        return this.circleVisibilityRulesListToSeeContact;
    }

    public void setCircleVisibilityRulesListToSeeContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeContact) {
        this.circleVisibilityRulesListToSeeContact = circleVisibilityRulesListToSeeContact;
    }

    public List<CirclesVisibilityRulesModel> getCircleVisibilityRulesListToSeeAutoContact() {
        return this.circleVisibilityRulesListToSeeAutoContact;
    }

    public void setCircleVisibilityRulesListToSeeAutoContact(List<CirclesVisibilityRulesModel> circleVisibilityRulesListToSeeAutoContact) {
        this.circleVisibilityRulesListToSeeAutoContact = circleVisibilityRulesListToSeeAutoContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlvidCircleVisibilityRulesListByVisibilityModel that = (OlvidCircleVisibilityRulesListByVisibilityModel)o;
        return Objects.equals(this.circleVisibilityRulesListFromNoContact, that.circleVisibilityRulesListFromNoContact) && Objects.equals(this.circleVisibilityRulesListFromSeeNoContact, that.circleVisibilityRulesListFromSeeNoContact) && Objects.equals(this.circleVisibilityRulesListFromSeeContact, that.circleVisibilityRulesListFromSeeContact) && Objects.equals(this.circleVisibilityRulesListFromSeeAutoContact, that.circleVisibilityRulesListFromSeeAutoContact) && Objects.equals(this.circleVisibilityRulesListToNoContact, that.circleVisibilityRulesListToNoContact) && Objects.equals(this.circleVisibilityRulesListToSeeNoContact, that.circleVisibilityRulesListToSeeNoContact) && Objects.equals(this.circleVisibilityRulesListToSeeContact, that.circleVisibilityRulesListToSeeContact) && Objects.equals(this.circleVisibilityRulesListToSeeAutoContact, that.circleVisibilityRulesListToSeeAutoContact);
    }

    public int hashCode() {
        return Objects.hash(this.circleVisibilityRulesListFromNoContact, this.circleVisibilityRulesListFromSeeNoContact, this.circleVisibilityRulesListFromSeeContact, this.circleVisibilityRulesListFromSeeAutoContact, this.circleVisibilityRulesListToNoContact, this.circleVisibilityRulesListToSeeNoContact, this.circleVisibilityRulesListToSeeContact, this.circleVisibilityRulesListToSeeAutoContact);
    }

    public String toString() {
        return "OlvidCircleVisibilityRulesListByVisibilityModel{circleVisibilityRulesListFromNoContact=" + String.valueOf(this.circleVisibilityRulesListFromNoContact) + ", circleVisibilityRulesListFromSeeNoContact=" + String.valueOf(this.circleVisibilityRulesListFromSeeNoContact) + ", circleVisibilityRulesListFromSeeContact=" + String.valueOf(this.circleVisibilityRulesListFromSeeContact) + ", circleVisibilityRulesListFromSeeAutoContact=" + String.valueOf(this.circleVisibilityRulesListFromSeeAutoContact) + ", circleVisibilityRulesListToNoContact=" + String.valueOf(this.circleVisibilityRulesListToNoContact) + ", circleVisibilityRulesListToSeeNoContact=" + String.valueOf(this.circleVisibilityRulesListToSeeNoContact) + ", circleVisibilityRulesListToSeeContact=" + String.valueOf(this.circleVisibilityRulesListToSeeContact) + ", circleVisibilityRulesListToSeeAutoContact=" + String.valueOf(this.circleVisibilityRulesListToSeeAutoContact) + "}";
    }

    public OlvidCircleVisibilityRulesListByVisibilityModel newOlvidCircleVisibilityRulesListByVisibilityModel(EntityManager em, KeycloakSession session, RealmModel realmModel, List<CirclesVisibilityRulesModel> rules, String id, Boolean isWithMembers) {
        OlvidCircleVisibilityRulesListByVisibilityModel olvidCircleVisibilityRulesListModel = new OlvidCircleVisibilityRulesListByVisibilityModel();
        ArrayList arrayCircleVisibilityRulesList = new ArrayList();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListFromNoContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListFromSeeNoContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListFromSeeContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListFromSeeAutoContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListToNoContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListToSeeNoContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListToSeeContact = new ArrayList<CirclesVisibilityRulesModel>();
        ArrayList<CirclesVisibilityRulesModel> arrayCircleVisibilityRulesListToSeeAutoContact = new ArrayList<CirclesVisibilityRulesModel>();
        rules.forEach(rule -> {
            CirclesVisibilityRulesModel groupsVisibilityRules = new CirclesVisibilityRulesModel();
            try {
                groupsVisibilityRules.setVisibilityRule(rule.getVisibilityRule());
            }
            catch (Exception e) {
                rule.setVisibilityRule("NO");
                groupsVisibilityRules.setVisibilityRule("NO");
            }
            CircleVisibilityModel customVisbilityRulesModelFrom = new CircleVisibilityModel();
            OlvidCircleVisibility retFrom = new OlvidCircleVisibility();
            if (!rule.getFrom().getId().contains("default")) {
                TypedQuery queryFrom = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
                queryFrom.setParameter("realmId", (Object)realmModel.getId());
                queryFrom.setParameter("id", (Object)rule.getFrom().getId());
                retFrom = (OlvidCircleVisibility)queryFrom.getSingleResult();
            } else {
                retFrom.setId("default-from");
                retFrom.setName("Default Circle");
                retFrom.setDescription("All users not assigned to any other Circle");
            }
            customVisbilityRulesModelFrom.setId(retFrom.getId());
            customVisbilityRulesModelFrom.setName(retFrom.getName());
            customVisbilityRulesModelFrom.setDescription(retFrom.getDescription());
            groupsVisibilityRules.setFrom(customVisbilityRulesModelFrom);
            CircleVisibilityModel customVisbilityRulesModelTo = new CircleVisibilityModel();
            OlvidCircleVisibility retTo = new OlvidCircleVisibility();
            if (!rule.getTo().getId().contains("default")) {
                TypedQuery queryTo = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
                queryTo.setParameter("realmId", (Object)realmModel.getId());
                queryTo.setParameter("id", (Object)rule.getTo().getId());
                retTo = (OlvidCircleVisibility)queryTo.getSingleResult();
            } else {
                retTo.setId("default-to");
                retTo.setName("Default Circle");
                retTo.setDescription("All users not assigned to any other Circle");
            }
            customVisbilityRulesModelTo.setId(retTo.getId());
            customVisbilityRulesModelTo.setName(retTo.getName());
            customVisbilityRulesModelTo.setDescription(retTo.getDescription());
            groupsVisibilityRules.setTo(customVisbilityRulesModelTo);
            ArrayList<String> olvidCircleVisibilityMembersFilteredTo = new ArrayList();
            ArrayList<String> olvidCircleVisibilityMembersFilteredFrom = new ArrayList();
            if (isWithMembers.booleanValue()) {
                TypedQuery<Object[]> queryToUsers;
                TypedQuery<Object[]> queryFromUsers;
                if (!retFrom.getId().contains("default")) {
                    olvidCircleVisibilityMembersFilteredFrom = Configuration.getOlvidCircleVisibilityMembersFiltered(em, realmModel, retFrom.getId(), "", new ArrayList<String>(), 10000, 0).stream().map(OlvidCircleVisibilityUser::getUserId).collect(Collectors.toList());
                    queryFromUsers = this.buildUsersQueryByIds(em, realmModel.getId(), olvidCircleVisibilityMembersFilteredFrom);
                } else {
                    queryFromUsers = this.buildUsersWithoutCircleQuery(em, realmModel.getId());
                }
                customVisbilityRulesModelFrom.setCircleMembers(queryFromUsers.getResultList().stream().map(result -> new CustomUserBasicModel().initCustomUserBasicModel((UserEntity)result[0])).collect(Collectors.toList()));
                if (!retTo.getId().contains("default")) {
                    olvidCircleVisibilityMembersFilteredTo = Configuration.getOlvidCircleVisibilityMembersFiltered(em, realmModel, retTo.getId(), "", new ArrayList<String>(), 10000, 0).stream().map(OlvidCircleVisibilityUser::getUserId).collect(Collectors.toList());
                    queryToUsers = this.buildUsersQueryByIds(em, realmModel.getId(), olvidCircleVisibilityMembersFilteredTo);
                } else {
                    queryToUsers = this.buildUsersWithoutCircleQuery(em, realmModel.getId());
                }
                customVisbilityRulesModelTo.setCircleMembers(queryToUsers.getResultList().stream().map(result -> new CustomUserBasicModel().initCustomUserBasicModel((UserEntity)result[0])).collect(Collectors.toList()));
            } else {
                customVisbilityRulesModelFrom.setCircleMembers(new ArrayList<CustomUserBasicModel>());
                customVisbilityRulesModelTo.setCircleMembers(new ArrayList<CustomUserBasicModel>());
            }
            arrayCircleVisibilityRulesList.add(groupsVisibilityRules);
            if (rule.getVisibilityRule() == null) {
                rule.setVisibilityRule("NO");
            }
            if (rule.getVisibilityRule().contentEquals("NO") && id.contentEquals(rule.getFrom().getId())) {
                arrayCircleVisibilityRulesListFromNoContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("NO") && id.contentEquals(rule.getTo().getId())) {
                arrayCircleVisibilityRulesListToNoContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_NO_CONTACT") && id.contentEquals(rule.getFrom().getId())) {
                arrayCircleVisibilityRulesListFromSeeNoContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_NO_CONTACT") && id.contentEquals(rule.getTo().getId())) {
                arrayCircleVisibilityRulesListToSeeNoContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_CONTACT") && id.contentEquals(rule.getFrom().getId())) {
                arrayCircleVisibilityRulesListFromSeeContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_CONTACT") && id.contentEquals(rule.getTo().getId())) {
                arrayCircleVisibilityRulesListToSeeContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_AUTO_CONTACT") && id.contentEquals(rule.getFrom().getId())) {
                arrayCircleVisibilityRulesListFromSeeAutoContact.add(groupsVisibilityRules);
            }
            if (rule.getVisibilityRule().contentEquals("SEE_AUTO_CONTACT") && id.contentEquals(rule.getTo().getId())) {
                arrayCircleVisibilityRulesListToSeeAutoContact.add(groupsVisibilityRules);
            }
        });
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListFromNoContact(arrayCircleVisibilityRulesListFromNoContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListFromSeeContact(arrayCircleVisibilityRulesListFromSeeContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListFromSeeNoContact(arrayCircleVisibilityRulesListFromSeeNoContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListFromSeeAutoContact(arrayCircleVisibilityRulesListFromSeeAutoContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListToNoContact(arrayCircleVisibilityRulesListToNoContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListToSeeContact(arrayCircleVisibilityRulesListToSeeContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListToSeeNoContact(arrayCircleVisibilityRulesListToSeeNoContact);
        olvidCircleVisibilityRulesListModel.setCircleVisibilityRulesListToSeeAutoContact(arrayCircleVisibilityRulesListToSeeAutoContact);
        return olvidCircleVisibilityRulesListModel;
    }

    private TypedQuery<Object[]> buildUsersQueryByIds(EntityManager em, String realmId, List<String> list) {
        StringBuilder sb = new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId");
        sb.append(" AND (u.id IN :list)");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("list", list);
        return query;
    }

    private TypedQuery<Object[]> buildUsersWithoutCircleQuery(EntityManager em, String realmId) {
        StringBuilder sb = new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        return query;
    }
}

