/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.utils.mail;

import org.apache.commons.text.StringEscapeUtils;

public class Email {
    public static String getCreateAdminEmailSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: your password";
            }
        }
        return "Console de Gestion Olvid\u00a0: votre mot de passe";
    }

    public static String getCreateAdminEmailBodyText(String isocode, String username, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour temporary password is: " + password + "\nYou will be requested to change it on your first connection.\n\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "Bonjour " + username + "\u00a0!\n\nVotre mot de passe temporaire est\u00a0:  " + password + "\nIl vous sera demand\u00e9 de le changer lors de votre premi\u00e8re connexion.\n\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getCreateAdminEmailBodyHTML(String isocode, String username, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your temporary password is: <strong>" + StringEscapeUtils.escapeHtml3(password) + "</strong></p><p>You will be requested to change it on your first connection.</p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>Bonjour " + username + "\u00a0!</p><p>Votre mot de passe temporaire est\u00a0:  <strong>" + StringEscapeUtils.escapeHtml3(password) + "</strong></p><p>Il vous sera demand\u00e9 de le changer lors de votre premi\u00e8re connexion.</p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getPasswordResetEmailSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: password reset";
            }
        }
        return "Console de Gestion Olvid\u00a0: r\u00e9initialisation de mot de passe";
    }

    public static String getPasswordResetEmailBodyText(String isocode, String username, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour password has been reset.\nYour temporary password is: " + password + "\nYou will be requested to change it on your next connection.\n\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "Bonjour " + username + "\u00a0!\n\nVotre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9.\nVotre mot de passe temporaire est\u00a0: " + password + "\nIl vous sera demand\u00e9 de le changer lors de votre prochaine connexion.\n\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getPasswordResetEmailBodyHTML(String isocode, String username, String password) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your password has been reset</p><p>Your temporary password is: <strong>" + StringEscapeUtils.escapeHtml3(password) + "</strong></p><p>You will be requested to change it on your next connection.</p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>Bonjour " + username + "\u00a0!</p><p>Votre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9.</p><p>Votre mot de passe temporaire est\u00a0: <strong>" + StringEscapeUtils.escapeHtml3(password) + "</strong></p><p>Il vous sera demand\u00e9 de le changer lors de votre prochaine connexion.</p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getUserOldDeviceAlertSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: Old Device Alert";
            }
        }
        return "TODO FR Console de Gestion Olvid\u00a0: Old Device Alert";
    }

    public static String getUserOldDeviceAlertBodyText(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour device " + displayName + " has on old device sync.\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "TODO FR Hello " + username + "!\n\nTODO FR Your device " + displayName + "has on old device sync.\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getUserOldDeviceAlertBodyHTML(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your device: <strong>" + displayName + "</strong> has on old device sync.</p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>TODO FR Bonjour " + username + "\u00a0!</p><p>Your device: <strong>" + displayName + "</strong> has on old device sync.</p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getUserUnknownDeviceAlertBodyHTML(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "<p>Hello " + username + "!</p><p>Your device: <strong>" + displayName + "</strong> is not known by our service.</p><p>Please, Contact us for set is : known </p><p>Regards,</p><p>-- The Olvid Management Console</p>";
            }
        }
        return "<p>TODO FR Bonjour " + username + "\u00a0!</p><p>Your device: <strong>" + displayName + "</strong> is not known by our service.</p><p>S'il vous plait, Contactez nous pour que nous puissions le passer \u00e0 : connu </p><p>Respectueusement,</p><p>-- La Console de Gestion Olvid</p>";
    }

    public static String getUserUnknownDeviceAlertBodyText(String isocode, String username, String displayName) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Hello " + username + "!\n\nYour device " + displayName + " has on old device sync.\nRegards,\n\n-- The Olvid Management Console";
            }
        }
        return "TODO FR Hello " + username + "!\n\nYour device " + displayName + "has on old device sync.\nRespectueusement,\n\n-- La Console de Gestion Olvid";
    }

    public static String getUserUnknownDeviceAlertSubject(String isocode) {
        if (isocode == null) {
            isocode = "fr";
        }
        switch (isocode) {
            case "en": {
                return "Olvid Management Console: Unknown Device Alert";
            }
        }
        return "TODO FR Console de Gestion Olvid\u00a0: Unknown Device Alert";
    }
}

