/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.users;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidExternalLink;
import io.olvid.keycloak.jpa.OlvidExternalLinkDao;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class SynchronizeApiKeysJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;
    public static final long MAX_TRANSACTION_DURATION = 10000L;

    public SynchronizeApiKeysJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block55: {
            KeycloakTransactionManager transactionManager;
            KeycloakSession session;
            this.logger.info((Object)"Starting API keys and push topics synchronization task");
            HashMap<String, HashMap<String, UserAndRealmIds>> apiKeyMap = new HashMap<String, HashMap<String, UserAndRealmIds>>();
            HashMap<String, HashMap<String, PushTopicOrigin>> pushTopicMap = new HashMap<String, HashMap<String, PushTopicOrigin>>();
            HashMap<String, String> apiKeyServer = new HashMap<String, String>();
            boolean transactionCompletedSuccessfully = false;
            HashSet olvidRealmIds = new HashSet();
            long currentTimestamp = System.currentTimeMillis();
            try {
                session = this.factory.create();
                try {
                    transactionManager = session.getTransactionManager();
                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                    try {
                        transactionManager.begin();
                        session.realms().getRealmsStream().forEach(realmModel -> {
                            session.getContext().setRealm(realmModel);
                            if (OlvidConfigurationDao.getBooleanConfiguration(em, realmModel.getId(), "olvid", false)) {
                                olvidRealmIds.add(realmModel.getId());
                            }
                        });
                    }
                    finally {
                        transactionManager.rollback();
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception in Synchronize API keys detection task (part 1)", (Throwable)e);
                return;
            }
            try {
                for (String realmId2 : olvidRealmIds) {
                    int processedUsers;
                    int totalProcessedUsers = 0;
                    while ((processedUsers = this.subProcess(realmId2, totalProcessedUsers, apiKeyServer, apiKeyMap)) != 0) {
                        this.logger.info((Object)("    Collecting API keys for realm " + realmId2 + " progress: " + (totalProcessedUsers += processedUsers)));
                    }
                    this.subProcessForPushTopicsAndExternalLinks(realmId2, apiKeyMap, pushTopicMap);
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception in Synchronize API keys detection task (part 2)", (Throwable)e);
                return;
            }
            this.logger.info((Object)"Collected all API keys.");
            session = this.factory.create();
            try {
                block58: {
                    block54: {
                        transactionManager = session.getTransactionManager();
                        ObjectMapper jsonObjectMapper = new ObjectMapper();
                        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionManager.begin();
                        for (String keycloakApiKey : apiKeyMap.keySet()) {
                            String serverUrl = apiKeyServer.get(keycloakApiKey);
                            HashMap<String, UserAndRealmIds> userMap = apiKeyMap.get(keycloakApiKey);
                            HashMap<String, PushTopicOrigin> topicsMap = pushTopicMap.get(keycloakApiKey);
                            if (serverUrl == null || userMap == null || topicsMap == null) {
                                this.logger.warn((Object)("API Keys synchronization: error for keycloakApiKey" + keycloakApiKey));
                                continue;
                            }
                            this.logger.info((Object)("API Keys synchronization: querying server for keycloakApiKey " + keycloakApiKey));
                            OlvidServerApiHelper.UnknownApiKeysAndPushTopics unknownApiKeysAndPushTopics = OlvidServerApiHelper.apiKeySynchronization(session, serverUrl, keycloakApiKey, jsonObjectMapper, userMap.keySet(), topicsMap.keySet(), em);
                            if (unknownApiKeysAndPushTopics == null) {
                                this.logger.warn((Object)"API Keys synchronization: server error (response is null)");
                                continue;
                            }
                            List<String> realmIds = OlvidConfigurationDao.getRealmIdsForApiKey(em, keycloakApiKey);
                            realmIds.forEach(realmId -> OlvidConfigurationDao.setConfiguration(em, realmId, "licensesCount", String.valueOf(unknownApiKeysAndPushTopics.licenseCount)));
                            Set<String> unknownApiKeys = unknownApiKeysAndPushTopics.unknownApiKeys;
                            if (unknownApiKeys != null && !unknownApiKeys.isEmpty()) {
                                this.logger.info((Object)("API Keys synchronization: server reported " + unknownApiKeys.size() + " unknown API keys"));
                                HashMap<String, RealmModel> realmModelMap = new HashMap<String, RealmModel>();
                                for (String unknownApiKey : unknownApiKeys) {
                                    UserAndRealmIds userAndRealm = userMap.get(unknownApiKey);
                                    if (userAndRealm == null) continue;
                                    RealmModel realmModel2 = realmModelMap.computeIfAbsent(userAndRealm.realmId, realmId -> session.realms().getRealm(realmId));
                                    session.getContext().setRealm(realmModel2);
                                    if (userAndRealm.userId == null) {
                                        OlvidExternalLinkDao.revokeByRealmAndApiKey(em, userAndRealm.realmId, unknownApiKey);
                                        continue;
                                    }
                                    UserModel user = session.users().getUserById(realmModel2, userAndRealm.userId);
                                    if (user == null) continue;
                                    user.removeAttribute("olvid-api-key");
                                }
                            } else {
                                this.logger.info((Object)"API Keys synchronization: no unknown API keys");
                            }
                            Set<String> unknownPushTopics = unknownApiKeysAndPushTopics.unknownPushTopics;
                            if (unknownPushTopics != null && !unknownPushTopics.isEmpty()) {
                                this.logger.info((Object)("API Keys synchronization: server reported " + unknownPushTopics.size() + " unknown Push Topics"));
                                for (String unknownPushTopic : unknownPushTopics) {
                                    PushTopicOrigin pushTopicOrigin = topicsMap.get(unknownPushTopic);
                                    switch (pushTopicOrigin.type.ordinal()) {
                                        case 0: {
                                            OlvidConfigurationDao.setConfiguration(em, pushTopicOrigin.realmId, "keycloakPushTopic", null);
                                            break;
                                        }
                                        case 1: {
                                            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(em, pushTopicOrigin.realmId, pushTopicOrigin.keycloakGroupId);
                                            if (olvidGroup == null) break;
                                            olvidGroup.setPushTopic(null);
                                            em.merge((Object)olvidGroup);
                                            break;
                                        }
                                    }
                                }
                                continue;
                            }
                            this.logger.info((Object)"API Keys synchronization: no unknown Push Topics");
                        }
                        transactionCompletedSuccessfully = true;
                        if (!transactionCompletedSuccessfully) break block54;
                        transactionManager.commit();
                        break block58;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)("Ending API Keys synchronization task: " + (transactionCompletedSuccessfully ? "success" : "failed")));
                try {
                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                    transactionManager.begin();
                    RealmModel master = session.realms().getRealmByName("master");
                    session.getContext().setRealm(master);
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().synchronizeApiKeys);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception em) {
                    transactionManager.commit();
                    break block55;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block55;
                catch (Exception e) {
                    block59: {
                        block56: {
                            try {
                                this.logger.warn((Object)"Exception in API Keys synchronization task (part 3)", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block56;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)("Ending API Keys synchronization task: " + (transactionCompletedSuccessfully ? "success" : "failed")));
                                try {
                                    EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                                    transactionManager.begin();
                                    RealmModel master = session.realms().getRealmByName("master");
                                    session.getContext().setRealm(master);
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().synchronizeApiKeys);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block59;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)("Ending API Keys synchronization task: " + (transactionCompletedSuccessfully ? "success" : "failed")));
                    try {
                        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionManager.begin();
                        RealmModel master = session.realms().getRealmByName("master");
                        session.getContext().setRealm(master);
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().synchronizeApiKeys);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block55;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int subProcess(String realmId, int offset, HashMap<String, String> apiKeyServer, HashMap<String, HashMap<String, UserAndRealmIds>> apiKeyMap) {
        try (KeycloakSession session = this.factory.create();){
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            int[] processedUsers = new int[]{0};
            long startTime = System.currentTimeMillis();
            try {
                transactionManager.begin();
                String keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
                String serverUrl = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverUrl");
                if (keycloakApiKey == null || serverUrl == null) {
                    int n = 0;
                    return n;
                }
                String previousServerUrl = apiKeyServer.computeIfAbsent(keycloakApiKey, k -> serverUrl);
                if (!serverUrl.equals(previousServerUrl)) {
                    throw new RuntimeException("2 realms with the same keycloakApiKey have different serverUrl!");
                }
                HashMap userMap = apiKeyMap.computeIfAbsent(keycloakApiKey, k -> new HashMap());
                RealmModel realmModel = session.realms().getRealm(realmId);
                session.getContext().setRealm(realmModel);
                session.users().searchForUserStream(realmModel, Collections.emptyMap(), Integer.valueOf(offset), Integer.valueOf(1000)).filter(userModel -> {
                    String apiKey = userModel.getFirstAttribute("olvid-api-key");
                    if (apiKey != null) {
                        userMap.put(apiKey, new UserAndRealmIds(userModel.getId(), realmId));
                    }
                    processedUsers[0] = processedUsers[0] + 1;
                    return System.currentTimeMillis() > startTime + 10000L;
                }).findFirst();
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception in Synchronize API keys detection task (part 2) Collecting API keys for realm subProcess e " + e.getMessage()));
            }
            finally {
                transactionManager.rollback();
            }
            int n = processedUsers[0];
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subProcessForPushTopicsAndExternalLinks(String realmId, HashMap<String, HashMap<String, UserAndRealmIds>> apiKeyMap, HashMap<String, HashMap<String, PushTopicOrigin>> pushTopicMap) {
        try (KeycloakSession session = this.factory.create();){
            KeycloakTransactionManager transactionManager = session.getTransactionManager();
            EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
            try {
                transactionManager.begin();
                String keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realmId, "serverKeycloakApiKey");
                if (keycloakApiKey == null) {
                    return;
                }
                HashMap pushMap = pushTopicMap.computeIfAbsent(keycloakApiKey, k -> new HashMap());
                String pushTopic = OlvidConfigurationDao.getStringConfiguration(em, realmId, "keycloakPushTopic");
                if (pushTopic != null) {
                    pushMap.put(pushTopic, new PushTopicOrigin(PushTopicType.REALM, realmId, null));
                }
                try {
                    TypedQuery q = em.createNamedQuery("OlvidGroup.getAllWithAPushTopicByRealm", OlvidGroup.class);
                    q.setParameter("realmId", (Object)realmId);
                    for (OlvidGroup olvidGroup : q.getResultList()) {
                        pushMap.put(olvidGroup.getPushTopic(), new PushTopicOrigin(PushTopicType.GROUP, olvidGroup.getRealmId(), olvidGroup.getKeycloakGroupId()));
                    }
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Exception in subProcessForPushTopicsAndExternalLinks", (Throwable)e);
                }
                HashMap userMap = apiKeyMap.computeIfAbsent(keycloakApiKey, k -> new HashMap());
                for (OlvidExternalLink olvidExternalLink : OlvidExternalLinkDao.getAllNotRevokedOlvidExternalLinkForRealmId(em, realmId)) {
                    userMap.put(olvidExternalLink.getKey(), new UserAndRealmIds(null, realmId));
                }
            }
            finally {
                transactionManager.rollback();
            }
        }
    }

    private static class UserAndRealmIds {
        public final String userId;
        public final String realmId;

        public UserAndRealmIds(String userId, String realmId) {
            this.userId = userId;
            this.realmId = realmId;
        }
    }

    private static class PushTopicOrigin {
        public final PushTopicType type;
        public final String realmId;
        public final String keycloakGroupId;

        public PushTopicOrigin(PushTopicType type, String realmId, String keycloakGroupId) {
            this.type = type;
            this.realmId = realmId;
            this.keycloakGroupId = keycloakGroupId;
        }
    }

    private static enum PushTopicType {
        REALM,
        GROUP;

    }
}

