/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.jpa.OlvidNotifications;
import io.olvid.keycloak.jpa.OlvidNotificationsDao;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.timer.oneTimeJob.PluginVersionUpgradeOneTimeJob;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;

public class GetKeycloakPluginVersionJob
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public GetKeycloakPluginVersionJob(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block38: {
            this.logger.info((Object)"Starting Get Keycloak Plugin Version task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block43: {
                    block37: {
                        OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson requestGetKeycloakPluginVersionResponseJson;
                        block35: {
                            block41: {
                                block36: {
                                    transactionManager = session.getTransactionManager();
                                    ObjectMapper jsonObjectMapper = new ObjectMapper();
                                    jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                                    em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                                    transactionCompletedSuccessfully = false;
                                    transactionManager.begin();
                                    requestGetKeycloakPluginVersionResponseJson = Utils.getRequestGetKeycloakPluginVersionResponseJson(session, jsonObjectMapper);
                                    if (requestGetKeycloakPluginVersionResponseJson != null && requestGetKeycloakPluginVersionResponseJson.version != null) break block35;
                                    this.logger.warn((Object)"Failed to get Keycloak Plugin version from server");
                                    if (!transactionCompletedSuccessfully) break block36;
                                    transactionManager.commit();
                                    break block41;
                                }
                                transactionManager.rollback();
                            }
                            this.logger.info((Object)"Ending Get Keycloak Plugin Version task task.");
                            try {
                                transactionManager.begin();
                                OlvidLogsBackend item = new OlvidLogsBackend();
                                item.setLogType(new CronJobModel().getKeycloakPluginVersionJob);
                                item.setTimestampStart(currentTimestamp);
                                item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                em.persist((Object)item);
                            }
                            catch (Exception item) {
                                transactionManager.commit();
                                catch (Throwable throwable) {
                                    transactionManager.commit();
                                    throw throwable;
                                }
                            }
                            transactionManager.commit();
                            return;
                        }
                        this.logger.info((Object)("Got Keycloak Plugin version from server: " + requestGetKeycloakPluginVersionResponseJson.version));
                        try {
                            if (PluginVersionUpgradeOneTimeJob.getPluginVersionFromString("4.4.0") >= PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(requestGetKeycloakPluginVersionResponseJson.version)) {
                                this.markAsReadAllExistingVersionNotifications(em, currentTimestamp);
                            } else {
                                GetKeycloakPluginVersionJob.createVersionNotificationIfNotExists(em, requestGetKeycloakPluginVersionResponseJson, currentTimestamp);
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)"Internal error in new version notifications", (Throwable)e);
                        }
                        transactionCompletedSuccessfully = true;
                        if (!transactionCompletedSuccessfully) break block37;
                        transactionManager.commit();
                        break block43;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Get Keycloak Plugin Version task task.");
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().getKeycloakPluginVersionJob);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block38;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block38;
                catch (Exception e) {
                    block44: {
                        block39: {
                            try {
                                this.logger.warn((Object)"Exception in Get Keycloak Plugin Version task task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block39;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Get Keycloak Plugin Version task task.");
                                try {
                                    transactionManager.begin();
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().getKeycloakPluginVersionJob);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block44;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Get Keycloak Plugin Version task task.");
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().getKeycloakPluginVersionJob);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block38;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }

    private void markAsReadAllExistingVersionNotifications(EntityManager em, long currentTimestamp) {
        int currentVersion = PluginVersionUpgradeOneTimeJob.getPluginVersionFromString("4.4.0");
        List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(em);
        onList.forEach(on -> {
            if (PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(on.getValue()) <= currentVersion) {
                on.setIsRead(true);
                on.setReadDate(currentTimestamp);
                on.setReaderUserId("cronJob");
                em.merge(on);
            }
        });
    }

    private static void createVersionNotificationIfNotExists(EntityManager em, OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson requestGetKeycloakPluginVersionResponseJson, long currentTimestamp) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidNotifications.getKeycloakPluginVersionNotificationByRealm", OlvidNotifications.class);
            q.setParameter("realmId", (Object)"master");
            q.setParameter("value", (Object)requestGetKeycloakPluginVersionResponseJson.version);
            q.getSingleResult();
        }
        catch (NoResultException e) {
            OlvidNotifications olvidNotifications = new OlvidNotifications();
            olvidNotifications.setCreatedDate(currentTimestamp);
            olvidNotifications.setRealmId("master");
            olvidNotifications.setNotificationType(OlvidNotifications.NotificationType.pluginVersion.getStringValue());
            olvidNotifications.setIsRead(false);
            olvidNotifications.setValue(requestGetKeycloakPluginVersionResponseJson.version);
            em.persist((Object)olvidNotifications);
        }
    }
}

