/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.generic;

import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;

public class CleanUpRealms
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public CleanUpRealms(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block26: {
            this.logger.info((Object)"Starting Clean up Realms task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block29: {
                    block25: {
                        transactionManager = session.getTransactionManager();
                        em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionCompletedSuccessfully = false;
                        transactionManager.begin();
                        List realmIds = session.realms().getRealmsStream().map(RealmModel::getId).collect(Collectors.toList());
                        realmIds.add("master");
                        em.createNamedQuery("OlvidConfiguration.cleanUselessConfiguration").setParameter("realmIds", realmIds).executeUpdate();
                        transactionCompletedSuccessfully = true;
                        if (!transactionCompletedSuccessfully) break block25;
                        transactionManager.commit();
                        break block29;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Clean up Realms task.");
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().cleanUpRealms);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block26;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block26;
                catch (Exception e) {
                    block30: {
                        block27: {
                            try {
                                this.logger.warn((Object)"Exception in Clean up Realms task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block27;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Clean up Realms task.");
                                try {
                                    transactionManager.begin();
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().cleanUpRealms);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block30;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Clean up Realms task.");
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().cleanUpRealms);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block26;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }
}

