/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.timer.cronTask.circlesVisibility;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.models.circleVisibility.CirclesVisibilityRulesModel;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;

public class CleanUpOlvidVisibilityCircleRules
implements Runnable {
    private final KeycloakSessionFactory factory;
    private final Logger logger;

    public CleanUpOlvidVisibilityCircleRules(KeycloakSessionFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            this.logger.info((Object)"Starting Clean up OlvidVisibilityCircleRules task");
            long currentTimestamp = System.currentTimeMillis();
            try (KeycloakSession session = this.factory.create();){
                boolean transactionCompletedSuccessfully;
                EntityManager em;
                KeycloakTransactionManager transactionManager;
                block44: {
                    block40: {
                        transactionManager = session.getTransactionManager();
                        ObjectMapper jsonObjectMapper = new ObjectMapper();
                        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
                        transactionCompletedSuccessfully = false;
                        transactionManager.begin();
                        TypedQuery qFrom = em.createNamedQuery("OlvidCircleVisibilityRules.getRulesWithDeletedCircleFrom", OlvidCircleVisibilityRules.class);
                        List olvidCircleVisibilityRulesListFrom = qFrom.getResultList();
                        for (OlvidCircleVisibilityRules olvidCircleVisibilityRules : olvidCircleVisibilityRulesListFrom) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityRules.getById", OlvidCircleVisibilityRules.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityRules.getId());
                            try {
                                OlvidCircleVisibilityRules found = (OlvidCircleVisibilityRules)qSingle.getSingleResult();
                                em.remove((Object)found);
                            }
                            catch (NoResultException found) {}
                        }
                        TypedQuery qTo = em.createNamedQuery("OlvidCircleVisibilityRules.getRulesWithDeletedCircleTo", OlvidCircleVisibilityRules.class);
                        List olvidCircleVisibilityRulesListTo = qTo.getResultList();
                        for (OlvidCircleVisibilityRules olvidCircleVisibilityRules : olvidCircleVisibilityRulesListTo) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityRules.getById", OlvidCircleVisibilityRules.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityRules.getId());
                            try {
                                OlvidCircleVisibilityRules found = (OlvidCircleVisibilityRules)qSingle.getSingleResult();
                                em.remove((Object)found);
                            }
                            catch (NoResultException found) {}
                        }
                        TypedQuery qEmptyVisibility = em.createNamedQuery("OlvidCircleVisibilityRules.getRulesWithEmptyStringVisibilityValue", OlvidCircleVisibilityRules.class);
                        List olvidCircleVisibilityEmptyString = qEmptyVisibility.getResultList();
                        for (OlvidCircleVisibilityRules olvidCircleVisibilityRules : olvidCircleVisibilityEmptyString) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityRules.getById", OlvidCircleVisibilityRules.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityRules.getId());
                            try {
                                OlvidCircleVisibilityRules found = (OlvidCircleVisibilityRules)qSingle.getSingleResult();
                                found.setVisibility(null);
                                em.merge((Object)found);
                            }
                            catch (NoResultException found) {}
                        }
                        TypedQuery qEmptyFrom = em.createNamedQuery("OlvidCircleVisibilityRules.getRulesWithEmptyStringRuleFrom", OlvidCircleVisibilityRules.class);
                        List olvidCircleFromEmptyString = qEmptyFrom.getResultList();
                        for (OlvidCircleVisibilityRules olvidCircleVisibilityRules : olvidCircleFromEmptyString) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityRules.getById", OlvidCircleVisibilityRules.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityRules.getId());
                            try {
                                OlvidCircleVisibilityRules found = (OlvidCircleVisibilityRules)qSingle.getSingleResult();
                                found.setCircleVisibilityId1From(null);
                                em.merge((Object)found);
                            }
                            catch (NoResultException found) {}
                        }
                        TypedQuery qEmptyTo = em.createNamedQuery("OlvidCircleVisibilityRules.getRulesWithEmptyStringRuleTo", OlvidCircleVisibilityRules.class);
                        List olvidCircleToEmptyString = qEmptyTo.getResultList();
                        for (OlvidCircleVisibilityRules olvidCircleVisibilityRules : olvidCircleToEmptyString) {
                            TypedQuery qSingle = em.createNamedQuery("OlvidCircleVisibilityRules.getById", OlvidCircleVisibilityRules.class);
                            qSingle.setParameter("id", (Object)olvidCircleVisibilityRules.getId());
                            try {
                                OlvidCircleVisibilityRules found = (OlvidCircleVisibilityRules)qSingle.getSingleResult();
                                found.setCircleVisibilityId2To(null);
                                em.merge((Object)found);
                            }
                            catch (NoResultException noResultException) {}
                        }
                        new CirclesVisibilityRulesModel().checkRulesDuplicate(em);
                        transactionCompletedSuccessfully = true;
                        if (!transactionCompletedSuccessfully) break block40;
                        transactionManager.commit();
                        break block44;
                    }
                    transactionManager.rollback();
                }
                this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleRules task");
                try {
                    transactionManager.begin();
                    OlvidLogsBackend item = new OlvidLogsBackend();
                    item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityRules);
                    item.setTimestampStart(currentTimestamp);
                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                    em.persist((Object)item);
                }
                catch (Exception item) {
                    transactionManager.commit();
                    break block41;
                    catch (Throwable throwable) {
                        transactionManager.commit();
                        throw throwable;
                    }
                }
                transactionManager.commit();
                break block41;
                catch (Exception e) {
                    block45: {
                        block42: {
                            try {
                                this.logger.warn((Object)"Exception in Clean up OlvidVisibilityCircleRules task", (Throwable)e);
                                if (!transactionCompletedSuccessfully) break block42;
                            }
                            catch (Throwable throwable) {
                                if (transactionCompletedSuccessfully) {
                                    transactionManager.commit();
                                } else {
                                    transactionManager.rollback();
                                }
                                this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleRules task");
                                try {
                                    transactionManager.begin();
                                    OlvidLogsBackend item = new OlvidLogsBackend();
                                    item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityRules);
                                    item.setTimestampStart(currentTimestamp);
                                    item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                                    item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                                    em.persist((Object)item);
                                }
                                catch (Exception exception) {
                                }
                                finally {
                                    transactionManager.commit();
                                }
                                throw throwable;
                            }
                            transactionManager.commit();
                            break block45;
                        }
                        transactionManager.rollback();
                    }
                    this.logger.info((Object)"Ending Clean up OlvidVisibilityCircleRules task");
                    try {
                        transactionManager.begin();
                        OlvidLogsBackend item = new OlvidLogsBackend();
                        item.setLogType(new CronJobModel().cleanUpOlvidCircleVisibilityRules);
                        item.setTimestampStart(currentTimestamp);
                        item.setTimestampEnd(transactionCompletedSuccessfully ? System.currentTimeMillis() : 0L);
                        item.setMessage(transactionCompletedSuccessfully ? "success" : "failed");
                        em.persist((Object)item);
                    }
                    catch (Exception exception) {
                        transactionManager.commit();
                        break block41;
                        catch (Throwable throwable) {
                            transactionManager.commit();
                            throw throwable;
                        }
                    }
                    transactionManager.commit();
                }
            }
        }
    }
}

