/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.verify;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.Encoded;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureVerifierContext;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.verify.JsonVerifyRequest;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class Verify
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(Verify.class);

    public Verify(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        String signature;
        try {
            JsonVerifyRequest request = (JsonVerifyRequest)this.objectMapper.readValue(postData, JsonVerifyRequest.class);
            signature = request.getSignature();
            if (signature == null) {
                throw new Exception("Signature not found in request");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{-1})}).getBytes(), (String)"application/octet-stream").build();
        }
        try {
            UserModel user;
            OlvidUserDetails olvidUserDetails;
            OlvidUserDetailsSignatureVerifierContext verifierContext;
            boolean success;
            JWSInput jwsInput = new JWSInput(signature);
            String signatureKid = jwsInput.getHeader().getKeyId();
            KeyWrapper key = null;
            for (KeyWrapper keyCandidate : this.session.keys().getKeysStream(this.session.getContext().getRealm()).collect(Collectors.toList())) {
                if (!keyCandidate.getKid().equals(signatureKid)) continue;
                key = keyCandidate;
                break;
            }
            if (key != null && (success = (verifierContext = new OlvidUserDetailsSignatureVerifierContext(key)).verify(jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jwsInput.getSignature())) && (olvidUserDetails = (OlvidUserDetails)this.objectMapper.readValue(jwsInput.readContentAsString(), OlvidUserDetails.class)).getId() != null && !olvidUserDetails.getId().isEmpty() && olvidUserDetails.getIdentity() != null && (user = this.session.users().getUserById(this.session.getContext().getRealm(), olvidUserDetails.getId())) != null) {
                String identityAttribute = user.getFirstAttribute("olvid-identity");
                if (Objects.equals(olvidUserDetails.getIdentity(), identityAttribute)) {
                    logger.debug((Object)"Identities match");
                    return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{0}), Encoded.of(true)}).getBytes(), (String)"application/octet-stream").build();
                }
                logger.warn((Object)("Identity mismatch: " + olvidUserDetails.getIdentity() + " vs. " + identityAttribute));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{0}), Encoded.of(false)}).getBytes(), (String)"application/octet-stream").build();
    }
}

