/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import io.olvid.keycloak.rest.api.search.JsonSearchRequest;
import io.olvid.keycloak.rest.api.search.JsonSearchResponse;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.services.managers.AuthenticationManager;

public class Search
extends AbstractBearerTokenAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(Configuration.class);
    public static final String COUNT_QUERY_WITH_CIRCLE = "SELECT  COUNT(DISTINCT u)  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String COUNT_QUERY_FILTERED_WITH_CIRCLE = "SELECT  COUNT(DISTINCT u)  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String SELECT_QUERY_WITH_CIRCLE = "SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String SELECT_QUERY_FILTERED_WITH_CIRCLE = "SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String AND_USERS_IN_CIRCLE = " AND ocvu.circleVisibilityId in :circleIds ";
    public static final String AND_USERS_IN_CIRCLE_AND_USERS_FROM_DEFAULT_CIRCLE = " AND (ocvu.circleVisibilityId in :circleIds  OR ocvu.circleVisibilityId is null) ";
    public static final String SELECT_QUERY_ALL_NOT_ACTIVATED_WITH_CIRCLE = " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String SELECT_QUERY_FILTERED_NOT_ACTIVATED_WITH_CIRCLE = " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String SELECT_QUERY_NOT_ACTIVATED_WITH_CIRCLE = " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String COUNT_QUERY_ALL_NOT_ACTIVATED_WITH_CIRCLE = " SELECT  COUNT(DISTINCT u)  FROM OlvidCircleVisibilityRules ocvr  LEFT JOIN OlvidCircleVisibilityUser ocvu on (ocvr.circleVisibilityId2To = ocvu.circleVisibilityId or ocvr.circleVisibilityId2To is null) LEFT JOIN UserEntity u on u.id = ocvu.userId  JOIN u.attributes attr_id  WHERE ocvr.realmId = :realmId  AND ocvr.circleVisibilityId1From = :circleId  AND u.id != :userId  AND ocvr.visibility = 'SEE_CONTACT' AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String COUNT_QUERY_FILTERED_NOT_ACTIVATED_WITH_CIRCLE = " SELECT  COUNT(DISTINCT u)  FROM OlvidCircleVisibilityRules ocvr  LEFT JOIN OlvidCircleVisibilityUser ocvu on (ocvr.circleVisibilityId2To = ocvu.circleVisibilityId or ocvr.circleVisibilityId2To is null) LEFT JOIN UserEntity u on u.id = ocvu.userId  JOIN u.attributes attr_id  JOIN u.attributes attr_full  WHERE ocvr.realmId = :realmId  AND ocvr.circleVisibilityId1From = :circleId  AND u.id != :userId  AND ocvr.visibility = 'SEE_CONTACT' AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String COUNT_QUERY_ALL = "SELECT  COUNT(DISTINCT u)  FROM UserEntity u  JOIN u.attributes attr_id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String COUNT_QUERY_FILTERED = "SELECT COUNT(DISTINCT u) FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String SELECT_QUERY_ALL = "SELECT DISTINCT u FROM UserEntity u  JOIN u.attributes attr_id  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String SELECT_QUERY_FILTERED = "SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  WHERE u.realmId = :realmId  AND u.id != :userId  AND attr_id.name = 'olvid-identity' ";
    public static final String SELECT_QUERY_ALL_NOT_ACTIVATED = " SELECT DISTINCT u FROM UserEntity u  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String SELECT_QUERY_FILTERED_NOT_ACTIVATED = " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String COUNT_QUERY_ALL_NOT_ACTIVATED = " SELECT COUNT(DISTINCT u) FROM UserEntity u  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String COUNT_QUERY_FILTERED_NOT_ACTIVATED = " SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr_full  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))";
    public static final String QUERY_FILTER = " AND ( attr_full.name = 'olvid-search' AND attr_full.value LIKE :?) ";
    public static final String QUERY_ORDER = " ORDER BY u.lastName ASC, u.firstName ASC ";

    public Search(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        boolean circleVisibility;
        boolean searchIncludeNotActivatedUsers;
        int searchResultCount;
        List<String> filters;
        RealmModel realm = this.session.getContext().getRealm();
        String userId = authResult.getUser().getId();
        try {
            JsonSearchRequest query = (JsonSearchRequest)this.objectMapper.readValue(postData, JsonSearchRequest.class);
            filters = query.filter;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        try {
            searchResultCount = OlvidConfigurationDao.getIntConfiguration(this.em, realm.getId(), "searchResultCount", 50);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        try {
            searchIncludeNotActivatedUsers = OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "isSearchIncludeNotActivatedUsers", false);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        try {
            circleVisibility = OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "enableVisibilityCircles", false);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        try {
            JsonSearchResponse response = new JsonSearchResponse();
            response.setResults(new ArrayList<OlvidUserDetails>());
            if (circleVisibility) {
                List queryResultList;
                block60: {
                    String circleId;
                    TypedQuery queryCircleVisibilityUser = this.em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
                    queryCircleVisibilityUser.setParameter("realmId", (Object)realm.getId());
                    queryCircleVisibilityUser.setParameter("id", (Object)userId);
                    try {
                        circleId = ((OlvidCircleVisibilityUser)queryCircleVisibilityUser.getSingleResult()).getCircleVisibilityId();
                    }
                    catch (NoResultException ignored) {
                        circleId = "";
                    }
                    TypedQuery<UserEntity> query = this.buildQuery(realm.getId(), userId, searchResultCount, filters, circleId);
                    if (query == null) {
                        return this.internalErrorDevice();
                    }
                    queryResultList = query.getResultList();
                    if (queryResultList.size() < searchResultCount) {
                        response.setCount(Long.valueOf(queryResultList.size()));
                        if (searchIncludeNotActivatedUsers) {
                            try {
                                TypedQuery<UserEntity> queryUnactivatedUsers = this.buildQueryWithUnActivatedUsersWithCircle(realm.getId(), userId, searchResultCount - queryResultList.size(), filters, circleId);
                                if (queryUnactivatedUsers == null) {
                                    return this.internalErrorDevice();
                                }
                                List queryResultUnactivatedUsersList = queryUnactivatedUsers.getResultList();
                                if (queryResultUnactivatedUsersList.isEmpty()) break block60;
                                queryResultList.addAll(queryResultUnactivatedUsersList);
                                if (queryResultList.size() == searchResultCount) {
                                    TypedQuery<Long> countQueryWithUnActivatedUsers = this.buildCountQueryWithUnActivatedUsersWithCircle(realm.getId(), userId, filters, circleId);
                                    response.setCountUnactivatedUsers((Long)countQueryWithUnActivatedUsers.getSingleResult());
                                    break block60;
                                }
                                response.setCountUnactivatedUsers(Long.valueOf(queryResultUnactivatedUsersList.size()));
                            }
                            catch (Exception e) {
                                logger.info((Object)e.getMessage());
                            }
                        }
                    } else {
                        TypedQuery<Long> countQuery = this.buildCountQueryWithCircle(realm.getId(), userId, filters, circleId);
                        response.setCount((Long)countQuery.getSingleResult());
                    }
                }
                for (UserEntity entity : queryResultList) {
                    OlvidUserDetails userDetails = new OlvidUserDetails();
                    userDetails.setId(entity.getId());
                    userDetails.setFirstname(entity.getFirstName());
                    userDetails.setLastname(entity.getLastName());
                    for (UserAttributeEntity attr : entity.getAttributes()) {
                        if (attr.getName() == null) continue;
                        switch (attr.getName()) {
                            case "olvid-position": {
                                userDetails.setPosition(attr.getValue());
                                break;
                            }
                            case "olvid-company": {
                                userDetails.setCompany(attr.getValue());
                                break;
                            }
                            case "olvid-identity": {
                                try {
                                    Base64.getDecoder().decode(attr.getValue());
                                }
                                catch (IllegalArgumentException e) {
                                    break;
                                }
                                userDetails.setIdentity(attr.getValue());
                            }
                        }
                    }
                    if (userDetails.getIdentity() == null) {
                        if (!searchIncludeNotActivatedUsers) continue;
                        if (response.resultsUnactivatedUsers == null) {
                            response.setResultsUnactivatedUsers(new ArrayList<OlvidUserDetails>());
                        }
                        response.resultsUnactivatedUsers.add(userDetails);
                        continue;
                    }
                    response.results.add(userDetails);
                }
            } else {
                TypedQuery<UserEntity> query = this.buildQuery(realm.getId(), userId, searchResultCount, filters, null);
                if (query == null) {
                    return this.internalErrorDevice();
                }
                List queryResultList = query.getResultList();
                if (queryResultList.size() < searchResultCount) {
                    TypedQuery<UserEntity> queryUnactivatedUsers;
                    List queryResultUnactivatedUsersList;
                    response.setCount(Long.valueOf(queryResultList.size()));
                    if (searchIncludeNotActivatedUsers && !(queryResultUnactivatedUsersList = (queryUnactivatedUsers = this.buildQueryWithUnActivatedUsers(realm.getId(), userId, searchResultCount - queryResultList.size(), filters)).getResultList()).isEmpty()) {
                        queryResultList.addAll(queryResultUnactivatedUsersList);
                        if (queryResultList.size() == searchResultCount) {
                            TypedQuery<Long> countQueryWithUnActivatedUsers = this.buildCountQueryWithUnActivatedUsers(realm.getId(), userId, filters);
                            response.setCountUnactivatedUsers((Long)countQueryWithUnActivatedUsers.getSingleResult());
                        } else {
                            response.setCountUnactivatedUsers(Long.valueOf(queryResultUnactivatedUsersList.size()));
                        }
                    }
                } else {
                    TypedQuery<Long> countQuery = this.buildCountQuery(realm.getId(), userId, filters);
                    response.setCount((Long)countQuery.getSingleResult());
                }
                for (UserEntity entity : queryResultList) {
                    OlvidUserDetails userDetails = new OlvidUserDetails();
                    userDetails.setId(entity.getId());
                    userDetails.setFirstname(entity.getFirstName());
                    userDetails.setLastname(entity.getLastName());
                    for (UserAttributeEntity attr : entity.getAttributes()) {
                        if (attr.getName() == null) continue;
                        switch (attr.getName()) {
                            case "olvid-position": {
                                userDetails.setPosition(attr.getValue());
                                break;
                            }
                            case "olvid-company": {
                                userDetails.setCompany(attr.getValue());
                                break;
                            }
                            case "olvid-identity": {
                                try {
                                    Base64.getDecoder().decode(attr.getValue());
                                }
                                catch (IllegalArgumentException e) {
                                    break;
                                }
                                userDetails.setIdentity(attr.getValue());
                            }
                        }
                    }
                    if (userDetails.getIdentity() == null) {
                        if (!searchIncludeNotActivatedUsers) continue;
                        if (response.resultsUnactivatedUsers == null) {
                            response.setResultsUnactivatedUsers(new ArrayList<OlvidUserDetails>());
                        }
                        response.resultsUnactivatedUsers.add(userDetails);
                        continue;
                    }
                    response.results.add(userDetails);
                }
            }
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }

    private TypedQuery<UserEntity> buildQuery(String realmId, String userId, Integer searchResultCount, List<String> filters, String circleId) {
        TypedQuery query;
        StringBuilder sb;
        ArrayList<String> circlesIds = new ArrayList<String>();
        if (filters == null || filters.isEmpty()) {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, SELECT_QUERY_WITH_CIRCLE, SELECT_QUERY_ALL);
            sb.append(QUERY_ORDER);
        } else {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, SELECT_QUERY_FILTERED_WITH_CIRCLE, SELECT_QUERY_FILTERED);
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
            sb.append(QUERY_ORDER);
        }
        try {
            query = this.em.createQuery(sb.toString(), UserEntity.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return null;
        }
        query.setMaxResults(searchResultCount.intValue());
        query.setParameter("realmId", (Object)realmId);
        if (circleId != null) {
            query.setParameter("circleIds", circlesIds);
        }
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    public static StringBuilder switchQuery(EntityManager em, String realmId, String circleId, List<String> circlesIds, String query1, String query3) {
        StringBuilder sb;
        block10: {
            sb = new StringBuilder();
            if (circleId == null) {
                sb.append(query3);
            } else {
                TypedQuery queryCircleVisibilitySeeContact;
                if (!circleId.isEmpty()) {
                    queryCircleVisibilitySeeContact = em.createNamedQuery("OlvidCircleVisibility.getCircleForRuleSeeContactFromCircleId", OlvidCircleVisibility.class);
                    queryCircleVisibilitySeeContact.setParameter("realmId", (Object)realmId);
                    queryCircleVisibilitySeeContact.setParameter("circleId", (Object)circleId);
                } else {
                    queryCircleVisibilitySeeContact = em.createNamedQuery("OlvidCircleVisibility.getCircleForRuleSeeContactDefaultCircle", OlvidCircleVisibility.class);
                    queryCircleVisibilitySeeContact.setParameter("realmId", (Object)realmId);
                }
                List queryCircleCanBeSee = queryCircleVisibilitySeeContact.getResultList();
                circlesIds.addAll(queryCircleCanBeSee.stream().map(OlvidCircleVisibility::getId).collect(Collectors.toList()));
                try {
                    TypedQuery queryCircleVisibilityDefaultCircleSeeContact = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromDefaultCircleSeeContact", OlvidCircleVisibilityRules.class);
                    queryCircleVisibilityDefaultCircleSeeContact.setParameter("realmId", (Object)realmId);
                    queryCircleVisibilityDefaultCircleSeeContact.setParameter("circleId", (Object)circleId);
                    sb.append(query1);
                    try {
                        queryCircleVisibilityDefaultCircleSeeContact.getSingleResult();
                        sb.append(AND_USERS_IN_CIRCLE_AND_USERS_FROM_DEFAULT_CIRCLE);
                    }
                    catch (NoResultException e) {
                        String circleDefaultRule = "";
                        if (circleId.isEmpty()) {
                            TypedQuery qDefaultRule = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRuleBetweenMembers", OlvidCircleVisibilityRules.class);
                            qDefaultRule.setParameter("realmId", (Object)realmId);
                            circleDefaultRule = ((OlvidCircleVisibilityRules)qDefaultRule.getSingleResult()).getVisibility();
                        }
                        if ("SEE_CONTACT".contentEquals(circleDefaultRule)) {
                            sb.append(AND_USERS_IN_CIRCLE_AND_USERS_FROM_DEFAULT_CIRCLE);
                            break block10;
                        }
                        sb.append(AND_USERS_IN_CIRCLE);
                    }
                }
                catch (Exception e) {
                    logger.info((Object)"Exception : ", (Throwable)e);
                }
            }
        }
        return sb;
    }

    private TypedQuery<UserEntity> buildQueryWithUnActivatedUsers(String realmId, String userId, Integer limit, List<String> filters) {
        StringBuilder sb = new StringBuilder();
        if (filters == null || filters.isEmpty()) {
            sb.append(SELECT_QUERY_ALL_NOT_ACTIVATED);
            sb.append(QUERY_ORDER);
        } else {
            sb.append(" SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))");
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
            sb.append(QUERY_ORDER);
        }
        TypedQuery query = this.em.createQuery(sb.toString(), UserEntity.class);
        query.setMaxResults(limit.intValue());
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    private TypedQuery<UserEntity> buildQueryWithUnActivatedUsersWithCircle(String realmId, String userId, Integer limit, List<String> filters, String circleId) {
        TypedQuery query;
        StringBuilder sb;
        ArrayList<String> circlesIds = new ArrayList<String>();
        if (filters == null || filters.isEmpty()) {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))", " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))");
            sb.append(QUERY_ORDER);
        } else {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))", " SELECT  DISTINCT u  FROM UserEntity u  JOIN u.attributes attr_id  JOIN u.attributes attr_full  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  WHERE u.realmId = :realmId  AND u.id != :userId  AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))");
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
            sb.append(QUERY_ORDER);
        }
        try {
            query = this.em.createQuery(sb.toString(), UserEntity.class);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return null;
        }
        query.setMaxResults(limit.intValue());
        query.setParameter("realmId", (Object)realmId);
        if (circleId != null) {
            query.setParameter("circleIds", circlesIds);
        }
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    private TypedQuery<Long> buildCountQuery(String realmId, String userId, List<String> filters) {
        StringBuilder sb = new StringBuilder();
        if (filters == null || filters.isEmpty()) {
            sb.append(COUNT_QUERY_ALL);
        } else {
            sb.append(COUNT_QUERY_FILTERED);
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
        }
        TypedQuery query = this.em.createQuery(sb.toString(), Long.class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    private TypedQuery<Long> buildCountQueryWithCircle(String realmId, String userId, List<String> filters, String circleId) {
        StringBuilder sb;
        ArrayList<String> circlesIds = new ArrayList<String>();
        if (filters == null || filters.isEmpty()) {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, COUNT_QUERY_WITH_CIRCLE, COUNT_QUERY_ALL);
        } else {
            sb = Search.switchQuery(this.em, realmId, circleId, circlesIds, COUNT_QUERY_FILTERED_WITH_CIRCLE, COUNT_QUERY_FILTERED);
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
        }
        TypedQuery query = this.em.createQuery(sb.toString(), Long.class);
        query.setParameter("realmId", (Object)realmId);
        if (circleId != null) {
            query.setParameter("circleIds", circlesIds);
            query.setParameter("userId", (Object)userId);
        }
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    private TypedQuery<Long> buildCountQueryWithUnActivatedUsers(String realmId, String userId, List<String> filters) {
        StringBuilder sb = new StringBuilder();
        if (filters == null || filters.isEmpty()) {
            sb.append(COUNT_QUERY_ALL_NOT_ACTIVATED);
        } else {
            sb.append(COUNT_QUERY_FILTERED_NOT_ACTIVATED);
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
        }
        TypedQuery query = this.em.createQuery(sb.toString(), Long.class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("userId", (Object)userId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }

    private TypedQuery<Long> buildCountQueryWithUnActivatedUsersWithCircle(String realmId, String userId, List<String> filters, String circleId) {
        StringBuilder sb = new StringBuilder();
        if (filters == null || filters.isEmpty()) {
            sb.append(COUNT_QUERY_ALL_NOT_ACTIVATED_WITH_CIRCLE);
        } else {
            sb.append(COUNT_QUERY_FILTERED_NOT_ACTIVATED_WITH_CIRCLE);
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                sb.append(QUERY_FILTER.replace("?", "s" + count));
                ++count;
            }
        }
        TypedQuery query = this.em.createQuery(sb.toString(), Long.class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("userId", (Object)userId);
        query.setParameter("circleId", (Object)circleId);
        if (filters != null) {
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().isEmpty()) continue;
                query.setParameter("s" + count, (Object)("%" + Utils.unAccent(filter) + "%"));
                ++count;
            }
        }
        return query;
    }
}

