/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.revocationTest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import io.olvid.keycloak.rest.api.revocationTest.JsonRevocationTestRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;

public class RevocationTest
extends AbstractEntryPoint {
    public RevocationTest(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        JsonRevocationTestRequest request;
        try {
            request = (JsonRevocationTestRequest)this.objectMapper.readValue(postData, JsonRevocationTestRequest.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to parse revocationTest post data. ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        byte[] response = new byte[]{0};
        Query query = this.em.createQuery("SELECT COUNT(*) FROM UserAttributeEntity attr WHERE attr.name = :name AND attr.value = :nonce").setParameter("name", (Object)"olvid-nonce").setParameter("nonce", (Object)request.getNonce());
        Object result = query.getSingleResult();
        if (result instanceof Long && (Long)result == 0L) {
            response[0] = 1;
        }
        return Response.ok((Object)response, (String)"application/octet-stream").build();
    }
}

