/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.groups;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.groups.JsonGroupsRequest;
import io.olvid.keycloak.rest.api.groups.JsonGroupsResponse;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;

public class Groups
extends AbstractBearerTokenAuthenticationPoint {
    public Groups(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = authResult.getUser();
        JsonGroupsRequest query = null;
        if (postData != null && postData.length > 0) {
            try {
                query = (JsonGroupsRequest)this.objectMapper.readValue(postData, JsonGroupsRequest.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse Groups post data. ", (Throwable)e);
            }
        }
        Long queryTimestamp = query == null ? null : query.getTimestamp();
        long currentTimestamp = System.currentTimeMillis();
        try {
            JsonGroupsResponse response = new JsonGroupsResponse();
            response.currentTimestamp = currentTimestamp;
            ArrayList<String> signedGroupBlobs = new ArrayList<String>();
            user.getGroupsStream().forEach(groupModel -> {
                OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), groupModel.getId());
                if (olvidGroup != null && olvidGroup.isEnabled() && (queryTimestamp == null || queryTimestamp < olvidGroup.getLastModificationTimestamp())) {
                    signedGroupBlobs.add(olvidGroup.getSignedGroupBlob());
                }
            });
            long earliestRevocationTimestamp = queryTimestamp != null ? queryTimestamp : currentTimestamp - 5184000000L;
            TypedQuery q = this.em.createNamedQuery("OlvidGroupDeletion.getGroupDeletionList", String.class);
            q.setParameter("realmId", (Object)realm.getId());
            q.setParameter("timestamp", (Object)earliestRevocationTimestamp);
            List signedGroupDeletions = q.getResultList();
            TypedQuery q2 = this.em.createNamedQuery("OlvidGroupMemberKicked.getGroupKickList", String.class);
            q2.setParameter("realmId", (Object)realm.getId());
            q2.setParameter("userId", (Object)user.getId());
            q2.setParameter("timestamp", (Object)earliestRevocationTimestamp);
            List signedGroupKicks = q2.getResultList();
            if (!signedGroupBlobs.isEmpty()) {
                response.signedGroupBlobs = signedGroupBlobs;
            }
            if (!signedGroupDeletions.isEmpty()) {
                response.signedGroupDeletions = signedGroupDeletions;
            }
            if (!signedGroupKicks.isEmpty()) {
                response.signedGroupKicks = signedGroupKicks;
            }
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

