/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.getData;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.DecodingException;
import io.olvid.keycloak.datatypes.Encoded;
import io.olvid.keycloak.datatypes.crypto.AuthEnc;
import io.olvid.keycloak.datatypes.crypto.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import io.olvid.keycloak.jpa.OlvidData;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.security.InvalidKeyException;
import java.util.Base64;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class GetData
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(GetData.class);

    public GetData(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(byte[] postData) {
        if (postData.length != 32) {
            return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{-1})}).getBytes()).build();
        }
        RealmModel realmModel = this.session.getContext().getRealm();
        TypedQuery q = this.em.createNamedQuery("OlvidData.getByUid", OlvidData.class);
        q.setParameter("realmId", (Object)realmModel.getId());
        q.setParameter("dataUid", (Object)Base64.getEncoder().encodeToString(postData));
        try {
            OlvidData olvidData = (OlvidData)q.getSingleResult();
            AuthEncKey authEncKey = (AuthEncKey)new Encoded(olvidData.getEncodedDataKey()).decodeSymmetricKey();
            byte[] encryptedData = new AuthEnc().encrypt(authEncKey, olvidData.getData(), PRNGHmacSHA256.get());
            return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{0}), Encoded.of(encryptedData)}).getBytes()).build();
        }
        catch (DecodingException | NoResultException | InvalidKeyException e) {
            logger.warn((Object)"No corresponding data found (or data corrupted)");
            return Response.ok((Object)Encoded.of(new Encoded[]{Encoded.of(new byte[]{9})}).getBytes()).build();
        }
    }
}

