/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.constants.ConstantsCircleVisibility;
import io.olvid.keycloak.classes.constants.EmailConstants;
import io.olvid.keycloak.classes.constants.ResponseConstants;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityChangeVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityEditVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.CircleVisibilityRuleModel;
import io.olvid.keycloak.classes.models.circleVisibility.CirclesVisibilityRulesModel;
import io.olvid.keycloak.classes.models.circleVisibility.CreateCircleVisibilityModel;
import io.olvid.keycloak.classes.models.circleVisibility.OlvidCircleVisibilityRulesListModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardJPAModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardLicensesModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardOldDataModel;
import io.olvid.keycloak.classes.models.dashboard.DashboardUsersModel;
import io.olvid.keycloak.classes.models.externalLinks.ExternalLinkModel;
import io.olvid.keycloak.classes.models.groups.CreateOlvidGroupModel;
import io.olvid.keycloak.classes.models.groups.GroupDuplicateSettingsModel;
import io.olvid.keycloak.classes.models.groups.GroupUserModel;
import io.olvid.keycloak.classes.models.groups.KeycloakProviderGroupMapperModel;
import io.olvid.keycloak.classes.models.groups.UpdateOlvidGroupModel;
import io.olvid.keycloak.classes.models.logs.LogModel;
import io.olvid.keycloak.classes.models.managers.CustomBasicWithPasswordModel;
import io.olvid.keycloak.classes.models.managers.CustomManagerBasicModel;
import io.olvid.keycloak.classes.models.managers.CustomManagerModel;
import io.olvid.keycloak.classes.models.realms.ClientInfoModel;
import io.olvid.keycloak.classes.models.realms.CronJobModel;
import io.olvid.keycloak.classes.models.realms.KeyPropertiesModel;
import io.olvid.keycloak.classes.models.realms.RealmBasicInfoModel;
import io.olvid.keycloak.classes.models.realms.RealmConfigModel;
import io.olvid.keycloak.classes.models.realms.RealmMainConfigModel;
import io.olvid.keycloak.classes.models.realms.RealmSettingsModel;
import io.olvid.keycloak.classes.models.realms.RealmsGlobalSettingsModel;
import io.olvid.keycloak.classes.models.revocations.RevocationModel;
import io.olvid.keycloak.classes.models.users.CustomUserBasicWithPasswordModel;
import io.olvid.keycloak.classes.models.users.CustomUserModel;
import io.olvid.keycloak.classes.models.users.UserModelAttributes;
import io.olvid.keycloak.classes.modelsDevices.OlvidUserDeviceModel;
import io.olvid.keycloak.datatypes.Encoded;
import io.olvid.keycloak.datatypes.JsonSharedSettings;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.datatypes.crypto.AuthEncAES256ThenSHA256Key;
import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityRules;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidConfiguration;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidConsoleLogs;
import io.olvid.keycloak.jpa.OlvidConsoleLogsDao;
import io.olvid.keycloak.jpa.OlvidData;
import io.olvid.keycloak.jpa.OlvidDataDao;
import io.olvid.keycloak.jpa.OlvidExternalLink;
import io.olvid.keycloak.jpa.OlvidExternalLinkDao;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.jpa.OlvidLogsBackend;
import io.olvid.keycloak.jpa.OlvidNotifications;
import io.olvid.keycloak.jpa.OlvidNotificationsDao;
import io.olvid.keycloak.jpa.OlvidRevocation;
import io.olvid.keycloak.jpa.OlvidRevocationDao;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractCookieAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModels.configurations.payload.users.bots.CreateBotPayloadModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.AddCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.EditCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityMembersFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCircleVisibilityRulesByCirclesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.circlesVisibilities.GetCirclesVisibilitiesFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.dashboard.GetDashboardResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.devices.GetDevicesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.devices.SetKnownDeviceResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.emails.SendAutomaticPasswordResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.CreateExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.GetExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.RevokeExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.externalLinks.UpdateExternalLinksResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.generic.GenericReponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.AddGroupUserResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.CreateOlvidGroupResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.DuplicateGroupResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupAvatarResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupEphemeralSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsByIdResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsByNameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.GetGroupsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.RemoveGroupAvatarResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.groups.UpdateOlvidGroupByIdResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.logs.GetLogsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.logs.GetLogsTypesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.managers.AddManagerResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.managers.GetManagerUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.notifications.GetNotificationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.notifications.PluginVersionInformationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmGlobalSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmSettingsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsBasicInfoResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsConfigurationResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.realms.GetRealmsMainAttributesResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.revocations.GetRevocationsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.AddUserResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.AddUsersByListResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUserByUsernameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUserGroupsResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUsersByUsernameResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.GetUsersFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.RemoveOlvidGroupUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.SignOutUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.UpdateUserResetPasswordResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.users.bots.GetBotsFilteredResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.utils.DownloadXslxCsvUsersResponseModel;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.utils.GetEmailContentResponseModel;
import io.olvid.keycloak.rest.api.configuration.ConfigurationQueryJson;
import io.olvid.keycloak.timer.CronScheduler;
import io.olvid.keycloak.timer.oneTimeJob.PluginVersionUpgradeOneTimeJob;
import io.olvid.keycloak.utils.mail.Email;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.urls.UrlType;

public class Configuration
extends AbstractCookieAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(Configuration.class);
    private static final int DEFAULT_PASSWORD_LENGTH = 10;
    private static final char[] ALLOWED_ADMIN_PASSWORD_CHARS = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$*_+=-/".toCharArray();

    public Configuration(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        block83: {
            try {
                ConfigurationQueryJson.QueryJson query = (ConfigurationQueryJson.QueryJson)this.objectMapper.readValue(postData, ConfigurationQueryJson.QueryJson.class);
                String role = authResult.getUser().getFirstAttribute("olvid-role");
                boolean isQueryAllowed = this.checkQueryIsAllowed(query.q, role, authResult);
                if (isQueryAllowed) {
                    logger.infof("Called \"configuration\", query " + query.q, new Object[0]);
                    switch (query.q) {
                        case 0: {
                            return this.processGetErrorContainersVersionQuery();
                        }
                        case 3: {
                            return this.processGetRealmsQuery();
                        }
                        case 42: {
                            return this.processGetRealmsGlobalSettings();
                        }
                        case 43: {
                            return this.processGetRealmSettings(authResult, role, query.realmName);
                        }
                        case 44: {
                            return this.processSetRealmsSettings(authResult, role, query.realmName, query.realmSettings);
                        }
                        case 4: {
                            return this.processGetRealmsMainAttributesQuery(authResult, role);
                        }
                        case 6: {
                            return this.processSetRealmsConfig(authResult, query.realmListSettings);
                        }
                        case 41: {
                            return this.processSetRealmsGlobalSettings(authResult, query.realmGlobalSettings);
                        }
                        case 7: {
                            return this.processSetRole(authResult, role, query.realmName, query.roleList);
                        }
                        case 8: {
                            return this.processGetManagersUsers(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 9: {
                            return this.processGetOlvidUsersFiltered(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset, query.isWithRestrictedInformations);
                        }
                        case 12: {
                            return this.processGetRevocation(authResult, role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 13: {
                            return this.processSignOutUser(query.realmName, query.id);
                        }
                        case 14: {
                            return this.processDeleteUserRevokedData(authResult, role, query.realmName, query.revocationId);
                        }
                        case 15: {
                            return this.processGetLogs(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 47: {
                            return this.processGetLogsType();
                        }
                        case 16: {
                            return this.processAddManagerUser(authResult, query.managerUser);
                        }
                        case 17: {
                            return this.processRemoveManagers(authResult, role, query.managersList);
                        }
                        case 18: {
                            return this.processSendAutomaticPasswordEmail(query.password, query.username, query.isocode, query.realmName);
                        }
                        case 21: {
                            return this.processSendAutomaticPasswordEmailReseted(query.password, query.username, query.isocode, query.realmName);
                        }
                        case 20: {
                            return this.processResetManagerPassword(authResult, query.managersList);
                        }
                        case 22: {
                            return this.processGetEmailContent(query.isocode, query.emailType);
                        }
                        case 19: {
                            return this.processCreateBot(authResult, postData);
                        }
                        case 46: {
                            return this.processResetBotLink(authResult, query.realmName, query.id);
                        }
                        case 23: {
                            return this.processResetUserPassword(authResult, query.usersUsernameList, query.password, query.realmName);
                        }
                        case 24: {
                            return this.processAddUser(authResult, query.user, query.realmName, query.isNoPassword);
                        }
                        case 25: {
                            return this.processGetUsersByUsername(authResult, role, query.realmName, query.usersUsernameList, query.filters, query.limit, query.offset);
                        }
                        case 26: {
                            return this.processUpdateUser(authResult, query.user, query.realmName);
                        }
                        case 30: {
                            return this.processUpdateGroup(authResult, query.realmName, query.dataObj);
                        }
                        case 31: {
                            return this.processSetUnsetGroupOlvidDiscussion(authResult, role, query.realmName, query.dataObj);
                        }
                        case 27: {
                            return this.processAddUsersByList(authResult, query.usersList, query.realmName, query.isNoPassword);
                        }
                        case 28: {
                            return this.processGetAllGroups(authResult, role, query.realmName, query.userId, query.isWithRestrictedInformations);
                        }
                        case 29: {
                            return this.processGetGroupsByName(authResult, role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 32: {
                            return this.processCreateOlvidGroup(authResult, query.realmName, query.dataObj);
                        }
                        case 33: {
                            return this.processAddOlvidGroupUsers(authResult, query.realmName, query.id, query.dataArray);
                        }
                        case 34: {
                            return this.processSetUpGroupAvatar(authResult, query.realmName, query.dataBytes, query.id, query.name);
                        }
                        case 35: {
                            return this.processRemoveOlvidGroupUsers(authResult, query.realmName, query.id, query.dataArray);
                        }
                        case 36: {
                            return this.processRemoveGroupAvatar(authResult, query.realmName, query.data);
                        }
                        case 37: {
                            return this.processGetGroupById(authResult, role, query.realmName, query.id);
                        }
                        case 38: {
                            return this.processGetGroupAvatar(query.realmName, query.dataBytes, query.id);
                        }
                        case 39: {
                            return this.processRevokeUsers(authResult, role, query.realmName, query.usersUsernameList, query.revocationType);
                        }
                        case 40: {
                            return this.processDeleteGroup(authResult, query.realmName, query.data);
                        }
                        case 45: {
                            return this.processGetBotsFiltered(authResult, role, query.realmName, query.filters, query.limit, query.offset);
                        }
                        case 48: {
                            return this.processGetRealmsBasicInfo();
                        }
                        case 49: {
                            return this.processMoveOlvidGroup(authResult, query.realmName, query.id, query.newId);
                        }
                        case 50: {
                            return this.processDuplicateOlvidGroup(authResult, query.realmName, query.id, query.dataObj);
                        }
                        case 51: {
                            return this.processGetOlvidDevicesFiltered(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 52: {
                            return this.processSetDeviceKnown(authResult, role, query.realmName, query.id, query.userId, query.value);
                        }
                        case 53: {
                            return this.processSendUserOldDeviceAlert(query.id, query.username, query.isocode, query.realmName);
                        }
                        case 54: {
                            return this.processSendUserUnknownDeviceAlert(query.id, query.username, query.isocode, query.realmName);
                        }
                        case 55: {
                            return this.processDownloadXslxCsv(authResult, query.realmName, query.format, query.tabChose, query.filters, query.offset);
                        }
                        case 56: {
                            return this.processGetUserByUsername(authResult, role, query.realmName, query.username, query.filters, query.limit, query.offset);
                        }
                        case 57: {
                            return this.processGetGroupMembersById(authResult, role, query.realmName, query.id, query.tabChose, query.filters, query.limit, query.offset, query.groupList);
                        }
                        case 58: {
                            return this.processCreateExternalLinks(authResult, query.realmName, query.dataArray);
                        }
                        case 59: {
                            return this.processGetExternalLinks(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 60: {
                            return this.processRevokeExternalLinks(authResult, role, query.realmName, query.dataArray);
                        }
                        case 61: {
                            return this.processEditExternalLinks(authResult, role, query.realmName, query.dataObj);
                        }
                        case 62: {
                            return this.processCreateCronOneTimeJob(authResult, role, query.dataObj);
                        }
                        case 63: {
                            return this.processGetUserGroups(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset, query.userId);
                        }
                        case 64: {
                            return this.processGetCirclesVisibilitesFiltered(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 65: {
                            return this.processGetCircleVisibility(authResult, role, query.realmName, query.id);
                        }
                        case 66: {
                            return this.processGetCircleVisibilityRulesByCircles(authResult, role, query.realmName, query.id, query.isWithMembers);
                        }
                        case 67: {
                            return this.processGetCircleVisibilityRulesByUsers(authResult, role, query.realmName, query.id);
                        }
                        case 68: {
                            return this.processGetCircleVisibilityMembers(authResult, role, query.realmName, query.id, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 69: {
                            return this.processAddCircleVisibility(authResult, query.realmName, query.dataObj);
                        }
                        case 70: {
                            return this.processDeleteCircleVisibility(authResult, query.realmName, query.id, query.name);
                        }
                        case 71: {
                            return this.processEditCircleVisibility(authResult, query.realmName, query.dataObj);
                        }
                        case 72: {
                            return this.processEditCircleVisibilityRules(authResult, query.realmName, query.dataObj);
                        }
                        case 73: {
                            return this.processEditUserCircleVisibilityRules(authResult, query.realmName, query.id, query.userId);
                        }
                        case 74: {
                            return this.processRemoveUsersCircleVisibility(authResult, query.realmName, query.id, query.list);
                        }
                        case 75: {
                            return this.processAddUsersCircleVisibility(authResult, query.realmName, query.id, query.list);
                        }
                        case 76: {
                            return this.processGetNotifications(authResult, role, query.realmName, query.tabChose, query.filters, query.limit, query.offset);
                        }
                        case 77: {
                            return this.processSetNotificationRead(authResult, role, query.dataArray);
                        }
                        case 78: {
                            return this.processGetDashboard(authResult, role);
                        }
                        case 79: {
                            return this.processSetGroupSharedSettings(authResult, role, query.realmName, query.id, query.data);
                        }
                        case 80: {
                            return this.processGetGroupEphemeralSettings(query.realmName, query.id);
                        }
                    }
                    break block83;
                }
                try {
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 7, "isQueryAllowed", false);
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                }
                catch (JsonProcessingException e) {
                    logger.warn((Object)"Switch configuration", (Throwable)e);
                    GenericReponseModel response = new GenericReponseModel();
                    response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, new HashMap<String, String>().put("message", e.getMessage()), false);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        return this.internalError();
    }

    private Boolean checkQueryIsAllowed(int query, String role, AuthenticationManager.AuthResult authResult) {
        String userRealmId = authResult.getSession().getRealm().getId();
        String userRealmName = authResult.getSession().getRealm().getName();
        if ("master".equals(userRealmName)) {
            return true;
        }
        boolean isAdminRealm = OlvidConfigurationDao.getBooleanConfiguration(this.em, userRealmId, "admin", false);
        if (!isAdminRealm) {
            return false;
        }
        if (role == null) {
            return false;
        }
        switch (role) {
            case "admin": {
                return true;
            }
            case "editor": {
                switch (query) {
                    case 4: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 78: 
                    case 80: {
                        return true;
                    }
                }
                return false;
            }
            case "viewer": {
                switch (query) {
                    case 4: 
                    case 9: 
                    case 12: 
                    case 25: 
                    case 28: 
                    case 29: 
                    case 37: 
                    case 38: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 76: 
                    case 78: 
                    case 80: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    protected Response processGetErrorContainersVersionQuery() {
        this.session.realms().getRealmsStream().forEach(realm -> realm.getClientsStream().forEach(element -> logger.info((Object)element.getClientId())));
        try {
            return Response.status((Response.Status)Response.Status.OK).type("application/json").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected Response processGetRealmsQuery() {
        ArrayList<RealmConfigModel> realmList = new ArrayList<RealmConfigModel>();
        this.session.realms().getRealmsStream().forEach(realm -> {
            if ("master".equals(realm.getName())) {
                return;
            }
            realmList.add(this.processGetOneConfig(this.em, this.session, (RealmModel)realm));
        });
        GetRealmsConfigurationResponseModel responseModel = new GetRealmsConfigurationResponseModel();
        responseModel.setRealmList(realmList);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return this.internalError();
        }
    }

    public RealmConfigModel processGetOneConfig(EntityManager em, KeycloakSession session, RealmModel realm) {
        Object baseRealmUrl;
        String keycloakServerUrl;
        String keycloakApiKey;
        String olvidServerUrl;
        RealmConfigModel config = new RealmConfigModel();
        config.setRevocationAllowed(OlvidConfigurationDao.getBooleanConfiguration(em, realm.getId(), "revocationAllowed", false));
        config.setTransferRestricted(OlvidConfigurationDao.getBooleanConfiguration(em, realm.getId(), "transferRestricted", false));
        config.setAdmin(OlvidConfigurationDao.getBooleanConfiguration(em, realm.getId(), "admin", false));
        config.setOlvid(OlvidConfigurationDao.getBooleanConfiguration(em, realm.getId(), "olvid", false));
        config.setName(realm.getName());
        String olvidClient = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "authClient");
        ArrayList clients = new ArrayList();
        realm.getClientsStream().forEach(clientModel -> clients.add(clientModel.getClientId()));
        if (olvidClient != null && clients.contains(olvidClient)) {
            config.setOlvidClient(olvidClient);
        }
        if ((olvidServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "serverUrl")) != null) {
            config.setOlvidServerUrl(olvidServerUrl);
        }
        if ((keycloakApiKey = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "serverKeycloakApiKey")) != null) {
            config.setKeycloakApiKey(keycloakApiKey);
        }
        if ((keycloakServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "keycloakUrl")) != null) {
            config.setKeycloakServerUrl(keycloakServerUrl);
        }
        String keyChosen = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "keyChoosen");
        config.setKeyId(new ArrayList<KeyPropertiesModel>());
        for (KeyWrapper key : session.keys().getKeysStream(realm).collect(Collectors.toList())) {
            if (key.getStatus() != KeyStatus.ACTIVE || !Objects.equals(key.getType(), "RSA") && !Objects.equals(key.getType(), "EC") || key.getUse() != KeyUse.SIG) continue;
            KeyPropertiesModel keyProperties = new KeyPropertiesModel();
            keyProperties.keyAlgorithm = key.getAlgorithm();
            keyProperties.keyType = key.getType();
            keyProperties.name = key.getKid();
            config.getKeyId().add(keyProperties);
            if (!key.getKid().equals(keyChosen)) continue;
            config.setKeyChoosen(keyChosen);
        }
        if (keycloakServerUrl != null) {
            keycloakServerUrl = keycloakServerUrl.replaceAll("/*$", "");
            baseRealmUrl = keycloakServerUrl + session.getContext().getUri(UrlType.FRONTEND).getBaseUri().getPath();
        } else {
            baseRealmUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        }
        if (!((String)baseRealmUrl).endsWith("/")) {
            baseRealmUrl = (String)baseRealmUrl + "/";
        }
        String realmUrl = (String)baseRealmUrl + "realms/" + realm.getName() + "/";
        config.setClientsInfo(new ArrayList<ClientInfoModel>());
        realm.getClientsStream().forEach(clientModel -> {
            if (!clientModel.isEnabled()) {
                return;
            }
            HashMap<String, String> keycloakJson = new HashMap<String, String>();
            keycloakJson.put("server", realmUrl);
            keycloakJson.put("cid", clientModel.getClientId());
            if (clientModel.getSecret() != null) {
                keycloakJson.put("secret", clientModel.getSecret());
            }
            HashMap<String, Object> linkJson = new HashMap<String, Object>();
            linkJson.put("keycloak", keycloakJson);
            if (olvidServerUrl != null) {
                linkJson.put("server", olvidServerUrl);
            }
            try {
                String serializedConfig = this.objectMapper.writeValueAsString(linkJson);
                String configurationUrl = "https://configuration.olvid.io/#" + Base64.getUrlEncoder().encodeToString(serializedConfig.getBytes(StandardCharsets.UTF_8));
                ClientInfoModel clientInfoModel = new ClientInfoModel();
                clientInfoModel.setName(clientModel.getClientId());
                clientInfoModel.setConfigLink(configurationUrl);
                config.getClientsInfo().add(clientInfoModel);
            }
            catch (JsonProcessingException e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        });
        return config;
    }

    private Response processGetRealmsBasicInfo() {
        ArrayList<RealmBasicInfoModel> realmList = new ArrayList<RealmBasicInfoModel>();
        this.session.realms().getRealmsStream().forEach(realm -> {
            RealmBasicInfoModel realmBasicInfo = new RealmBasicInfoModel();
            realmBasicInfo.setId(realm.getId());
            realmBasicInfo.setName(realm.getName());
            realmList.add(realmBasicInfo);
        });
        GetRealmsBasicInfoResponseModel responseModel = new GetRealmsBasicInfoResponseModel();
        responseModel.setRealmList(realmList);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return this.internalError();
        }
    }

    private Response processGetRealmsGlobalSettings() throws IOException {
        GetRealmGlobalSettingsResponseModel responseModel = new GetRealmGlobalSettingsResponseModel();
        PluginVersionInformationsResponseModel versionsInformations = new PluginVersionInformationsResponseModel();
        try {
            versionsInformations.setCurrent("4.4.0");
            versionsInformations.setMax("4.4.0");
            List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(this.em);
            if (onList.isEmpty()) {
                versionsInformations.setNotificationIsRead("1");
            } else {
                versionsInformations.setNotificationIsRead("0");
                onList.forEach(on -> {
                    if (PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(versionsInformations.getMax()) < PluginVersionUpgradeOneTimeJob.getPluginVersionFromString(on.getValue())) {
                        versionsInformations.setMax(on.getValue());
                    }
                });
            }
            responseModel.setVersionsInformations(versionsInformations);
        }
        catch (NoResultException e) {
            versionsInformations.setNotificationIsRead("0");
            versionsInformations.setMax("0.0.0");
            versionsInformations.setCurrent("0.0.0");
            responseModel.setVersionsInformations(versionsInformations);
        }
        ArrayList<CronJobModel> cronList = new ArrayList<CronJobModel>();
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidLogsBackend.getLastTimestampStartByType", OlvidLogsBackend.class);
            for (CronJobModel.Label item : CronJobModel.Label.values()) {
                q.setParameter("logType", (Object)item.toString());
                CronJobModel cronJobModel = new CronJobModel();
                cronJobModel.setLabel(item);
                try {
                    OlvidLogsBackend logBackend = (OlvidLogsBackend)q.getSingleResult();
                    cronJobModel.setStatus(logBackend.getMessage());
                    cronJobModel.setLastRunTimestamp(logBackend.getTimestampStart());
                    if (logBackend.getTimestampEnd() != null) {
                        cronJobModel.setDuration(logBackend.getTimestampEnd() - logBackend.getTimestampStart());
                    }
                }
                catch (NoResultException e) {
                    cronJobModel.setStatus("");
                    cronJobModel.setLastRunTimestamp(0L);
                }
                cronList.add(cronJobModel);
            }
            responseModel.setCronJob(cronList);
        }
        catch (Exception e) {
            responseModel.setCronJob(cronList);
            logger.error((Object)e.getMessage());
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return this.internalError();
        }
    }

    private Response processGetRealmSettings(AuthenticationManager.AuthResult authResult, String role, String realmName) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(44, role, authResult);
        }
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        RealmSettingsModel realmSettings = RealmSettingsModel.initRealmSettings(this.em, this.session, realm, writeAllowed);
        RealmConfigModel realmConfig = this.processGetOneConfig(this.em, this.session, realm);
        realmSettings.configLink = realmConfig.getClientsInfo().stream().filter(clientInfo -> clientInfo.getName().equals(realmConfig.getOlvidClient())).findFirst().get().getConfigLink();
        GetRealmSettingsResponseModel responseModel = new GetRealmSettingsResponseModel().initGetRealmSettingsResponseModel(realmSettings);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, new HashMap<String, String>().put("message", e.getMessage()), true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
        }
    }

    private Response processGetRealmsMainAttributesQuery(AuthenticationManager.AuthResult authResult, String role) throws JsonProcessingException {
        boolean adminRealmAccess;
        ArrayList<RealmMainConfigModel> realms = new ArrayList<RealmMainConfigModel>();
        boolean globalSettingsAccess = false;
        if (authResult != null) {
            globalSettingsAccess = this.checkQueryIsAllowed(3, role, authResult);
            adminRealmAccess = this.checkQueryIsAllowed(8, role, authResult);
        } else {
            adminRealmAccess = false;
        }
        this.session.realms().getRealmsStream().forEach(realmModel -> {
            if ("master".equals(realmModel.getName())) {
                return;
            }
            if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false) && !adminRealmAccess) {
                return;
            }
            RealmMainConfigModel realmMainConfig = new RealmMainConfigModel();
            realmMainConfig.setName(realmModel.getName());
            realmMainConfig.setAdmin(OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false));
            realmMainConfig.setOlvid(OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false));
            realmMainConfig.setIdProvider(realmModel.getIdentityProvidersStream().findAny().isPresent());
            List realmComponentList = realmModel.getComponentsStream().map(ComponentModel::getProviderId).collect(Collectors.toList());
            realmMainConfig.setUserFederation(false);
            if (!realmComponentList.isEmpty()) {
                realmMainConfig.setUserFederation(realmComponentList.contains("ldap") || realmComponentList.contains("kerberos"));
            }
            realmMainConfig.setRealmSettings(RealmSettingsModel.initRealmSettings(this.em, this.session, realmModel, false));
            realms.add(realmMainConfig);
        });
        GetRealmsMainAttributesResponseModel responseModel = new GetRealmsMainAttributesResponseModel();
        responseModel.setGlobalSettingsAccess(globalSettingsAccess);
        responseModel.setRealmMainAttributes(realms);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private boolean processSetOneRealmConfig(String realmId, boolean revocationAllowed, boolean transferRestricted, boolean admin, boolean olvid, String olvidClient, String olvidServerUrl, String keycloakApiKey, String keycloakServerUrl, String keyChosen) {
        try {
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "revocationAllowed", revocationAllowed);
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "transferRestricted", transferRestricted);
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "admin", admin);
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "olvid", olvid);
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "authClient", Utils.nullOrTrim(olvidClient));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "serverUrl", Utils.nullOrTrim(olvidServerUrl));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "serverKeycloakApiKey", Utils.nullOrTrim(keycloakApiKey));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "keycloakUrl", Utils.nullOrTrim(keycloakServerUrl));
            OlvidConfigurationDao.setConfiguration(this.em, realmId, "keyChoosen", Utils.nullOrTrim(keyChosen));
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return false;
        }
    }

    private Response processSetRealmsConfig(AuthenticationManager.AuthResult authResult, HashMap<String, List<RealmConfigModel>> realmListSettings) {
        boolean[] existsAdmin = new boolean[]{false};
        try {
            Optional<RealmConfigModel> authenticatedUserRealmConfig;
            AtomicReference response = new AtomicReference();
            response.set(null);
            realmListSettings.get("realmList").forEach(realmConfig -> {
                HashMap<String, String> error;
                if (realmConfig.isAdmin()) {
                    if (existsAdmin[0]) {
                        error = new HashMap<String, String>();
                        error.put("errorMessage", "Cannot save two different admin realms");
                        try {
                            response.set(Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(error)).type("application/json").build());
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    existsAdmin[0] = true;
                }
                if (realmConfig.isOlvid()) {
                    if (realmConfig.getKeyChoosen() == null) {
                        error = new HashMap();
                        error.put("errorMessage", "Cannot save without Key chosen");
                        try {
                            response.set(Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(error)).type("application/json").build());
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (realmConfig.getOlvidClient() == null) {
                        error = new HashMap();
                        error.put("errorMessage", "Cannot save without Client chosen");
                        try {
                            response.set(Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(error)).type("application/json").build());
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            if (response.get() != null) {
                return (Response)response.get();
            }
            if (!"master".equals(authResult.getSession().getRealm().getName()) && (authenticatedUserRealmConfig = realmListSettings.get("realmList").stream().filter(realm -> realm.getName().equals(authResult.getSession().getRealm().getName())).findFirst()).isPresent() && !authenticatedUserRealmConfig.get().isAdmin()) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("errorMessage", "Cannot set the realm you are logged in to non admin");
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(error)).type("application/json").build();
            }
        }
        catch (JsonProcessingException e) {
            return this.internalError();
        }
        StringBuilder realmsSb = new StringBuilder();
        try {
            realmListSettings.get("realmList").forEach(realmConfig -> {
                String realmName = realmConfig.getName();
                RealmModel realmModel = this.session.realms().getRealmByName(realmName);
                StringBuilder modificationsSb = new StringBuilder();
                boolean realmHasModifications = false;
                boolean configHasModifications = false;
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "revocationAllowed", false) != realmConfig.isRevocationAllowed()) {
                    modificationsSb.append("    revocationAllowed: " + realmConfig.isRevocationAllowed());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "transferRestricted", false) != realmConfig.isTransferRestricted()) {
                    modificationsSb.append("    transferRestricted: " + realmConfig.isTransferRestricted());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false) != realmConfig.isAdmin()) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    admin: " + realmConfig.isAdmin());
                    realmHasModifications = true;
                }
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false) != realmConfig.isOlvid()) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    olvid: " + realmConfig.isOlvid());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "authClient"), realmConfig.getOlvidClient())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    authClient: " + realmConfig.getOlvidClient());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "keyChoosen"), realmConfig.getKeyChoosen())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    keyChoosen: " + realmConfig.getKeyChoosen());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "serverUrl"), realmConfig.getOlvidServerUrl())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    serverUrl: " + realmConfig.getOlvidServerUrl());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "serverKeycloakApiKey"), realmConfig.getKeycloakApiKey())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    serverKeycloakApiKey: " + realmConfig.getKeycloakApiKey());
                    realmHasModifications = true;
                }
                if (!Objects.equals(OlvidConfigurationDao.getStringConfiguration(this.em, realmModel.getId(), "keycloakUrl"), realmConfig.getKeycloakServerUrl())) {
                    if (realmHasModifications) {
                        modificationsSb.append(",\n");
                    }
                    modificationsSb.append("    keycloakUrl: " + realmConfig.getKeycloakServerUrl());
                    realmHasModifications = true;
                }
                if (realmHasModifications) {
                    if (configHasModifications) {
                        realmsSb.append("\n");
                    }
                    realmsSb.append("- '" + realmName + "' modified [\n" + String.valueOf(modificationsSb) + "\n  ]");
                    configHasModifications = true;
                }
                if (!this.processSetOneRealmConfig(realmModel.getId(), realmConfig.isRevocationAllowed(), realmConfig.isTransferRestricted(), realmConfig.isAdmin(), realmConfig.isOlvid(), realmConfig.getOlvidClient(), realmConfig.getOlvidServerUrl(), realmConfig.getKeycloakApiKey(), realmConfig.getKeycloakServerUrl(), realmConfig.getKeyChoosen())) {
                    logger.warn((Object)("An error occurred saving " + realmConfig.getName() + ", Configuration.java"));
                }
                if (configHasModifications) {
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realmName, "setConfig", "Realms modified:\n" + String.valueOf(realmsSb), ret);
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return this.processGetRealmsQuery();
    }

    private Response processSetRealmsGlobalSettings(AuthenticationManager.AuthResult authResult, RealmsGlobalSettingsModel realmListGlobalSettings) throws IOException {
        StringBuilder realmsSb = new StringBuilder();
        boolean configHasModifications = false;
        if (configHasModifications) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), "master", "setGlobalSettings", realmsSb.toString(), ret);
        }
        return this.processGetRealmsGlobalSettings();
    }

    private Response processSetRealmsSettings(AuthenticationManager.AuthResult authResult, String role, String realmName, RealmSettingsModel realmSettings) {
        boolean configHasModifications;
        StringBuilder realmsSb;
        block30: {
            realmsSb = new StringBuilder();
            realmsSb.append(realmName).append(" ");
            configHasModifications = false;
            try {
                RealmModel realmModel = this.session.realms().getRealmByName(realmName);
                String userLogIn = authResult.getUser().getUsername();
                boolean isBotUserExist = this.session.users().searchForUserByUserAttributeStream(realmModel, "olvid-is-bot", "true").findAny().isPresent();
                if (!isBotUserExist) {
                    if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false) != realmSettings.getEnableBotsManagement()) {
                        realmsSb.append("- Bots management " + (realmSettings.getEnableBotsManagement() ? "enabled" : "disabled"));
                        configHasModifications = true;
                    }
                    OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "enableBotsManagement", realmSettings.getEnableBotsManagement());
                } else {
                    OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "enableBotsManagement", true);
                }
                if (OlvidConfigurationDao.getIntConfiguration(this.em, realmModel.getId(), "searchResultCount", 50) != realmSettings.searchResultCount) {
                    if (configHasModifications) {
                        realmsSb.append("\n");
                    }
                    realmsSb.append("- Search result count management : " + realmSettings.searchResultCount);
                    configHasModifications = true;
                }
                if (realmSettings.searchResultCount < 1) {
                    realmSettings.searchResultCount = 50;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "searchResultCount", String.valueOf(realmSettings.searchResultCount));
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "isSearchIncludeNotActivatedUsers", false) != realmSettings.getIsSearchIncludeNotActivatedUsers()) {
                    if (configHasModifications) {
                        realmsSb.append("\n");
                    }
                    realmsSb.append("- Search IncludeNotActivatedUsers management " + (realmSettings.getIsSearchIncludeNotActivatedUsers() ? "enabled" : "disabled"));
                    configHasModifications = true;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "isSearchIncludeNotActivatedUsers", realmSettings.getIsSearchIncludeNotActivatedUsers());
                if (realmSettings.oldDeviceTimeLimit < 1) {
                    realmSettings.oldDeviceTimeLimit = 30;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "oldDeviceTimeLimit", String.valueOf(realmSettings.oldDeviceTimeLimit));
                if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableVisibilityCircles", false) != realmSettings.getEnableVisibilityCircle()) {
                    realmsSb.append("- Visibility Circle management " + (realmSettings.getEnableVisibilityCircle() ? "enabled" : "disabled"));
                    configHasModifications = true;
                }
                OlvidConfigurationDao.setConfiguration(this.em, realmModel.getId(), "enableVisibilityCircles", realmSettings.getEnableVisibilityCircle());
                if (!realmSettings.getEnableVisibilityCircle()) break block30;
                try {
                    HashMap<String, Object> ret;
                    String logs2;
                    TypedQuery qFrom = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                    qFrom.setParameter("realmId", (Object)realmModel.getId());
                    qFrom.getSingleResult();
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultRealmCircleRuleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)"NO").executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultRuleFrom = new OlvidCircleVisibilityRules();
                            circleDefaultRuleFrom.setId("default-from");
                            circleDefaultRuleFrom.setRealmId(realmModel.getId());
                            circleDefaultRuleFrom.setVisibility("NO");
                            this.em.persist((Object)circleDefaultRuleFrom);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : default-from,\n  edit rule visibility : NO,\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap<String, Object>();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs2) {}
                    }
                    catch (NoResultException count) {
                        // empty catch block
                    }
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultRealmCircleRuleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)"NO").executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultRuleTo = new OlvidCircleVisibilityRules();
                            circleDefaultRuleTo.setId("default-to");
                            circleDefaultRuleTo.setRealmId(realmModel.getId());
                            circleDefaultRuleTo.setVisibility("NO");
                            this.em.persist((Object)circleDefaultRuleTo);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : default-to,\n  edit rule visibility : NO,\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs3) {}
                    }
                    catch (NoResultException count) {
                        // empty catch block
                    }
                    try {
                        int count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)ConstantsCircleVisibility.sanitizeVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers())).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules circleDefaultCircleRules = new OlvidCircleVisibilityRules();
                            circleDefaultCircleRules.setId("defaultCircleBetweenMembers");
                            circleDefaultCircleRules.setVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers());
                            circleDefaultCircleRules.setRealmId(realmModel.getId());
                            this.em.persist((Object)circleDefaultCircleRules);
                        }
                        try {
                            logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  edit default rule for realm : DefaultCircleRuleBetweenMembers,\n  edit rule visibility : " + realmSettings.getVisibilityCircleDefaultRuleBetweenMembers() + ",\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs2);
                            ret = new HashMap();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs2, ret);
                        }
                        catch (Exception logs4) {}
                    }
                    catch (NoResultException count) {
                    }
                }
                catch (Exception e) {
                    OlvidCircleVisibilityRules circleDefaultRuleFrom = new OlvidCircleVisibilityRules();
                    circleDefaultRuleFrom.setId("default-from");
                    circleDefaultRuleFrom.setRealmId(realmModel.getId());
                    circleDefaultRuleFrom.setVisibility(realmSettings.getVisibilityCircleRealmDefaultRuleFrom() != null ? realmSettings.getVisibilityCircleRealmDefaultRuleFrom() : "NO");
                    this.em.persist((Object)circleDefaultRuleFrom);
                    OlvidCircleVisibilityRules circleDefaultRuleTo = new OlvidCircleVisibilityRules();
                    circleDefaultRuleTo.setId("default-to");
                    circleDefaultRuleTo.setRealmId(realmModel.getId());
                    circleDefaultRuleTo.setVisibility(realmSettings.getVisibilityCircleRealmDefaultRuleTo() != null ? realmSettings.getVisibilityCircleRealmDefaultRuleTo() : "NO");
                    this.em.persist((Object)circleDefaultRuleTo);
                    OlvidCircleVisibilityRules circleDefaultCircleRules = new OlvidCircleVisibilityRules();
                    circleDefaultCircleRules.setId("defaultCircleBetweenMembers");
                    circleDefaultCircleRules.setVisibility(realmSettings.getVisibilityCircleDefaultRuleBetweenMembers());
                    circleDefaultCircleRules.setRealmId(realmModel.getId());
                    this.em.persist((Object)circleDefaultCircleRules);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        if (configHasModifications) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realmName, "setGlobalSettings", "Realms modified:\n" + String.valueOf(realmsSb), ret);
        }
        return this.processGetRealmSettings(authResult, role, realmName);
    }

    private Response processSetRole(AuthenticationManager.AuthResult authResult, String role, String realmName, List<CustomManagerModel> roleList) {
        StringBuilder sb = new StringBuilder();
        boolean[] modified = new boolean[]{false};
        try {
            RealmModel realmModel = this.session.realms().getRealmByName(realmName);
            roleList.forEach(roleManager -> {
                UserModel userModel = this.session.users().getUserByUsername(realmModel, roleManager.getUsername());
                String previousRole = userModel.getFirstAttribute("olvid-role");
                if (!Objects.equals(previousRole, roleManager.getRole())) {
                    userModel.setSingleAttribute("olvid-role", roleManager.getRole());
                    if (modified[0]) {
                        sb.append(";\n");
                    }
                    sb.append(roleManager.getUsername() + " given role " + roleManager.getRole());
                    modified[0] = true;
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        if (modified[0]) {
            sb.append(";");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realmName, "setRole", "Changes roles of users:\n" + String.valueOf(sb), ret);
        ArrayList<String> filters = new ArrayList<String>();
        String tabChose = "";
        return this.processGetManagersUsers(authResult, role, realmName, tabChose, filters, 5, 0);
    }

    private Response processSetDeviceKnown(AuthenticationManager.AuthResult authResult, String role, String realmName, String deviceUid, String userId, Boolean value) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(52, role, authResult);
        }
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByDeviceUid", OlvidUserDevice.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("deviceUid", (Object)deviceUid);
            q.setParameter("userId", (Object)userId);
            OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
            olvidUserDevice.setIsKnown(value);
            this.em.persist((Object)olvidUserDevice);
        }
        catch (NoResultException q) {
            // empty catch block
        }
        try {
            SetKnownDeviceResponseModel responseModel = new SetKnownDeviceResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processRevokeUsers(AuthenticationManager.AuthResult authResult, String role, String realmName, ArrayList<String> userIdsList, Integer revocationType) {
        if (realmName == null || userIdsList.get(0) == null || revocationType == null || revocationType != 0 && revocationType != 1) {
            return this.internalError();
        }
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        if (realm == null) {
            return this.internalError();
        }
        HashSet groupIdsSet = new HashSet();
        userIdsList.forEach(userId -> {
            UserModel user = this.session.users().getUserById(realm, userId);
            groupIdsSet.addAll(user.getGroupsStream().map(GroupModel::getId).collect(Collectors.toList()));
        });
        userIdsList.forEach(userId -> {
            OlvidUser olvidUser2;
            TypedQuery q;
            UserModel user = this.session.users().getUserById(realm, userId);
            long timestamp = System.currentTimeMillis();
            try {
                List offlineSessions = this.session.sessions().getOfflineUserSessionsStream(realm, user).collect(Collectors.toList());
                for (UserSessionModel userSessionModel : offlineSessions) {
                    this.session.sessions().removeOfflineUserSession(realm, userSessionModel);
                }
                this.session.sessions().removeUserSessions(realm, user);
            }
            catch (Exception offlineSessions) {
                // empty catch block
            }
            try {
                q = this.em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
                q.setParameter("realmId", (Object)realm.getId());
                q.setParameter("userId", userId);
                try {
                    olvidUser2 = (OlvidUser)q.getSingleResult();
                    olvidUser2.setLastSync(null);
                    this.em.merge((Object)olvidUser2);
                }
                catch (NoResultException olvidUser2) {
                    // empty catch block
                }
                TypedQuery qd = this.em.createNamedQuery("OlvidUserDevice.getById", OlvidUserDevice.class);
                qd.setParameter("realmId", (Object)realm.getId());
                qd.setParameter("userId", userId);
                try {
                    List olvidUserDevices = qd.getResultList();
                    olvidUserDevices.forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0));
                }
                catch (NoResultException noResultException) {}
            }
            catch (Exception e) {
                logger.warn((Object)"Exception in processRevokeUsers : ", (Throwable)e);
            }
            try {
                HashMap<String, Object> ret;
                OlvidRevocationDao.createRevocation(this.em, realm, user, timestamp, revocationType, this.session, this.objectMapper);
                try {
                    q = this.em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
                    q.setParameter("realmId", (Object)realm.getId());
                    q.setParameter("userId", (Object)user.getId());
                    olvidUser2 = (OlvidUser)q.getSingleResult();
                    this.em.remove((Object)olvidUser2);
                }
                catch (NoResultException q2) {
                    // empty catch block
                }
                if (revocationType == 0) {
                    ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realmName, "idRevocation", "User's id revoked: " + user.getUsername(), ret);
                } else {
                    ret = new HashMap();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realmName, "removeUser", "User removed: " + user.getUsername(), ret);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        });
        SecureRandom random = new SecureRandom();
        groupIdsSet.forEach(groupId -> {
            GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realm, groupModel, this.objectMapper, random);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to update OlvidGroup with id " + groupModel.getId()));
                    logger.warn((Object)"Exception : ", (Throwable)e);
                }
            }
        });
        HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
        String pushTopic = OlvidConfigurationDao.getStringConfiguration(this.em, realm.getId(), "keycloakPushTopic");
        if (pushTopic != null) {
            usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.TOPIC, realm.getId(), pushTopic));
        }
        CronScheduler.scheduleSendNotifications(usersAndTopicsToNotify);
        return this.processGetRevocation(authResult, role, realmName, new ArrayList<String>(), 10, 0);
    }

    private Response processGetRevocation(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> filters, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(14, role, authResult);
        }
        return this.getResponseProcessGetRevocation(filters, limit, offset, realm, writeAllowed);
    }

    protected Response getResponseProcessGetRevocation(List<String> filters, int limit, int offset, RealmModel realm, boolean writeAllowed) {
        if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            List<OlvidRevocation> revocations = OlvidRevocationDao.getOlvidRevocations(this.em, realm.getId(), filters, limit, offset);
            List<RevocationModel> customRevocationsModel = revocations.stream().map(revocation -> new RevocationModel().initRevocationModel((OlvidRevocation)revocation)).collect(Collectors.toList());
            long count = OlvidRevocationDao.getOlvidCountRevocations(this.em, realm.getId(), filters);
            GetRevocationsResponseModel responseModel = new GetRevocationsResponseModel();
            responseModel.setRevocations(customRevocationsModel);
            responseModel.setCount(count);
            responseModel.setWriteAllowed(writeAllowed);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            try {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
                return this.internalError();
            }
        }
        logger.warn((Object)"Cannot access revocation list of a non olvid realm");
        return this.badRealmType();
    }

    private Response processGetManagersUsers(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(7, role, authResult);
        }
        return this.getResponseProcessGetManagerUsers(tabChose, filters, limit, offset, realm, writeAllowed);
    }

    protected Response getResponseProcessGetManagerUsers(String tabChose, List<String> filters, int limit, int offset, RealmModel realm, boolean writeAllowed) {
        HashMap<String, String> searchParams;
        ArrayList<CustomManagerModel> managerUsersList = new ArrayList<CustomManagerModel>();
        if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "admin", false)) {
            searchParams = new HashMap<String, String>();
            if (!filters.isEmpty()) {
                for (String filter : filters) {
                    if (tabChose.contentEquals("Username")) {
                        searchParams.put("username", filter);
                        continue;
                    }
                    if (tabChose.contentEquals("Firstname")) {
                        searchParams.put("firstName", filter);
                        continue;
                    }
                    if (tabChose.contentEquals("Lastname")) {
                        searchParams.put("lastName", filter);
                        continue;
                    }
                    if (!tabChose.contentEquals("Email")) continue;
                    searchParams.put("email", filter);
                }
            }
        } else {
            logger.warn((Object)"Cannot access admin users of a non admin realm");
            return this.badRealmType();
        }
        List<UserModel> usersList = this.session.users().searchForUserStream(realm, searchParams, Integer.valueOf(offset), Integer.valueOf(limit)).collect(Collectors.toList());
        usersList.forEach(userModel -> {
            OlvidUserDetails olvidUserDetails = new OlvidUserDetails((UserModel)userModel);
            CustomManagerModel managerUsers = new CustomManagerModel();
            managerUsers.setFirstname(olvidUserDetails.getFirstname());
            managerUsers.setLastname(olvidUserDetails.getLastname());
            managerUsers.setUsername(userModel.getUsername());
            managerUsers.setEmail(userModel.getEmail());
            managerUsers.setRole(userModel.getFirstAttribute("olvid-role"));
            managerUsers.setFederatedUsers(Utils.getUserAttribute(userModel, "LDAP_ID") != null || Utils.getUserAttribute(userModel, "KERBEROS_PRINCIPAL") != null);
            managerUsers.setFederatedIdentities(this.session.users().getFederatedIdentitiesStream(realm, userModel).findAny().isPresent());
            managerUsersList.add(managerUsers);
        });
        filters = new ArrayList<String>();
        Query countQuery = this.buildQueryCountWithFilter(realm.getId(), "", filters, new ArrayList<String>());
        Object countResult = countQuery.getSingleResult();
        GetManagerUsersResponseModel responseModel = new GetManagerUsersResponseModel();
        responseModel.setCount((Long)countResult);
        responseModel.setWriteAllowed(writeAllowed);
        responseModel.setManagerUsersList(managerUsersList);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    private Response processGetOlvidUsersFiltered(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset, Boolean isWithRestrictedInformations) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(39, role, authResult);
        }
        if (isWithRestrictedInformations == null) {
            isWithRestrictedInformations = false;
        }
        return this.getResponseProcessGetOlvidUsersFiltered(tabChose, filters, limit, offset, realm, writeAllowed, isWithRestrictedInformations);
    }

    protected Response getResponseProcessGetOlvidUsersFiltered(String tabChose, List<String> filters, int limit, int offset, RealmModel realm, boolean writeAllowed, boolean isWithRestrictedInformations) {
        try {
            TypedQuery<Object[]> query = this.buildUsersQueryLimited(realm.getId(), filters, limit, offset, Utils.emptyStringOrTrim(tabChose), new ArrayList<String>());
            List<Object> olvidUsersList = new ArrayList();
            olvidUsersList = isWithRestrictedInformations ? query.getResultStream().map(result -> Configuration.createOlvidUserRestrictedFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList()) : query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildQueryCountWithFilter(realm.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
            Long countResult = (Long)countQuery.getSingleResult();
            GetUsersFilteredResponseModel responseModel = new GetUsersFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount(countResult);
            responseModel.setUsersList(olvidUsersList);
            responseModel.setRealmComponent(realm.getComponentsStream().map(ComponentModel::getName).collect(Collectors.toList()));
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetOlvidDevicesFiltered(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            TypedQuery<Object[]> query = this.buildDevicesQueryLimited(realm.getId(), filters, limit, offset, Utils.emptyStringOrTrim(tabChose));
            List<OlvidUserDeviceModel> olvidUserDeviceList = query.getResultStream().map(device -> new OlvidUserDeviceModel().newOlvidUserDevice(this.em, this.session, realm, (Object[])device, new OlvidCircleVisibility())).collect(Collectors.toList());
            Query countQuery = this.buildDevicesQueryCountWithFilter(realm.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
            Object countResult = countQuery.getSingleResult();
            Object countResultUnknown = 0;
            Object countResultOldSync = 0;
            if (!tabChose.contentEquals("From User Page")) {
                Query countQueryUnknown = this.buildDevicesQueryCountWithFilter(realm.getId(), "Devices UnKnown", filters, new ArrayList<String>());
                countResultUnknown = countQueryUnknown.getSingleResult();
                Query countQueryOldSync = this.buildDevicesQueryCountWithFilter(realm.getId(), "Old Sync", filters, new ArrayList<String>());
                countResultOldSync = countQueryOldSync.getSingleResult();
            }
            GetDevicesResponseModel responseModel = new GetDevicesResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setCountUnknown((Long)countResultUnknown);
            responseModel.setCountOldSync((Long)countResultOldSync);
            responseModel.setDevicesList(olvidUserDeviceList);
            responseModel.setRealmComponent(realm.getComponentsStream().map(ComponentModel::getName).collect(Collectors.toList()));
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetBotsFiltered(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> filters, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(46, role, authResult);
        }
        boolean botsManagementEnable = false;
        if (authResult != null) {
            botsManagementEnable = OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "enableBotsManagement", false);
        }
        return this.getResponseProcessGetBotsFiltered(filters, limit, offset, realm, writeAllowed, botsManagementEnable);
    }

    protected Response getResponseProcessGetBotsFiltered(List<String> filters, int limit, int offset, RealmModel realm, boolean writeAllowed, boolean botsManagementEnable) {
        try {
            TypedQuery<Object[]> query = this.buildBotQueryLimited(realm.getId(), filters, limit, offset);
            List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildBotCountQueryLimited(realm.getId(), filters, new ArrayList<String>());
            Object countResult = countQuery.getSingleResult();
            GetBotsFilteredResponseModel responseModel = new GetBotsFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setEnableBotsManagement(botsManagementEnable);
            responseModel.setCount((Long)countResult);
            responseModel.setBotsList(olvidUsersList);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    public static CustomUserModel createOlvidUserFromUserEntity(EntityManager em, KeycloakSession session, RealmModel realm, UserEntity userEntity, OlvidCircleVisibility userOlvidCircleVisibility) {
        try {
            UserModel userModel = session.users().getUserById(realm, userEntity.getId());
            if (userModel != null) {
                String tabChose = "";
                return Configuration.createOlvidUserFromUserModel(em, session, realm, userModel, tabChose, userOlvidCircleVisibility);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        return null;
    }

    public static CustomUserModel createOlvidUserRestrictedFromUserEntity(EntityManager em, KeycloakSession session, RealmModel realm, UserEntity userEntity, OlvidCircleVisibility userOlvidCircleVisibility) {
        CustomUserModel olvidUser = new CustomUserModel();
        olvidUser.setId(userEntity.getId());
        olvidUser.setUsername(userEntity.getUsername());
        olvidUser.setFirstname(userEntity.getFirstName());
        olvidUser.setLastname(userEntity.getLastName());
        olvidUser.setFullname(userEntity.getFirstName(), userEntity.getLastName());
        olvidUser.setEmail(userEntity.getEmail());
        return olvidUser;
    }

    public static CustomUserModel createOlvidUserFromUserModel(EntityManager em, KeycloakSession session, RealmModel realm, UserModel user, String tabChose, OlvidCircleVisibility userOlvidCircleVisibility) {
        CustomUserModel olvidUser = new CustomUserModel();
        olvidUser = olvidUser.initCustomUserModel(em, session, realm, olvidUser, user, userOlvidCircleVisibility);
        olvidUser.setLastSync(OlvidUserDetails.getLastSync(em, realm, user));
        olvidUser.setUserDevices(OlvidUserDetails.getOlvidUserDevice(em, realm, user));
        olvidUser.setCountUserOlvidGroups(user.getGroupsCount());
        olvidUser.setUserGroups(Collections.emptyList());
        if (olvidUser.getOlvidIdentity() != null) {
            try {
                byte[] identityBytes = Base64.getDecoder().decode(olvidUser.getOlvidIdentity());
                StringBuilder sb = new StringBuilder();
                if (olvidUser.getFirstname() != null) {
                    sb.append(olvidUser.getFirstname());
                }
                if (olvidUser.getLastname() != null) {
                    if (olvidUser.getFirstname() != null) {
                        sb.append(" ");
                    }
                    sb.append(olvidUser.getLastname());
                }
                if (olvidUser.getPosition() != null || olvidUser.getCompany() != null) {
                    sb.append(" (");
                    if (olvidUser.getPosition() != null) {
                        sb.append(olvidUser.getPosition());
                        if (olvidUser.getCompany() != null) {
                            sb.append("@");
                            sb.append(olvidUser.getCompany());
                        }
                    } else {
                        sb.append(olvidUser.getCompany());
                    }
                    sb.append(")");
                }
                olvidUser.setInvitationLink("https://invitation.olvid.io/#" + Base64.getUrlEncoder().encodeToString(Encoded.of(new Encoded[]{Encoded.of(identityBytes), Encoded.of(sb.toString())}).getBytes()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (tabChose != null && !tabChose.isEmpty()) {
            if (tabChose.contentEquals("Without Olvid password")) {
                if (!olvidUser.getCredential().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("Activated")) {
                if (olvidUser.getIsActivated().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("Not activated")) {
                if (!olvidUser.getIsActivated().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            if (tabChose.contentEquals("Bot")) {
                if (olvidUser.getOlvidIsBot().booleanValue()) {
                    return olvidUser;
                }
                olvidUser.setId("");
                return olvidUser;
            }
            olvidUser.setId("");
            return olvidUser;
        }
        return olvidUser;
    }

    private Response processGetAllGroups(AuthenticationManager.AuthResult authResult, String role, String realmName, String userId, Boolean isWithRestrictedInformations) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        if (isWithRestrictedInformations == null) {
            isWithRestrictedInformations = true;
        }
        return this.getResponseProcessGetAllGroups(realmName, writeAllowed, userId, isWithRestrictedInformations);
    }

    protected Response getResponseProcessGetAllGroups(String realmName, boolean writeAllowed, String userId, Boolean isWithRestrictedInformations) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid groups of a non olvid realm");
            return this.badRealmType();
        }
        try {
            ArrayList<UserModelAttributes> userModelsCache = new ArrayList<UserModelAttributes>();
            List<GroupModel> flatGroupList = realm.getGroupsStream().collect(Collectors.toList());
            ArrayList<GroupModel> groupFlatListFiltered = new ArrayList<GroupModel>();
            List<GroupModel> flatGroupListTopPath = flatGroupList.stream().filter(group -> Utils.computeGroupPath(group).isEmpty()).collect(Collectors.toList());
            int limit = flatGroupListTopPath.size();
            List<GroupUserModel> groupTreeList = this.buildGroupsTreeHierarchy(this.em, this.session, realm, flatGroupList, flatGroupListTopPath, groupFlatListFiltered, 0, limit, userId, userModelsCache, isWithRestrictedInformations);
            GetGroupsResponseModel responseModel = new GetGroupsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            List flatGroupListFilteredFormated = groupFlatListFiltered.stream().map(group -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realm, (GroupModel)group, isWithRestrictedInformations, (List<UserModelAttributes>)userModelsCache, "", (List<String>)new ArrayList<String>(), "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            responseModel.setCount(flatGroupList.size());
            responseModel.setFlatList(flatGroupListFilteredFormated);
            responseModel.setGroupTreeList(groupTreeList);
            responseModel.setCountTopGroup(flatGroupListTopPath.size());
            responseModel.setCountPages((flatGroupListTopPath.size() - 1) / 10 + 1);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected List<GroupUserModel> buildGroupsTreeHierarchy(EntityManager em, KeycloakSession session, RealmModel realm, List<GroupModel> flatGroupList, List<GroupModel> flatGroupListTopPath, List<GroupModel> flatGroupListFiltered, int offset, int limit, String userId, List<UserModelAttributes> userModelsCache, Boolean isWithMembers) {
        if (!flatGroupListTopPath.isEmpty()) {
            for (int i = offset; i < flatGroupListTopPath.size(); ++i) {
                try {
                    GroupModel group2 = flatGroupListTopPath.get(i);
                    flatGroupListFiltered.add(group2);
                    List listParentsIdToFind = flatGroupListFiltered.stream().map(GroupModel::getId).collect(Collectors.toList());
                    while (!listParentsIdToFind.isEmpty()) {
                        String parentId = (String)listParentsIdToFind.get(listParentsIdToFind.size() - 1);
                        List<GroupModel> groupsChildFound = flatGroupList.stream().filter(child -> child.getParentId() != null && child.getParentId().contentEquals(parentId)).collect(Collectors.toList());
                        if (!groupsChildFound.isEmpty()) {
                            groupsChildFound.forEach(groupChildFound -> {
                                listParentsIdToFind.add(groupChildFound.getId());
                                if (!flatGroupListFiltered.contains(groupChildFound)) {
                                    flatGroupListFiltered.add((GroupModel)groupChildFound);
                                }
                            });
                        }
                        listParentsIdToFind.remove(parentId);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)("buildGroupsTreeHierarchy 'for boucle' Exception " + e.getMessage()));
                }
            }
        }
        List<GroupUserModel> flatGroupListFilteredFormated = flatGroupListFiltered.stream().map(group -> {
            try {
                return this.createGroupUsersFromGroupModel(em, session, realm, (GroupModel)group, isWithMembers, userModelsCache, "", (List<String>)new ArrayList<String>(), "");
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return Configuration.arrayToTree(flatGroupListFilteredFormated, null, 0);
    }

    protected static List<GroupUserModel> arrayToTree(List<GroupUserModel> groupFlatList, String parentId, int currentDepth) {
        return groupFlatList.stream().filter(item -> Objects.equals(item.parentId, parentId)).peek(parent -> {
            if (currentDepth < 50) {
                parent.children = Configuration.arrayToTree(groupFlatList, parent.id, currentDepth + 1);
                if (!parent.children.isEmpty()) {
                    parent.hasChild = true;
                }
            }
        }).collect(Collectors.toList());
    }

    private GroupUserModel createGroupUsersFromGroupModel(EntityManager em, KeycloakSession session, RealmModel realm, GroupModel groupModel, Boolean isWithRestrictedInformations, List<UserModelAttributes> userModelsCache, String tabChoseGroupMembers, List<String> filtersGroupMembers, String groupId) throws NamingException {
        GroupUserModel groupUsers = GroupUserModel.initGroupUsers(groupModel);
        groupUsers.setParentId(groupModel.getParentId());
        if (groupUsers.getParentId() != null) {
            groupUsers.setParentName(session.groups().getGroupById(realm, groupUsers.parentId).getName());
        }
        groupUsers.setDuplicateGroup(session.groups().getGroupsStream(realm).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupUsers.name) && !Objects.equals(groupFound.getId(), groupUsers.id)));
        groupUsers.setOlvidManaged(Utils.getGroupBooleanAttribute(groupModel, "olvid-managed"));
        ArrayList<CustomUserModel> groupMembers = new ArrayList<CustomUserModel>();
        if (!isWithRestrictedInformations.booleanValue()) {
            if (!groupUsers.olvidManaged.booleanValue()) {
                if (tabChoseGroupMembers != null && !tabChoseGroupMembers.isEmpty() || !filtersGroupMembers.isEmpty() || !groupId.isEmpty()) {
                    Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realm, groupModel, isWithRestrictedInformations == false, new ArrayList<UserModelAttributes>(), tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
                    groupUsers.setGroupMembers(groupMembers);
                } else {
                    List<ComponentModel> userProviderList = realm.getComponentsStream().filter(elem -> Objects.equals("ldap", elem.getProviderId())).collect(Collectors.toList());
                    if (!userProviderList.isEmpty()) {
                        Configuration.getProviderGroupsAndUsers(em, session, realm, groupModel, isWithRestrictedInformations == false, userProviderList, groupUsers, groupMembers, userModelsCache, tabChoseGroupMembers, filtersGroupMembers);
                    } else {
                        Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realm, groupModel, isWithRestrictedInformations == false, userModelsCache, tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
                    }
                    groupUsers.setGroupMembers(groupMembers);
                }
            } else {
                Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realm, groupModel, isWithRestrictedInformations == false, userModelsCache, tabChoseGroupMembers, filtersGroupMembers, groupUsers, groupMembers);
                groupUsers.setGroupMembers(groupMembers);
            }
        }
        groupUsers.setGroupMembers(groupMembers);
        try {
            byte[] groupPhotoUid;
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(em, realm.getId(), groupUsers.id);
            if (olvidGroup != null && (groupPhotoUid = olvidGroup.getGroupPhotoUid()) != null) {
                groupUsers.avatarUuid = groupPhotoUid;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"createGroupUsersFromGroupModel: Exception while preparing group avatar", (Throwable)e);
        }
        return groupUsers;
    }

    private static void getGroupMembersKeycloakProcessWithTabChoseAndFilters(EntityManager em, KeycloakSession session, RealmModel realm, GroupModel groupModel, Boolean isWithGroupMembers, List<UserModelAttributes> userModelsCache, String tabChoseGroupMembers, List<String> filtersGroupMembers, GroupUserModel groupUsers, List<CustomUserModel> groupMembers) {
        if (tabChoseGroupMembers != null && !tabChoseGroupMembers.isEmpty()) {
            if (!filtersGroupMembers.isEmpty()) {
                session.users().getGroupMembersStream(realm, groupModel, String.join((CharSequence)",", filtersGroupMembers), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10000)).forEach(userModel -> {
                    CustomUserModel olvidUser = Configuration.createOlvidUserFromUserModel(em, session, realm, userModel, tabChoseGroupMembers, new OlvidCircleVisibility());
                    if (!olvidUser.getId().isEmpty()) {
                        Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realm, isWithGroupMembers, userModelsCache, userModel, groupUsers, groupMembers);
                    }
                });
            } else {
                session.users().getGroupMembersStream(realm, groupModel).forEach(userModel -> {
                    CustomUserModel olvidUser = Configuration.createOlvidUserFromUserModel(em, session, realm, userModel, tabChoseGroupMembers, new OlvidCircleVisibility());
                    if (!olvidUser.getId().isEmpty()) {
                        Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realm, isWithGroupMembers, userModelsCache, userModel, groupUsers, groupMembers);
                    }
                });
            }
        } else if (!filtersGroupMembers.isEmpty()) {
            session.users().getGroupMembersStream(realm, groupModel, String.join((CharSequence)",", filtersGroupMembers), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10000)).forEach(userModel -> Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realm, isWithGroupMembers, userModelsCache, userModel, groupUsers, groupMembers));
        } else {
            session.users().getGroupMembersStream(realm, groupModel).forEach(userModel -> Configuration.setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(em, session, realm, isWithGroupMembers, userModelsCache, userModel, groupUsers, groupMembers));
        }
    }

    private static void setGroupUsersInformationFromUserModelAndGetGroupMemberIfIsWithGroupMembers(EntityManager em, KeycloakSession session, RealmModel realm, Boolean isWithGroupMembers, List<UserModelAttributes> userModelsCache, UserModel userModel, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers) {
        UserModelAttributes user;
        Optional<UserModelAttributes> userFound = userModelsCache.stream().filter(userCache -> userCache.getId().equals(userModel.getId())).findAny();
        if (!userFound.isPresent()) {
            user = new UserModelAttributes().initUserModelAttributes(session, realm, new UserModelAttributes(), userModel, userModel.getUsername());
            userModelsCache.add(user);
        } else {
            user = userFound.get();
        }
        Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, user);
        if (isWithGroupMembers.booleanValue()) {
            String tabChose = "";
            groupMembers.add(Configuration.createOlvidUserFromUserModel(em, session, realm, userModel, tabChose, new OlvidCircleVisibility()));
        }
    }

    private static void getProviderGroupsAndUsers(EntityManager em, KeycloakSession session, RealmModel realm, GroupModel groupModel, Boolean isWithGroupMembers, List<ComponentModel> userProviderList, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers, List<UserModelAttributes> usersModelAttributesCache, String tabChoseGroupMembers, List<String> filtersGroupMembers) {
        userProviderList.forEach(provider -> {
            block17: {
                if (provider.getProviderId().equals("ldap")) {
                    try {
                        MultivaluedHashMap config = provider.getConfig();
                        LDAPConfig ldapConfig = new LDAPConfig(config);
                        LDAPStorageProviderFactory lDAPStorageProviderFactory = new LDAPStorageProviderFactory();
                        LDAPIdentityStore lDAPIdentityStore = new LDAPIdentityStore(session, ldapConfig);
                        LDAPStorageProvider lDAPStorageProvider = new LDAPStorageProvider(lDAPStorageProviderFactory, session, provider, lDAPIdentityStore);
                        List configProperties = lDAPStorageProviderFactory.getConfigProperties();
                        AtomicReference<Boolean> isEnabled = new AtomicReference<Boolean>(false);
                        configProperties.forEach(configProperty -> {
                            if (configProperty.getName().equals("importEnabled")) {
                                isEnabled.set(true);
                            }
                        });
                        List<ComponentModel> mapperModels = realm.getComponentsStream(lDAPStorageProvider.getModel().getId(), LDAPStorageMapper.class.getName()).collect(Collectors.toList());
                        AtomicReference<KeycloakProviderGroupMapperModel> keycloakProviderGroupMapperModel = new AtomicReference<KeycloakProviderGroupMapperModel>(new KeycloakProviderGroupMapperModel());
                        mapperModels.forEach(mapper -> {
                            if (mapper.getProviderId().equals("group-ldap-mapper")) {
                                MultivaluedHashMap configMapper = mapper.getConfig();
                                keycloakProviderGroupMapperModel.set(new KeycloakProviderGroupMapperModel().initKeycloakProviderGroupMapperModel((MultivaluedHashMap<String, String>)configMapper));
                            }
                        });
                        if (!isEnabled.get().booleanValue()) break block17;
                        try (LDAPQuery ldapQuery = new LDAPQuery(lDAPStorageProvider);){
                            LDAPConfig configIdentityStore = lDAPStorageProvider.getLdapIdentityStore().getConfig();
                            ldapQuery.setSearchScope(configIdentityStore.getSearchScope());
                            ldapQuery.setSearchDn(configIdentityStore.getUsersDn());
                            configIdentityStore.getCustomUserSearchFilter();
                            ldapQuery.addReturningLdapAttribute(keycloakProviderGroupMapperModel.get().getMembershipLdapAttribute());
                            ldapQuery.addMappers(mapperModels);
                            String customFilterCustom = configIdentityStore.getCustomUserSearchFilter();
                            if (customFilterCustom != null) {
                                Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilterCustom);
                                ldapQuery.addWhereCondition(new Condition[]{customFilterCondition});
                            }
                            String customFilter = "(" + keycloakProviderGroupMapperModel.get().getGroupNameLdapAttribute() + "=" + finalGroupUsers.getName() + ")";
                            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
                            ldapQuery.addWhereCondition(new Condition[]{customFilterCondition});
                            ldapQuery.getFirstResult();
                            List queryResults = ldapQuery.getResultList();
                            List groupMembersLDAP = new ArrayList();
                            List resultTMP = queryResults.stream().map(result -> new ArrayList((Collection)result.getAttributes().get(((KeycloakProviderGroupMapperModel)keycloakProviderGroupMapperModel.get()).getMembershipLdapAttribute()))).collect(Collectors.toList());
                            if (!resultTMP.isEmpty()) {
                                groupMembersLDAP = (List)resultTMP.get(0);
                            }
                            int limit = 0;
                            int offset = 0;
                            ArrayList usersModelCache = new ArrayList();
                            while (limit < groupMembersLDAP.size() - 1) {
                                try {
                                    List<String> groupMembersLDAP_TMP;
                                    int limitForGetGroups = 20;
                                    if ((limit += limitForGetGroups) > groupMembersLDAP.size()) {
                                        limit = groupMembersLDAP.size();
                                        groupMembersLDAP_TMP = groupMembersLDAP.subList(offset, groupMembersLDAP.size());
                                    } else {
                                        groupMembersLDAP_TMP = groupMembersLDAP.subList(offset, limit);
                                    }
                                    TypedQuery<UserEntity> query = Configuration.buildGetUserByAttributes(em, realm.getId(), groupMembersLDAP_TMP, 10000, 0);
                                    List usersEntities = query.getResultList();
                                    usersEntities.forEach(userEntity -> {
                                        if (!filtersGroupMembers.isEmpty()) {
                                            List foundList = filtersGroupMembers.stream().filter(filter -> userEntity.getUsername().contains((CharSequence)filter) || userEntity.getEmail().contains((CharSequence)filter) || userEntity.getFirstName().contains((CharSequence)filter) || userEntity.getLastName().contains((CharSequence)filter)).collect(Collectors.toList());
                                            if (!foundList.isEmpty()) {
                                                Optional<UserModelAttributes> userModelAttributesInCacheFound = usersModelAttributesCache.stream().filter(userModelAttributes -> userModelAttributes.getId().equals(userEntity.getId())).findFirst();
                                                if (userModelAttributesInCacheFound.isPresent()) {
                                                    Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, userModelAttributesInCacheFound.get());
                                                    if (isWithGroupMembers.booleanValue()) {
                                                        CustomUserModel customUserModel = usersModelCache.stream().filter(userModel -> userModel.getId().equals(((UserModelAttributes)userModelAttributesInCacheFound.get()).getId())).findFirst().get();
                                                        groupMembers.add(customUserModel);
                                                        finalGroupUsers.groupMembers.add(customUserModel);
                                                    }
                                                } else {
                                                    Configuration.setGroupUsersInformationAndIfIsWithMembers(em, session, realm, isWithGroupMembers, finalGroupUsers, groupMembers, usersModelAttributesCache, userEntity, usersModelCache, tabChoseGroupMembers);
                                                }
                                            }
                                        } else if (!usersModelAttributesCache.isEmpty()) {
                                            Optional<UserModelAttributes> userModelAttributesInCacheFound = usersModelAttributesCache.stream().filter(userModelAttributes -> userModelAttributes.getId().equals(userEntity.getId())).findFirst();
                                            if (userModelAttributesInCacheFound.isPresent()) {
                                                Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, userModelAttributesInCacheFound.get());
                                                if (isWithGroupMembers.booleanValue()) {
                                                    CustomUserModel customUserModel = usersModelCache.stream().filter(userModel -> userModel.getId().equals(((UserModelAttributes)userModelAttributesInCacheFound.get()).getId())).findFirst().get();
                                                    groupMembers.add(customUserModel);
                                                    finalGroupUsers.groupMembers.add(customUserModel);
                                                }
                                            } else {
                                                Configuration.setGroupUsersInformationAndIfIsWithMembers(em, session, realm, isWithGroupMembers, finalGroupUsers, groupMembers, usersModelAttributesCache, userEntity, usersModelCache, tabChoseGroupMembers);
                                            }
                                        } else {
                                            Configuration.setGroupUsersInformationAndIfIsWithMembers(em, session, realm, isWithGroupMembers, finalGroupUsers, groupMembers, usersModelAttributesCache, userEntity, usersModelCache, tabChoseGroupMembers);
                                        }
                                    });
                                    offset = limit;
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Exception in createGroupUsersFromGroupModel e " + e.getMessage()));
                                }
                            }
                        }
                    }
                    catch (Exception ectx) {
                        logger.warn((Object)ectx);
                        Configuration.getGroupMembersKeycloakProcessWithTabChoseAndFilters(em, session, realm, groupModel, isWithGroupMembers, usersModelAttributesCache, tabChoseGroupMembers, filtersGroupMembers, finalGroupUsers, groupMembers);
                    }
                } else if (provider.getProviderId().equals("kerberos")) {
                    logger.warn((Object)"Kerberos is not actually implemented, ask Olvid Team for the feature");
                }
            }
        });
    }

    private static void setGroupUsersInformationAndIfIsWithMembers(EntityManager em, KeycloakSession session, RealmModel realm, Boolean isWithGroupMembers, GroupUserModel finalGroupUsers, List<CustomUserModel> groupMembers, List<UserModelAttributes> usersModelAttributesCache, UserEntity userEntity, List<CustomUserModel> usersModelCache, String tabChose) {
        UserModelAttributes userModelAttributes = new UserModelAttributes().initUserModelAttributes(session, realm, new UserModelAttributes(), session.users().getUserById(realm, userEntity.getId()), userEntity.getUsername());
        Configuration.setGroupUsersInformationFromUserModel(finalGroupUsers, userModelAttributes);
        usersModelAttributesCache.add(userModelAttributes);
        if (isWithGroupMembers.booleanValue()) {
            try {
                UserModel userModel = session.users().getUserById(realm, userEntity.getId());
                CustomUserModel customUserModel = Configuration.createOlvidUserFromUserModel(em, session, realm, userModel, tabChose, new OlvidCircleVisibility());
                groupMembers.add(customUserModel);
                usersModelCache.add(customUserModel);
                finalGroupUsers.groupMembers.add(customUserModel);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
    }

    private static void setGroupUsersInformationFromUserModel(GroupUserModel finalGroupUsers, UserModelAttributes user) {
        ++finalGroupUsers.countGroupMembers;
        if (user.getFederatedUsers().booleanValue()) {
            ++finalGroupUsers.countMembersFederated;
        } else if (user.getFederatedIdentities().booleanValue()) {
            ++finalGroupUsers.countMembersIdentityProvider;
        } else if (!user.getCredential().booleanValue()) {
            ++finalGroupUsers.countMembersWithoutPassword;
        }
        if (user.getOlvidIdentity() == null && !user.getOlvidIsBot().booleanValue()) {
            ++finalGroupUsers.countMembersAwaitingActivation;
        }
        if (user.getOlvidIsBot().booleanValue()) {
            ++finalGroupUsers.countMembersBots;
        }
    }

    private Response processGetUsersByUsername(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> usersList, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(39, role, authResult);
        }
        int userGroupsLimit = 10;
        int userGroupsOffset = 0;
        return this.getResponseProcessGetUsersByUsername(realmName, usersList, filters, limit, offset, writeAllowed, userGroupsLimit, userGroupsOffset);
    }

    private Response processGetUserByUsername(AuthenticationManager.AuthResult authResult, String role, String realmName, String username, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(39, role, authResult);
        }
        return this.getResponseProcessGetUserByUsername(realmName, username, filters, limit, offset, writeAllowed);
    }

    protected Response getResponseProcessGetUserByUsername(String realmName, String username, List<String> filters, int userGroupsLimit, int userGroupsOffset, boolean writeAllowed) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            UserModel user = this.session.users().getUserByUsername(realm, username);
            String tabChose = "";
            CustomUserModel userFormated = Configuration.createOlvidUserFromUserModel(this.em, this.session, realm, user, tabChose, new OlvidCircleVisibility());
            GetUserByUsernameResponseModel responseModel = new GetUserByUsernameResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setUser(userFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected Response getResponseProcessGetUsersByUsername(String realmName, List<String> usersList, List<String> filters, int limit, int offset, boolean writeAllowed, int userGroupsLimit, int userGroupsOffset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            TypedQuery<Object[]> query = this.buildQueryFindUsersLimited(realm.getId(), usersList, filters, limit, offset);
            List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            Query countQuery = this.buildQueryCountWithFilter(realm.getId(), "Selected", filters, usersList);
            Object countResult = countQuery.getSingleResult();
            Query countQueryTotal = this.buildQueryCount(realm.getId());
            Object countResultTotal = countQueryTotal.getSingleResult();
            List<OlvidCircleVisibility> circles = Configuration.getOlvidCirclesVisibilities(this.em, realm);
            GetUsersByUsernameResponseModel responseModel = new GetUsersByUsernameResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setUsersList(olvidUsersList);
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCircles(circles);
            responseModel.setCountRealmTotalUserst((Long)countResultTotal);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetGroupsByName(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetGroupsByName(realmName, filters, writeAllowed, limit, offset);
    }

    protected Response getResponseProcessGetGroupsByName(String realmName, List<String> filters, boolean writeAllowed, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List unaccentFilters = filters.stream().filter(filter -> !filter.trim().isEmpty()).map(Utils::unAccent).collect(Collectors.toList());
            List matchingGroupModels = realm.getGroupsStream().filter(groupModel -> {
                for (String filter : unaccentFilters) {
                    if (Utils.unAccent(groupModel.getName()).contains(filter)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            ArrayList<GroupModel> flatGroupListTopPath = new ArrayList<GroupModel>();
            ArrayList<GroupModel> flatGroupListFiltered = new ArrayList<GroupModel>();
            for (GroupModel matchingGroupModel : matchingGroupModels) {
                boolean isChild;
                boolean bl = isChild = matchingGroupModel.getParentId() != null;
                if (!isChild) {
                    if (!flatGroupListTopPath.contains(matchingGroupModel)) {
                        flatGroupListTopPath.add(matchingGroupModel);
                    }
                } else {
                    ArrayList<String> listParentsIdToFind = new ArrayList<String>();
                    listParentsIdToFind.add(matchingGroupModel.getParentId());
                    while (!listParentsIdToFind.isEmpty()) {
                        boolean isChildTMP;
                        String parentId = (String)listParentsIdToFind.get(listParentsIdToFind.size() - 1);
                        GroupModel groupsParentFound = this.session.groups().getGroupById(realm, parentId);
                        boolean bl2 = isChildTMP = groupsParentFound.getParentId() != null;
                        if (!isChildTMP && !flatGroupListTopPath.contains(groupsParentFound)) {
                            flatGroupListTopPath.add(groupsParentFound);
                        }
                        if (groupsParentFound.getParentId() != null) {
                            listParentsIdToFind.add(groupsParentFound.getParentId());
                            if (!flatGroupListFiltered.contains(groupsParentFound)) {
                                flatGroupListFiltered.add(groupsParentFound);
                            }
                        }
                        listParentsIdToFind.remove(parentId);
                    }
                }
                if (flatGroupListFiltered.contains(matchingGroupModel)) continue;
                flatGroupListFiltered.add(matchingGroupModel);
            }
            ArrayList<GroupModel> groupFlatListFiltered = new ArrayList<GroupModel>();
            limit = flatGroupListTopPath.size();
            ArrayList<UserModelAttributes> userModelsCache = new ArrayList<UserModelAttributes>();
            List<GroupUserModel> groupTreeList = this.buildGroupsTreeHierarchy(this.em, this.session, realm, flatGroupListFiltered, flatGroupListTopPath, groupFlatListFiltered, offset, limit, null, userModelsCache, false);
            List<GroupUserModel> flatGroupListFilteredFormated = groupFlatListFiltered.stream().map(group -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realm, (GroupModel)group, false, (List<UserModelAttributes>)userModelsCache, "", (List<String>)new ArrayList<String>(), "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            GetGroupsByNameResponseModel responseModel = new GetGroupsByNameResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroupTreeList(groupTreeList);
            responseModel.setFlatList(flatGroupListFilteredFormated);
            responseModel.setCountTopGroup(flatGroupListTopPath.size());
            responseModel.setCountPages((flatGroupListTopPath.size() - 1) / 10 + 1);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetGroupMembersById(AuthenticationManager.AuthResult authResult, String role, String realmName, String groupId, String tabChose, List<String> filters, int limit, int offset, List<String> groupList) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetGroupMembersById(realmName, groupId, tabChose, filters, writeAllowed, limit, offset, groupList);
    }

    protected Response getResponseProcessGetGroupMembersById(String realmName, String groupId, String tabChose, List<String> filters, boolean writeAllowed, int limit, int offset, List<String> groupList) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            GroupUserModel groupUsers = this.getGroupUsers(groupId, realm, tabChose, filters, limit, offset, true, groupList);
            GetGroupsByIdResponseModel responseModel = new GetGroupsByIdResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroup(groupUsers);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetGroupById(AuthenticationManager.AuthResult authResult, String role, String realmName, String groupId) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetGroupById(realmName, groupId, writeAllowed);
    }

    protected Response getResponseProcessGetGroupById(String realmName, String groupId, boolean writeAllowed) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
            GroupUserModel groupUsers = GroupUserModel.initGroupUsers(groupModel);
            groupUsers.setCountGroupMembers(this.session.users().getGroupMembersStream(realm, groupModel).count());
            GetGroupsByIdResponseModel responseModel = new GetGroupsByIdResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setGroup(groupUsers);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected GroupUserModel getGroupUsers(String groupId, RealmModel realm, String tabChose, List<String> filters, int limit, int offset, boolean isWithGroupMembers, List<String> groupList) throws NamingException {
        GroupModel matchingGroupModel = realm.getGroupById(groupId);
        boolean isWithRestrictedInformations = !isWithGroupMembers;
        return this.createGroupUsersFromGroupModel(this.em, this.session, realm, matchingGroupModel, isWithRestrictedInformations, new ArrayList<UserModelAttributes>(), tabChose, filters, groupId);
    }

    private Response processGetGroupsById(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> groupList, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        int userGroupsLimit = 5;
        int userGroupsOffset = 0;
        return this.getResponseProcessGetGroupsById(realmName, groupList, filters, writeAllowed, userGroupsLimit, userGroupsOffset);
    }

    protected Response getResponseProcessGetGroupsById(String realmName, List<String> groupList, List<String> filters, boolean writeAllowed, int userGroupsLimit, int userGroupsOffset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List matchingGroupModels;
            if (!groupList.isEmpty()) {
                matchingGroupModels = realm.getGroupsStream().filter(realmGroup -> groupList.contains(realmGroup.getId())).collect(Collectors.toList());
            } else {
                List unaccentFilters = filters.stream().map(Utils::unAccent).collect(Collectors.toList());
                matchingGroupModels = realm.getGroupsStream().filter(groupModel -> {
                    for (String filter : unaccentFilters) {
                        if (Utils.unAccent(groupModel.getName()).contains(filter)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
            }
            HashSet matchingGroupIds = matchingGroupModels.stream().map(GroupModel::getId).collect(Collectors.toCollection(HashSet::new));
            ArrayList<GroupUserModel> matchingGroupList = new ArrayList<GroupUserModel>();
            for (GroupModel matchingGroupModel : matchingGroupModels) {
                GroupUserModel groupUsers = this.createGroupUsersFromGroupModel(this.em, this.session, realm, matchingGroupModel, true, new ArrayList<UserModelAttributes>(), "", new ArrayList<String>(), matchingGroupModel.getId());
                matchingGroupList.add(groupUsers);
                if (!groupList.isEmpty()) {
                    String tabChose = "";
                    groupUsers.groupMembers = this.session.users().getGroupMembersStream(realm, matchingGroupModel).map(userModel -> Configuration.createOlvidUserFromUserModel(this.em, this.session, realm, userModel, tabChose, new OlvidCircleVisibility())).collect(Collectors.toList());
                    continue;
                }
                GroupModel parent = matchingGroupModel.getParent();
                for (int i = 0; i < 50 && parent != null && !matchingGroupIds.contains(parent.getId()); parent = parent.getParent(), ++i) {
                    matchingGroupIds.add(parent.getId());
                }
            }
            ArrayList groupTreeList = new ArrayList();
            HashMap<String, Serializable> response = new HashMap<String, Serializable>();
            response.put("writeAllowed", Boolean.valueOf(writeAllowed));
            response.put("groupTreeList", groupTreeList);
            response.put("groupList", matchingGroupList);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes(response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected Response processGetGroupAvatar(String realmName, byte[] dataUid, String id) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        Object avatarUrl = "";
        try {
            try {
                OlvidData olvidData;
                OlvidGroup olvidGroup;
                byte[] dataUidToFind = dataUid;
                if (dataUidToFind == null && (olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), id)) != null) {
                    dataUidToFind = olvidGroup.getGroupPhotoUid();
                }
                if (dataUidToFind != null && (olvidData = OlvidDataDao.getOlvidDataByUid(this.em, realm.getId(), dataUidToFind)) != null) {
                    avatarUrl = "data:image/jpeg;base64," + Base64.getEncoder().encodeToString(olvidData.getData());
                }
            }
            catch (Exception e) {
                logger.warn((Object)"getGroupAvatar: Exception while preparing group avatar", (Throwable)e);
            }
            GetGroupAvatarResponseModel responseModel = new GetGroupAvatarResponseModel();
            responseModel.setAvatarUrl((String)avatarUrl);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected Response processGetGroupEphemeralSettings(String realmName, String id) throws IOException {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (realm == null) {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, 1, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), id);
        JsonSharedSettings sharedSettings = new JsonSharedSettings();
        if (olvidGroup != null) {
            sharedSettings = new JsonSharedSettings().initJsonSharedSettings(olvidGroup.getSerializedSharedSettings());
        }
        GetGroupEphemeralSettingsResponseModel responseModel = new GetGroupEphemeralSettingsResponseModel();
        responseModel.setSharedSettings(sharedSettings);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
    }

    private static TypedQuery<UserEntity> buildGetUserByAttributes(EntityManager em, String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'LDAP_ENTRY_DN' AND (attr.value IN :filters))");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = em.createQuery(sb.toString(), UserEntity.class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("filters", filters);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildUsersQueryLimited(String realmId, List<String> filters, int limit, int offset, String tabChose, List<String> usernameList) {
        StringBuilder sb = tabChose.contentEquals("Without Olvid password") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND attr.name in ('LDAP_ID', 'KERBEROS_PRINCIPAL'))) AND ((cred.id is null) AND u not in (SELECT DISTINCT u FROM UserEntity u  LEFT JOIN u.attributes attr WHERE u.realmId = :realmId AND size(u.federatedIdentities)>0))") : (tabChose.contentEquals("Activated") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity')") : (tabChose.contentEquals("Not activated") ? new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))") : (tabChose.contentEquals("Bot") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')") : (tabChose.contentEquals("With Some Device UnKnown") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilit9y9.yId = ocv.id  WHERE u.realmId = :realmId AND oud.isKnown = false") : (tabChose.contentEquals("Old Sync") ? new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId LEFT JOIN u.credentials cred on cred.type = 'password' left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true") : new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId"))))));
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        if (!usernameList.isEmpty()) {
            sb.append(" AND (u.username IN :usernameList)");
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        if (!usernameList.isEmpty()) {
            query.setParameter("usernameList", usernameList);
        }
        if (tabChose.contentEquals("Old Sync")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildCircleMembersQueryLimited(String realmId, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT u as userEntity, ocvu as olvidCircleVisibilityUser, ocv as olvidCircleVisibility, ocvr as olvidCircleVisibilityRules FROM UserEntity u  LEFT JOIN u.attributes attr  RIGHT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocv.id = ocvu.circleVisibilityId  LEFT JOIN OlvidCircleVisibilityRules ocvr on (ocvr.circleVisibilityId1From = ocv.id or ocvr.circleVisibilityId2To = ocv.id) WHERE u.realmId = :realmId");
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    private TypedQuery<Object[]> buildDevicesQueryLimited(String realmId, List<String> filters, int limit, int offset, String tabChose) {
        StringBuilder sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ");
        if (tabChose.contentEquals("Devices UnKnown")) {
            sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false");
        } else if (tabChose.contentEquals("Old Sync")) {
            sb = new StringBuilder("SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true");
        } else if (tabChose.contentEquals("From Page Users")) {
            sb = new StringBuilder(" SELECT oud, u FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId");
        }
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (oud.displayName LIKE :? OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("Old Sync")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 24L * 60L * 60L * 1000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        if (tabChose.contentEquals("From Page Users")) {
            RealmModel realm = this.session.realms().getRealm(realmId);
            String userId = this.session.users().getUserByUsername(realm, filters.get(0)).getId();
            query.setParameter("userId", (Object)userId);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        if (!tabChose.contentEquals("From Page Users")) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query;
    }

    private TypedQuery<Object[]> buildBotQueryLimited(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder("SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersLimited(String realmId, List<String> usersList, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.username in :usersList");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("usersList", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersByIdsLimited(String realmId, List<String> usersList, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT DISTINCT u, ocv as olvidCircleVisibility FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("list", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<Object[]> buildQueryFindUsersWithoutCircleVisibility(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT distinct u as userEntity, ocv as olvidCircleVisibility FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.lastName, u.firstName, u.username");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    public TypedQuery<String> buildQueryFindAllUsersIdsWithoutCircleVisibility(String realmId) {
        StringBuilder sb = new StringBuilder(" SELECT distinct u.id FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        TypedQuery query = this.em.createQuery(sb.toString(), String.class);
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Query buildQueryCountWithFilter(String realmId, String tabChose, List<String> filters, List<String> usersList) {
        StringBuilder sb = tabChose.contentEquals("Without Olvid password") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.credentials cred on cred.type = 'password' WHERE u.realmId = :realmId AND (cred.id is null)") : (tabChose.contentEquals("Activated") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE attr.name = 'olvid-identity'  AND u.realmId = :realmId ") : (tabChose.contentEquals("Not activated") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND u.id not in ( SELECT u.id FROM UserEntity u  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-identity'))") : (tabChose.contentEquals("Selected") ? new StringBuilder(" SELECT COUNT(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and u.username in :usersList") : (tabChose.contentEquals("Bot") ? new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')") : (tabChose.contentEquals("With Some Device UnKnown") ? new StringBuilder("SELECT COUNT(DISTINCT(u)) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  INNER JOIN OlvidUserDevice oud ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false") : (tabChose.contentEquals("Old Sync") ? new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true") : (tabChose.contentEquals("User Old Last Sync") ? new StringBuilder("SELECT  count(distinct u.username)  FROM UserEntity u  INNER JOIN OlvidUser ou ON u.id = ou.userId AND u.realmId = ou.realmId  WHERE u.realmId = :realmId AND ou.lastSync < :oldDeviceTimeLimit") : new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId"))))))));
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("Selected")) {
            query.setParameter("usersList", usersList);
        }
        if (tabChose.contentEquals("Old Sync") || tabChose.contentEquals("User Old Last Sync")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    protected TypedQuery<Object[]> buildQueryFindCircleVisibilityLimitedWithFilter(String realmId, List<String> filters, int limit, int offset) {
        StringBuilder sb = new StringBuilder(" SELECT olgv FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId");
        logger.info((Object)sb.toString());
        logger.info((Object)realmId);
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        sb.append(" order by u.name");
        TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query;
    }

    protected Query buildQueryCountFindCircleVisibilityWithFilter(String realmId, String tabChose, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(olgv) FROM OlvidCircleVisibility olgv  WHERE olgv.realmId = :realmId ");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityMembersWithFilter(String realmId, List<String> usersList, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u)FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId and u.id in :list");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("list", usersList);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(String realmId, String id, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(olgvu) FROM OlvidCircleVisibilityUser olgvu  WHERE olgvu.realmId = :realmId AND olgvu.circleVisibilityId in :id ");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        query.setParameter("id", (Object)id);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(String realmId) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN OlvidCircleVisibilityUser olgvu on olgvu.userId = u.id  WHERE u.realmId = :realmId and olgvu.userId is null");
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Query buildQueryCountDefaultCircleVisibilityMembers(String realmId, List<String> filters) {
        StringBuilder sb = new StringBuilder(" SELECT count(DISTINCT u) FROM UserEntity u  LEFT JOIN u.attributes attr  LEFT JOIN OlvidCircleVisibilityUser ocvu on ocvu.userId = u.id  LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId and ocvu.userId is null");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    private Query buildDevicesQueryCountWithFilter(String realmId, String tabChose, List<String> filters, List<String> usersList) {
        StringBuilder sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId ");
        if (tabChose.contentEquals("Devices UnKnown")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.isKnown = false");
        } else if (tabChose.contentEquals("Old Sync")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId LEFT JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  WHERE u.realmId = :realmId AND oud.lastSync < :oldDeviceTimeLimit AND oud.isKnown = true");
        } else if (tabChose.contentEquals("From Page Users")) {
            sb = new StringBuilder(" SELECT COUNT(oud) FROM OlvidUserDevice oud  INNER JOIN UserEntity u ON u.id = oud.userId WHERE u.realmId = :realmId AND oud.userId = :userId");
        }
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (oud.displayName LIKE :? OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        if (tabChose.contentEquals("Selected")) {
            query.setParameter("usersList", usersList);
        }
        if (tabChose.contentEquals("Old Sync")) {
            int oldDeviceTimeLimit = OlvidConfigurationDao.getIntConfiguration(this.em, realmId, "oldDeviceTimeLimit", 30);
            long currentTimestamp = System.currentTimeMillis();
            long oldDeviceTimeLimitFromcurrentTimestamp = currentTimestamp - (long)oldDeviceTimeLimit * 86400000L;
            query.setParameter("oldDeviceTimeLimit", (Object)oldDeviceTimeLimitFromcurrentTimestamp);
        }
        if (tabChose.contentEquals("From Page Users")) {
            RealmModel realm = this.session.realms().getRealm(realmId);
            String userId = this.session.users().getUserByUsername(realm, filters.get(0)).getId();
            query.setParameter("userId", (Object)userId);
        }
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    private Query buildBotCountQueryLimited(String realmId, List<String> filters, List<String> usersList) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId AND (attr.name = 'olvid-is-bot')");
        int count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            sb.append(" AND (( attr.name = 'olvid-position' AND attr.value LIKE :?) OR ( attr.name = 'olvid-company' AND attr.value LIKE :?) OR u.firstName LIKE :? OR u.lastName LIKE :? OR u.username LIKE :? OR u.email LIKE :? OR ocv.name LIKE :?) ".replace("?", "s" + count));
            ++count;
        }
        Query query = this.em.createQuery(sb.toString());
        query.setParameter("realmId", (Object)realmId);
        count = 0;
        for (String filter : filters) {
            if (filter == null || filter.trim().isEmpty()) continue;
            query.setParameter("s" + count, (Object)("%" + filter + "%"));
            ++count;
        }
        return query;
    }

    protected Query buildQueryCount(String realmId) {
        Query query = this.em.createQuery("SELECT COUNT(DISTINCT u) FROM UserEntity u  left JOIN OlvidCircleVisibilityUser ocvu on u.id = ocvu.userId LEFT JOIN OlvidCircleVisibility ocv on ocvu.circleVisibilityId = ocv.id  LEFT JOIN u.attributes attr  WHERE u.realmId = :realmId");
        query.setParameter("realmId", (Object)realmId);
        return query;
    }

    protected Response processSignOutUser(String realmName, String id) {
        boolean userWasSignedOut = this.signOutUser(realmName, id);
        SignOutUsersResponseModel responseModel = new SignOutUsersResponseModel();
        responseModel.setStatus(userWasSignedOut);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().type("text/html").build();
        }
    }

    protected boolean signOutUser(String realmName, String id) {
        UserModel userModel;
        RealmModel realmModel;
        boolean userWasSignedOut = false;
        if (id != null && realmName != null && (realmModel = this.session.realms().getRealmByName(realmName)) != null && (userModel = this.session.users().getUserById(realmModel, id)) != null) {
            List offlineSessions = this.session.sessions().getOfflineUserSessionsStream(realmModel, userModel).collect(Collectors.toList());
            for (UserSessionModel userSessionModel : offlineSessions) {
                this.session.sessions().removeOfflineUserSession(realmModel, userSessionModel);
            }
            this.session.sessions().removeUserSessions(realmModel, userModel);
            userWasSignedOut = true;
        }
        return userWasSignedOut;
    }

    private boolean removeCredential(String realmName, String userId) {
        UserModel userModel;
        RealmModel realmModel;
        boolean removedCredential = false;
        if (userId != null && realmName != null && (realmModel = this.session.realms().getRealmByName(realmName)) != null && (userModel = this.session.users().getUserById(realmModel, userId)) != null) {
            userModel.credentialManager().getStoredCredentialsByTypeStream("password").forEach(elem -> userModel.credentialManager().removeStoredCredentialById(elem.getId()));
            removedCredential = true;
        }
        return removedCredential;
    }

    private Response processDeleteUserRevokedData(AuthenticationManager.AuthResult authResult, String role, String realmName, Long revocationId) {
        block4: {
            try {
                if (revocationId == null) break block4;
                RealmModel realm = this.session.realms().getRealmByName(realmName);
                try {
                    String logs = " [\n  userId : " + revocationId + ",\n  realm Name: " + realmName + ",\n]";
                    logger.debug((Object)logs);
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realm.getName(), "userRevokedData", "Admin created:" + logs, ret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OlvidRevocationDao.clearOlvidRevocationUserData(this.em, revocationId, realm.getId());
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        return this.processGetRevocation(authResult, role, realmName, new ArrayList<String>(), 10, 0);
    }

    private Response processGetLogs(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(15, role, authResult);
        }
        return this.getResponseProcessGetLogs(realmName, tabChose, filters, limit, offset, writeAllowed);
    }

    protected Response getResponseProcessGetLogs(String realmName, String tabChose, List<String> filters, int limit, int offset, boolean writeAllowed) {
        String realmId = "";
        if (realmName != null && !realmName.isEmpty()) {
            realmId = this.session.realms().getRealmByName(realmName).getId();
        }
        List<OlvidConsoleLogs> consoleLogs = OlvidConsoleLogsDao.getLogs(this.em, realmId, tabChose, filters, limit, offset);
        Long consoleLogsCount = OlvidConsoleLogsDao.getLogsCount(this.em, realmId, tabChose, filters);
        if (consoleLogsCount == null || consoleLogs == null) {
            logger.warn((Object)"Null consoleLogsCount or consoleLogs");
            return this.internalError();
        }
        GetLogsResponseModel responseModel = new GetLogsResponseModel();
        responseModel.setCount(consoleLogsCount);
        responseModel.setWriteAllowed(writeAllowed);
        responseModel.setConsoleLogs(new LogModel().initLogsListModel(consoleLogs));
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected Response processGetLogsType() {
        List<String> logsType = OlvidConsoleLogsDao.getLogsType(this.em);
        GetLogsTypesResponseModel responseModel = new GetLogsTypesResponseModel();
        responseModel.setLogsType(logsType);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddManagerUser(AuthenticationManager.AuthResult authResult, CustomManagerBasicModel managerUser) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessAddAdminUser(managerUser, userLogIn);
    }

    protected Response getResponseProcessAddAdminUser(CustomManagerBasicModel managerUser, String userLogIn) {
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (!adminRealm.isPresent()) {
            logger.warn((Object)"Admin user creation error: could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel realm = adminRealm.get();
        if (Utils.nullOrTrim(managerUser.getUsername()) == null || Utils.nullOrTrim(managerUser.getEmail()) == null || Utils.nullOrTrim(managerUser.getRole()) == null || this.session.users().getUserByUsername(realm, managerUser.getUsername().trim()) != null || this.session.users().getUserByEmail(realm, managerUser.getEmail().trim()) != null) {
            logger.warn((Object)"Admin user creation error: username already exists or invalid request");
            return this.invalidRequest();
        }
        UserModel newUser = this.session.users().addUser(realm, Utils.nullOrTrim(managerUser.getUsername()));
        newUser.setFirstName(Utils.nullOrTrim(managerUser.getFirstname()));
        newUser.setLastName(Utils.nullOrTrim(managerUser.getLastname()));
        newUser.setEmail(Utils.nullOrTrim(managerUser.getEmail()));
        newUser.setSingleAttribute("olvid-role", managerUser.getRole());
        newUser.setEnabled(true);
        PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
        String password = this.generateRandomPassword(passwordPolicy);
        try {
            this.setUserPassword(newUser, password, passwordPolicy);
        }
        catch (Exception e) {
            logger.warn((Object)"Admin user creation error: unable to create password for account (no hash provider found)");
            return this.internalError();
        }
        try {
            String logs = " [\n  username: " + newUser.getUsername() + ",\n  realm Name: " + realm.getName() + ",\n" + (String)(Utils.nullOrTrim(newUser.getFirstName()) != null ? "  firstname: " + newUser.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(newUser.getLastName()) != null ? "  lastname: " + newUser.getLastName() + ",\n" : "") + "  email: " + newUser.getEmail() + ",\n  role: " + managerUser.getRole() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "adminCreation", "Admin created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        AddManagerResponseModel responseModel = new AddManagerResponseModel();
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.addManagerResponseModel(password, masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddUser(AuthenticationManager.AuthResult authResult, CustomUserBasicWithPasswordModel user, String realmName, Boolean isNoPassword) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessAddUser(user, realmName, isNoPassword, userLogIn);
    }

    protected Response getResponseProcessAddUser(CustomUserBasicWithPasswordModel user, String realmName, Boolean isNoPassword, String userLogIn) {
        AddUserResponseModel responseModel;
        GenericReponseModel response;
        block10: {
            RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            response = new GenericReponseModel();
            responseModel = new AddUserResponseModel();
            if (Utils.nullOrTrim(user.getUsername()) == null || Utils.nullOrTrim(user.getFirstname()) == null || this.session.users().getUserByUsername(realm, user.getUsername().trim()) != null) {
                return this.invalidRequest();
            }
            UserModel newUser = this.session.users().addUser(realm, user.getUsername().trim());
            newUser.setFirstName(Utils.nullOrTrim(user.getFirstname()));
            newUser.setLastName(Utils.nullOrTrim(user.getLastname()));
            newUser.setEmail(Utils.nullOrTrim(user.getEmail()));
            Utils.setUserAttribute(newUser, "olvid-company", user.getCompany());
            Utils.setUserAttribute(newUser, "olvid-position", user.getPosition());
            String fullSearchString = Utils.getUserAttributeFullSearch(newUser);
            Utils.setUserAttribute(newUser, "olvid-search", fullSearchString);
            newUser.setEnabled(true);
            try {
                if (isNoPassword.booleanValue()) {
                    responseModel.setPassword("");
                    break block10;
                }
                PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
                String password = user.getPassword() == null || user.getPassword().trim().isEmpty() ? this.generateRandomPassword(passwordPolicy) : user.getPassword().trim();
                try {
                    this.setUserPassword(newUser, password, passwordPolicy);
                }
                catch (Exception e) {
                    logger.warn((Object)"User creation error: unable to create password for account (no hash provider found)");
                    return this.internalError();
                }
                try {
                    String logs = " [\n  username: " + user.getUsername() + ",\n  realmName: " + realm.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstname()) != null ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastname()) != null ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    OlvidConsoleLogsDao.logUserEvent(this.em, this.session, this.session.users().getUserById(realm, userLogIn).getUsername(), realm.getName(), "userCreation", "User created:" + logs, ret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                responseModel.setPassword(password);
            }
            catch (Exception e) {
                logger.warn((Object)"User create : create password Exception : ", (Throwable)e);
                responseModel.setPassword("");
            }
        }
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddUsersByList(AuthenticationManager.AuthResult authResult, List<CustomUserBasicWithPasswordModel> usersList, String realmName, Boolean isNoPassword) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessAddUsersByList(usersList, realmName, isNoPassword, userLogIn);
    }

    protected Response getResponseProcessAddUsersByList(List<CustomUserBasicWithPasswordModel> usersList, String realmName, Boolean isNoPassword, String userLogIn) {
        ArrayList errors = new ArrayList();
        ArrayList<CustomUserBasicWithPasswordModel> usersCreated = new ArrayList<CustomUserBasicWithPasswordModel>();
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (realm == null) {
            return this.internalError();
        }
        usersList.forEach(user -> {
            block10: {
                if (Utils.nullOrTrim(user.getUsername()) == null || Utils.nullOrTrim(user.getFirstname()) == null && Utils.nullOrTrim(user.getLastname()) == null || this.session.users().getUserByUsername(realm, user.getUsername()) != null) {
                    logger.warn((Object)"User creation error: username already exists or invalid request");
                    errors.add(user);
                    return;
                }
                UserModel newUser = this.session.users().addUser(realm, user.getUsername().trim());
                newUser.setFirstName(Utils.nullOrTrim(user.getFirstname()));
                newUser.setLastName(Utils.nullOrTrim(user.getLastname()));
                newUser.setEmail(Utils.nullOrTrim(user.getEmail()));
                Utils.setUserAttribute(newUser, "olvid-position", user.getPosition());
                Utils.setUserAttribute(newUser, "olvid-company", user.getCompany());
                String fullSearchString = Utils.getUserAttributeFullSearch(newUser);
                Utils.setUserAttribute(newUser, "olvid-search", fullSearchString);
                newUser.setEnabled(true);
                try {
                    PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
                    String password = "";
                    if (user.getPassword() == null || user.getPassword().trim().isEmpty()) {
                        if (!isNoPassword.booleanValue()) {
                            password = this.generateRandomPassword(passwordPolicy);
                        }
                    } else {
                        password = user.getPassword().trim();
                    }
                    if (password.contentEquals("")) break block10;
                    try {
                        this.setUserPassword(newUser, password, passwordPolicy);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"User creation error: unable to create password for account (no hash provider found)");
                        errors.add(user);
                        return;
                    }
                    user.setPassword(password);
                }
                catch (Exception passwordPolicy) {
                    // empty catch block
                }
            }
            try {
                String logs = " [\n  username: " + user.getUsername() + ",\n  realmName: " + realm.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstname()) != null ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastname()) != null ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "userCreation", "User created:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            usersCreated.add((CustomUserBasicWithPasswordModel)user);
        });
        GenericReponseModel response = new GenericReponseModel();
        AddUsersByListResponseModel responseModel = new AddUsersByListResponseModel();
        responseModel.setUsersCreated(usersCreated);
        responseModel.setUsersErrors(errors);
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        responseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private String generateRandomPassword(PasswordPolicy passwordPolicy) {
        int length = 10;
        Object maxLength = passwordPolicy.getPolicyConfig("maxLength");
        if (maxLength instanceof Integer && length > (Integer)maxLength) {
            length = (Integer)maxLength;
        }
        Object minLength = passwordPolicy.getPolicyConfig("length");
        if (maxLength instanceof Integer && length < (Integer)minLength) {
            length = (Integer)minLength;
        }
        SecureRandom random = new SecureRandom();
        char[] password = new char[length];
        for (int i = 0; i < length; ++i) {
            password[i] = ALLOWED_ADMIN_PASSWORD_CHARS[random.nextInt(ALLOWED_ADMIN_PASSWORD_CHARS.length)];
        }
        return new String(password);
    }

    private void setUserPassword(UserModel user, String password, PasswordPolicy passwordPolicy) throws Exception {
        PasswordHashProvider hashProvider = this.getHashProvider(passwordPolicy);
        if (hashProvider == null) {
            throw new Exception();
        }
        PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
        credentialModel.setCreatedDate(Long.valueOf(System.currentTimeMillis()));
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        user.credentialManager().getStoredCredentialsByTypeStream("password").forEach(elem -> user.credentialManager().removeStoredCredentialById(elem.getId()));
        user.credentialManager().createStoredCredential((CredentialModel)credentialModel);
    }

    private Response processUpdateUser(AuthenticationManager.AuthResult authResult, CustomUserBasicWithPasswordModel user, String realmName) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessUpdateUser(user, realmName, userLogIn);
    }

    protected Response getResponseProcessUpdateUser(CustomUserBasicWithPasswordModel user, String realmName, String userLogIn) {
        HashMap<String, Object> ret;
        String logs2;
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        UserModel userToUpdate = this.session.users().getUserByUsername(realm, user.getUsername());
        if (userToUpdate == null || Utils.nullOrTrim(user.getFirstname()) == null) {
            logger.warn((Object)"User update error: username already exists or invalid request");
            return this.invalidRequest();
        }
        userToUpdate.setEnabled(true);
        userToUpdate.setFirstName(Utils.nullOrTrim(user.getFirstname()));
        userToUpdate.setLastName(Utils.nullOrTrim(user.getLastname()));
        userToUpdate.setEmail(Utils.nullOrTrim(user.getEmail()));
        Utils.setUserAttribute(userToUpdate, "olvid-position", Utils.nullOrTrim(user.getPosition()));
        Utils.setUserAttribute(userToUpdate, "olvid-company", Utils.nullOrTrim(user.getCompany()));
        OlvidUserDetails olvidUserDetails = new OlvidUserDetails(userToUpdate);
        Utils.setUserAttribute(userToUpdate, "olvid-search", olvidUserDetails.getFullSearchString());
        boolean isBotUser = Utils.isBotUser(userToUpdate);
        if (!isBotUser) {
            try {
                logs2 = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realm.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(user.getFirstname()).isEmpty() ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(user.getLastname()).isEmpty() ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "userUpdate", "User updated:" + logs2, ret);
            }
            catch (Exception logs2) {}
        } else {
            try {
                logs2 = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realm.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(user.getFirstname()).isEmpty() ? "  firstname: " + user.getFirstname() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(user.getLastname()).isEmpty() ? "  lastname: " + user.getLastname() + ",\n" : "") + "  email: " + user.getEmail() + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "botUpdate", "Bot updated:" + logs2, ret);
            }
            catch (Exception logs3) {
                // empty catch block
            }
        }
        try {
            String identityString;
            if (OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false) && (identityString = Utils.getUserAttribute(userToUpdate, "olvid-identity")) != null) {
                try {
                    OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(this.session, this.em, realm);
                    if (signatureSignerContext == null) {
                        logger.warn((Object)"Unable to update signed user details: failed to get signature context");
                    } else {
                        Utils.updateSignedUserDetails(this.em, realm, userToUpdate, olvidUserDetails.getSignedDetails((SignatureSignerContext)signatureSignerContext, this.objectMapper), false);
                        CronScheduler.scheduleSendNotifications(Collections.singletonList(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realm.getId(), identityString)));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception : ", (Throwable)e);
                }
            }
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processUpdateGroup(AuthenticationManager.AuthResult authResult, String realmName, Object data) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessUpdateGroup(realmName, data, userLogIn);
    }

    protected Response getResponseProcessUpdateGroup(String realmName, Object data, String userLogIn) throws Exception {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        UpdateOlvidGroupModel group = (UpdateOlvidGroupModel)this.objectMapper.convertValue(data, UpdateOlvidGroupModel.class);
        String groupId = group.getId();
        String groupName = group.getName();
        String groupDescription = group.getDescription();
        String groupOlvidName = group.getOlvidName();
        if (this.session.groups().getGroupsStream(realm).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupName) && !Objects.equals(groupFound.getId(), groupId))) {
            logger.info((Object)"processUpdateGroup: duplicate group name");
            return this.invalidRequest();
        }
        GroupModel groupToUpdate = this.session.groups().getGroupById(realm, groupId);
        if (groupToUpdate == null) {
            logger.info((Object)"processUpdateGroup: group id not found");
            return this.invalidRequest();
        }
        groupToUpdate.setName(groupName);
        Utils.setGroupAttribute(groupToUpdate, "olvid-description", groupDescription);
        Utils.setGroupAttribute(groupToUpdate, "olvid-name", groupOlvidName);
        this.updateOlvidGroupAndNotify(realm, groupToUpdate);
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupName + ",\n  groupDescription: " + groupDescription + ",\n  groupCustomName: " + groupOlvidName + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        UpdateOlvidGroupByIdResponseModel responseModel = new UpdateOlvidGroupByIdResponseModel();
        responseModel.setStatus(true);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processSetUnsetGroupOlvidDiscussion(AuthenticationManager.AuthResult authResult, String role, String realmName, Object dataObj) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupUserModel group = (GroupUserModel)this.objectMapper.convertValue(dataObj, GroupUserModel.class);
        String groupId = group.getId();
        Boolean groupOlvid = group.getOlvidGroup();
        if (groupOlvid == null || groupId == null) {
            return this.invalidRequest();
        }
        GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        if (groupOlvid.booleanValue()) {
            Utils.setGroupAttribute(groupModel, "olvid-group", "true");
            this.updateOlvidGroupAndNotify(realm, groupModel);
        } else {
            Utils.setGroupAttribute(groupModel, "olvid-group", null);
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), groupId);
            if (olvidGroup != null) {
                this.disableOlvidGroupAndNotify(realm, olvidGroup);
            }
        }
        String groupName = groupModel.getName();
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupName + ",\n  change groupOlvid: " + groupOlvid + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private void disableOlvidGroupAndNotify(RealmModel realm, OlvidGroup olvidGroup) {
        CronScheduler.scheduleSendNotifications(OlvidGroupDao.disableGroupAndGetMembersToNotify(this.session, this.objectMapper, this.em, realm, olvidGroup));
    }

    private void updateOlvidGroupAndNotify(RealmModel realm, GroupModel groupModel) throws Exception {
        if (Utils.isOlvidGroup(groupModel)) {
            CronScheduler.scheduleSendNotifications(OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realm, groupModel, this.objectMapper, new SecureRandom()));
        }
    }

    private Response processCreateCronOneTimeJob(AuthenticationManager.AuthResult authResult, String role, Object dataObj) {
        UserModel userLogIn = authResult.getUser();
        return this.getResponseCreateCronOneTimeJob(dataObj, userLogIn);
    }

    protected Response getResponseCreateCronOneTimeJob(Object dataObj, UserModel userLogIn) {
        CronJobModel job = (CronJobModel)this.objectMapper.convertValue(dataObj, CronJobModel.class);
        CronScheduler.scheduleOneTimeJobFromManagementConsole(job.label.toString());
        try {
            String logs = " [\n  create cron one time job : " + dataObj.toString() + "]";
            logger.debug((Object)logs);
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn.getUsername(), "master", "cronOneTimeJob", "Cron One Time Job:" + logs, new HashMap<String, Object>());
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processEditExternalLinks(AuthenticationManager.AuthResult authResult, String role, String realmName, Object dataObj) {
        UserModel userLogIn = authResult.getUser();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessEditExternalLinks(realmName, dataObj, userLogIn);
    }

    protected Response getResponseProcessEditExternalLinks(String realmName, Object dataObj, UserModel userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        Map data = (Map)this.objectMapper.convertValue(dataObj, (TypeReference)new TypeReference<Map<String, String>>(){});
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<OlvidExternalLink> success = new ArrayList<OlvidExternalLink>();
        try {
            TypedQuery q = this.em.createNamedQuery("OlvidExternalLinks.getById", OlvidExternalLink.class);
            q.setParameter("realmId", (Object)realm.getId());
            q.setParameter("id", data.get("id"));
            OlvidExternalLink found = (OlvidExternalLink)q.getSingleResult();
            found.setTag((String)data.get("newTag"));
            try {
                this.em.createNamedQuery("OlvidExternalLinks.updateById").setParameter("realmId", (Object)realm.getId()).setParameter("newTag", data.get("newTag")).setParameter("id", data.get("id")).executeUpdate();
                success.add(found);
            }
            catch (NoResultException noResultException) {}
        }
        catch (Exception e) {
            errors.add((String)data.get("newTag"));
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  external Links tags : " + dataObj.toString() + "]";
            logger.debug((Object)logs);
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn.getUsername(), realm.getName(), "externalLinks", "External Links edited:" + logs, new HashMap<String, Object>());
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        GenericReponseModel response = new GenericReponseModel();
        UpdateExternalLinksResponseModel responseModel = new UpdateExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setSuccess(success);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processRevokeExternalLinks(AuthenticationManager.AuthResult authResult, String role, String realmName, List<String> dataArray) {
        UserModel userLogIn = authResult.getUser();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessRevokeExternalLinks(realmName, dataArray, userLogIn);
    }

    protected Response getResponseProcessRevokeExternalLinks(String realmName, List<String> dataArray, UserModel userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> success = new ArrayList<String>();
        dataArray.forEach(data -> {
            block7: {
                try {
                    OlvidExternalLink externalLink = (OlvidExternalLink)this.em.createNamedQuery("OlvidExternalLinks.getById", OlvidExternalLink.class).setParameter("realmId", (Object)realm.getId()).setParameter("id", data).getSingleResult();
                    String apiKey = externalLink.getKey();
                    if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, realm.getId(), this.objectMapper, apiKey)) {
                        try {
                            this.em.createNamedQuery("OlvidExternalLinks.revokeById").setParameter("realmId", (Object)realm.getId()).setParameter("id", data).setParameter("revokedDate", (Object)System.currentTimeMillis()).executeUpdate();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        try {
                            String logs = " [\n  realm Name: " + realm.getName() + ",\n  external Links tags : " + String.join((CharSequence)",", data) + "]";
                            logger.debug((Object)logs);
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn.getUsername(), realm.getName(), "externalLinks", "External Links revoked:" + logs, ret);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Exception : ", (Throwable)e);
                        }
                        success.add((String)data);
                        break block7;
                    }
                    errors.add((String)data);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
        GenericReponseModel response = new GenericReponseModel();
        RevokeExternalLinksResponseModel responseModel = new RevokeExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setSuccess(success);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processCreateExternalLinks(AuthenticationManager.AuthResult authResult, String realmName, List<String> dataArray) {
        UserModel userLogIn = authResult.getUser();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessCreateExternalLinks(realmName, dataArray, userLogIn);
    }

    protected Response getResponseProcessCreateExternalLinks(String realmName, List<String> dataArray, UserModel userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<ExternalLinkModel> success = new ArrayList<ExternalLinkModel>();
        dataArray.forEach(data -> {
            String newApiKey;
            long currentTimestamp = System.currentTimeMillis();
            try {
                newApiKey = OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realm.getId(), this.objectMapper);
            }
            catch (Exception e) {
                logger.error((Object)"ERROR in getResponseProcessCreateExternalLinks: ", (Throwable)e);
                errors.add("Error generating link for " + data);
                return;
            }
            String id = KeycloakModelUtils.generateId();
            try {
                OlvidExternalLink olvidExternalLink = new OlvidExternalLink();
                olvidExternalLink.setId(id);
                olvidExternalLink.setRealmId(realm.getId());
                olvidExternalLink.setUserCreatorId(userLogIn.getId());
                olvidExternalLink.setKey(newApiKey);
                olvidExternalLink.setTag((String)data);
                olvidExternalLink.setCreateDate(currentTimestamp);
                olvidExternalLink.setRevoked(false);
                this.em.persist((Object)olvidExternalLink);
            }
            catch (Exception e) {
                logger.error((Object)("getResponseProcessCreateExternalLinks e " + e.getMessage()));
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            try {
                String logs = " [\n  realm Name: " + realm.getName() + ",\n  external Links tags : " + String.join((CharSequence)",", data) + "]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn.getUsername(), realm.getName(), "externalLinks", "External Links created:" + logs, ret);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
            if (ret.get("status").equals("ERROR") && ret.get("message").equals("Duplicate entry")) {
                errors.add((String)data);
            }
            if (ret.get("status").equals("SUCCESS")) {
                String link;
                ExternalLinkModel detail = new ExternalLinkModel();
                detail.setTag((String)data);
                try {
                    link = Utils.generateConfigurationLink(this.em, realm, this.objectMapper, newApiKey);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                detail.setId(id);
                detail.setLink(link);
                detail.setLink(link);
                detail.setKey_value(newApiKey);
                detail.setCreateDate(currentTimestamp);
                success.add(detail);
            }
        });
        GenericReponseModel response = new GenericReponseModel();
        CreateExternalLinksResponseModel responseModel = new CreateExternalLinksResponseModel();
        responseModel.setErrors(errors);
        responseModel.setCreated(success);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetExternalLinks(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetExternalLinks(realmName, tabChose, filters, writeAllowed, limit, offset);
    }

    protected Response getResponseProcessGetExternalLinks(String realmName, String tabChose, List<String> filters, boolean writeAllowed, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<OlvidExternalLink> list = OlvidExternalLinkDao.getAllOlvidExternalLinkForRealmId(this.em, realm.getId(), filters);
            int count = list.size();
            list = list.subList(Math.min(count, offset), Math.min(count, offset + limit));
            List<ExternalLinkModel> listFormated = list.stream().map(item -> new ExternalLinkModel().initExternalLinkModel(this.em, realm, this.objectMapper, (OlvidExternalLink)item)).collect(Collectors.toList());
            GetExternalLinksResponseModel responseModel = new GetExternalLinksResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(listFormated);
            responseModel.setCount(count);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetUserGroups(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset, String userId) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetUserGroups(realmName, tabChose, filters, writeAllowed, limit, offset, userId);
    }

    protected Response getResponseProcessGetUserGroups(String realmName, String tabChose, List<String> filters, boolean writeAllowed, int limit, int offset, String userId) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            UserModel userModel = this.session.users().getUserById(realm, userId);
            ArrayList userModelsCache = new ArrayList();
            List<GroupUserModel> userGroups = !filters.isEmpty() ? userModel.getGroupsStream(String.join((CharSequence)",", filters), Integer.valueOf(0), Integer.valueOf(10000)).map(groupModel -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realm, (GroupModel)groupModel, false, userModelsCache, "", (List<String>)new ArrayList<String>(), "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()) : userModel.getGroupsStream().map(groupModel -> {
                try {
                    return this.createGroupUsersFromGroupModel(this.em, this.session, realm, (GroupModel)groupModel, false, userModelsCache, tabChose, filters, "");
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            GetUserGroupsResponseModel responseModel = new GetUserGroupsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(userGroups);
            responseModel.setCount(userGroups.size());
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetCirclesVisibilitesFiltered(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetCirclesVisibilitiesFiltered(realmName, tabChose, filters, writeAllowed, limit, offset);
    }

    protected Response getResponseProcessGetCirclesVisibilitiesFiltered(String realmName, String tabChose, List<String> filters, boolean writeAllowed, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            List<OlvidCircleVisibility> data = Configuration.getOlvidCirclesVisibilities(this.em, realm);
            if (!filters.isEmpty()) {
                ArrayList<OlvidCircleVisibility> dataFiltered = new ArrayList<OlvidCircleVisibility>();
                List<OlvidCircleVisibility> finalData = data;
                filters.forEach(filter -> dataFiltered.addAll(finalData.stream().filter(item -> item.getName() != null && item.getName().toLowerCase().contains(filter.toLowerCase()) || item.getDescription() != null && item.getDescription().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList())));
                data = dataFiltered;
            }
            GetCirclesVisibilitiesFilteredResponseModel responseModel = new GetCirclesVisibilitiesFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(data);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    public static List<OlvidCircleVisibility> getOlvidCirclesVisibilities(EntityManager em, RealmModel realmModel) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getAllByRealm", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            List ret = q.getResultList();
            OlvidCircleVisibility olvidCircleVisibility = new OlvidCircleVisibility();
            olvidCircleVisibility.setId("default");
            olvidCircleVisibility.setName("Default Circle");
            olvidCircleVisibility.setDescription("All users not assigned to any other Circle");
            olvidCircleVisibility.setRealmId(realmModel.getId());
            ret.add(olvidCircleVisibility);
            return ret;
        }
        catch (NoResultException e) {
            return new ArrayList<OlvidCircleVisibility>();
        }
    }

    public static OlvidCircleVisibility getOlvidCircleVisibility(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibility ret = (OlvidCircleVisibility)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibility();
        }
    }

    public static List<OlvidCircleVisibilityRules> getOlvidCircleVisibilityByCircles(EntityManager em, RealmModel realmModel, String id) {
        new CirclesVisibilityRulesModel().checkRulesDuplicate(em);
        try {
            TypedQuery q;
            if (!id.contentEquals("default")) {
                q = em.createNamedQuery("OlvidCircleVisibilityRules.getByIdFromTo", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("fromId", (Object)id);
                q.setParameter("toId", (Object)id);
            } else {
                q = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRules", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
            }
            List<OlvidCircleVisibilityRules> result = q.getResultList();
            if (id.contentEquals("default")) {
                OlvidCircleVisibilityRules defaultCircle = (OlvidCircleVisibilityRules)result.stream().filter(rule -> rule.getId().contains("default")).collect(Collectors.toList()).get(0);
                List<OlvidCircleVisibilityRules> defaultsRules = result.stream().filter(rule -> !rule.getId().contains("default")).collect(Collectors.toList());
                defaultCircle.setId("default");
                List<OlvidCircleVisibilityRules> listClean = defaultsRules;
                listClean.add(defaultCircle);
                result = listClean;
            }
            result.forEach(rule -> {
                if (rule.getVisibility() != null && rule.getVisibility().isEmpty()) {
                    rule.setVisibility(null);
                }
            });
            TypedQuery queryCircles = em.createNamedQuery("OlvidCircleVisibility.getAllByRealm", OlvidCircleVisibility.class);
            queryCircles.setParameter("realmId", (Object)realmModel.getId());
            List circles = queryCircles.getResultList();
            ArrayList<OlvidCircleVisibility> missingCircles = new ArrayList<OlvidCircleVisibility>();
            List<OlvidCircleVisibilityRules> finalResult = result;
            circles.forEach(circle -> {
                List found = finalResult.stream().filter(rule -> rule.getCircleVisibilityId1From() != null && rule.getCircleVisibilityId1From().contentEquals(circle.getId()) || rule.getCircleVisibilityId2To() != null && rule.getCircleVisibilityId2To().contentEquals(circle.getId())).collect(Collectors.toList());
                if (found.isEmpty()) {
                    missingCircles.add((OlvidCircleVisibility)circle);
                }
            });
            boolean isDefaultRule = finalResult.stream().anyMatch(rule -> rule.getCircleVisibilityId1From() == null);
            boolean isCircleRule = finalResult.stream().filter(elem -> elem.getCircleVisibilityId1From() != null && elem.getCircleVisibilityId2To() != null).anyMatch(rule -> rule.getCircleVisibilityId1From().contentEquals(rule.getCircleVisibilityId2To()) && rule.getCircleVisibilityId2To().contentEquals(rule.getCircleVisibilityId1From()));
            if (!isDefaultRule) {
                OlvidCircleVisibility defaultRule = new OlvidCircleVisibility();
                defaultRule.setId("default");
                missingCircles.add(defaultRule);
            }
            if (!isCircleRule) {
                OlvidCircleVisibility circleRule = new OlvidCircleVisibility();
                circleRule.setId(id);
                missingCircles.add(circleRule);
            }
            if (!missingCircles.isEmpty()) {
                TypedQuery queryDefaultCircleRuleFrom = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                queryDefaultCircleRuleFrom.setParameter("realmId", (Object)realmModel.getId());
                try {
                    OlvidCircleVisibilityRules defaultCircleRuleFrom = (OlvidCircleVisibilityRules)queryDefaultCircleRuleFrom.getResultList().get(0);
                    missingCircles.forEach(circle -> {
                        if (!circle.getId().contains("default")) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circle.getId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(id);
                            olvidCircleVisibilityRulesFrom.setVisibility(defaultCircleRuleFrom.getVisibility());
                            olvidCircleVisibilityRulesFrom.setRealmId(defaultCircleRuleFrom.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesFrom);
                            if (!circle.getId().contentEquals(id)) {
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(id);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circle.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(defaultCircleRuleFrom.getVisibility());
                                olvidCircleVisibilityRulesTo.setRealmId(defaultCircleRuleFrom.getRealmId());
                                finalResult.add(olvidCircleVisibilityRulesTo);
                            }
                        } else if (!id.contains("default")) {
                            TypedQuery queryDefaultCircleRuleTo = em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                            queryDefaultCircleRuleTo.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules defaultCircleRuleTo = (OlvidCircleVisibilityRules)queryDefaultCircleRuleFrom.getResultList().get(0);
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circle.getId());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(id);
                            olvidCircleVisibilityRulesFrom.setVisibility(defaultCircleRuleTo.getVisibility());
                            olvidCircleVisibilityRulesFrom.setRealmId(defaultCircleRuleTo.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesFrom);
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(id);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circle.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(defaultCircleRuleTo.getVisibility());
                            olvidCircleVisibilityRulesTo.setRealmId(defaultCircleRuleTo.getRealmId());
                            finalResult.add(olvidCircleVisibilityRulesTo);
                        }
                    });
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                return finalResult;
            }
            return finalResult;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return new ArrayList<OlvidCircleVisibilityRules>();
        }
    }

    public static OlvidCircleVisibility getOlvidCircleVisibilityByUsers(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibility ret = (OlvidCircleVisibility)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibility();
        }
    }

    private Response processGetCircleVisibility(AuthenticationManager.AuthResult authResult, String role, String realmName, String id) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetCircleVisibility(realmName, writeAllowed, id);
    }

    protected Response getResponseProcessGetCircleVisibility(String realmName, boolean writeAllowed, String id) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            OlvidCircleVisibility data = new OlvidCircleVisibility();
            if (!id.contentEquals("") && !id.contentEquals("default")) {
                data = Configuration.getOlvidCircleVisibility(this.em, realmModel, id);
            }
            List<OlvidCircleVisibility> circles = Configuration.getOlvidCirclesVisibilities(this.em, realmModel);
            String circleDefaultRule = "";
            if (!id.contentEquals("default") && !id.contentEquals("")) {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRule", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("id", (Object)id);
                circleDefaultRule = ((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility();
            } else {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultCircleRuleBetweenMembers", OlvidCircleVisibilityRules.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                try {
                    circleDefaultRule = ((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility();
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            }
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
            }
            Object countResult = countQuery.getSingleResult();
            try {
                GetCircleVisibilityResponseModel responseModel = new GetCircleVisibilityResponseModel();
                responseModel.setWriteAllowed(writeAllowed);
                responseModel.setCircles(circles);
                responseModel.setCount((Long)countResult);
                responseModel.setData(data);
                responseModel.setCircleDefaultRule(circleDefaultRule);
                GenericReponseModel response = new GenericReponseModel();
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
                return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
        return this.internalError();
    }

    private Response processGetCircleVisibilityMembers(AuthenticationManager.AuthResult authResult, String role, String realmName, String id, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetCircleVisibilityMembers(realmName, writeAllowed, id, tabChose, filters, limit, offset);
    }

    protected Response getResponseProcessGetCircleVisibilityMembers(String realmName, boolean writeAllowed, String id, String tabChose, List<String> filters, int limit, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            ArrayList<CustomUserModel> data;
            List<OlvidCircleVisibilityUser> olvidCircleVisibilityMembersFiltered = Configuration.getOlvidCircleVisibilityMembersFiltered(this.em, realm, id, tabChose, filters, limit, offset);
            List usersListIds = olvidCircleVisibilityMembersFiltered.stream().map(OlvidCircleVisibilityUser::getUserId).collect(Collectors.toList());
            TypedQuery<Object[]> query = this.buildQueryFindUsersByIdsLimited(realm.getId(), usersListIds, filters, limit, offset);
            if (id.contains("default")) {
                query = this.buildQueryFindUsersWithoutCircleVisibility(realm.getId(), filters, limit, offset);
            }
            try {
                data = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
            }
            catch (NoResultException e) {
                data = new ArrayList();
            }
            if (id.contains("default")) {
                TypedQuery<String> queryIds = this.buildQueryFindAllUsersIdsWithoutCircleVisibility(realm.getId());
                usersListIds = queryIds.getResultList();
            }
            Query countQuery = this.buildQueryCountCircleVisibilityMembersWithFilter(realm.getId(), usersListIds, filters);
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountDefaultCircleVisibilityMembers(realm.getId(), filters);
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityMembersFilteredResponseModel responseModel = new GetCircleVisibilityMembersFilteredResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount((Long)countResult);
            responseModel.setData(data);
            responseModel.setTotalMembersIds(usersListIds);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    public static List<OlvidCircleVisibilityUser> getOlvidCircleVisibilityMembersFiltered(EntityManager em, RealmModel realmModel, String id, String tabChose, List<String> filters, int limit, int offset) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibilityUser.getAllByCircleVisibilityId", OlvidCircleVisibilityUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            List ret = q.getResultList();
            return ret;
        }
        catch (NoResultException e) {
            return new ArrayList<OlvidCircleVisibilityUser>();
        }
    }

    public static OlvidCircleVisibilityUser getUserOlvidCircleVisibility(EntityManager em, RealmModel realmModel, String id) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("id", (Object)id);
            OlvidCircleVisibilityUser ret = (OlvidCircleVisibilityUser)q.getSingleResult();
            return ret;
        }
        catch (NoResultException e) {
            return new OlvidCircleVisibilityUser();
        }
    }

    private Response processGetCircleVisibilityRulesByCircles(AuthenticationManager.AuthResult authResult, String role, String realmName, String id, Boolean isWithMembers) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        return this.getResponseProcessGetCircleVisibilityRulesByCircles(realmName, writeAllowed, id, isWithMembers);
    }

    protected Response getResponseProcessGetCircleVisibilityRulesByCircles(String realmName, boolean writeAllowed, String id, Boolean isWithMembers) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            if (id.isEmpty()) {
                id = "default";
            }
            List<OlvidCircleVisibilityRules> data = Configuration.getOlvidCircleVisibilityByCircles(this.em, realm, id);
            OlvidCircleVisibilityRulesListModel dataFormated = new OlvidCircleVisibilityRulesListModel().newOlvidCircleVisibilityRulesListModel(this.em, this.session, realm, data, id, isWithMembers);
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realm.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realm.getId());
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityRulesByCirclesResponseModel responseModel = new GetCircleVisibilityRulesByCirclesResponseModel();
            responseModel.setCount((Long)countResult);
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(dataFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetCircleVisibilityRulesByUsers(AuthenticationManager.AuthResult authResult, String role, String realmName, String id) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(30, role, authResult);
        }
        Boolean isWithMembers = true;
        return this.getResponseProcessGetCircleVisibilityRulesByCirclesByUsers(realmName, writeAllowed, id, isWithMembers);
    }

    protected Response getResponseProcessGetCircleVisibilityRulesByCirclesByUsers(String realmName, boolean writeAllowed, String id, Boolean isWithMembers) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "olvid", false)) {
            logger.error((Object)"Cannot access olvid users of a non olvid realm");
            return this.badRealmType();
        }
        try {
            if (id.isEmpty()) {
                id = "default";
            }
            List<OlvidCircleVisibilityRules> data = Configuration.getOlvidCircleVisibilityByCircles(this.em, realm, id);
            OlvidCircleVisibilityRulesListModel dataFormated = new OlvidCircleVisibilityRulesListModel().newOlvidCircleVisibilityRulesListModel(this.em, this.session, realm, data, id, isWithMembers);
            Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realm.getId(), id, new ArrayList<String>());
            if (id.contentEquals("default")) {
                countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realm.getId());
            }
            Object countResult = countQuery.getSingleResult();
            GetCircleVisibilityRulesByCirclesResponseModel responseModel = new GetCircleVisibilityRulesByCirclesResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setCount((Long)countResult);
            responseModel.setData(dataFormated);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddCircleVisibility(AuthenticationManager.AuthResult authResult, String realmName, Object dataObj) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessAddCircleVisibility(realmName, userLogIn, dataObj);
    }

    protected Response getResponseProcessAddCircleVisibility(String realmName, String userLogIn, Object dataObj) {
        GenericReponseModel response = new GenericReponseModel();
        AddCircleVisibilityResponseModel responseModel = new AddCircleVisibilityResponseModel();
        try {
            this.em.getTransaction().begin();
            RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
            CreateCircleVisibilityModel createCircleVisibilityModel = (CreateCircleVisibilityModel)this.objectMapper.convertValue(dataObj, CreateCircleVisibilityModel.class);
            OlvidCircleVisibility olvidCircleVisibility = new OlvidCircleVisibility();
            String circleId = KeycloakModelUtils.generateId();
            olvidCircleVisibility.setId(circleId);
            olvidCircleVisibility.setRealmId(realmModel.getId());
            olvidCircleVisibility.setName(createCircleVisibilityModel.getName());
            olvidCircleVisibility.setDescription(createCircleVisibilityModel.getDescription());
            this.em.persist((Object)olvidCircleVisibility);
            OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
            String ruleId = KeycloakModelUtils.generateId();
            olvidCircleVisibilityRules.setRealmId(realmModel.getId());
            olvidCircleVisibilityRules.setId(ruleId);
            olvidCircleVisibilityRules.setCircleVisibilityId1From(circleId);
            olvidCircleVisibilityRules.setCircleVisibilityId2To(circleId);
            olvidCircleVisibilityRules.setVisibility(createCircleVisibilityModel.getDefaultCircleMembersRule().toUpperCase());
            this.em.persist((Object)olvidCircleVisibilityRules);
            CircleVisibilityRuleModel fromRules = createCircleVisibilityModel.getFrom();
            fromRules.noContact.forEach(rule -> this.createOlvidCircleVisibilityRulesFrom(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            fromRules.seeContact.forEach(rule -> this.createOlvidCircleVisibilityRulesFrom(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            CircleVisibilityRuleModel toRules = createCircleVisibilityModel.getTo();
            toRules.noContact.forEach(rule -> this.createOlvidCircleVisibilityRulesTo(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            toRules.seeContact.forEach(rule -> this.createOlvidCircleVisibilityRulesTo(realmModel, (CirclesVisibilityRulesModel)rule, circleId));
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  create circleName: " + createCircleVisibilityModel.getName() + ",\n  with description: " + createCircleVisibilityModel.getDescription() + ",\n  with rules From : " + String.valueOf(createCircleVisibilityModel.getFrom()) + ",\n  with rules To : " + String.valueOf(createCircleVisibilityModel.getTo()) + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityCreate", "Circle visibility created:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            responseModel.setId(circleId);
            responseModel.setStatus(true);
            this.em.flush();
            this.em.getTransaction().commit();
        }
        catch (Exception e) {
            this.em.getTransaction().rollback();
        }
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processDeleteCircleVisibility(AuthenticationManager.AuthResult authResult, String realmName, String id, String name) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessDeleteCircleVisibility(realmName, userLogIn, id, name);
    }

    protected Response getResponseProcessDeleteCircleVisibility(String realmName, String userLogIn, String id, String name) {
        HashMap<String, Object> ret;
        String logs2;
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        TypedQuery query = this.em.createNamedQuery("OlvidCircleVisibility.getById", OlvidCircleVisibility.class);
        query.setParameter("realmId", (Object)realmModel.getId());
        query.setParameter("id", (Object)id);
        OlvidCircleVisibility olvidCircleVisibility = (OlvidCircleVisibility)query.getSingleResult();
        try {
            int countLinks = this.em.createNamedQuery("OlvidCircleVisibilityRules.deleteAllCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 1 delete circle's members: " + olvidCircleVisibility.getName() + ",\n  countLinks: " + countLinks + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs2) {}
        }
        catch (NoResultException countLinks) {
            // empty catch block
        }
        try {
            int countRules = this.em.createNamedQuery("OlvidCircleVisibilityRules.deleteAllCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 2 delete circle's rules: " + olvidCircleVisibility.getName() + ",\n  countRules: " + countRules + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs3) {}
        }
        catch (NoResultException countRules) {
            // empty catch block
        }
        try {
            int countCircle = this.em.createNamedQuery("OlvidCircleVisibility.deleteCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)id).executeUpdate();
            try {
                logs2 = " [\n  realm Name: " + realmModel.getName() + ",\n  step 3 delete circle : " + olvidCircleVisibility.getName() + ",\n  countCircle: " + countCircle + ",\n]";
                logger.debug((Object)logs2);
                ret = new HashMap();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityDelete", "Circle visibility deletion:" + logs2, ret);
            }
            catch (Exception logs4) {}
        }
        catch (NoResultException countCircle) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        AddCircleVisibilityResponseModel responseModel = new AddCircleVisibilityResponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processEditCircleVisibility(AuthenticationManager.AuthResult authResult, String realmName, Object dataObj) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessEditCircleVisibility(realmName, userLogIn, dataObj);
    }

    protected Response getResponseProcessEditCircleVisibility(String realmName, String userLogIn, Object dataObj) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CircleVisibilityModel circleEdited = (CircleVisibilityModel)this.objectMapper.convertValue(dataObj, CircleVisibilityModel.class);
        circleEdited.setRealmId(realmModel.getId());
        try {
            int count = this.em.createNamedQuery("OlvidCircleVisibility.editCircle").setParameter("name", (Object)circleEdited.getName()).setParameter("description", (Object)circleEdited.getDescription()).setParameter("id", (Object)circleEdited.getId()).executeUpdate();
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit circle id : " + circleEdited.getId() + ",\n  edit circle name : " + circleEdited.getName() + ",\n  edit circle description : " + circleEdited.getDescription() + ",\n  count edited : " + count + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
            }
            catch (Exception logs) {}
        }
        catch (NoResultException count) {
            // empty catch block
        }
        Query countQuery = this.buildQueryCountCircleVisibilityByCircleIdMembersWithFilter(realmModel.getId(), circleEdited.getId(), new ArrayList<String>());
        if (circleEdited.getId().contentEquals("default")) {
            countQuery = this.buildQueryCountCircleVisibilityMemberWithoutCircleIdWithFilter(realmModel.getId());
        }
        Object countResult = countQuery.getSingleResult();
        GenericReponseModel response = new GenericReponseModel();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setCount((Long)countResult);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processEditCircleVisibilityRules(AuthenticationManager.AuthResult authResult, String realmName, Object dataObj) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessEditCircleVisibilityRules(realmName, userLogIn, dataObj);
    }

    protected Response getResponseProcessEditCircleVisibilityRules(String realmName, String userLogIn, Object dataObj) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CircleVisibilityChangeVisibilityRuleModel rulesEdited = (CircleVisibilityChangeVisibilityRuleModel)this.objectMapper.convertValue(dataObj, CircleVisibilityChangeVisibilityRuleModel.class);
        ClusterProvider clusterProvider = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        logger.info((Object)userLogIn);
        this.em.getTransaction().begin();
        ExecutionResult result = clusterProvider.executeIfNotExecuted("olvid.editCircle." + realmModel.getId() + "." + rulesEdited.circleId, 10000, () -> {
            List<CircleVisibilityEditVisibilityRuleModel> changesFrom = rulesEdited.getChangeFrom();
            changesFrom.forEach(rule -> {
                String visibility = ConstantsCircleVisibility.sanitizeVisibility(rule.getAfter());
                try {
                    int count;
                    if (!(rule.getId().contentEquals("default") || rule.getId().contentEquals("default-to") || rule.getId().contentEquals("default-from"))) {
                        OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo;
                        String circleId;
                        String string = circleId = rulesEdited.getCircleId().contentEquals("default") ? null : rulesEdited.getCircleId();
                        if (circleId != null) {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)circleId).setParameter("toId", (Object)rule.getId()).executeUpdate();
                            if (count == 0) {
                                olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(circleId);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(circleId);
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        } else {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("toId", (Object)rule.getId()).executeUpdate();
                            if (count == 0) {
                                olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(circleId);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(circleId);
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(rule.getId());
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        }
                    } else if (rule.getId().contentEquals("default")) {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).executeUpdate();
                    } else {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("fromId", (Object)rulesEdited.getCircleId()).setParameter("visibility", (Object)visibility).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(visibility);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesTo);
                            TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                            q.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                        }
                    }
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit rule from circle id : " + rulesEdited.getCircleId() + ",\n  edit rule to circle : " + rule.item + ",\n  edit rule before : " + rule.before + ",\n  edit rule after : " + rule.after + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception exception) {}
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            });
            List<CircleVisibilityEditVisibilityRuleModel> changesTo = rulesEdited.getChangeTo();
            changesTo.forEach(rule -> {
                String visibility = ConstantsCircleVisibility.sanitizeVisibility(rule.getAfter());
                try {
                    int count;
                    if (!(rule.getId().contentEquals("defaultCircleBetweenMembers") || rule.getId().contentEquals("default-to") || rule.getId().contentEquals("default-from"))) {
                        String circleId;
                        String string = circleId = rulesEdited.getCircleId().contentEquals("default") ? null : rulesEdited.getCircleId();
                        if (circleId != null) {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRules").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)rule.getId()).setParameter("toId", (Object)circleId).executeUpdate();
                            if (count == 0) {
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesTo.setVisibility(visibility);
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rule.getId());
                                olvidCircleVisibilityRulesTo.setCircleVisibilityId2To(circleId);
                                this.em.persist((Object)olvidCircleVisibilityRulesTo);
                                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleTo", OlvidCircleVisibilityRules.class);
                                q.setParameter("realmId", (Object)realmModel.getId());
                                OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                                olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                                olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                                olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rule.getId());
                                olvidCircleVisibilityRulesFrom.setCircleVisibilityId1From(circleId);
                                this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                            }
                        } else {
                            count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleTo").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).setParameter("fromId", (Object)rule.getId()).executeUpdate();
                        }
                    } else if (rule.getId().contentEquals("defaultCircleBetweenMembers")) {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateDefaultCircleRuleBetweenMembers").setParameter("realmId", (Object)realmModel.getId()).setParameter("visibility", (Object)visibility).executeUpdate();
                    } else {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityRules.updateCircleRulesDefaultCircleFrom").setParameter("realmId", (Object)realmModel.getId()).setParameter("toId", (Object)rulesEdited.getCircleId()).setParameter("visibility", (Object)visibility).executeUpdate();
                        if (count == 0) {
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesTo = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesTo.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesTo.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesTo.setVisibility(visibility);
                            olvidCircleVisibilityRulesTo.setCircleVisibilityId1From(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesTo);
                            TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityRules.getDefaultRealmCircleRuleFrom", OlvidCircleVisibilityRules.class);
                            q.setParameter("realmId", (Object)realmModel.getId());
                            OlvidCircleVisibilityRules olvidCircleVisibilityRulesFrom = new OlvidCircleVisibilityRules();
                            olvidCircleVisibilityRulesFrom.setId(KeycloakModelUtils.generateId());
                            olvidCircleVisibilityRulesFrom.setRealmId(realmModel.getId());
                            olvidCircleVisibilityRulesFrom.setVisibility(((OlvidCircleVisibilityRules)q.getSingleResult()).getVisibility());
                            olvidCircleVisibilityRulesFrom.setCircleVisibilityId2To(rulesEdited.getCircleId());
                            this.em.persist((Object)olvidCircleVisibilityRulesFrom);
                        }
                    }
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit rule to circle id : " + rulesEdited.getCircleId() + ",\n  edit rule from circle : " + rule.item + ",\n  edit rule before : " + rule.before + ",\n  edit rule after : " + rule.after + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception exception) {}
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            });
            return this.success();
        });
        GenericReponseModel response = new GenericReponseModel();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        if (result.isExecuted()) {
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        } else {
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 3, "ERROR_CODE_OPERATION_ALREADY_PROCESSING", true);
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processEditUserCircleVisibilityRules(AuthenticationManager.AuthResult authResult, String realmName, String circleId, String userId) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessEditUserCircleVisibilityRules(realmName, userLogIn, circleId, userId);
    }

    protected Response getResponseProcessEditUserCircleVisibilityRules(String realmName, String userLogIn, String circleId, String userId) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        int count = this.editUserRules(userLogIn, circleId, userId, realmModel);
        GenericReponseModel response = new GenericReponseModel();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        responseModel.setCount(count);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private int editUserRules(String userLogIn, String circleId, String userId, RealmModel realmModel) {
        int count;
        block11: {
            count = 0;
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidCircleVisibilityUser.getUserCircleVisibilityId", OlvidCircleVisibilityUser.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("id", (Object)userId);
                q.getSingleResult();
                if (!circleId.contains("default")) {
                    try {
                        count = this.em.createNamedQuery("OlvidCircleVisibilityUser.updateUserCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("newCircleId", (Object)circleId).setParameter("id", (Object)userId).executeUpdate();
                        try {
                            String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit user : " + userId + ",\n  set circle : " + circleId + ",\n  count edited : " + count + ",\n]";
                            logger.debug((Object)logs);
                            HashMap<String, Object> ret = new HashMap<String, Object>();
                            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                            break block11;
                        }
                        catch (Exception logs) {
                        }
                    }
                    catch (NoResultException logs) {}
                    break block11;
                }
                try {
                    count = this.em.createNamedQuery("OlvidCircleVisibilityUser.deleteUserCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("id", (Object)userId).executeUpdate();
                    try {
                        String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit user : " + userId + ",\n  set circle : " + circleId + ",\n  count edited : " + count + ",\n]";
                        logger.debug((Object)logs);
                        HashMap<String, Object> ret = new HashMap<String, Object>();
                        OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
                    }
                    catch (Exception logs) {
                    }
                }
                catch (NoResultException logs) {}
            }
            catch (NoResultException e) {
                OlvidCircleVisibilityUser olvidCircleVisibilityUser = new OlvidCircleVisibilityUser();
                olvidCircleVisibilityUser.setId(KeycloakModelUtils.generateId());
                olvidCircleVisibilityUser.setRealmId(realmModel.getId());
                olvidCircleVisibilityUser.setUserId(userId);
                olvidCircleVisibilityUser.setCircleVisibilityId(circleId);
                this.em.persist((Object)olvidCircleVisibilityUser);
            }
        }
        return count;
    }

    private Response processRemoveUsersCircleVisibility(AuthenticationManager.AuthResult authResult, String realmName, String circleId, List<String> usersList) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessRemoveUserCircleVisibility(realmName, userLogIn, circleId, usersList);
    }

    protected Response getResponseProcessRemoveUserCircleVisibility(String realmName, String userLogIn, String circleId, List<String> usersList) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        try {
            int count = this.em.createNamedQuery("OlvidCircleVisibilityUser.deleteUsersCircle").setParameter("realmId", (Object)realmModel.getId()).setParameter("list", usersList).executeUpdate();
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  edit users : " + String.valueOf(usersList) + ",\n  remove circle : " + circleId + ",\n  count removed : " + count + ",\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realmModel.getName(), "circleVisibilityEdit", "Circle visibility edited:" + logs, ret);
            }
            catch (Exception logs) {}
        }
        catch (NoResultException count) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddUsersCircleVisibility(AuthenticationManager.AuthResult authResult, String realmName, String circleId, List<String> usersList) {
        String userLogIn = authResult.getUser().getUsername();
        if (userLogIn == null) {
            return this.internalError();
        }
        return this.getResponseProcessAddUsersCircleVisibility(realmName, userLogIn, circleId, usersList);
    }

    protected Response getResponseProcessAddUsersCircleVisibility(String realmName, String userLogIn, String circleId, List<String> usersList) {
        RealmModel realmModel = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        AtomicInteger count = new AtomicInteger();
        usersList.forEach(userId -> count.addAndGet(this.editUserRules(userLogIn, circleId, (String)userId, realmModel)));
        GenericReponseModel response = new GenericReponseModel();
        EditCircleVisibilityResponseModel responseModel = new EditCircleVisibilityResponseModel();
        responseModel.setStatus(true);
        responseModel.setCount(count.get());
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private void createOlvidCircleVisibilityRulesFrom(RealmModel realmModel, CirclesVisibilityRulesModel rule, String circleId) {
        OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
        String ruleId = KeycloakModelUtils.generateId();
        olvidCircleVisibilityRules.setRealmId(realmModel.getId());
        olvidCircleVisibilityRules.setId(ruleId);
        olvidCircleVisibilityRules.setCircleVisibilityId1From(circleId);
        olvidCircleVisibilityRules.setCircleVisibilityId2To(rule.getTo().getId().contains("default-to") ? null : rule.getTo().getId());
        olvidCircleVisibilityRules.setVisibility(rule.getVisibilityRule());
        this.em.persist((Object)olvidCircleVisibilityRules);
    }

    private void createOlvidCircleVisibilityRulesTo(RealmModel realmModel, CirclesVisibilityRulesModel rule, String circleId) {
        OlvidCircleVisibilityRules olvidCircleVisibilityRules = new OlvidCircleVisibilityRules();
        String ruleId = KeycloakModelUtils.generateId();
        olvidCircleVisibilityRules.setRealmId(realmModel.getId());
        olvidCircleVisibilityRules.setId(ruleId);
        olvidCircleVisibilityRules.setCircleVisibilityId1From(rule.getFrom().getId().contains("default") ? null : rule.getFrom().getId());
        olvidCircleVisibilityRules.setCircleVisibilityId2To(circleId);
        olvidCircleVisibilityRules.setVisibility(rule.getVisibilityRule());
        this.em.persist((Object)olvidCircleVisibilityRules);
    }

    private Response processCreateOlvidGroup(AuthenticationManager.AuthResult authResult, String realmName, Object dataObj) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessCreateOlvidGroup(realmName, dataObj, userLogIn);
    }

    protected Response getResponseProcessCreateOlvidGroup(String realmName, Object dataObj, String userLogIn) throws Exception {
        GroupModel newGroupModel;
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        CreateOlvidGroupModel group = (CreateOlvidGroupModel)this.objectMapper.convertValue(dataObj, CreateOlvidGroupModel.class);
        String groupName = group.getName();
        String groupParentId = group.getParentId();
        Boolean groupOlvid = group.getOlvidGroup();
        String groupDescription = group.getDescription();
        String groupOlvidName = group.getOlvidName();
        if (this.session.groups().getGroupsStream(realm).anyMatch(groupFound -> Objects.equals(groupFound.getName(), groupName))) {
            logger.info((Object)"processCreateOlvidGroup: duplicate group name");
            return this.invalidRequest();
        }
        if (groupParentId != null) {
            GroupModel parentGroupModel = this.session.groups().getGroupById(realm, groupParentId);
            if (parentGroupModel == null) {
                logger.info((Object)"processCreateOlvidGroup: invalid parent Id");
                return this.invalidRequest();
            }
            newGroupModel = this.session.groups().createGroup(realm, groupName, parentGroupModel);
        } else {
            newGroupModel = this.session.groups().createGroup(realm, groupName);
        }
        Utils.setGroupAttribute(newGroupModel, "olvid-description", groupDescription);
        Utils.setGroupAttribute(newGroupModel, "olvid-name", groupOlvidName);
        Utils.setGroupAttribute(newGroupModel, "olvid-group", groupOlvid.toString());
        Utils.setGroupAttribute(newGroupModel, "olvid-managed", "true");
        this.updateOlvidGroupAndNotify(realm, newGroupModel);
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + newGroupModel.getName() + ",\n  groupCustomName: " + groupOlvidName + ",\n  create group: " + groupOlvid + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupCreate", "Group created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        CreateOlvidGroupResponseModel responseModel = new CreateOlvidGroupResponseModel();
        responseModel.setId(newGroupModel.getId());
        responseModel.setStatus(true);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processMoveOlvidGroup(AuthenticationManager.AuthResult authResult, String realmName, String groupId, String newParentGroupId) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessMoveOlvidGroup(realmName, groupId, newParentGroupId, userLogIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getResponseProcessMoveOlvidGroup(String realmName, String groupId, String newParentGroupId, String userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        GroupModel group = this.session.groups().getGroupById(realm, groupId);
        String oldGroupParentName = "";
        if (group.getParentId() != null) {
            oldGroupParentName = this.session.groups().getGroupById(realm, group.getParentId()).getName();
        }
        GroupModel newGroupParent = this.session.groups().getGroupById(realm, newParentGroupId);
        try {
            tx = this.em.getTransaction();
            tx.begin();
            group.setParent(newGroupParent);
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  move group: " + group.getName() + ",\n  from oldParent: " + oldGroupParentName + ",\n  to newParent: " + newGroupParent.getName() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupMove", "Group moved:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processDuplicateOlvidGroup(AuthenticationManager.AuthResult authResult, String realmName, String groupId, Object data) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessDuplicateOlvidGroup(realmName, groupId, data, userLogIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getResponseProcessDuplicateOlvidGroup(String realmName, String groupId, Object data, String userLogIn) throws Exception {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        GroupModel group = this.session.groups().getGroupById(realm, groupId);
        GroupDuplicateSettingsModel parameters = (GroupDuplicateSettingsModel)this.objectMapper.convertValue(data, GroupDuplicateSettingsModel.class);
        GroupModel groupDuplicatedResponse = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            GroupModel groupDuplicated = this.session.groups().createGroup(realm, parameters.getGroupName());
            groupDuplicated.setParent(group.getParent());
            Utils.setGroupAttribute(groupDuplicated, "olvid-managed", "true");
            group.getAttributes().forEach((arg_0, arg_1) -> ((GroupModel)groupDuplicated).setAttribute(arg_0, arg_1));
            Utils.setGroupAttribute(groupDuplicated, "olvid-name", parameters.getOlvidName());
            try {
                OlvidGroup olvidGroup;
                if (parameters.getWithGroupAvatar().booleanValue() && (olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), group.getId())) != null) {
                    byte[] groupPhotoUid = olvidGroup.getGroupPhotoUid();
                    OlvidData groupData = OlvidDataDao.getOlvidDataByUid(this.em, realm.getId(), groupPhotoUid);
                    if (groupData != null) {
                        OlvidGroup olvidGroupDuplicated = OlvidGroup.createOlvidGroupFromModelAndSign(this.session, this.em, realm, groupDuplicated, this.objectMapper, new SecureRandom());
                        this.em.persist((Object)olvidGroupDuplicated);
                        OlvidData olvidDataDuplicated = new OlvidData();
                        byte[] dataDuplicatedUid = this.setOlvidDataAvatar(groupData.getData(), realm, olvidDataDuplicated);
                        olvidGroupDuplicated.setGroupPhotoUid(dataDuplicatedUid);
                        this.em.merge((Object)olvidGroupDuplicated);
                    }
                }
            }
            catch (Exception olvidGroup) {
                // empty catch block
            }
            this.updateOlvidGroupAndNotify(realm, groupDuplicated);
            groupDuplicatedResponse = groupDuplicated;
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                try {
                    if (parameters.getWithGroupMembers().booleanValue()) {
                        List<UserModel> groupMembers = this.session.users().getGroupMembersStream(realm, group).collect(Collectors.toList());
                        GroupModel finalGroupDuplicatedResponse = this.session.groups().getGroupById(realm, groupDuplicatedResponse.getId());
                        groupMembers.forEach(user -> {
                            UserModel userFound = this.session.users().getUserById(realm, user.getId());
                            userFound.joinGroup(finalGroupDuplicatedResponse);
                        });
                        this.updateOlvidGroupAndNotify(realm, finalGroupDuplicatedResponse);
                    }
                }
                catch (Exception groupMembers) {}
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  duplicate group: " + group.getName() + ",\n  with parameters : \n  with Group' Members: " + parameters.getWithGroupMembers().toString() + "\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupDuplicate", "Group duplicated:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        int userGroupsLimit = 10000;
        int userGroupsOffset = 0;
        GroupUserModel groupUsers = this.getGroupUsers(groupDuplicatedResponse.getId(), realm, "", new ArrayList<String>(), userGroupsLimit, userGroupsOffset, true, new ArrayList<String>());
        DuplicateGroupResponseModel responseModel = new DuplicateGroupResponseModel();
        responseModel.setGroup(groupUsers);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processSetUpGroupAvatar(AuthenticationManager.AuthResult authResult, String realmName, byte[] dataBytes, String id, String name) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessSetUpGroupAvatar(realmName, dataBytes, id, name, userLogIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getResponseProcessSetUpGroupAvatar(String realmName, byte[] dataBytes, String groupId, String groupName, String userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        OlvidData olvidData = new OlvidData();
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        GetGroupAvatarResponseModel responseModel = new GetGroupAvatarResponseModel();
        Object avatarUrl = "";
        responseModel.setAvatarUrl((String)avatarUrl);
        try {
            tx = this.em.getTransaction();
            tx.begin();
            byte[] dataUid = this.setOlvidDataAvatar(dataBytes, realm, olvidData);
            GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
            if (groupModel == null) {
                logger.error((Object)"In processSetUpGroupAvatar: group not found");
                Response response = this.internalError();
                return response;
            }
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), groupId);
            if (olvidGroup == null) {
                try {
                    olvidGroup = OlvidGroup.createOlvidGroupFromModelAndSign(this.session, this.em, realm, groupModel, this.objectMapper, new SecureRandom());
                    this.em.persist((Object)olvidGroup);
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to create OlvidGroup", (Throwable)e);
                    Response response = this.internalError();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response;
                }
            }
            olvidGroup.setGroupPhotoUid(dataUid);
            this.em.merge((Object)olvidGroup);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    notificationsToSend = OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realm, groupModel, this.objectMapper, new SecureRandom());
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                    Response response = this.internalError();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response;
                }
            }
            avatarUrl = "data:image/jpeg;base64," + Base64.getEncoder().encodeToString(olvidData.getData());
            responseModel.setAvatarUrl((String)avatarUrl);
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupName + ",\n  setUp Group Avatar : " + olvidData.getDataUid() + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected byte[] setOlvidDataAvatar(byte[] dataBytes, RealmModel realm, OlvidData olvidData) {
        olvidData.setData(dataBytes);
        olvidData.setRealmId(realm.getId());
        byte[] dataUid = PRNGHmacSHA256.get().bytes(32);
        String dataUidString = Base64.getEncoder().encodeToString(dataUid);
        olvidData.setDataUid(dataUidString);
        olvidData.setEncodedDataKey(Encoded.of(AuthEncAES256ThenSHA256Key.generate(PRNGHmacSHA256.get())).getBytes());
        OlvidData.insert(this.em, olvidData);
        return dataUid;
    }

    private Response processRemoveGroupAvatar(AuthenticationManager.AuthResult authResult, String realmName, String groupId) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessRemoveGroupAvatar(realmName, groupId, userLogIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getResponseProcessRemoveGroupAvatar(String realmName, String groupId, String userLogIn) {
        String olvidGroupName;
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
            if (groupModel == null) {
                logger.error((Object)"In processRemoveGroupAvatar: group not found");
                Response response = this.internalError();
                return response;
            }
            olvidGroupName = groupModel.getName();
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), groupId);
            if (olvidGroup == null) {
                logger.error((Object)"In processRemoveGroupAvatar: OlvidGroup doesn't exist");
                Response response = this.internalError();
                return response;
            }
            olvidGroup.setGroupPhotoUid(null);
            this.em.merge((Object)olvidGroup);
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    notificationsToSend = OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realm, groupModel, this.objectMapper, new SecureRandom());
                }
                catch (Exception e) {
                    logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                    Response response = this.internalError();
                    if (isDone) {
                        tx.commit();
                        if (notificationsToSend != null) {
                            CronScheduler.scheduleSendNotifications(notificationsToSend);
                        }
                    } else if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    return response;
                }
            }
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + olvidGroupName + ",\n  removed group avatar\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        RemoveGroupAvatarResponseModel responseModel = new RemoveGroupAvatarResponseModel();
        responseModel.setStatus(new ResponseConstants().STATUS_SUCCESS);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processDeleteGroup(AuthenticationManager.AuthResult authResult, String realmName, String groupId) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessDeleteGroup(realmName, groupId, userLogIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getResponseProcessDeleteGroup(String realmName, String groupId, String userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        EntityTransaction tx = null;
        boolean isDone = false;
        Collection<UserOrTopicToNotify> notificationsToSend = null;
        GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
        if (groupModel == null) {
            logger.error((Object)"In processDeleteAvatar: group not found");
            return this.internalError();
        }
        String groupName = groupModel.getName();
        try {
            tx = this.em.getTransaction();
            tx.begin();
            OlvidGroup olvidGroup = OlvidGroupDao.getOlvidGroupById(this.em, realm.getId(), groupId);
            if (olvidGroup != null) {
                if (Utils.isOlvidGroup(groupModel)) {
                    try {
                        notificationsToSend = OlvidGroupDao.disableGroupAndGetMembersToNotify(this.session, this.objectMapper, this.em, realm, olvidGroup);
                    }
                    catch (Exception e) {
                        logger.error((Object)"In processSetUpGroupAvatar: unable to updateOlvidGroupIfNeededAndGetMembersToNotify", (Throwable)e);
                        Response response = this.internalError();
                        if (isDone) {
                            tx.commit();
                            if (notificationsToSend != null) {
                                CronScheduler.scheduleSendNotifications(notificationsToSend);
                            }
                            this.session.groups().removeGroup(realm, groupModel);
                        } else if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        return response;
                    }
                }
                this.em.remove((Object)olvidGroup);
            }
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
                if (notificationsToSend != null) {
                    CronScheduler.scheduleSendNotifications(notificationsToSend);
                }
                this.session.groups().removeGroup(realm, groupModel);
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupName + ",\n  delete group\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupDelete", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processAddOlvidGroupUsers(AuthenticationManager.AuthResult authResult, String realmName, String groupId, List<String> dataArray) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessAddOlvidGroupUsers(realmName, groupId, dataArray, userLogIn);
    }

    protected Response getResponseProcessAddOlvidGroupUsers(String realmName, String groupId, List<String> usersList, String userLogIn) throws Exception {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        ArrayList usersListName = new ArrayList();
        usersList.forEach(userId -> {
            UserModel user = this.session.users().getUserById(realm, userId);
            if (user != null) {
                user.joinGroup(groupModel);
                usersListName.add(user.getUsername());
            }
        });
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  add users : " + String.valueOf(usersListName) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        this.updateOlvidGroupAndNotify(realm, groupModel);
        GenericReponseModel response = new GenericReponseModel();
        AddGroupUserResponseModel responseModel = new AddGroupUserResponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processRemoveOlvidGroupUsers(AuthenticationManager.AuthResult authResult, String realmName, String groupId, List<String> dataArray) throws Exception {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessRemoveOlvidGroupUsers(realmName, groupId, dataArray, userLogIn);
    }

    protected Response getResponseProcessRemoveOlvidGroupUsers(String realmName, String groupId, List<String> usersList, String userLogIn) throws Exception {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        GroupModel groupModel = this.session.groups().getGroupById(realm, groupId);
        if (groupModel == null) {
            return this.invalidRequest();
        }
        ArrayList usersListName = new ArrayList();
        usersList.forEach(userId -> {
            UserModel user = this.session.users().getUserById(realm, userId);
            if (user != null) {
                user.leaveGroup(groupModel);
                usersListName.add(user.getUsername());
            }
        });
        try {
            String logs = " [\n  realm Name: " + realm.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  remove users : " + String.valueOf(usersListName) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "groupEdit", "Group edited:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        this.updateOlvidGroupAndNotify(realm, groupModel);
        try {
            RemoveOlvidGroupUsersResponseModel responseModel = new RemoveOlvidGroupUsersResponseModel();
            responseModel.setStatus(new ResponseConstants().STATUS_SUCCESS);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processRemoveManagers(AuthenticationManager.AuthResult authResult, String role, ArrayList<String> managerIdList) {
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (!adminRealm.isPresent()) {
            logger.warn((Object)"Manager user creation: Could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel adminRealmModel = adminRealm.get();
        for (String s : managerIdList) {
            if (authResult.getUser().getUsername().equals(s) && authResult.getSession().getRealm().getId().equals(adminRealmModel.getId())) continue;
            UserModel userModel = this.session.users().getUserByUsername(adminRealmModel, s);
            UserManager um = new UserManager(this.session);
            um.removeUser(adminRealmModel, userModel);
            try {
                String logs = " [\n  username: " + userModel.getUsername() + ",\n  realm Id: " + adminRealmModel.getId() + ",\n  realm Name: " + adminRealmModel.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(userModel.getFirstName()).isEmpty() ? "  firstname: " + userModel.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(userModel.getUsername()).isEmpty() ? "  lastname: " + userModel.getUsername() + ",\n" : "") + "  email: " + userModel.getEmail() + ",\n  role: " + Utils.getUserAttribute(userModel, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), adminRealmModel.getName(), "adminDeletion", "Admin deletion:" + logs, ret);
            }
            catch (Exception exception) {}
        }
        ArrayList<String> filters = new ArrayList<String>();
        String tabChose = "";
        return this.processGetManagersUsers(authResult, role, adminRealmModel.getName(), tabChose, filters, 10, 0);
    }

    protected Response processSendAutomaticPasswordEmail(String password, String username, String isocode, String realmName) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realm, Utils.emptyStringOrTrim(username));
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getCreateAdminEmailSubject(isocode), Email.getCreateAdminEmailBodyText(isocode, userModel.getUsername(), password), Email.getCreateAdminEmailBodyHTML(isocode, userModel.getUsername(), password));
    }

    protected Response processSendAutomaticPasswordEmailReseted(String password, String username, String isocode, String realmName) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realm, Utils.emptyStringOrTrim(username));
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getPasswordResetEmailSubject(isocode), Email.getPasswordResetEmailBodyText(isocode, userModel.getUsername(), password), Email.getPasswordResetEmailBodyHTML(isocode, userModel.getUsername(), password));
    }

    private Response processSendUserOldDeviceAlert(String id, String username, String isocode, String realmName) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realm, Utils.emptyStringOrTrim(username));
        TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
        q.setParameter("realmId", (Object)realm.getId());
        q.setParameter("userId", (Object)userModel.getId());
        q.setParameter("deviceUid", (Object)id);
        OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
        String displayName = olvidUserDevice.getDisplayName();
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getUserOldDeviceAlertSubject(isocode), Email.getUserOldDeviceAlertBodyText(isocode, userModel.getUsername(), displayName), Email.getUserOldDeviceAlertBodyHTML(isocode, userModel.getUsername(), displayName));
    }

    private Response processSendUserUnknownDeviceAlert(String id, String username, String isocode, String realmName) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        RealmModel masterRealm = this.session.realms().getRealmByName("master");
        UserModel userModel = this.session.users().getUserByUsername(realm, Utils.emptyStringOrTrim(username));
        TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
        q.setParameter("realmId", (Object)realm.getId());
        q.setParameter("userId", (Object)userModel.getId());
        q.setParameter("deviceUid", (Object)id);
        OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
        String displayName = olvidUserDevice.getDisplayName();
        return this.sendEmailAndGetResponse(masterRealm, userModel, Email.getUserUnknownDeviceAlertSubject(isocode), Email.getUserUnknownDeviceAlertBodyText(isocode, userModel.getUsername(), displayName), Email.getUserUnknownDeviceAlertBodyHTML(isocode, userModel.getUsername(), displayName));
    }

    private Response sendEmailAndGetResponse(RealmModel masterRealm, UserModel userModel, String emailSubject, String emailTextBody, String emailHtmlBody) {
        try {
            EmailSenderProvider emailSender = (EmailSenderProvider)this.session.getProvider(EmailSenderProvider.class);
            try {
                emailSender.send(masterRealm.getSmtpConfig(), userModel, emailSubject, emailTextBody, emailHtmlBody);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception sendEmailAndGetResponse senderProvider e " + String.valueOf(e)));
                GenericReponseModel response = new GenericReponseModel();
                SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(false);
                CustomUserModel olvidUser = new CustomUserModel();
                CustomUserModel userModelCustom = olvidUser.initCustomUserModel(this.em, this.session, masterRealm, olvidUser, userModel, new OlvidCircleVisibility());
                response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, userModelCustom, true);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
            }
            GenericReponseModel response = new GenericReponseModel();
            SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(true);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)response).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception sendEmailAndGetResponse e ", (Throwable)e);
            GenericReponseModel response = new GenericReponseModel();
            SendAutomaticPasswordResponseModel responseModel = new SendAutomaticPasswordResponseModel().setUpSendAutomaticPasswordResponseModel(false);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, userModel, true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).type("application/json").build();
        }
    }

    private Response processResetManagerPassword(AuthenticationManager.AuthResult authResult, ArrayList<String> managersListString) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessResetManagerPassword(managersListString, userLogIn);
    }

    protected Response getResponseProcessResetManagerPassword(ArrayList<String> managersListString, String userLogIn) {
        ArrayList<String> managerUsersListError = new ArrayList<String>();
        Optional<RealmModel> adminRealm = this.session.realms().getRealmsStream().filter(realmModel -> OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "admin", false)).findFirst();
        if (!adminRealm.isPresent()) {
            logger.warn((Object)"Manager user reset password error: could not find any admin realm");
            return this.invalidRequest();
        }
        RealmModel realm = adminRealm.get();
        ArrayList<UserModel> managerUsersList = new ArrayList<UserModel>();
        for (String string : managersListString) {
            UserModel managerUser = this.session.users().getUserByUsername(realm, string);
            if (managerUser == null || string.isEmpty()) {
                logger.warn((Object)"Manager user reset password error: one or mode username not exists or invalid request");
                managerUsersListError.add(string);
                continue;
            }
            managerUsersList.add(managerUser);
        }
        ArrayList<CustomBasicWithPasswordModel> dataRet = new ArrayList<CustomBasicWithPasswordModel>();
        for (UserModel managerUser : managerUsersList) {
            PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
            String password = this.generateRandomPassword(passwordPolicy);
            try {
                this.setUserPassword(managerUser, password, passwordPolicy);
            }
            catch (Exception e) {
                logger.warn((Object)"Manager user update error: unable to create password for account (no hash provider found)");
                managerUsersListError.add(managerUser.getUsername());
                continue;
            }
            CustomBasicWithPasswordModel dataRetObject = new CustomBasicWithPasswordModel();
            dataRetObject.setUsername(managerUser.getUsername());
            dataRetObject.setEmail(managerUser.getEmail());
            dataRetObject.setPassword(password);
            try {
                String logs = " [\n  username: " + managerUser.getUsername() + ",\n  realm Name: " + realm.getName() + ",\n" + (String)(Utils.nullOrTrim(managerUser.getFirstName()) != null ? "  firstname: " + managerUser.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(managerUser.getLastName()) != null ? "  lastname: " + managerUser.getLastName() + ",\n" : "") + "  email: " + managerUser.getEmail() + ",\n  role: " + Utils.getUserAttribute(managerUser, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "adminUpdate", "Admin updated:" + logs, new HashMap<String, Object>());
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataRet.add(dataRetObject);
        }
        Map map = this.session.realms().getRealmByName("master").getSmtpConfig();
        UpdateUserResetPasswordResponseModel responseModel = new UpdateUserResetPasswordResponseModel();
        responseModel.updateManagerResetPasswordResponseModel(dataRet, managerUsersListError, map.isEmpty() || map.get("host") == null || ((String)map.get("host")).isEmpty() || map.get("from") == null || ((String)map.get("from")).isEmpty());
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processResetUserPassword(AuthenticationManager.AuthResult authResult, ArrayList<String> usersListString, String passwordCustom, String realmName) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessResetUserPassword(usersListString, passwordCustom, realmName, userLogIn);
    }

    protected Response getResponseProcessResetUserPassword(ArrayList<String> usersListString, String passwordCustom, String realmName, String userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        ArrayList<UserModel> usersList = new ArrayList<UserModel>();
        ArrayList<String> errorsList = new ArrayList<String>();
        for (String string : usersListString) {
            UserModel user = this.session.users().getUserByUsername(realm, string);
            if (user == null || string.isEmpty()) {
                logger.warn((Object)"User reset password error: one or more username does not exist (or invalid request)");
                errorsList.add(string);
                continue;
            }
            usersList.add(user);
        }
        ArrayList<CustomBasicWithPasswordModel> dataArray = new ArrayList<CustomBasicWithPasswordModel>();
        for (UserModel user : usersList) {
            PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
            String password = "";
            if (passwordCustom == null) {
                user.credentialManager().getStoredCredentialsByTypeStream("password").forEach(credentialModel -> user.credentialManager().removeStoredCredentialById(credentialModel.getId()));
                Utils.setUserAttribute(user, "one-time-password", null);
            } else {
                password = passwordCustom.trim().isEmpty() ? this.generateRandomPassword(passwordPolicy) : passwordCustom.trim();
                try {
                    this.setUserPassword(user, password, passwordPolicy);
                }
                catch (Exception e) {
                    logger.warn((Object)"User update error: unable to create password for account (no hash provider found)");
                    errorsList.add(user.getUsername());
                    continue;
                }
            }
            CustomBasicWithPasswordModel dataRetObject = new CustomBasicWithPasswordModel();
            dataRetObject.setUsername(user.getUsername());
            dataRetObject.setPassword(password);
            dataRetObject.setEmail(user.getEmail());
            try {
                String logs = " [\n  username: " + user.getUsername() + ",\n  realm Name: " + realm.getName() + ",\n" + (String)(Utils.nullOrTrim(user.getFirstName()) != null ? "  firstname: " + user.getFirstName() + ",\n" : "") + (String)(Utils.nullOrTrim(user.getLastName()) != null ? "  lastname: " + user.getLastName() + ",\n" : "") + "  email: " + user.getEmail() + ",\n  role: " + Utils.getUserAttribute(user, "olvid-role") + "\n]";
                logger.debug((Object)logs);
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "userCreation", "User created:" + logs, new HashMap<String, Object>());
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataArray.add(dataRetObject);
        }
        UpdateUserResetPasswordResponseModel updateUserResetPasswordResponseModel = new UpdateUserResetPasswordResponseModel();
        updateUserResetPasswordResponseModel.setData(dataArray);
        updateUserResetPasswordResponseModel.setErrors(errorsList);
        Map masterSmtpConfig = this.session.realms().getRealmByName("master").getSmtpConfig();
        updateUserResetPasswordResponseModel.setSmtpError(masterSmtpConfig.isEmpty() || masterSmtpConfig.get("host") == null || ((String)masterSmtpConfig.get("host")).isEmpty() || masterSmtpConfig.get("from") == null || ((String)masterSmtpConfig.get("from")).isEmpty());
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(updateUserResetPasswordResponseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        response.setData(updateUserResetPasswordResponseModel);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        if (policy != null && policy.getHashAlgorithm() != null) {
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        }
        return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class);
    }

    protected Response processGetEmailContent(String isocode, String emailType) {
        String dataRet = "";
        if (emailType.contains(EmailConstants.CREATE_USER)) {
            dataRet = Email.getCreateAdminEmailBodyHTML(isocode, "[OlvidUser]", "[OlvidPassword]");
        } else if (emailType.contains(EmailConstants.RESET_PASSWORD)) {
            dataRet = Email.getPasswordResetEmailBodyHTML(isocode, "[OlvidUser]", "[OlvidPassword]");
        } else if (emailType.contains(EmailConstants.ALERT_USER_OLD_SYNC)) {
            dataRet = Email.getUserOldDeviceAlertBodyHTML(isocode, "[OlvidUser]", "[DisplayName]");
        } else if (emailType.contains(EmailConstants.ALERT_USER_UNKNOWN_DEVICE)) {
            dataRet = Email.getUserUnknownDeviceAlertBodyHTML(isocode, "[OlvidUser]", "[DisplayName]");
        }
        GetEmailContentResponseModel responseModel = new GetEmailContentResponseModel();
        responseModel.setData(dataRet);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processCreateBot(AuthenticationManager.AuthResult authResult, byte[] postData) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessCreateBot(postData, userLogIn);
    }

    protected Response getResponseProcessCreateBot(byte[] postData, String userLogIn) {
        CreateBotPayloadModel request;
        if (postData == null || postData.length == 0) {
            logger.warn((Object)"Invalid request : CreateBot: no payload in request");
            return this.invalidRequest();
        }
        try {
            request = (CreateBotPayloadModel)this.objectMapper.readValue(postData, CreateBotPayloadModel.class);
            RealmModel realmModel = this.session.realms().getRealmByName(request.getRealmName());
            if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realmModel.getId(), "enableBotsManagement", false)) {
                logger.warn((Object)"Internal Error : Bots management disabled");
                return this.internalError("Bots management disabled");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception CreateBot: Unable to parse request", (Throwable)e);
            return this.invalidRequest();
        }
        if (request.getUsername() == null || request.getRealmName() == null || request.getFirstname() == null && request.getLastname() == null) {
            logger.warn((Object)"Invalid Request CreateBot: Missing required fields");
            return this.invalidRequest();
        }
        RealmModel realm = this.session.realms().getRealmByName(request.getRealmName());
        if (realm == null) {
            logger.warn((Object)"Internal Error : CreateBot: Unable to get requested realm");
            return this.internalError("Realm do not exists: " + request.getRealmName());
        }
        if (this.session.users().getUserByUsername(realm, request.getUsername()) != null) {
            logger.warn((Object)"CreateBot: username already used");
            return this.internalError("Username already exists: " + request.getUsername());
        }
        String apiKey = OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, realm.getId(), this.objectMapper);
        if (apiKey == null) {
            logger.warn((Object)"CreateBot: unable to get an API key for the bot");
            return this.internalError("Unable to get an API key for the bot");
        }
        ClientModel client = realm.getClientByClientId("olvid-bot-client");
        if (client == null) {
            client = realm.addClient("olvid-bot-client");
            client.setEnabled(true);
            client.setDirectAccessGrantsEnabled(true);
            client.setClientAuthenticatorType("client-secret");
            client.setSecret(UUID.randomUUID().toString());
            client.setProtocol("openid-connect");
            ClientScopeModel[] offlineAccess = new ClientScopeModel[1];
            realm.getClientScopesStream().forEach(clientScopeModel -> {
                if (clientScopeModel.getName().equals("offline_access")) {
                    offlineAccess[0] = clientScopeModel;
                }
            });
            if (offlineAccess[0] != null) {
                client.addClientScope(offlineAccess[0], false);
            } else {
                logger.warn((Object)"Unable to find offline scopes for bot client");
            }
            client.setAttribute("client.offline.session.idle.timeout", "86400000000");
            client.setAttribute("client.offline.session.max.lifespan", "86400000000");
            logger.info((Object)"CreateBot: Created bot client");
        }
        UserModel newUser = this.session.users().addUser(realm, request.getUsername());
        newUser.setFirstName(request.getFirstname());
        newUser.setLastName(request.getLastname());
        Utils.setUserAttribute(newUser, "olvid-company", request.getCompany());
        Utils.setUserAttribute(newUser, "olvid-position", request.getPosition());
        Utils.setUserAttribute(newUser, "olvid-is-bot", "true");
        Utils.setUserAttribute(newUser, "one-time-password", "true");
        Utils.setUserAttribute(newUser, "olvid-api-key", apiKey);
        newUser.setEnabled(true);
        String password = UUID.randomUUID().toString();
        PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        PasswordHashProvider hashProvider = this.getHashProvider(policy);
        if (hashProvider == null) {
            logger.warn((Object)"Internal Error : Unable to create password for bot account: no hash provider found");
            return this.internalError("Hash provider not found");
        }
        PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
        credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        newUser.credentialManager().createStoredCredential((CredentialModel)credentialModel);
        try {
            String logs = " [\n  bot: " + newUser.getUsername() + ",\n  realmName: " + realm.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(newUser.getFirstName()).isEmpty() ? "  firstname: " + newUser.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(newUser.getLastName()).isEmpty() ? "  lastname: " + newUser.getLastName() + ",\n" : "") + "  email: " + newUser.getEmail() + ",\n]";
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "botCreation", "Bot created:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            String configurationUrl = Utils.getBotConfigurationLink(this.em, this.session, this.objectMapper, realm, client, newUser, password);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)configurationUrl), (String)"application/json").build();
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"ResetBotLink: unable to serialize response");
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError("Json serialization error");
        }
    }

    private Response processResetBotLink(AuthenticationManager.AuthResult authResult, String realmName, String id) {
        String userLogIn = authResult.getUser().getUsername();
        return this.getResponseProcessResetBotLink(realmName, id, userLogIn);
    }

    protected Response getResponseProcessResetBotLink(String realmName, String id, String userLogIn) {
        RealmModel realm = this.session.realms().getRealmByName(Utils.emptyStringOrTrim(realmName));
        if (id == null) {
            logger.warn((Object)"Invalid request : ResetLinkBot: no botId in request");
            return this.invalidRequest();
        }
        UserModel bot = this.session.users().getUserById(realm, id);
        if (bot == null || !Utils.isBotUser(bot)) {
            logger.warn((Object)"Received a resetBotLink request for a user Id that is not a bot (or does not exist)");
            return this.invalidRequest();
        }
        this.signOutUser(realmName, id);
        this.removeCredential(realmName, id);
        ClientModel client = realm.getClientByClientId("olvid-bot-client");
        if (client == null) {
            logger.warn((Object)"Received a resetBotLink request and olvid bot client does not exist");
            return this.internalError();
        }
        bot.setAttribute("one-time-password", Collections.singletonList("true"));
        bot.setEnabled(true);
        String password = UUID.randomUUID().toString();
        PasswordPolicy passwordPolicy = realm.getPasswordPolicy();
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        PasswordHashProvider hashProvider = this.getHashProvider(policy);
        if (hashProvider == null) {
            logger.warn((Object)"Internal Error : Unable to create password for bot account: no hash provider found");
            return this.internalError("Hash provider not found");
        }
        PasswordCredentialModel credentialModel = hashProvider.encodedCredential(password, passwordPolicy.getHashIterations());
        credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        bot.credentialManager().createStoredCredential((CredentialModel)credentialModel);
        try {
            String logs = " [\n  bot: " + bot.getUsername() + ",\n  realmName: " + realm.getName() + ",\n" + (String)(!Utils.emptyStringOrTrim(bot.getFirstName()).isEmpty() ? "  firstname: " + bot.getFirstName() + ",\n" : "") + (String)(!Utils.emptyStringOrTrim(bot.getLastName()).isEmpty() ? "  lastname: " + bot.getLastName() + ",\n" : "") + "  email: " + bot.getEmail() + ",\n]";
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn, realm.getName(), "botResetLink", "Bot's link reseted:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            String configurationUrl = Utils.getBotConfigurationLink(this.em, this.session, this.objectMapper, realm, client, bot, password);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)configurationUrl), (String)"application/json").build();
        }
        catch (JsonProcessingException e) {
            logger.warn((Object)"ResetBotLink: unable to serialize response");
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError("Json serialization error");
        }
    }

    private Response processDownloadXslxCsv(AuthenticationManager.AuthResult authResult, String realmName, String format, String tabChose, List<String> filters, int offset) throws JsonProcessingException {
        Response ret = null;
        int userGroupsLimit = 1000;
        int userGroupsOffset = 0;
        if (format.contentEquals("users")) {
            ret = this.processDownloadUsersFormat(authResult, realmName, tabChose, filters, offset, userGroupsLimit, userGroupsOffset);
        } else if (format.contentEquals("devices")) {
            ret = this.processDownloadDevicesFormat(authResult, realmName, tabChose, filters, offset);
        } else if (format.contentEquals("externalLinks")) {
            ret = this.processDownloadExternalLinksFormat(authResult, realmName, tabChose, filters, offset);
        }
        return ret;
    }

    private Response processDownloadUsersFormat(AuthenticationManager.AuthResult authResult, String realmName, String tabChose, List<String> filters, int offset, int userGroupsLimit, int userGroupsOffset) throws JsonProcessingException {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        int usersCount = this.session.users().getUsersCount(realm);
        TypedQuery<Object[]> query = this.buildUsersQueryLimited(realm.getId(), filters, 500, offset, Utils.emptyStringOrTrim(tabChose), new ArrayList<String>());
        List<CustomUserModel> olvidUsersList = query.getResultStream().map(result -> Configuration.createOlvidUserFromUserEntity(this.em, this.session, realm, (UserEntity)result[0], (OlvidCircleVisibility)result[1])).collect(Collectors.toList());
        DownloadXslxCsvUsersResponseModel responseModel = new DownloadXslxCsvUsersResponseModel();
        responseModel.setData(olvidUsersList);
        responseModel.setCount(usersCount);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            String logs = " [\n  by manager's username: " + authResult.getUser().getUsername() + ",\n  realm Name: " + realm.getName() + ",\n  export users xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realm.getName(), "exportUsers", "Users exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception processDownloadUsersFormat e ", (Throwable)e);
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_ERROR, 1, new HashMap<String, String>().put("message", e.getMessage()), true);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
    }

    private Response processDownloadDevicesFormat(AuthenticationManager.AuthResult authResult, String realmName, String tabChose, List<String> filters, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query countQuery = this.buildDevicesQueryCountWithFilter(realm.getId(), Utils.emptyStringOrTrim(tabChose), filters, new ArrayList<String>());
        Object devicesCount = countQuery.getSingleResult();
        TypedQuery<Object[]> query = this.buildDevicesQueryLimited(realm.getId(), filters, 500, offset, Utils.emptyStringOrTrim(tabChose));
        List olvidUserDeviceList = query.getResultStream().map(device -> new OlvidUserDeviceModel().newOlvidUserDevice(this.em, this.session, realm, (Object[])device, new OlvidCircleVisibility())).collect(Collectors.toList());
        response.put("data", olvidUserDeviceList);
        response.put("count", devicesCount);
        try {
            String logs = " [\n  by manager's username: " + authResult.getUser().getUsername() + ",\n  realm Name: " + realm.getName() + ",\n  export devices xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realm.getName(), "exportDevices", "Devices exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes(response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processDownloadExternalLinksFormat(AuthenticationManager.AuthResult authResult, String realmName, String tabChose, List<String> filters, int offset) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        List<OlvidExternalLink> list = OlvidExternalLinkDao.getAllOlvidExternalLinkForRealmId(this.em, realm.getId(), filters);
        int count = list.size();
        list = list.subList(Math.min(count, offset), Math.min(count, offset + 500));
        List listFormated = list.stream().map(item -> new ExternalLinkModel().initExternalLinkModel(this.em, realm, this.objectMapper, (OlvidExternalLink)item)).collect(Collectors.toList());
        responseData.put("data", listFormated);
        responseData.put("count", count);
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(responseData, new ResponseConstants().STATUS_ERROR, 7, "isQueryAllowed", false);
        try {
            String logs = " [\n  by manager's username: " + authResult.getUser().getUsername() + ",\n  realm Name: " + realm.getName() + ",\n  export external links xslx or csv with: \n  tabChose: " + tabChose + ",\n  filters: " + String.valueOf(filters) + ",\n]";
            logger.debug((Object)logs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            OlvidConsoleLogsDao.logUserEvent(this.em, this.session, authResult.getUser().getUsername(), realm.getName(), "externalLinks", "External links exported:" + logs, ret);
        }
        catch (Exception logs) {
            // empty catch block
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }

    private Response processGetDashboard(AuthenticationManager.AuthResult authResult, String role) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(44, role, authResult);
        }
        return this.getResponseProcessGetDashboard(writeAllowed);
    }

    protected Response getResponseProcessGetDashboard(boolean writeAllowed) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT  u.username, oc.realmId, oc.value, a.value as activated  FROM OlvidConfiguration oc  LEFT JOIN UserEntity u on oc.realmId = u.realmId LEFT JOIN u.attributes AS a  WHERE a.name = 'olvid-identity'  AND oc.name = 'serverKeycloakApiKey'  AND oc.realmId in ( SELECT oc2.realmId FROM OlvidConfiguration oc2 WHERE oc2.name = 'olvid' and oc2.value = 'true')");
            TypedQuery query = this.em.createQuery(sb.toString(), Object[].class);
            List resultFormated = query.getResultStream().map(DashboardJPAModel::initDashboardJPAModel).collect(Collectors.toList());
            List<Object> realmIds = new ArrayList();
            if (!resultFormated.isEmpty()) {
                realmIds = resultFormated.stream().map(DashboardJPAModel::getRealmId).distinct().collect(Collectors.toList());
            }
            ArrayList<DashboardModel> dashboardModelsList = new ArrayList<DashboardModel>();
            ArrayList apiKeys = new ArrayList();
            if (!realmIds.isEmpty()) {
                realmIds.forEach(realmId -> {
                    RealmModel realmModel = this.session.realms().getRealm(realmId);
                    DashboardUsersModel dashboardUsersModel = new DashboardUsersModel();
                    long usersActivated = resultFormated.stream().filter(DashboardJPAModel::isActivated).filter(result -> result.getRealmId().equals(realmId)).map(DashboardJPAModel::getUsername).distinct().count();
                    dashboardUsersModel.setUsersActivated(usersActivated);
                    if (realmModel != null) {
                        dashboardUsersModel.setCount(this.session.users().getUsersCount(realmModel));
                        DashboardLicensesModel dashboardLicensesModel = new DashboardLicensesModel();
                        String apiKey = "";
                        try {
                            apiKey = resultFormated.stream().filter(result -> result.getRealmId().equals(realmId)).map(DashboardJPAModel::getValue).findFirst().get();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        if (!apiKeys.contains(apiKey)) {
                            apiKeys.add(apiKey);
                        }
                        dashboardLicensesModel.setApiKey(apiKey);
                        dashboardLicensesModel.setOlvidApiKeyCount(usersActivated);
                        String finalApiKey = apiKey;
                        try {
                            List<String> realmIdsWithSameApiKeys = resultFormated.stream().filter(result -> result.getValue().equals(finalApiKey)).map(DashboardJPAModel::getRealmId).distinct().collect(Collectors.toList());
                            ArrayList<String> realmNamesWithSameApiKeys = new ArrayList<String>();
                            realmIdsWithSameApiKeys.forEach(realm -> {
                                try {
                                    realmNamesWithSameApiKeys.add(this.session.realms().getRealm(realm).getName());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                            dashboardLicensesModel.setRealmNames(realmNamesWithSameApiKeys);
                            OlvidConfiguration licences = OlvidConfigurationDao.getOlvidConfiguration(this.em, realmId, "licensesCount");
                            dashboardLicensesModel.setMissingInformation(false);
                            long licensesCount = 0L;
                            if (licences == null) {
                                dashboardLicensesModel.setMissingInformation(true);
                            } else {
                                licensesCount = Long.parseLong(licences.getValue());
                            }
                            dashboardLicensesModel.setLicenseCount(licensesCount);
                            DashboardOldDataModel dashboardOldDataModel = new DashboardOldDataModel();
                            Query countQueryUsersOldLastSync = this.buildQueryCountWithFilter((String)realmId, "User Old Last Sync", (List<String>)new ArrayList<String>(), (List<String>)new ArrayList<String>());
                            Object countResultUsersOldLastSync = countQueryUsersOldLastSync.getSingleResult();
                            HashMap<String, Object> users = new HashMap<String, Object>();
                            users.put("countResultUsersOldSync", countResultUsersOldLastSync);
                            dashboardOldDataModel.setUsers(users);
                            Query countQueryOldSync = this.buildDevicesQueryCountWithFilter((String)realmId, "Old Sync", (List<String>)new ArrayList<String>(), (List<String>)new ArrayList<String>());
                            Object countResultOldSync = countQueryOldSync.getSingleResult();
                            HashMap<String, Object> devices = new HashMap<String, Object>();
                            devices.put("countResultOldSync", countResultOldSync);
                            dashboardOldDataModel.setDevices(devices);
                            DashboardModel dashboardModel = new DashboardModel();
                            dashboardModel.setRealmId((String)realmId);
                            dashboardModel.setRealmName(realmModel.getName());
                            dashboardModel.setUsers(dashboardUsersModel);
                            dashboardModel.setLicenses(dashboardLicensesModel);
                            dashboardModel.setOldData(dashboardOldDataModel);
                            dashboardModelsList.add(dashboardModel);
                        }
                        catch (Exception e) {
                            logger.info((Object)e);
                        }
                    }
                });
            }
            apiKeys.forEach(apiKey -> {
                Long count = dashboardModelsList.stream().filter(realm -> realm.getLicenses().apiKey.equals(apiKey)).map(realm -> realm.getLicenses().olvidApiKeyCount).reduce(0L, (a, b) -> a + b);
                dashboardModelsList.stream().filter(realm -> realm.getLicenses().getApiKey().equals(apiKey)).forEach(dashboardModel -> {
                    DashboardLicensesModel licensesModel = dashboardModel.getLicenses();
                    licensesModel.setOlvidApiKeyCountOverRealms(count);
                });
            });
            GetDashboardResponseModel responseModel = new GetDashboardResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setData(dashboardModelsList);
            responseModel.setVersion("4.4.0");
            List olvidNotifications = new ArrayList();
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidNotifications.getAllUnreadByRealm", OlvidNotifications.class);
                q.setParameter("realmId", (Object)"master");
                olvidNotifications = q.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            responseModel.setNotificationUnreadCount(olvidNotifications.size());
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            return this.internalError();
        }
    }

    private Response processGetNotifications(AuthenticationManager.AuthResult authResult, String role, String realmName, String tabChose, List<String> filters, int limit, int offset) {
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(44, role, authResult);
        }
        return this.getResponseProcessGetNotifications(realmName, writeAllowed, tabChose, filters, limit, offset);
    }

    protected Response getResponseProcessGetNotifications(String realmName, boolean writeAllowed, String tabChose, List<String> filters, int limit, int offset) {
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        try {
            List<OlvidNotifications> olvidNotifications = new ArrayList<OlvidNotifications>();
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidNotifications.getNotificationsByRealmAndType", OlvidNotifications.class);
                q.setParameter("realmId", (Object)"master");
                q.setParameter("isRead", (Object)false);
                q.setParameter("type", (Object)OlvidNotifications.NotificationType.pluginVersion.getStringValue());
                olvidNotifications = q.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            GetNotificationsResponseModel responseModel = new GetNotificationsResponseModel();
            responseModel.setWriteAllowed(writeAllowed);
            responseModel.setNotificationVersions(olvidNotifications);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            return this.internalError();
        }
    }

    private Response processSetNotificationRead(AuthenticationManager.AuthResult authResult, String role, List<String> dataArray) {
        UserModel userLogIn = authResult.getUser();
        if (userLogIn == null) {
            return this.internalError();
        }
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(44, role, authResult);
        }
        return this.getResponseProcessSetNotificationRead(writeAllowed, userLogIn, dataArray);
    }

    protected Response getResponseProcessSetNotificationRead(boolean writeAllowed, UserModel userLogIn, List<String> dataArray) {
        if (writeAllowed) {
            try {
                dataArray.forEach(id -> {
                    if (id == null) {
                        this.em.getTransaction().begin();
                        List<OlvidNotifications> onList = OlvidNotificationsDao.getOlvidNotificationsVersion(this.em);
                        long timestamp = System.currentTimeMillis();
                        onList.forEach(on -> {
                            on.setIsRead(true);
                            on.setReadDate(timestamp);
                            on.setReaderUserId(userLogIn.getId());
                            this.em.merge(on);
                        });
                    }
                });
                return this.getResponseProcessGetNotifications("master", writeAllowed, "", new ArrayList<String>(), 0, 0);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                return this.internalError();
            }
        }
        return this.internalError();
    }

    private Response processSetGroupSharedSettings(AuthenticationManager.AuthResult authResult, String role, String realmName, String id, String data) throws JsonProcessingException {
        UserModel userLogIn = authResult.getUser();
        if (userLogIn == null) {
            return this.internalError();
        }
        boolean writeAllowed = false;
        if (authResult != null) {
            writeAllowed = this.checkQueryIsAllowed(44, role, authResult);
        }
        RealmModel realmModel = this.session.realms().getRealmByName(realmName);
        return this.getResponseProcessSetGroupSharedSettings(writeAllowed, userLogIn, realmModel, id, data);
    }

    protected Response getResponseProcessSetGroupSharedSettings(boolean writeAllowed, UserModel userLogIn, RealmModel realmModel, String groupId, String data) throws JsonProcessingException {
        if (writeAllowed) {
            boolean isJsonSharedSettings = new JsonSharedSettings().isJsonSharedSettingsFormat(data);
            if (isJsonSharedSettings) {
                TypedQuery q = this.em.createNamedQuery("OlvidGroup.getById", OlvidGroup.class);
                q.setParameter("realmId", (Object)realmModel.getId());
                q.setParameter("keycloakGroupId", (Object)groupId);
                OlvidGroup result = (OlvidGroup)q.getSingleResult();
                result.setSerializedSharedSettings(data);
                this.em.merge((Object)result);
            }
            GroupModel groupModel = this.session.groups().getGroupById(realmModel, groupId);
            GenericReponseModel response = new GenericReponseModel();
            response.setUpGenericResponseModel(new HashMap(), new ResponseConstants().STATUS_SUCCESS, 0, "", true);
            try {
                String logs = " [\n  realm Name: " + realmModel.getName() + ",\n  groupName: " + groupModel.getName() + ",\n  new sharedSettings: " + data + "\n]";
                logger.debug((Object)logs);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                OlvidConsoleLogsDao.logUserEvent(this.em, this.session, userLogIn.getUsername(), realmModel.getName(), "groupEdit", "Group edited:" + logs, ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Response.ok(new HashMap(), (String)"application/json").build();
        }
        GenericReponseModel response = new GenericReponseModel();
        UpdateOlvidGroupByIdResponseModel responseModel = new UpdateOlvidGroupByIdResponseModel();
        responseModel.setStatus(true);
        response.setUpGenericResponseModel(responseModel, new ResponseConstants().STATUS_SUCCESS, 0, "", true);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalError();
        }
    }
}

