/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.transferProof;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.transferProof.payload.TransferProofPayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.transferProof.response.TransferProofJson;
import io.olvid.keycloak.rest.api.apiModelsDevices.transferProof.response.TransferProofResponseModel;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;

public class TransferProof
extends AbstractBearerTokenAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(TransferProof.class);

    public TransferProof(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        try {
            String sas;
            String sessionId;
            RealmModel realm = this.session.getContext().getRealm();
            try {
                TransferProofPayloadModel request = (TransferProofPayloadModel)this.objectMapper.readValue(postData, TransferProofPayloadModel.class);
                sessionId = request.getSessionId();
                sas = request.getSas();
                if (sessionId == null || sas == null) {
                    return this.invalidRequestDevice();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
                return this.invalidRequestDevice();
            }
            UserModel user = authResult.getUser();
            String identity = Utils.getUserAttribute(user, "olvid-identity");
            if (identity == null) {
                return this.identityNotUploadedYet();
            }
            OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(this.session, this.em, realm);
            if (signatureSignerContext == null) {
                return this.internalErrorDevice();
            }
            TransferProofJson transferProofJson = new TransferProofJson();
            transferProofJson.session_id = sessionId;
            transferProofJson.sas = sas;
            transferProofJson.identity = identity;
            transferProofJson.keycloak_id = user.getId();
            TransferProofResponseModel response = new TransferProofResponseModel();
            JWSBuilder jwsBuilder = new JWSBuilder();
            response.setSignature(jwsBuilder.content(this.objectMapper.writeValueAsBytes((Object)transferProofJson)).sign((SignatureSignerContext)signatureSignerContext));
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

