/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.putKey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidGroupDao;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.putKey.payload.PutKeyPayloadModel;
import io.olvid.keycloak.timer.CronScheduler;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.security.SecureRandom;
import java.util.HashSet;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;

public class PutKey
extends AbstractBearerTokenAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(PutKey.class);

    public PutKey(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        String identity;
        RealmModel realm = this.session.getContext().getRealm();
        try {
            PutKeyPayloadModel request = (PutKeyPayloadModel)this.objectMapper.readValue(postData, PutKeyPayloadModel.class);
            identity = request.getIdentity();
            if (identity == null) {
                return this.invalidRequestDevice();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        UserModel user = authResult.getUser();
        ClusterProvider clusterProvider = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        ExecutionResult result = clusterProvider.executeIfNotExecuted("olvid.putKey." + realm.getId() + "." + user.getId(), 10000, () -> {
            TypedQuery q = this.em.createNamedQuery("OlvidRevocation.getRevocationByOlvidId", Long.class);
            q.setParameter("olvidId", (Object)identity);
            q.setParameter("realmId", (Object)realm.getId());
            if ((Long)q.getSingleResult() > 0L) {
                return this.identityWasRevoked();
            }
            String oldIdentity = Utils.getUserAttribute(user, "olvid-identity");
            if (oldIdentity == null) {
                String newApiKey;
                String apiKey = Utils.getUserAttribute(user, "olvid-api-key");
                if (apiKey != null) {
                    if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, realm.getId(), this.objectMapper, apiKey)) {
                        Utils.setUserAttribute(user, "olvid-api-key", null);
                    } else {
                        return this.internalErrorDevice();
                    }
                }
                if ((newApiKey = Utils.isBotUser(user) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, realm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realm.getId(), this.objectMapper)) == null) {
                    return this.internalErrorDevice();
                }
                Utils.setUserAttribute(user, "olvid-api-key", newApiKey);
                Utils.setUserAttribute(user, "olvid-identity", identity);
                this.updateUserSignedDetailsAndAssociatedGroups(realm, user);
                return this.success();
            }
            if (oldIdentity.equals(identity)) {
                String apiKey = Utils.getUserAttribute(user, "olvid-api-key");
                if (apiKey == null) {
                    String newApiKey = Utils.isBotUser(user) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, realm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realm.getId(), this.objectMapper);
                    if (newApiKey != null) {
                        Utils.setUserAttribute(user, "olvid-api-key", newApiKey);
                    } else {
                        return this.internalErrorDevice();
                    }
                }
                return this.success();
            }
            if (!OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "revocationAllowed", false)) {
                return this.identityAlreadyUploaded();
            }
            String apiKey = Utils.getUserAttribute(user, "olvid-api-key");
            if (apiKey != null) {
                if (OlvidServerApiHelper.revokeApiKey(this.session, this.em, realm.getId(), this.objectMapper, apiKey)) {
                    Utils.setUserAttribute(user, "olvid-api-key", null);
                } else {
                    return this.internalErrorDevice();
                }
            }
            Utils.setUserAttribute(user, "olvid-identity", null);
            String newApiKey = Utils.isBotUser(user) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, realm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realm.getId(), this.objectMapper);
            if (newApiKey == null) {
                return this.internalErrorDevice();
            }
            Utils.setUserAttribute(user, "olvid-api-key", newApiKey);
            Utils.setUserAttribute(user, "olvid-identity", identity);
            this.updateUserSignedDetailsAndAssociatedGroups(realm, user);
            return this.success();
        });
        if (result.isExecuted()) {
            return (Response)result.getResult();
        }
        return this.invalidRequestDevice();
    }

    private void updateUserSignedDetailsAndAssociatedGroups(RealmModel realmModel, UserModel userModel) {
        try {
            logger.info((Object)"New identity uploaded --> updating signed user details");
            OlvidUserDetails olvidUserDetails = new OlvidUserDetails(userModel);
            OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(this.session, this.em, realmModel);
            if (signatureSignerContext == null) {
                logger.warn((Object)"Unable to update signed user details: failed to get signature context");
                return;
            }
            try {
                Utils.updateSignedUserDetails(this.em, realmModel, userModel, olvidUserDetails.getSignedDetails((SignatureSignerContext)signatureSignerContext, this.objectMapper), true);
            }
            catch (Exception e) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
        }
        HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
        SecureRandom random = new SecureRandom();
        userModel.getGroupsStream().forEach(groupModel -> {
            if (Utils.isOlvidGroup(groupModel)) {
                try {
                    usersAndTopicsToNotify.addAll(OlvidGroupDao.enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(this.session, this.em, realmModel, groupModel, this.objectMapper, random));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to update OlvidGroup with id " + groupModel.getId()));
                    logger.warn((Object)"Exception : ", (Throwable)e);
                }
            }
        });
        CronScheduler.scheduleSendNotifications(usersAndTopicsToNotify);
    }
}

