/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.myDevices;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.myDevices.payload.MyDevicesPayloadModel;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class MyDevices
extends AbstractBearerTokenAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(MyDevices.class);

    public MyDevices(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        MyDevicesPayloadModel query = null;
        if (postData != null && postData.length > 0) {
            try {
                query = (MyDevicesPayloadModel)this.objectMapper.readValue(postData, MyDevicesPayloadModel.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse MyDevices post data. ", (Throwable)e);
            }
        }
        if (query == null) {
            return this.internalErrorDevice();
        }
        RealmModel realm = this.session.getContext().getRealm();
        ArrayList deviceUidToFound = new ArrayList();
        ArrayList deviceUidInDb = new ArrayList();
        query.getDevices().forEach(device -> {
            String deviceUid = device.getDeviceUid();
            String displayName = device.getDisplayName() != null ? device.getDisplayName() : "";
            String devicePlatform = device.getPlatform() != null ? device.getPlatform() : "";
            deviceUidToFound.add(deviceUid);
            try {
                TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
                q.setParameter("realmId", (Object)realm.getId());
                q.setParameter("userId", (Object)authResult.getUser().getId());
                q.setParameter("deviceUid", (Object)deviceUid);
                OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
                olvidUserDevice.setDisplayName(displayName);
                olvidUserDevice.setPlatform(devicePlatform);
                olvidUserDevice.setIsActive(true);
                this.em.persist((Object)olvidUserDevice);
            }
            catch (NoResultException e) {
                OlvidUserDevice olvidUserDevice = new OlvidUserDevice();
                olvidUserDevice.setRealmId(realm.getId());
                olvidUserDevice.setUserId(authResult.getUser().getId());
                olvidUserDevice.setDeviceUid(deviceUid);
                olvidUserDevice.setDisplayName(displayName);
                olvidUserDevice.setPlatform(devicePlatform);
                olvidUserDevice.setIsActive(true);
                boolean isBot = Utils.isBotUser(authResult.getUser());
                if (!isBot) {
                    olvidUserDevice.setIsKnown(false);
                }
                this.em.persist((Object)olvidUserDevice);
            }
        });
        TypedQuery q = this.em.createNamedQuery("OlvidUserDevice.getById", OlvidUserDevice.class);
        q.setParameter("realmId", (Object)realm.getId());
        q.setParameter("userId", (Object)authResult.getUser().getId());
        q.getResultList().forEach(device -> deviceUidInDb.add(device.getDeviceUid()));
        ArrayList differences = new ArrayList(deviceUidInDb);
        differences.removeAll(deviceUidToFound);
        if (!differences.isEmpty()) {
            differences.forEach(differentUid -> {
                TypedQuery q2 = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
                q2.setParameter("realmId", (Object)realm.getId());
                q2.setParameter("userId", (Object)authResult.getUser().getId());
                q2.setParameter("deviceUid", differentUid);
                OlvidUserDevice olvidUserDevice = (OlvidUserDevice)q2.getSingleResult();
                olvidUserDevice.setIsActive(false);
                this.em.persist((Object)olvidUserDevice);
            });
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity(new HashMap()).type("application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

