/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.me;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.me.payload.MePayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.me.response.MeResponseModel;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class Me
extends AbstractBearerTokenAuthenticationPoint {
    protected static final Logger logger = Logger.getLogger(Me.class);

    public Me(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        MePayloadModel query = null;
        if (postData != null && postData.length > 0) {
            try {
                query = (MePayloadModel)this.objectMapper.readValue(postData, MePayloadModel.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse Me post data. ", (Throwable)e);
            }
        }
        RealmModel realm = this.session.getContext().getRealm();
        long currentTimestamp = System.currentTimeMillis();
        List olvidRevocationList = null;
        if (query != null) {
            TypedQuery q;
            try {
                Long timestamp = query.timestamp;
                if (timestamp != null) {
                    timestamp = Math.max(timestamp, currentTimestamp - 5184000000L);
                    q = this.em.createNamedQuery("OlvidRevocation.getMeRevocationsList", String.class);
                    q.setParameter("realmId", (Object)realm.getId());
                    q.setParameter("timestamp", (Object)timestamp);
                    olvidRevocationList = q.getResultList();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse Me post data.", (Throwable)e);
            }
            try {
                OlvidUserDetails.setLastSync(this.em, realm, authResult.getUser(), currentTimestamp);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to set user's lastSync.", (Throwable)e);
            }
            String deviceUid = query.getDeviceUid();
            if (deviceUid != null) {
                OlvidUserDevice olvidUserDevice;
                try {
                    q = this.em.createNamedQuery("OlvidUserDevice.getByIdAndDeviceUid", OlvidUserDevice.class);
                    q.setParameter("realmId", (Object)realm.getId());
                    q.setParameter("userId", (Object)authResult.getUser().getId());
                    q.setParameter("deviceUid", (Object)deviceUid);
                    olvidUserDevice = (OlvidUserDevice)q.getSingleResult();
                    olvidUserDevice.setLastSync(currentTimestamp);
                    if (olvidUserDevice.getCreateDate() == null) {
                        olvidUserDevice.setCreateDate(currentTimestamp);
                    }
                    olvidUserDevice.setIsActive(true);
                    this.em.persist((Object)olvidUserDevice);
                }
                catch (NoResultException e) {
                    olvidUserDevice = new OlvidUserDevice();
                    olvidUserDevice.setRealmId(realm.getId());
                    olvidUserDevice.setUserId(authResult.getUser().getId());
                    olvidUserDevice.setDeviceUid(deviceUid);
                    olvidUserDevice.setDisplayName("");
                    olvidUserDevice.setCreateDate(currentTimestamp);
                    olvidUserDevice.setLastSync(currentTimestamp);
                    olvidUserDevice.setIsActive(true);
                    boolean isBot = authResult.getUser().getAttributeStream("olvid-is-bot").findFirst().isPresent();
                    if (!isBot) {
                        olvidUserDevice.setIsKnown(false);
                    }
                    this.em.persist((Object)olvidUserDevice);
                }
            }
        }
        try {
            String newApiKey;
            MeResponseModel response = new MeResponseModel();
            OlvidUserDetails olvidUserDetails = new OlvidUserDetails(authResult.getUser());
            String fullSearchString = olvidUserDetails.getFullSearchString();
            if (!Objects.equals(fullSearchString, Utils.getUserAttribute(authResult.getUser(), "olvid-search"))) {
                Utils.setUserAttribute(authResult.getUser(), "olvid-search", fullSearchString);
            }
            response.setSignature(Utils.getSignedUserDetails(this.session, this.em, this.objectMapper, realm, authResult.getUser()));
            if (response.getSignature() == null) {
                return this.internalErrorDevice();
            }
            response.setApiKey(Utils.getUserAttribute(authResult.getUser(), "olvid-api-key"));
            if (olvidUserDetails.getIdentity() != null && response.getApiKey() == null && (newApiKey = Utils.isBotUser(authResult.getUser()) ? OlvidServerApiHelper.requestNewBotApiKey(this.session, this.em, realm.getId(), this.objectMapper) : OlvidServerApiHelper.requestNewApiKey(this.session, this.em, realm.getId(), this.objectMapper)) != null) {
                Utils.setUserAttribute(authResult.getUser(), "olvid-api-key", newApiKey);
                response.setApiKey(newApiKey);
            }
            response.setServer(OlvidConfigurationDao.getStringConfiguration(this.em, realm.getId(), "serverUrl"));
            response.setRevocationAllowed(OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "revocationAllowed", false));
            response.setTransferRestricted(OlvidConfigurationDao.getBooleanConfiguration(this.em, realm.getId(), "transferRestricted", false));
            response.setMinimumBuildVersions(new HashMap<String, Integer>());
            response.getMinimumBuildVersions().put("android", 200);
            response.getMinimumBuildVersions().put("ios", 650);
            String globalPushTopic = OlvidConfigurationDao.getStringConfiguration(this.em, realm.getId(), "keycloakPushTopic");
            if (globalPushTopic == null) {
                globalPushTopic = OlvidServerApiHelper.requestNewPushTopic(this.session, this.em, realm.getId(), this.objectMapper);
                OlvidConfigurationDao.setConfiguration(this.em, realm.getId(), "keycloakPushTopic", globalPushTopic);
            }
            if (globalPushTopic != null) {
                response.setPushTopicNames(Collections.singletonList(globalPushTopic));
            }
            if (olvidUserDetails.getIdentity() != null) {
                String nonce = Utils.getUserAttribute(authResult.getUser(), "olvid-nonce");
                if (nonce == null || nonce.trim().isEmpty()) {
                    nonce = UUID.randomUUID().toString();
                    Utils.setUserAttribute(authResult.getUser(), "olvid-nonce", nonce);
                }
                response.setNonce(nonce);
            }
            if (olvidRevocationList != null) {
                response.setSignedRevocations(olvidRevocationList);
            }
            response.setCurrentTimestamp(currentTimestamp);
            return Response.ok((Object)this.objectMapper.writeValueAsBytes((Object)response), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

