/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api.apiModelsDevices.getKey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractBearerTokenAuthenticationPoint;
import io.olvid.keycloak.rest.api.apiModelsDevices.getKey.payload.GetKeyPayloadModel;
import io.olvid.keycloak.rest.api.apiModelsDevices.getKey.response.GetKeyResponseModel;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;

public class GetKey
extends AbstractBearerTokenAuthenticationPoint {
    public GetKey(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    protected Response handler(AuthenticationManager.AuthResult authResult, byte[] postData) {
        GetKeyPayloadModel request;
        UserModel user = null;
        RealmModel realm = this.session.getContext().getRealm();
        try {
            request = (GetKeyPayloadModel)this.objectMapper.readValue(postData, GetKeyPayloadModel.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.invalidRequestDevice();
        }
        String userId = request.getUserId();
        if (userId != null && !userId.isEmpty()) {
            user = this.session.users().getUserById(realm, userId);
        }
        if (user == null) {
            return this.invalidRequestDevice();
        }
        try {
            String signedDetails = Utils.getSignedUserDetails(this.session, this.em, this.objectMapper, realm, user);
            if (signedDetails == null) {
                return this.internalErrorDevice();
            }
            GetKeyResponseModel getKeyResponseModel = new GetKeyResponseModel();
            getKeyResponseModel.setSignature(signedDetails);
            String response = this.objectMapper.writeValueAsString((Object)getKeyResponseModel);
            return Response.ok((Object)response, (String)"application/json").build();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception : ", (Throwable)e);
            return this.internalErrorDevice();
        }
    }
}

