/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.classes.constants.ResponseConstants;
import io.olvid.keycloak.rest.api.apiModels.configurations.response.generic.GenericReponseModel;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public abstract class AbstractEntryPoint {
    protected final KeycloakSession session;
    protected final EntityManager em;
    protected final ObjectMapper objectMapper;
    protected static final Logger logger = Logger.getLogger(AbstractEntryPoint.class);

    public AbstractEntryPoint(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        this.session = session;
        this.em = em;
        this.objectMapper = objectMapper;
    }

    public Response entryPoint(byte[] postData) {
        try {
            return this.handler(postData);
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected error occurred during EntryPoint handling:", (Throwable)e);
            return this.internalErrorDevice();
        }
    }

    protected abstract Response handler(byte[] var1);

    protected Response success() {
        try {
            return Response.ok((Object)this.objectMapper.writeValueAsBytes(Collections.singletonMap("status", "success")), (String)"application/json").build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    protected Response permissionDeniedDevice() {
        return this.createDeviceErrorResponse(2, "permission denied");
    }

    protected Response invalidRequestDevice() {
        return this.createDeviceErrorResponse(3, "invalid request");
    }

    protected Response identityAlreadyUploaded() {
        return this.createDeviceErrorResponse(4, "identity already uploaded, use override option");
    }

    protected Response identityWasRevoked() {
        return this.createDeviceErrorResponse(6, "Identity has been revoked");
    }

    protected Response identityNotUploadedYet() {
        return this.createDeviceErrorResponse(8, "Identity was not uploaded yet");
    }

    protected Response internalErrorDevice() {
        return this.createDeviceErrorResponse(1, "internal error");
    }

    private Response createDeviceErrorResponse(int errorCode, String message) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("error", errorCode);
        response.put("message", message);
        try {
            return Response.ok((Object)this.objectMapper.writeValueAsBytes(response), (String)"application/json").build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    protected Response internalError() {
        return this.createErrorResponse(1, "internal error");
    }

    protected Response internalError(String message) {
        return this.createErrorResponse(1, message);
    }

    protected Response permissionDenied() {
        return this.createErrorResponse(2, "permission denied");
    }

    protected Response badRealmType() {
        return this.createErrorResponse(5, "cannot access data for this realm");
    }

    protected Response invalidRequest() {
        return this.createErrorResponse(3, "invalid request");
    }

    private Response createErrorResponse(int errorCode, String message) {
        GenericReponseModel response = new GenericReponseModel();
        response.setUpGenericResponseModel(null, new ResponseConstants().STATUS_ERROR, errorCode, message, false);
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.objectMapper.writeValueAsBytes((Object)response)).type("application/json").build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

