/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public abstract class AbstractCookieAuthenticationPoint
extends AbstractEntryPoint {
    protected static final Logger logger = Logger.getLogger(AbstractCookieAuthenticationPoint.class);

    public AbstractCookieAuthenticationPoint(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    public Response entryPoint(byte[] postData) {
        try {
            AuthenticationManager.AuthResult authResult = this.isUserLoggedIn(this.session);
            if (authResult == null) {
                AuthenticationManager.AuthResult authResultBearerToken = new AppAuthManager.BearerTokenAuthenticator(this.session).authenticate();
                if (authResultBearerToken == null) {
                    return this.permissionDenied();
                }
                return this.handler(authResultBearerToken, postData);
            }
            return this.handler(authResult, postData);
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected error occurred during AbstractCookieAuthenticationPoint handling:", (Throwable)e);
            return this.internalError();
        }
    }

    protected abstract Response handler(AuthenticationManager.AuthResult var1, byte[] var2);

    @Override
    protected Response handler(byte[] postData) {
        return null;
    }

    private AuthenticationManager.AuthResult isUserLoggedIn(KeycloakSession session) {
        AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)session, (RealmModel)session.getContext().getRealm(), (boolean)true);
        if (authResult == null) {
            logger.warn((Object)"User is not logged in");
        }
        return authResult;
    }
}

