/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.AbstractEntryPoint;
import jakarta.persistence.EntityManager;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public abstract class AbstractBearerTokenAuthenticationPoint
extends AbstractEntryPoint {
    public AbstractBearerTokenAuthenticationPoint(KeycloakSession session, EntityManager em, ObjectMapper objectMapper) {
        super(session, em, objectMapper);
    }

    @Override
    public Response entryPoint(byte[] postData) {
        try {
            AuthenticationManager.AuthResult authResult = this.isUserLoggedIn(this.session);
            if (authResult == null) {
                return this.permissionDeniedDevice();
            }
            UserModel userModel = authResult.getUser();
            String needToDeletePassword = Utils.getUserAttribute(userModel, "one-time-password");
            if (Objects.equals(needToDeletePassword, "true")) {
                logger.info((Object)"BearerTokenAuthenticationPoint: deleting one time password");
                userModel.credentialManager().getStoredCredentialsByTypeStream("password").forEach(credentialModel -> userModel.credentialManager().removeStoredCredentialById(credentialModel.getId()));
                Utils.setUserAttribute(userModel, "one-time-password", null);
            }
            return this.handler(authResult, postData);
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected error occurred during AbstractBearerTokenAuthenticationPoint handling:", (Throwable)e);
            return this.internalErrorDevice();
        }
    }

    protected abstract Response handler(AuthenticationManager.AuthResult var1, byte[] var2);

    @Override
    protected Response handler(byte[] postData) {
        return null;
    }

    private AuthenticationManager.AuthResult isUserLoggedIn(KeycloakSession session) {
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
        if (authResult == null) {
            logger.warn((Object)"User is not logged in");
        }
        return authResult;
    }
}

