/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;

public class UtilsLdap {
    protected static final Logger logger = Logger.getLogger(UtilsLdap.class);

    public static DirContext LDAPctx(ComponentModel userProvider) throws NamingException {
        MultivaluedHashMap config = userProvider.getConfig();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.control", "com.sun.jndi.ldap.ControlFactory");
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.factory.state", "PersonStateFactory");
        environment.put("java.naming.factory.object", "PersonObjectFactory");
        environment.put("java.naming.provider.url", (String)((List)config.get((Object)"connectionUrl")).get(0));
        environment.put("java.naming.security.authentication", (String)((List)config.get((Object)"authType")).get(0));
        environment.put("java.naming.security.principal", (String)((List)config.get((Object)"bindDn")).get(0));
        environment.put("java.naming.security.credentials", (String)((List)config.get((Object)"bindCredential")).get(0));
        InitialDirContext ctx = new InitialDirContext(environment);
        return ctx;
    }

    public static List<ComponentModel> getRealmProvider(RealmModel realm) {
        List list = realm.getComponentsStream().collect(Collectors.toList());
        List<ComponentModel> userProviderList = list.stream().filter(elem -> elem.getName() != null && (elem.getName().equals("ldap") || elem.getName().equals("kerberos"))).collect(Collectors.toList());
        return userProviderList;
    }
}

