/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetails;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.urls.UrlType;

public class Utils {
    protected static final Logger logger = Logger.getLogger(Utils.class);
    private static final Pattern unAccentPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public static String unAccent(String source) {
        return unAccentPattern.matcher(Normalizer.normalize(source, Normalizer.Form.NFD)).replaceAll("").toLowerCase(Locale.getDefault());
    }

    public static String getUserAttribute(UserModel user, String attributeKey) {
        return user.getAttributeStream(attributeKey).findFirst().orElse(null);
    }

    public static String getGroupAttribute(GroupModel group, String attributeKey) {
        return group.getAttributeStream(attributeKey).findFirst().orElse(null);
    }

    public static boolean getGroupBooleanAttribute(GroupModel group, String attributeKey) {
        return Boolean.parseBoolean(Utils.getGroupAttribute(group, attributeKey));
    }

    public static void setUserAttribute(UserModel user, String attributeKey, String value) {
        if (value == null) {
            user.removeAttribute(attributeKey);
        } else {
            user.setAttribute(attributeKey, Collections.singletonList(value));
        }
    }

    public static String getUserAttributeFullSearch(UserModel user) {
        String position = Utils.getUserAttribute(user, "olvid-position");
        String company = Utils.getUserAttribute(user, "olvid-company");
        return Utils.unAccent((user.getFirstName() == null ? "" : user.getFirstName()) + " " + (user.getLastName() == null ? "" : user.getLastName()) + " " + (position == null ? "" : position) + " " + (company == null ? "" : company));
    }

    public static void setGroupAttribute(GroupModel group, String attributeKey, String value) {
        if (value == null) {
            group.removeAttribute(attributeKey);
        } else {
            group.setAttribute(attributeKey, Collections.singletonList(value));
        }
    }

    public static boolean isOlvidGroup(GroupModel group) {
        if (Utils.getGroupBooleanAttribute(group, "olvid-group")) {
            return true;
        }
        if (group.getParent() != null) {
            GroupModel lastParent = group;
            for (int i = 0; i < 50; ++i) {
                GroupModel parent = lastParent.getParent();
                if (parent == null) {
                    return "olvid-groups".equals(lastParent.getName());
                }
                lastParent = parent;
            }
        }
        return false;
    }

    public static boolean isBotUser(UserModel user) {
        return "true".equals(Utils.getUserAttribute(user, "olvid-is-bot"));
    }

    public static boolean groupHasChildren(GroupModel group) {
        return group.getSubGroupsStream().findAny().isPresent();
    }

    public static List<String> computeGroupPath(GroupModel group) {
        ArrayList<String> path = new ArrayList<String>();
        GroupModel parent = group.getParent();
        for (int i = 0; i < 50 && parent != null; parent = parent.getParent(), ++i) {
            path.add(parent.getName());
        }
        Collections.reverse(path);
        return path;
    }

    public static String computeGroupPathString(List<String> path) {
        return "/" + String.join((CharSequence)"/", path);
    }

    public static String getSignedUserDetails(KeycloakSession session, EntityManager em, ObjectMapper jsonObjectMapper, RealmModel realmModel, UserModel userModel) throws Exception {
        OlvidUserDetails details;
        OlvidUser olvidUser;
        String signedDetails = null;
        try {
            TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("userId", (Object)userModel.getId());
            olvidUser = (OlvidUser)q.getSingleResult();
            signedDetails = olvidUser.getSignedDetails();
        }
        catch (NoResultException q) {
            // empty catch block
        }
        if (signedDetails == null && (signedDetails = (details = new OlvidUserDetails(userModel)).getSignedDetails((SignatureSignerContext)OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realmModel), jsonObjectMapper)) != null) {
            try {
                olvidUser = new OlvidUser();
                olvidUser.setRealmId(realmModel.getId());
                olvidUser.setUserId(userModel.getId());
                olvidUser.setSignedDetails(signedDetails);
                olvidUser.setCreationTimestamp(System.currentTimeMillis());
                em.persist((Object)olvidUser);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
        }
        return signedDetails;
    }

    public static void updateSignedUserDetails(EntityManager em, RealmModel realmModel, UserModel userModel, String signedDetails, boolean userIdentityMayHaveChanged) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("userId", (Object)userModel.getId());
            OlvidUser olvidUser = (OlvidUser)q.getSingleResult();
            if (userIdentityMayHaveChanged) {
                olvidUser.setCreationTimestamp(System.currentTimeMillis());
            }
            olvidUser.setSignedDetails(signedDetails);
            em.merge((Object)olvidUser);
            return;
        }
        catch (NoResultException q) {
            try {
                OlvidUser olvidUser = new OlvidUser();
                olvidUser.setRealmId(realmModel.getId());
                olvidUser.setUserId(userModel.getId());
                olvidUser.setSignedDetails(signedDetails);
                olvidUser.setCreationTimestamp(System.currentTimeMillis());
                em.persist((Object)olvidUser);
            }
            catch (Exception e) {
                logger.warn((Object)"Exception : ", (Throwable)e);
            }
            return;
        }
    }

    public static String nullOrTrim(String in) {
        if (in == null) {
            return null;
        }
        String out = in.trim();
        if (out.isEmpty()) {
            return null;
        }
        return out;
    }

    public static String emptyStringOrTrim(String in) {
        if (in == null) {
            return "";
        }
        String out = in.trim();
        if (out.isEmpty()) {
            return "";
        }
        return out;
    }

    public static String getBotConfigurationLink(EntityManager em, KeycloakSession session, ObjectMapper objectMapper, RealmModel realm, ClientModel client, UserModel bot, String password) throws JsonProcessingException {
        HashMap<String, Object> keycloakJson = new HashMap<String, Object>();
        String keycloakServerUrl = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "keycloakUrl");
        if (keycloakServerUrl != null) {
            keycloakServerUrl = keycloakServerUrl.replaceAll("/*$", "");
            keycloakJson.put("server", keycloakServerUrl + session.getContext().getUri(UrlType.FRONTEND).getBaseUri().getPath() + "realms/" + realm.getName() + "/");
        } else {
            keycloakJson.put("server", session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString() + "realms/" + realm.getName() + "/");
        }
        keycloakJson.put("cid", client.getClientId());
        if (client.getSecret() != null) {
            keycloakJson.put("secret", client.getSecret());
        }
        HashMap<String, Object> linkJson = new HashMap<String, Object>();
        linkJson.put("keycloak", keycloakJson);
        String serverUrl = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "serverUrl");
        if (serverUrl != null) {
            linkJson.put("server", serverUrl);
        }
        HashMap<String, String> botJson = new HashMap<String, String>();
        botJson.put("username", bot.getUsername());
        botJson.put("password", password);
        linkJson.put("bot", botJson);
        return "https://configuration.olvid.io/#" + Base64.getUrlEncoder().encodeToString(objectMapper.writeValueAsBytes(linkJson));
    }

    public static String generateConfigurationLink(EntityManager em, RealmModel realm, ObjectMapper objectMapper, String key) throws JsonProcessingException {
        HashMap<String, String> linkJson = new HashMap<String, String>();
        String serverUrl = OlvidConfigurationDao.getStringConfiguration(em, realm.getId(), "serverUrl");
        if (serverUrl != null) {
            linkJson.put("server", serverUrl);
            linkJson.put("apikey", key);
        }
        return "https://configuration.olvid.io/#" + Base64.getUrlEncoder().encodeToString(objectMapper.writeValueAsBytes(linkJson));
    }

    public static OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson getRequestGetKeycloakPluginVersionResponseJson(KeycloakSession session, ObjectMapper jsonObjectMapper) throws IOException {
        byte[] output;
        block30: {
            String server = "https://server.olvid.io";
            HttpClientProvider clientProvider = (HttpClientProvider)session.getProvider(HttpClientProvider.class);
            CloseableHttpClient client = clientProvider.getHttpClient();
            URI uri = URI.create(server + "/keycloakQuery");
            if ("https".equals(uri.getScheme()) && uri.getPort() == -1) {
                try {
                    uri = new URI("https", uri.getUserInfo(), uri.getHost(), 443, uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HttpPost post = new HttpPost(uri);
            OlvidServerApiHelper.KeycloakQueryJson keycloakQueryJson = new OlvidServerApiHelper.KeycloakQueryJson();
            keycloakQueryJson.q = 9;
            byte[] dataToSend = jsonObjectMapper.writeValueAsBytes((Object)keycloakQueryJson);
            post.setEntity((HttpEntity)new ByteArrayEntity(dataToSend));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                int serverResponse = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (serverResponse == 200 && entity != null) {
                    try (InputStream is = entity.getContent();
                         BufferedInputStream bis = new BufferedInputStream(is);
                         ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                        int numberOfBytesRead;
                        byte[] buffer = new byte[32768];
                        while ((numberOfBytesRead = bis.read(buffer)) != -1) {
                            byteArrayOutputStream.write(buffer, 0, numberOfBytesRead);
                        }
                        byteArrayOutputStream.flush();
                        output = byteArrayOutputStream.toByteArray();
                        break block30;
                    }
                }
                OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson requestGetKeycloakPluginVersionResponseJson = null;
                return requestGetKeycloakPluginVersionResponseJson;
            }
        }
        try {
            Map errorMap = (Map)jsonObjectMapper.readValue(output, (TypeReference)new TypeReference<Map<String, Integer>>(){});
            Integer errorCode = (Integer)errorMap.get("error");
            if (errorCode != null) {
                logger.warn((Object)("Olvid server returned error code " + errorCode + " during Get Keycloak Plugin Version"));
            }
        }
        catch (Exception errorMap) {
            // empty catch block
        }
        OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson requestGetKeycloakPluginVersionResponseJson = (OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson)jsonObjectMapper.readValue(output, OlvidServerApiHelper.RequestGetKeycloakPluginVersionResponseJson.class);
        return requestGetKeycloakPluginVersionResponseJson;
    }
}

