/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.rest;

import io.olvid.keycloak.rest.RestProvider;
import io.olvid.keycloak.timer.CronScheduler;
import jakarta.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

public class RestProviderFactory
implements RealmResourceProviderFactory {
    protected static final Logger logger = Logger.getLogger(RestProviderFactory.class);
    public static final String ID = "olvid-rest";

    public RealmResourceProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new RestProvider(session, em);
    }

    public void init(Config.Scope config) {
        logger.info((Object)"Init RestProviderFactory");
    }

    public void postInit(KeycloakSessionFactory factory) {
        CronScheduler.initTimer(factory);
    }

    public void close() {
        logger.info((Object)"RestProviderFactory close");
    }

    public String getId() {
        return ID;
    }
}

