/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.jpa.OlvidRevocation;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;

public class OlvidRevocationDao {
    protected static final Logger logger = Logger.getLogger(OlvidRevocationDao.class);
    public static final String REVOCATION_IDENTITY = "identity";
    public static final String REVOCATION_TIMESTAMP = "timestamp";
    public static final String REVOCATION_TYPE = "type";

    public static List<OlvidRevocation> getOlvidRevocations(EntityManager em, String realmId, List<String> filters, int limit, int offset) {
        try {
            StringBuilder sb = new StringBuilder("SELECT olr FROM OlvidRevocation olr WHERE olr.realmId = :realmId ");
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().length() == 0) continue;
                sb.append(" AND (olr.fullSearchString LIKE :?) ".replace("?", "s" + count));
                ++count;
            }
            sb.append(" order by olr.timestamp DESC");
            TypedQuery q = em.createQuery(sb.toString(), OlvidRevocation.class);
            q.setParameter("realmId", (Object)realmId);
            count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().length() == 0) continue;
                q.setParameter("s" + count, (Object)("%" + filter + "%"));
                ++count;
            }
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            return q.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public static long getOlvidCountRevocations(EntityManager em, String realmId, List<String> filters) {
        try {
            StringBuilder sb = new StringBuilder("SELECT COUNT(DISTINCT olr) FROM OlvidRevocation olr WHERE olr.realmId = :realmId ");
            int count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().length() == 0) continue;
                sb.append(" AND (olr.fullSearchString LIKE :?) ".replace("?", "s" + count));
                ++count;
            }
            TypedQuery q = em.createQuery(sb.toString(), Long.class);
            q.setParameter("realmId", (Object)realmId);
            count = 0;
            for (String filter : filters) {
                if (filter == null || filter.trim().length() == 0) continue;
                q.setParameter("s" + count, (Object)("%" + filter + "%"));
                ++count;
            }
            return (Long)q.getSingleResult();
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public static void clearOlvidRevocationUserData(EntityManager em, long revocationId, String realmId) {
        try {
            em.createNamedQuery("OlvidRevocation.deleteUserData").setParameter("realmId", (Object)realmId).setParameter("id", (Object)revocationId).executeUpdate();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRevocation(EntityManager em, RealmModel realmModel, UserModel user, long timestamp, int revocationType, KeycloakSession session, ObjectMapper objectMapper) throws Exception {
        String signedRevocation = null;
        String olvidIdentityString = Utils.getUserAttribute(user, "olvid-identity");
        if (olvidIdentityString != null) {
            byte[] olvidIdentity = Base64.getDecoder().decode(olvidIdentityString);
            OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realmModel);
            if (signatureSignerContext == null) {
                logger.warn((Object)"Unable to get signature context when creating revocation");
                throw new Exception();
            }
            signedRevocation = new RevocationData(olvidIdentity, timestamp, revocationType).getSignedRevocation((SignatureSignerContext)signatureSignerContext, objectMapper);
        }
        EntityTransaction tx = null;
        boolean isDone = false;
        try {
            tx = em.getTransaction();
            tx.begin();
            String apiKey = user.getFirstAttribute("olvid-api-key");
            if (apiKey != null) {
                OlvidServerApiHelper.revokeApiKey(session, em, realmModel.getId(), objectMapper, apiKey);
            }
            if (signedRevocation != null) {
                OlvidRevocation or = new OlvidRevocation();
                or.setRealmId(realmModel.getId());
                or.setOlvidId(olvidIdentityString);
                or.setTimestamp(timestamp);
                or.setRevocationType(revocationType);
                or.setKeycloakSignature(signedRevocation);
                or.setUsername(user.getUsername());
                or.setFirstname(user.getFirstName());
                or.setLastname(user.getLastName());
                or.setMail(user.getEmail());
                or.setPosition(user.getFirstAttribute("olvid-position"));
                or.setCompany(user.getFirstAttribute("olvid-company"));
                or.setFullSearchString();
                em.persist((Object)or);
                em.flush();
            }
            if (revocationType == 0) {
                user.removeAttribute("olvid-api-key");
                user.removeAttribute("olvid-identity");
                user.removeAttribute("olvid-nonce");
            } else if (revocationType == 1) {
                UserManager um = new UserManager(session);
                um.removeUser(realmModel, user);
            }
            isDone = true;
        }
        finally {
            if (isDone) {
                tx.commit();
            } else if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RevocationData {
        public byte[] identity;
        public long timestamp;
        public int revocationType;

        public RevocationData(byte[] identity, long timestamp, int revocationType) {
            this.identity = identity;
            this.timestamp = timestamp;
            this.revocationType = revocationType;
        }

        @JsonIgnore
        public String getSignedRevocation(SignatureSignerContext signatureSignerContext, ObjectMapper objectMapper) throws JsonProcessingException {
            logger.info((Object)("Signing with " + signatureSignerContext.getAlgorithm() + " " + signatureSignerContext.getKid()));
            JWSBuilder jwsBuilder = new JWSBuilder();
            return jwsBuilder.content(objectMapper.writeValueAsBytes((Object)this)).sign(signatureSignerContext);
        }

        @JsonProperty(value="identity")
        public byte[] getIdentity() {
            return this.identity;
        }

        @JsonProperty(value="identity")
        public void setIdentity(byte[] identity) {
            this.identity = identity;
        }

        @JsonProperty(value="timestamp")
        public long getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="type")
        public int getRevocationType() {
            return this.revocationType;
        }

        @JsonProperty(value="type")
        public void setRevocationType(int revocationType) {
            this.revocationType = revocationType;
        }
    }
}

