/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;

@NamedQueries(value={@NamedQuery(name="OlvidRevocation.getMeRevocationsList", query="SELECT olr.keycloakSignature FROM OlvidRevocation olr WHERE olr.realmId = :realmId and olr.timestamp > :timestamp"), @NamedQuery(name="OlvidRevocation.getRevocationByOlvidId", query="SELECT count(*) FROM OlvidRevocation olr WHERE olr.olvidId= :olvidId AND olr.realmId = :realmId AND olr.revocationType=0"), @NamedQuery(name="OlvidRevocation.deleteUserData", query="UPDATE OlvidRevocation olr SET olr.firstname=null, olr.lastname=null, olr.mail=null, olr.position=null, olr.company=null, olr.username=null, olr.fullSearchString=null WHERE olr.realmId = :realmId AND olr.id=:id"), @NamedQuery(name="OlvidRevocation.applyVersion30003", query="UPDATE OlvidRevocation olr SET olr.fullSearchString=CONCAT(IFNULL(olr.username, ''), ' ', IFNULL(olr.firstname, ''), ' ', IFNULL(olr.lastname, ''), ' ', IFNULL(olr.position, ''), ' ', IFNULL(olr.company, '')) WHERE olr.fullSearchString=null")})
@Entity
@Table(name="OLVID_REVOCATION")
public class OlvidRevocation {
    public static final String SELECT_QUERY_GET_REVOCATIONS = "SELECT olr FROM OlvidRevocation olr WHERE olr.realmId = :realmId ";
    public static final String SELECT_QUERY_FILTER_AND = " AND (olr.fullSearchString LIKE :?) ";
    public static final String SELECT_QUERY_COUNT_GET_REVOCATIONS = "SELECT COUNT(DISTINCT olr) FROM OlvidRevocation olr WHERE olr.realmId = :realmId ";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="REVOCATION_ID")
    private Long id;
    @Column(name="REALM_ID", nullable=false)
    private String realmId;
    @Column(name="OLVID_ID", nullable=false)
    private String olvidId;
    @Column(name="REVOCATION_TIMESTAMP", nullable=false)
    private long timestamp;
    @Column(name="REVOCATION_TYPE", nullable=false)
    private Integer revocationType;
    @Column(name="KEYCLOAK_SIGNATURE", nullable=false)
    private String keycloakSignature;
    @Column(name="USERNAME")
    private String username;
    @Column(name="FIRSTNAME")
    private String firstname;
    @Column(name="LASTNAME")
    private String lastname;
    @Column(name="EMAIL")
    private String mail;
    @Column(name="POSITION")
    private String position;
    @Column(name="COMPANY")
    private String company;
    @Column(name="FULL_SEARCH_STRING")
    private String fullSearchString;

    public Long getId() {
        return this.id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getOlvidId() {
        return this.olvidId;
    }

    public void setOlvidId(String olvidId) {
        this.olvidId = olvidId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getRevocationType() {
        return this.revocationType;
    }

    public void setRevocationType(Integer revocationType) {
        this.revocationType = revocationType;
    }

    public String getKeycloakSignature() {
        return this.keycloakSignature;
    }

    public void setKeycloakSignature(String keycloakSignature) {
        this.keycloakSignature = keycloakSignature;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getFullSearchString() {
        return this.fullSearchString;
    }

    public void setFullSearchString() {
        this.fullSearchString = Utils.unAccent(this.getUsername() + " " + this.getFirstname() + " " + this.getLastname() + " " + this.getPosition() + " " + this.getCompany());
        if (this.fullSearchString.length() > 65000) {
            this.fullSearchString = this.fullSearchString.substring(0, 65000);
        }
    }
}

