/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.util.Objects;
import org.jboss.logging.Logger;

@NamedQueries(value={@NamedQuery(name="OlvidNotifications.getAllByRealm", query="SELECT oln FROM OlvidNotifications oln WHERE oln.realmId = :realmId"), @NamedQuery(name="OlvidNotifications.getAllUnreadByRealm", query="SELECT oln FROM OlvidNotifications oln WHERE oln.realmId = :realmId and oln.isRead = false"), @NamedQuery(name="OlvidNotifications.getKeycloakPluginVersionNotificationByRealm", query="SELECT oln FROM OlvidNotifications oln WHERE oln.realmId = :realmId and oln.notificationType = 'pluginVersion' and oln.value = :value"), @NamedQuery(name="OlvidNotifications.getKeycloakPluginVersionAllUnReadNotificationByRealm", query="SELECT oln FROM OlvidNotifications oln WHERE oln.realmId = :realmId and oln.notificationType = 'pluginVersion' and oln.isRead = false"), @NamedQuery(name="OlvidNotifications.getNotificationsByRealmAndType", query="SELECT oln FROM OlvidNotifications oln WHERE oln.realmId = :realmId and oln.notificationType = :type and oln.isRead = :isRead order by oln.createdDate DESC")})
@Entity
@Table(name="OLVID_NOTIFICATIONS")
public class OlvidNotifications {
    @Id
    @Column(name="ID", nullable=false)
    private String id;
    @Id
    @Column(name="REALM_ID", nullable=false)
    private String realmId;
    @Column(name="NOTIFICATION_TYPE")
    private String notificationType;
    @Column(name="VALUE")
    private String value;
    @Column(name="CREATED_DATE")
    private Long createdDate;
    @Column(name="IS_READ")
    private Boolean isRead;
    @Column(name="READER_USER_ID")
    private String readerUserId;
    @Column(name="READ_DATE")
    private Long readDate;
    protected static final Logger logger = Logger.getLogger(OlvidNotifications.class);
    public static final String PLUGIN_VERSION = "pluginVersion";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    public String getReaderUserId() {
        return this.readerUserId;
    }

    public void setReaderUserId(String readerUserId) {
        this.readerUserId = readerUserId;
    }

    public Long getReadDate() {
        return this.readDate;
    }

    public void setReadDate(Long readDate) {
        this.readDate = readDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlvidNotifications that = (OlvidNotifications)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.notificationType, that.notificationType) && Objects.equals(this.value, that.value) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.isRead, that.isRead) && Objects.equals(this.readerUserId, that.readerUserId) && Objects.equals(this.readDate, that.readDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.realmId, this.notificationType, this.value, this.createdDate, this.isRead, this.readerUserId, this.readDate);
    }

    public String toString() {
        return "OlvidNotifications{id='" + this.id + "', realmId='" + this.realmId + "', notificationType='" + this.notificationType + "', value='" + this.value + "', createdDate='" + this.createdDate + "', isRead='" + this.isRead + "', readerUserId='" + this.readerUserId + "', readDate='" + this.readDate + "'}";
    }

    public static enum NotificationType {
        pluginVersion;


        public String getStringValue() {
            switch (this.ordinal()) {
                case 0: {
                    return OlvidNotifications.PLUGIN_VERSION;
                }
            }
            return null;
        }
    }
}

