/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.GroupBlob;
import io.olvid.keycloak.datatypes.GroupDeletionData;
import io.olvid.keycloak.datatypes.GroupMemberAndPermissions;
import io.olvid.keycloak.datatypes.GroupMemberKickedData;
import io.olvid.keycloak.datatypes.OlvidUserDetailsSignatureSignerContext;
import io.olvid.keycloak.datatypes.UserOrTopicToNotify;
import io.olvid.keycloak.jpa.OlvidData;
import io.olvid.keycloak.jpa.OlvidGroup;
import io.olvid.keycloak.jpa.OlvidGroupDeletion;
import io.olvid.keycloak.jpa.OlvidGroupMemberKicked;
import io.olvid.keycloak.rest.OlvidServerApiHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class OlvidGroupDao {
    protected static final Logger logger = Logger.getLogger(OlvidGroupDao.class);

    public static OlvidGroup getOlvidGroupById(EntityManager em, String realmId, String keycloakGroupId) {
        TypedQuery q = em.createNamedQuery("OlvidGroup.getById", OlvidGroup.class);
        q.setParameter("realmId", (Object)realmId);
        q.setParameter("keycloakGroupId", (Object)keycloakGroupId);
        try {
            return (OlvidGroup)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static Collection<UserOrTopicToNotify> disableGroupAndGetMembersToNotify(KeycloakSession session, ObjectMapper objectMapper, EntityManager em, RealmModel realm, OlvidGroup olvidGroup) {
        String signedGroupDeletion;
        HashSet<UserOrTopicToNotify> usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
        if (!olvidGroup.isEnabled()) {
            return usersAndTopicsToNotify;
        }
        long timestamp = System.currentTimeMillis();
        try {
            OlvidUserDetailsSignatureSignerContext signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realm);
            if (signatureSignerContext == null) {
                return usersAndTopicsToNotify;
            }
            GroupDeletionData groupDeletionData = new GroupDeletionData(olvidGroup.getGroupUid(), timestamp);
            logger.info((Object)("Signing groupDeletion of group " + olvidGroup.getKeycloakGroupId()));
            JWSBuilder jwsBuilder = new JWSBuilder();
            signedGroupDeletion = jwsBuilder.content(objectMapper.writeValueAsBytes((Object)groupDeletionData)).sign((SignatureSignerContext)signatureSignerContext);
        }
        catch (Exception e) {
            return usersAndTopicsToNotify;
        }
        OlvidGroupDeletion olvidGroupDeletion = new OlvidGroupDeletion();
        olvidGroupDeletion.setRealmId(olvidGroup.getRealmId());
        olvidGroupDeletion.setKeycloakGroupId(olvidGroup.getKeycloakGroupId());
        olvidGroupDeletion.setTimestamp(timestamp);
        olvidGroupDeletion.setKeycloakSignature(signedGroupDeletion);
        em.persist((Object)olvidGroupDeletion);
        olvidGroup.setEnabled(false);
        em.merge((Object)olvidGroup);
        em.flush();
        if (olvidGroup.getPushTopic() != null) {
            usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.TOPIC, realm.getId(), olvidGroup.getPushTopic()));
        }
        return usersAndTopicsToNotify;
    }

    public static Collection<UserOrTopicToNotify> enableThenUpdateOlvidGroupIfNeededAndGetMembersToNotify(KeycloakSession session, EntityManager em, RealmModel realmModel, GroupModel groupModel, ObjectMapper jsonObjectMapper, SecureRandom random) throws Exception {
        HashSet<UserOrTopicToNotify> usersAndTopicsToNotify;
        block31: {
            HashSet<GroupMemberAndPermissions> addedMembers;
            boolean changed;
            OlvidGroup olvidGroup;
            block32: {
                OlvidUserDetailsSignatureSignerContext signatureSignerContext;
                String currentSharedSettings;
                block30: {
                    usersAndTopicsToNotify = new HashSet<UserOrTopicToNotify>();
                    olvidGroup = OlvidGroupDao.getOlvidGroupById(em, realmModel.getId(), groupModel.getId());
                    if (olvidGroup != null) break block30;
                    olvidGroup = OlvidGroup.createOlvidGroupFromModelAndSign(session, em, realmModel, groupModel, jsonObjectMapper, random);
                    em.persist((Object)olvidGroup);
                    GroupBlob groupBlob = olvidGroup.getGroupBlob(jsonObjectMapper);
                    for (GroupMemberAndPermissions groupMember : groupBlob.groupMembersAndPermissions) {
                        usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmModel.getId(), groupMember.identityString));
                    }
                    break block31;
                }
                boolean newPushTopicCreated = false;
                boolean notifyMembersIndividually = false;
                if (olvidGroup.getPushTopic() == null) {
                    notifyMembersIndividually = true;
                    olvidGroup.setPushTopic(OlvidServerApiHelper.requestNewPushTopic(session, em, realmModel.getId(), jsonObjectMapper));
                    if (olvidGroup.getPushTopic() == null) {
                        logger.warn((Object)"Failed to get a push topic");
                    } else {
                        newPushTopicCreated = true;
                    }
                } else if (!olvidGroup.isEnabled()) {
                    notifyMembersIndividually = true;
                }
                GroupBlob currentGroupBlob = olvidGroup.getGroupBlob(jsonObjectMapper);
                changed = false;
                boolean userSignedDetailsChanged = false;
                addedMembers = new HashSet<GroupMemberAndPermissions>();
                HashSet<GroupMemberAndPermissions> removedMembers = new HashSet<GroupMemberAndPermissions>();
                if (!olvidGroup.isEnabled()) {
                    olvidGroup.setEnabled(true);
                    changed = true;
                    notifyMembersIndividually = true;
                }
                GroupBlob newGroupBlob = GroupBlob.createPartialBlobFromGroupModel(session, em, jsonObjectMapper, realmModel, groupModel, random);
                newGroupBlob.bytesGroupUid = olvidGroup.getGroupUid();
                newGroupBlob.pushTopic = olvidGroup.getPushTopic();
                if (!Objects.equals(newGroupBlob.groupDetails, currentGroupBlob.groupDetails)) {
                    logger.info((Object)"- Group details changed");
                    changed = true;
                }
                newGroupBlob.photoUid = olvidGroup.getGroupPhotoUid();
                if (!Arrays.equals(newGroupBlob.photoUid, currentGroupBlob.photoUid)) {
                    if (newGroupBlob.photoUid != null) {
                        TypedQuery q = em.createNamedQuery("OlvidData.getByUid", OlvidData.class);
                        q.setParameter("realmId", (Object)realmModel.getId());
                        q.setParameter("dataUid", (Object)Base64.getEncoder().encodeToString(newGroupBlob.photoUid));
                        try {
                            OlvidData olvidData = (OlvidData)q.getSingleResult();
                            newGroupBlob.encodedPhotoKey = olvidData.getEncodedDataKey();
                        }
                        catch (NoResultException e) {
                            logger.warn((Object)"    --> failed to get corresponding OlvidData\"");
                            newGroupBlob.photoUid = null;
                            newGroupBlob.encodedPhotoKey = null;
                        }
                    } else {
                        logger.info((Object)"- Group photo removed");
                        newGroupBlob.photoUid = null;
                        newGroupBlob.encodedPhotoKey = null;
                    }
                    changed = true;
                } else {
                    newGroupBlob.encodedPhotoKey = currentGroupBlob.encodedPhotoKey;
                }
                HashMap<GroupMemberAndPermissions, GroupMemberAndPermissions> currentMap = new HashMap<GroupMemberAndPermissions, GroupMemberAndPermissions>();
                for (GroupMemberAndPermissions groupMember : currentGroupBlob.groupMembersAndPermissions) {
                    if (newGroupBlob.groupMembersAndPermissions.contains(groupMember)) {
                        currentMap.put(groupMember, groupMember);
                        continue;
                    }
                    removedMembers.add(groupMember);
                    changed = true;
                }
                for (GroupMemberAndPermissions groupMember : newGroupBlob.groupMembersAndPermissions) {
                    GroupMemberAndPermissions currentMember = (GroupMemberAndPermissions)currentMap.get(groupMember);
                    if (currentMember == null) {
                        addedMembers.add(groupMember);
                        changed = true;
                        continue;
                    }
                    if (!Objects.equals(currentMember.identityString, groupMember.identityString)) {
                        removedMembers.add(currentMember);
                        addedMembers.add(groupMember);
                        changed = true;
                        continue;
                    }
                    groupMember.groupInvitationNonce = currentMember.groupInvitationNonce;
                    if (!Objects.equals(currentMember.signedUserDetails, groupMember.signedUserDetails)) {
                        userSignedDetailsChanged = true;
                    }
                    if (changed || new HashSet<String>(groupMember.permissions).equals(new HashSet<String>(currentMember.permissions))) continue;
                    changed = true;
                }
                String string = currentSharedSettings = currentGroupBlob.serializedSharedSettings == null ? null : currentGroupBlob.serializedSharedSettings;
                if (currentSharedSettings != null) {
                    String newSharedSettings;
                    String string2 = newSharedSettings = olvidGroup.getSerializedSharedSettings() != null ? olvidGroup.getSerializedSharedSettings() : "";
                    if (!newSharedSettings.contentEquals(currentSharedSettings)) {
                        newGroupBlob.serializedSharedSettings = newSharedSettings;
                        logger.info((Object)"- Group shared settings changed");
                        logger.info((Object)newGroupBlob.serializedSharedSettings);
                        changed = true;
                    }
                }
                newGroupBlob.timestamp = System.currentTimeMillis();
                if (changed || newPushTopicCreated || userSignedDetailsChanged || currentGroupBlob.timestamp < newGroupBlob.getTimestamp() - 1296000000L) {
                    if (changed) {
                        olvidGroup.setLastModificationTimestamp(newGroupBlob.timestamp);
                    }
                    if ((signatureSignerContext = OlvidUserDetailsSignatureSignerContext.createForRealm(session, em, realmModel)) == null) {
                        logger.warn((Object)"Unable to create signature context for createFromGroupModelAndSign");
                        throw new Exception();
                    }
                } else {
                    return usersAndTopicsToNotify;
                }
                logger.warn((Object)("Signing groupBlob of group " + olvidGroup.getKeycloakGroupId() + ". Reason: changed=" + changed + ", newPushTopicCreated=" + newPushTopicCreated + ", userSignedDetailsChanged=" + userSignedDetailsChanged + ", timestamp age=" + (newGroupBlob.getTimestamp() - currentGroupBlob.timestamp)));
                JWSBuilder jwsBuilder = new JWSBuilder();
                olvidGroup.setSignedGroupBlob(jwsBuilder.content(jsonObjectMapper.writeValueAsBytes((Object)newGroupBlob)).sign((SignatureSignerContext)signatureSignerContext));
                em.merge((Object)olvidGroup);
                for (GroupMemberAndPermissions removedMember : removedMembers) {
                    GroupMemberKickedData groupMemberKickedData = new GroupMemberKickedData(olvidGroup.getGroupUid(), removedMember.identityString, olvidGroup.getLastModificationTimestamp());
                    logger.info((Object)("Signing groupMemberKickedData of group " + olvidGroup.getKeycloakGroupId() + " for user " + removedMember.keycloakUserId));
                    JWSBuilder jwsBuilder2 = new JWSBuilder();
                    String signedGroupMemberKickedData = jwsBuilder2.content(jsonObjectMapper.writeValueAsBytes((Object)groupMemberKickedData)).sign((SignatureSignerContext)signatureSignerContext);
                    OlvidGroupMemberKicked olvidGroupMemberKicked = new OlvidGroupMemberKicked();
                    olvidGroupMemberKicked.setRealmId(realmModel.getId());
                    olvidGroupMemberKicked.setKeycloakGroupId(olvidGroup.getKeycloakGroupId());
                    olvidGroupMemberKicked.setUserId(removedMember.keycloakUserId);
                    olvidGroupMemberKicked.setTimestamp(olvidGroup.getLastModificationTimestamp());
                    olvidGroupMemberKicked.setKeycloakSignature(signedGroupMemberKickedData);
                    em.persist((Object)olvidGroupMemberKicked);
                }
                em.flush();
                if (!notifyMembersIndividually) break block32;
                for (GroupMemberAndPermissions groupMember : newGroupBlob.groupMembersAndPermissions) {
                    usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmModel.getId(), groupMember.identityString));
                }
                for (GroupMemberAndPermissions groupMember : removedMembers) {
                    usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmModel.getId(), groupMember.identityString));
                }
                break block31;
            }
            if (!changed) break block31;
            usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.TOPIC, realmModel.getId(), olvidGroup.getPushTopic()));
            for (GroupMemberAndPermissions groupMember : addedMembers) {
                usersAndTopicsToNotify.add(new UserOrTopicToNotify(UserOrTopicToNotify.NotificationType.SINGLE_USER, realmModel.getId(), groupMember.identityString));
            }
        }
        return usersAndTopicsToNotify;
    }
}

