/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import io.olvid.keycloak.jpa.OlvidData;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

@NamedQueries(value={@NamedQuery(name="OlvidExternalLinks.getById", query="SELECT oel FROM OlvidExternalLink oel WHERE oel.realmId = :realmId and oel.id = :id"), @NamedQuery(name="OlvidExternalLinks.getByTag", query="SELECT oel FROM OlvidExternalLink oel WHERE oel.realmId = :realmId and oel.tag = :tag"), @NamedQuery(name="OlvidExternalLinks.getByTags", query="SELECT oel FROM OlvidExternalLink oel WHERE oel.realmId = :realmId and oel.tag like :tags ORDER BY oel.createDate DESC"), @NamedQuery(name="OlvidExternalLinks.getAllByRealmId", query="SELECT oel FROM OlvidExternalLink oel WHERE oel.realmId = :realmId ORDER BY oel.createDate DESC"), @NamedQuery(name="OlvidExternalLinks.getAllNotRevokedByRealmId", query="SELECT oel FROM OlvidExternalLink oel WHERE oel.realmId = :realmId AND oel.isRevoked = false"), @NamedQuery(name="OlvidExternalLinks.updateByTag", query="UPDATE OlvidExternalLink oel SET oel.tag=:newTag WHERE oel.realmId = :realmId AND oel.tag=:tag"), @NamedQuery(name="OlvidExternalLinks.updateById", query="UPDATE OlvidExternalLink oel SET oel.tag=:newTag WHERE oel.realmId = :realmId AND oel.id=:id"), @NamedQuery(name="OlvidExternalLinks.revokeByTag", query="UPDATE OlvidExternalLink oel SET oel.isRevoked=true, oel.revokedDate=:revokedDate WHERE oel.realmId = :realmId AND oel.tag=:tag"), @NamedQuery(name="OlvidExternalLinks.revokeById", query="UPDATE OlvidExternalLink oel SET oel.isRevoked=true, oel.revokedDate=:revokedDate WHERE oel.realmId = :realmId AND oel.id=:id"), @NamedQuery(name="OlvidExternalLinks.revokeByApiKey", query="UPDATE OlvidExternalLink oel SET oel.isRevoked=true, oel.revokedDate=:revokedDate WHERE oel.realmId = :realmId AND oel.key=:apiKey")})
@Entity
@IdClass(value=OlvidExternalLinkId.class)
@Table(name="OLVID_EXTERNAL_LINK")
public class OlvidExternalLink {
    @Id
    @Column(name="ID", nullable=false)
    private String id;
    @Id
    @Column(name="REALM_ID", nullable=false)
    private String realmId;
    @Column(name="USER_CREATOR_ID", nullable=false)
    private String userCreatorId;
    @Column(name="KEY_VALUE", nullable=false)
    private String key;
    @Column(name="TAG", nullable=false)
    private String tag;
    @Column(name="IS_REVOKED", nullable=false)
    private Boolean isRevoked;
    @Column(name="ACTIVATED_DATE")
    private Long activatedDate;
    @Column(name="CREATED_DATE")
    private Long createDate;
    @Column(name="REVOKED_DATE")
    private Long revokedDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getUserCreatorId() {
        return this.userCreatorId;
    }

    public void setUserCreatorId(String userCreatorId) {
        this.userCreatorId = userCreatorId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Long createDate) {
        this.createDate = createDate;
    }

    public Boolean getRevoked() {
        return this.isRevoked;
    }

    public void setRevoked(Boolean revoked) {
        this.isRevoked = revoked;
    }

    public Long getActivatedDate() {
        return this.activatedDate;
    }

    public void setActivatedDate(Long activatedDate) {
        this.activatedDate = activatedDate;
    }

    public Long getRevokedDate() {
        return this.revokedDate;
    }

    public void setRevokedDate(Long revokedDate) {
        this.revokedDate = revokedDate;
    }

    public String toString() {
        return "OlvidExternalLink{id='" + this.id + "', realmId='" + this.realmId + "', userCreatorId='" + this.userCreatorId + "', key='" + this.key + "', tag='" + this.tag + "', isRevoked=" + this.isRevoked + ", activatedDate=" + this.activatedDate + ", createDate=" + this.createDate + ", revokedDate=" + this.revokedDate + "}";
    }

    public static class OlvidExternalLinkId
    implements Serializable {
        private String realmId;
        private String id;

        public OlvidExternalLinkId() {
        }

        public OlvidExternalLinkId(String realmId, String id) {
            this.realmId = realmId;
            this.id = id;
        }

        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        public void setId(String dataUid) {
            this.id = dataUid;
        }

        public String getRealmId() {
            return this.realmId;
        }

        public String id() {
            return this.id;
        }

        public int hashCode() {
            int hashCode = this.realmId == null ? 0 : this.realmId.hashCode();
            hashCode = 31 * hashCode + this.id.hashCode();
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OlvidData.OlvidDataId) {
                OlvidExternalLinkId casted = (OlvidExternalLinkId)obj;
                return Objects.equals(casted.realmId, this.realmId) && Objects.equals(casted.id, this.id);
            }
            return false;
        }
    }
}

