/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

@NamedQueries(value={@NamedQuery(name="OlvidData.getByUid", query="SELECT od FROM OlvidData od WHERE od.realmId = :realmId and od.dataUid = :dataUid"), @NamedQuery(name="OlvidData.getAll", query="SELECT od FROM OlvidData od")})
@Entity
@IdClass(value=OlvidDataId.class)
@Table(name="OLVID_DATA")
public class OlvidData {
    @Id
    @Column(name="REALM_ID")
    private String realmId;
    @Id
    @Column(name="DATA_UID")
    private String dataUid;
    @Column(name="DATA_KEY", nullable=false)
    private byte[] encodedDataKey;
    @Column(name="DATA", nullable=false)
    private byte[] data;

    public String getRealmId() {
        return this.realmId;
    }

    public String getDataUid() {
        return this.dataUid;
    }

    public byte[] getEncodedDataKey() {
        return this.encodedDataKey;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setEncodedDataKey(byte[] encodedDataKey) {
        this.encodedDataKey = encodedDataKey;
    }

    public void setDataUid(String dataUid) {
        this.dataUid = dataUid;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public static void insert(EntityManager em, OlvidData data) {
        em.persist((Object)data);
        em.flush();
    }

    public static class OlvidDataId
    implements Serializable {
        private String realmId;
        private String dataUid;

        public OlvidDataId() {
        }

        public OlvidDataId(String realmId, String dataUid) {
            this.realmId = realmId;
            this.dataUid = dataUid;
        }

        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        public void setDataUid(String dataUid) {
            this.dataUid = dataUid;
        }

        public String getRealmId() {
            return this.realmId;
        }

        public String getDataUid() {
            return this.dataUid;
        }

        public int hashCode() {
            int hashCode = this.realmId == null ? 0 : this.realmId.hashCode();
            hashCode = 31 * hashCode + this.dataUid.hashCode();
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OlvidDataId) {
                OlvidDataId casted = (OlvidDataId)obj;
                return Objects.equals(casted.realmId, this.realmId) && Objects.equals(casted.dataUid, this.dataUid);
            }
            return false;
        }
    }
}

