/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.DictionaryKey;
import io.olvid.keycloak.datatypes.Encoded;
import io.olvid.keycloak.datatypes.crypto.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.CryptographicKey;
import io.olvid.keycloak.datatypes.crypto.MACKey;
import io.olvid.keycloak.datatypes.crypto.SymEncKey;
import java.util.HashMap;

public abstract class SymmetricKey
extends CryptographicKey {
    public SymmetricKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static SymmetricKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 2: {
                return AuthEncKey.of(algorithmImplementation, key);
            }
            case 1: {
                return MACKey.of(algorithmImplementation, key);
            }
            case 0: {
                return SymEncKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

