/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.SymEncCTRAES256Key;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class SymEncCtrAES256 {
    private Cipher aes;
    private SymEncCTRAES256Key key;
    static final int KEY_BYTE_LENGTH = 32;
    static final int IV_BYTE_LENGTH = 8;
    static final int AES_BLOCK_BYTE_LENGTH = 16;
    private static final int ENCRYPT_BUFFER_SIZE = 262144;

    SymEncCtrAES256(SymEncCTRAES256Key key) throws InvalidKeyException {
        try {
            this.aes = Cipher.getInstance("AES/CTR/NoPadding");
            this.key = key;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int keyByteLength() {
        return 32;
    }

    public int ivByteLength() {
        return 8;
    }

    public int ciphertextLengthFromPlaintextLength(int plaintextLength) {
        return plaintextLength + 8;
    }

    public int plaintextLengthFromCiphertextLength(int ciphertextLength) {
        return ciphertextLength - 8;
    }

    public void encrypt(byte[] iv, byte[] plaintext, byte[] ciphertext) throws InvalidKeyException {
        if (iv.length != 8) {
            throw new InvalidKeyException();
        }
        System.arraycopy(iv, 0, ciphertext, 0, 8);
        byte[] fullIV = new byte[16];
        System.arraycopy(iv, 0, fullIV, 0, 8);
        try {
            this.aes.init(1, (Key)new SecretKeySpec(this.key.getKeyBytes(), "AES"), new IvParameterSpec(fullIV));
            int outOffset = 8;
            for (int offsetIn = 0; offsetIn < plaintext.length; offsetIn += 262144) {
                int len = Math.min(plaintext.length - offsetIn, 262144);
                outOffset += this.aes.update(plaintext, offsetIn, len, ciphertext, outOffset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] decrypt(byte[] ciphertextBytes) {
        byte[] iv = Arrays.copyOfRange(ciphertextBytes, 0, 8);
        byte[] ciphertextEnd = Arrays.copyOfRange(ciphertextBytes, 8, ciphertextBytes.length);
        byte[] plaintext = null;
        byte[] fullIV = new byte[16];
        System.arraycopy(iv, 0, fullIV, 0, 8);
        try {
            this.aes.init(2, (Key)new SecretKeySpec(this.key.getKeyBytes(), "AES"), new IvParameterSpec(fullIV));
            plaintext = this.aes.doFinal(ciphertextEnd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return plaintext;
    }
}

