/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import java.util.Arrays;

class Seed {
    public static final int MIN_SEED_LENGTH = 32;
    private final byte[] seed;
    public final int length;

    public Seed(byte[] seed) throws IllegalArgumentException {
        if (seed.length < 32) {
            throw new IllegalArgumentException();
        }
        this.seed = seed;
        this.length = seed.length;
    }

    public Seed(PRNGHmacSHA256 prng) {
        this(prng.bytes(32));
    }

    public byte[] getBytes() {
        return this.seed;
    }

    public int hashCode() {
        return Arrays.hashCode(this.seed);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Seed)) {
            return false;
        }
        return Arrays.equals(this.seed, ((Seed)obj).seed);
    }
}

