/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.MACHmacSha256;
import io.olvid.keycloak.datatypes.crypto.MACHmacSha256Key;
import io.olvid.keycloak.datatypes.crypto.Seed;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.util.Arrays;

public class PRNGHmacSHA256 {
    byte[] state_k = new byte[32];
    byte[] state_v = new byte[32];
    private static PRNGHmacSHA256 INSTANCE = null;

    public static PRNGHmacSHA256 get() {
        if (INSTANCE == null) {
            SecureRandom rand = new SecureRandom();
            byte[] seedBytes = new byte[32];
            rand.nextBytes(seedBytes);
            INSTANCE = new PRNGHmacSHA256(new Seed(seedBytes));
        }
        return INSTANCE;
    }

    public PRNGHmacSHA256(Seed seed) throws InvalidParameterException {
        Arrays.fill(this.state_k, (byte)0);
        Arrays.fill(this.state_v, (byte)1);
        this.update(seed.getBytes());
    }

    private void update(byte[] data) {
        try {
            byte[] in = new byte[this.state_v.length + 1 + data.length];
            System.arraycopy(this.state_v, 0, in, 0, this.state_v.length);
            in[this.state_v.length] = 0;
            System.arraycopy(data, 0, in, this.state_v.length + 1, data.length);
            this.state_k = new MACHmacSha256().digest(MACHmacSha256Key.of(this.state_k), in);
            this.state_v = new MACHmacSha256().digest(MACHmacSha256Key.of(this.state_k), this.state_v);
            if (data.length > 0) {
                System.arraycopy(this.state_v, 0, in, 0, this.state_v.length);
                in[this.state_v.length] = 1;
                System.arraycopy(data, 0, in, this.state_v.length + 1, data.length);
                this.state_k = new MACHmacSha256().digest(MACHmacSha256Key.of(this.state_k), in);
                this.state_v = new MACHmacSha256().digest(MACHmacSha256Key.of(this.state_k), this.state_v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] bytes(int l) {
        byte[] output = new byte[l];
        for (int i = 0; i < 1 + (l - 1) / 32; ++i) {
            try {
                this.state_v = new MACHmacSha256().digest(MACHmacSha256Key.of(this.state_k), this.state_v);
                System.arraycopy(this.state_v, 0, output, i * 32, Math.min(32, l - i * 32));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.update(new byte[0]);
        return output;
    }

    public BigInteger bigInt(BigInteger n) {
        byte[] rand;
        BigInteger r;
        BigInteger n_minus_one = n.subtract(BigInteger.ONE);
        int l = n_minus_one.bitLength();
        int ell = 1 + (l - 1) / 8;
        int mask = (1 << l - 8 * (ell - 1)) - 1;
        do {
            rand = this.bytes(ell);
            rand[0] = (byte)(rand[0] & mask);
        } while ((r = new BigInteger(1, rand)).compareTo(n) >= 0);
        return r;
    }
}

