/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.DictionaryKey;
import io.olvid.keycloak.datatypes.Encoded;
import io.olvid.keycloak.datatypes.crypto.MACKey;
import java.security.InvalidParameterException;
import java.util.HashMap;

class MACHmacSha256Key
extends MACKey {
    public static final int KEY_BYTE_LENGTH = 32;

    public MACHmacSha256Key(HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)0, key);
        if (this.getKeyLength() < 32) {
            throw new InvalidParameterException();
        }
    }

    public static MACHmacSha256Key of(byte[] macKey) {
        HashMap<DictionaryKey, Encoded> key = new HashMap<DictionaryKey, Encoded>();
        key.put(new DictionaryKey("mackey"), Encoded.of(macKey));
        return new MACHmacSha256Key(key);
    }
}

