/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.KDFDelegateForHmacSHA256;
import io.olvid.keycloak.datatypes.crypto.KDFSha256;
import io.olvid.keycloak.datatypes.crypto.MACKey;
import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import io.olvid.keycloak.datatypes.crypto.Seed;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class MACHmacSha256 {
    static final int OUTPUT_LENGTH = 32;

    MACHmacSha256() {
    }

    public int outputLength() {
        return 32;
    }

    public byte[] digest(MACKey key, byte[] bytes) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            return h.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public byte[] digest(MACKey key, byte[] bytes, int inputLen) throws InvalidKeyException {
        try {
            Mac h = Mac.getInstance("HmacSHA256");
            h.init(new SecretKeySpec(key.getKeyBytes(), "HmacSHA256"));
            h.update(bytes, 0, inputLen);
            return h.doFinal();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public boolean verify(MACKey key, byte[] bytes, byte[] mac) throws InvalidKeyException {
        byte[] newMac = this.digest(key, bytes);
        return Arrays.equals(mac, newMac);
    }

    public MACKey generateKey(PRNGHmacSHA256 prng) {
        KDFSha256 kdf = new KDFSha256();
        Seed kdfSeed = new Seed(prng);
        try {
            return (MACKey)kdf.gen(kdfSeed, new KDFDelegateForHmacSHA256())[0];
        }
        catch (Exception e) {
            return null;
        }
    }
}

