/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes.crypto;

import io.olvid.keycloak.datatypes.crypto.AuthEncAES256ThenSHA256Key;
import io.olvid.keycloak.datatypes.crypto.AuthEncKey;
import io.olvid.keycloak.datatypes.crypto.DecryptionException;
import io.olvid.keycloak.datatypes.crypto.KDF;
import io.olvid.keycloak.datatypes.crypto.KDFDelegateForAuthEncAES256ThenSHA256;
import io.olvid.keycloak.datatypes.crypto.KDFSha256;
import io.olvid.keycloak.datatypes.crypto.MACHmacSha256;
import io.olvid.keycloak.datatypes.crypto.MACHmacSha256Key;
import io.olvid.keycloak.datatypes.crypto.PRNGHmacSHA256;
import io.olvid.keycloak.datatypes.crypto.Seed;
import io.olvid.keycloak.datatypes.crypto.SymEncCTRAES256Key;
import io.olvid.keycloak.datatypes.crypto.SymEncCtrAES256;
import java.security.InvalidKeyException;
import java.util.Arrays;

public class AuthEnc {
    public int keyByteLength() {
        return 64;
    }

    public int ciphertextLengthFromPlaintextLength(int plaintextLength) {
        return plaintextLength + 8 + 32;
    }

    public int plaintextLengthFromCiphertextLength(int ciphertextLength) {
        return ciphertextLength - 8 - 32;
    }

    public byte[] encrypt(AuthEncKey key, byte[] plaintext, PRNGHmacSHA256 prng) throws InvalidKeyException {
        if (!(key instanceof AuthEncAES256ThenSHA256Key)) {
            throw new InvalidKeyException();
        }
        MACHmacSha256Key macKey = ((AuthEncAES256ThenSHA256Key)key).getMacKey();
        SymEncCTRAES256Key encKey = ((AuthEncAES256ThenSHA256Key)key).getEncKey();
        MACHmacSha256 mac = new MACHmacSha256();
        SymEncCtrAES256 enc = new SymEncCtrAES256(encKey);
        byte[] ciphertext = new byte[this.ciphertextLengthFromPlaintextLength(plaintext.length)];
        byte[] iv = prng.bytes(8);
        enc.encrypt(iv, plaintext, ciphertext);
        byte[] hash = mac.digest(macKey, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length));
        System.arraycopy(hash, 0, ciphertext, enc.ciphertextLengthFromPlaintextLength(plaintext.length), hash.length);
        return ciphertext;
    }

    public byte[] decrypt(AuthEncKey key, byte[] ciphertextBytes) throws DecryptionException, InvalidKeyException {
        if (!(key instanceof AuthEncAES256ThenSHA256Key)) {
            throw new InvalidKeyException();
        }
        MACHmacSha256Key macKey = ((AuthEncAES256ThenSHA256Key)key).getMacKey();
        SymEncCTRAES256Key encKey = ((AuthEncAES256ThenSHA256Key)key).getEncKey();
        MACHmacSha256 mac = new MACHmacSha256();
        SymEncCtrAES256 enc = new SymEncCtrAES256(encKey);
        byte[] hash = Arrays.copyOfRange(ciphertextBytes, ciphertextBytes.length - mac.outputLength(), ciphertextBytes.length);
        byte[] encryptedBytes = Arrays.copyOfRange(ciphertextBytes, 0, ciphertextBytes.length - mac.outputLength());
        if (!mac.verify(macKey, encryptedBytes, hash)) {
            throw new DecryptionException();
        }
        return enc.decrypt(encryptedBytes);
    }

    public KDF.Delegate getKDFDelegate() {
        return new KDFDelegateForAuthEncAES256ThenSHA256();
    }

    public AuthEncKey generateKey(PRNGHmacSHA256 prng) {
        KDFSha256 kdf = new KDFSha256();
        Seed kdfSeed = new Seed(prng);
        try {
            return (AuthEncKey)kdf.gen(kdfSeed, this.getKDFDelegate())[0];
        }
        catch (Exception e) {
            return null;
        }
    }
}

