/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.ECDSAAlgorithm;
import org.keycloak.crypto.KeyWrapper;

public class OlvidUserDetailsSignatureVerifierContext
extends AsymmetricSignatureVerifierContext {
    private final KeyWrapper key;

    public OlvidUserDetailsSignatureVerifierContext(KeyWrapper key) {
        super(key);
        this.key = key;
    }

    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        switch (this.key.getType()) {
            case "EC": {
                try {
                    return super.verify(data, ECDSAAlgorithm.concatenatedRSToASN1DER((byte[])signature, (int)signature.length));
                }
                catch (Exception e) {
                    throw new VerificationException("Verification failed", (Throwable)e);
                }
            }
        }
        return super.verify(data, signature);
    }
}

