/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import io.olvid.keycloak.jpa.OlvidConfigurationDao;
import jakarta.persistence.EntityManager;
import java.util.stream.Collectors;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.ECDSAAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlvidUserDetailsSignatureSignerContext
extends AsymmetricSignatureSignerContext {
    protected static final org.jboss.logging.Logger logger = org.jboss.logging.Logger.getLogger(OlvidUserDetailsSignatureSignerContext.class);
    private static final Logger log = LoggerFactory.getLogger(OlvidUserDetailsSignatureSignerContext.class);
    private final KeyWrapper key;

    public static OlvidUserDetailsSignatureSignerContext createForRealm(KeycloakSession session, EntityManager em, RealmModel realmModel) {
        String keyId = OlvidConfigurationDao.getStringConfiguration(em, realmModel.getId(), "keyChoosen");
        if (keyId == null) {
            return null;
        }
        KeyWrapper key = null;
        for (KeyWrapper keyCandidate : session.keys().getKeysStream(realmModel).collect(Collectors.toList())) {
            if (!keyCandidate.getKid().equals(keyId)) continue;
            key = keyCandidate;
            break;
        }
        if (key == null) {
            return null;
        }
        return new OlvidUserDetailsSignatureSignerContext(key);
    }

    private OlvidUserDetailsSignatureSignerContext(KeyWrapper key) {
        super(key);
        this.key = key;
    }

    public byte[] sign(byte[] data) throws SignatureException {
        switch (this.key.getType()) {
            case "EC": {
                try {
                    int size = ECDSAAlgorithm.getSignatureLength((String)this.getAlgorithm());
                    return ECDSAAlgorithm.asn1derToConcatenatedRS((byte[])super.sign(data), (int)size);
                }
                catch (Exception e) {
                    throw new SignatureException("Signing failed", (Throwable)e);
                }
            }
        }
        return super.sign(data);
    }
}

