/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.jpa.OlvidUser;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.Utils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OlvidUserDetails {
    protected static final Logger logger = Logger.getLogger(OlvidUserDetails.class);
    private String id;
    private String identity;
    private String firstname;
    private String lastname;
    private String position;
    private String company;
    private long timestamp;

    public OlvidUserDetails() {
    }

    public OlvidUserDetails(UserModel user) {
        this.id = user.getId();
        this.firstname = user.getFirstName();
        this.lastname = user.getLastName();
        this.position = user.getFirstAttribute("olvid-position");
        this.company = user.getFirstAttribute("olvid-company");
        String identityAttribute = user.getFirstAttribute("olvid-identity");
        if (identityAttribute == null) {
            this.identity = null;
        } else {
            boolean badFormat = false;
            try {
                Base64.getDecoder().decode(identityAttribute);
            }
            catch (IllegalArgumentException e) {
                badFormat = true;
                user.removeAttribute("olvid-identity");
            }
            this.identity = badFormat ? null : identityAttribute;
        }
    }

    @JsonIgnore
    public String getSignedDetails(SignatureSignerContext signatureSignerContext, ObjectMapper objectMapper) throws Exception {
        logger.info((Object)("Signing details of user " + this.id));
        if (Utils.nullOrTrim(this.firstname) == null && Utils.nullOrTrim(this.lastname) == null) {
            logger.warn((Object)("Not signing details as user has no first name or last name: " + this.id));
            throw new Exception();
        }
        JWSBuilder jwsBuilder = new JWSBuilder();
        this.timestamp = System.currentTimeMillis();
        return jwsBuilder.content(objectMapper.writeValueAsBytes((Object)this)).sign(signatureSignerContext);
    }

    @JsonIgnore
    public String getFullSearchString() {
        return Utils.unAccent((this.firstname == null ? "" : this.firstname) + " " + (this.lastname == null ? "" : this.lastname) + " " + (this.position == null ? "" : this.position) + " " + (this.company == null ? "" : this.company));
    }

    @JsonIgnore
    public static Long getLastSync(EntityManager em, RealmModel realmModel, UserModel userModel) {
        Long lastSync = 0L;
        try {
            TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("userId", (Object)userModel.getId());
            OlvidUser olvidUser = (OlvidUser)q.getSingleResult();
            lastSync = olvidUser.getLastSync();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return lastSync;
    }

    public static void setLastSync(EntityManager em, RealmModel realmModel, UserModel userModel, Long currentTimestamp) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidUser.getById", OlvidUser.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("userId", (Object)userModel.getId());
            OlvidUser olvidUser = (OlvidUser)q.getSingleResult();
            olvidUser.setLastSync(currentTimestamp);
            em.merge((Object)olvidUser);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    public static List<OlvidUserDevice> getOlvidUserDevice(EntityManager em, RealmModel realmModel, UserModel userModel) {
        try {
            TypedQuery q = em.createNamedQuery("OlvidUserDevice.getById", OlvidUserDevice.class);
            q.setParameter("realmId", (Object)realmModel.getId());
            q.setParameter("userId", (Object)userModel.getId());
            List olvidUserDevices = q.getResultList();
            return olvidUserDevices;
        }
        catch (NoResultException e) {
            return new ArrayList<OlvidUserDevice>();
        }
    }

    @JsonIgnore
    public boolean areContentsTheSame(OlvidUserDetails other) {
        return Objects.equals(this.id, other.id) && Objects.equals(this.identity, other.identity) && Objects.equals(this.firstname, other.firstname) && Objects.equals(this.lastname, other.lastname) && Objects.equals(this.position, other.position) && Objects.equals(this.company, other.company);
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="identity")
    public String getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="identity")
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @JsonProperty(value="first-name")
    public String getFirstname() {
        return this.firstname;
    }

    @JsonProperty(value="first-name")
    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    @JsonProperty(value="last-name")
    public String getLastname() {
        return this.lastname;
    }

    @JsonProperty(value="last-name")
    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    @JsonProperty(value="position")
    public String getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    public void setPosition(String position) {
        this.position = position;
    }

    @JsonProperty(value="company")
    public String getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    public void setCompany(String company) {
        this.company = company;
    }

    @JsonProperty(value="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

