/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.keycloak.datatypes.JsonExpiration;
import java.util.HashMap;
import java.util.Objects;
import org.jboss.logging.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonSharedSettings {
    protected static final Logger logger = Logger.getLogger(JsonSharedSettings.class);
    int version;
    JsonExpiration exp;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @JsonProperty(value="exp")
    public JsonExpiration getJsonExpiration() {
        return this.exp;
    }

    @JsonProperty(value="exp")
    public void setJsonExpiration(JsonExpiration exp) {
        this.exp = exp;
    }

    public boolean isJsonSharedSettingsFormat(String value) throws JsonProcessingException {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        try {
            jsonObjectMapper.readValue(value, JsonSharedSettings.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonSharedSettings)) {
            return false;
        }
        JsonSharedSettings other = (JsonSharedSettings)obj;
        return Objects.equals(this.exp, other.exp);
    }

    public boolean likeNull() {
        return this.exp == null || this.exp.likeNull();
    }

    public String toString() {
        return "{version=" + this.version + ", exp=" + String.valueOf(this.exp) + "}";
    }

    public JsonSharedSettings initJsonSharedSettingsFromExpirationString(String jsonExpirationString) {
        HashMap serializedSharedSettings = new HashMap();
        JsonExpiration expirationSettings = new JsonExpiration().initJsonExpirationFromHashMap(serializedSharedSettings);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            serializedSharedSettings = (HashMap)objectMapper.readValue(jsonExpirationString, HashMap.class);
            expirationSettings = new JsonExpiration().initJsonExpirationFromHashMap(serializedSharedSettings);
        }
        catch (Exception objectMapper) {
            // empty catch block
        }
        JsonSharedSettings jsonSharedSettings = new JsonSharedSettings();
        jsonSharedSettings.setVersion(0);
        jsonSharedSettings.setJsonExpiration(expirationSettings);
        return jsonSharedSettings;
    }

    public JsonSharedSettings initJsonSharedSettings(String jsonSharedString) {
        HashMap serializedSharedSettings = new HashMap();
        JsonSharedSettings jsonSharedSettings = new JsonSharedSettings();
        jsonSharedSettings.setVersion(0);
        jsonSharedSettings.setJsonExpiration(new JsonExpiration());
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            serializedSharedSettings = (HashMap)objectMapper.readValue(jsonSharedString, HashMap.class);
            JsonExpiration expirationSettings = new JsonExpiration();
            expirationSettings = new JsonExpiration().initJsonExpirationFromHashMap((HashMap)serializedSharedSettings.get("exp"));
            jsonSharedSettings.setJsonExpiration(expirationSettings);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return jsonSharedSettings;
    }
}

