/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonExpiration {
    Long ex;
    Long vis;
    Boolean ro;

    @JsonProperty(value="ex")
    public Long getEx() {
        return this.ex;
    }

    @JsonProperty(value="ex")
    public void setEx(Long ex) {
        this.ex = ex;
    }

    @JsonProperty(value="vis")
    public Long getVis() {
        return this.vis;
    }

    @JsonProperty(value="vis")
    public void setVis(Long vis) {
        this.vis = vis;
    }

    @JsonProperty(value="ro")
    public Boolean getRo() {
        return this.ro;
    }

    @JsonProperty(value="ro")
    public void setRo(Boolean ro) {
        this.ro = ro;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonExpiration)) {
            return false;
        }
        JsonExpiration other = (JsonExpiration)obj;
        if ((this.ro != null && this.ro != false) ^ (other.ro != null && other.ro != false)) {
            return false;
        }
        if (!Objects.equals(this.vis, other.vis)) {
            return false;
        }
        return Objects.equals(this.ex, other.ex);
    }

    public boolean likeNull() {
        return (this.ro == null || this.ro == false) && this.vis == null && this.ex == null;
    }

    public boolean isJsonExpirationFormat(String value) throws JsonProcessingException {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        try {
            jsonObjectMapper.readValue(value, JsonExpiration.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JsonExpiration initJsonExpirationFromHashMap(HashMap data) {
        JsonExpiration expirationSettings = new JsonExpiration();
        expirationSettings.setEx(data.get("ex") != null ? Long.valueOf(((Integer)data.get("ex")).intValue()) : (data.get("existenceDuration") != null ? Long.valueOf(((Integer)data.get("existenceDuration")).intValue()) : null));
        expirationSettings.setVis(data.get("vis") != null ? Long.valueOf(((Integer)data.get("vis")).intValue()) : (data.get("visibilityDuration") != null ? Long.valueOf(((Integer)data.get("visibilityDuration")).intValue()) : null));
        expirationSettings.setRo(data.get("ro") != null ? (Boolean)data.get("ro") : (data.get("readOnce") != null ? (Boolean)data.get("readOnce") : false));
        return expirationSettings;
    }

    public String toString() {
        return "JsonExpiration{ex=" + this.ex + ", vis=" + this.vis + ", ro=" + this.ro + "}";
    }
}

