/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public enum GroupPermission {
    GROUP_ADMIN,
    REMOTE_DELETE_ANYTHING,
    EDIT_OR_REMOTE_DELETE_OWN_MESSAGES,
    CHANGE_SETTINGS,
    SEND_MESSAGE;

    public static final String[] DEFAULT_MEMBER_PERMISSIONS;
    private static final Map<String, GroupPermission> valueMap;

    public String getString() {
        switch (this.ordinal()) {
            case 0: {
                return "ga";
            }
            case 1: {
                return "rd";
            }
            case 2: {
                return "eo";
            }
            case 3: {
                return "cs";
            }
            case 4: {
                return "sm";
            }
        }
        return "";
    }

    public static GroupPermission fromString(String value) {
        return valueMap.get(value);
    }

    public static HashSet<GroupPermission> fromStrings(Collection<String> permissionStrings) {
        HashSet<GroupPermission> res = new HashSet<GroupPermission>();
        for (String permissionString : permissionStrings) {
            GroupPermission perm = GroupPermission.fromString(permissionString);
            if (perm == null) continue;
            res.add(perm);
        }
        return res;
    }

    public static List<String> deserializePermissions(byte[] serializedPermissions) {
        ArrayList<String> permissionStrings = new ArrayList<String>();
        int startPos = 0;
        for (int i = 0; i < serializedPermissions.length; ++i) {
            if (serializedPermissions[i] != 0) continue;
            permissionStrings.add(new String(Arrays.copyOfRange(serializedPermissions, startPos, i), StandardCharsets.UTF_8));
            startPos = i + 1;
        }
        if (startPos != serializedPermissions.length) {
            permissionStrings.add(new String(Arrays.copyOfRange(serializedPermissions, startPos, serializedPermissions.length), StandardCharsets.UTF_8));
        }
        return permissionStrings;
    }

    public static HashSet<GroupPermission> deserializeKnownPermissions(byte[] serializedPermissions) {
        List<String> permissionStrings = GroupPermission.deserializePermissions(serializedPermissions);
        HashSet<GroupPermission> permissions = new HashSet<GroupPermission>();
        for (String permissionString : permissionStrings) {
            GroupPermission permission = GroupPermission.fromString(permissionString);
            if (permission == null) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static byte[] serializePermissionStrings(Collection<String> permissionStrings) {
        Object object;
        if (permissionStrings.size() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (String permissionString : permissionStrings) {
                if (baos.size() > 0) {
                    baos.write(new byte[]{0});
                }
                baos.write(permissionString.getBytes(StandardCharsets.UTF_8));
            }
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return object;
    }

    public static byte[] serializePermissions(Collection<GroupPermission> permissions) {
        Object object;
        if (permissions.size() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (GroupPermission permission : permissions) {
                if (baos.size() > 0) {
                    baos.write(new byte[]{0});
                }
                baos.write(permission.getString().getBytes(StandardCharsets.UTF_8));
            }
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return object;
    }

    static {
        DEFAULT_MEMBER_PERMISSIONS = new String[]{EDIT_OR_REMOTE_DELETE_OWN_MESSAGES.getString(), SEND_MESSAGE.getString()};
        valueMap = new HashMap<String, GroupPermission>();
        valueMap.put("ga", GROUP_ADMIN);
        valueMap.put("rd", REMOTE_DELETE_ANYTHING);
        valueMap.put("eo", EDIT_OR_REMOTE_DELETE_OWN_MESSAGES);
        valueMap.put("cs", CHANGE_SETTINGS);
        valueMap.put("sm", SEND_MESSAGE);
    }
}

