/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.datatypes;

import io.olvid.keycloak.datatypes.DecodingException;
import io.olvid.keycloak.datatypes.DictionaryKey;
import io.olvid.keycloak.datatypes.EncodingException;
import io.olvid.keycloak.datatypes.crypto.SymmetricKey;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Encoded {
    public static final int INT_ENCODING_LENGTH = 8;
    public static final int ENCODED_HEADER_LENGTH = 5;
    protected final byte[] data;
    private static final byte BYTE_IDS_BYTE_ARRAY = 0;
    private static final byte BYTE_IDS_INT = 1;
    private static final byte BYTE_IDS_BOOLEAN = 2;
    private static final byte BYTE_IDS_LIST = 3;
    private static final byte BYTE_IDS_DICTIONARY = 4;
    private static final byte BYTE_IDS_BIG_UINT = -128;
    private static final byte BYTE_IDS_SYM_KEY = -112;
    private static final byte BYTE_IDS_PUB_KEY = -111;
    private static final byte BYTE_IDS_PRV_KEY = -110;

    public Encoded(byte[] bytes) {
        this.data = bytes;
    }

    public static byte[] encodeChunk(int chunkNumber, byte[] buffer, int bufferFullness) {
        byte[] output = new byte[23 + bufferFullness];
        output[0] = 3;
        System.arraycopy(Encoded.bytesFromUInt32(18 + bufferFullness), 0, output, 1, 4);
        output[5] = 1;
        output[6] = 0;
        output[7] = 0;
        output[8] = 0;
        output[9] = 8;
        for (int j = 0; j < 8; ++j) {
            output[17 - j] = (byte)(chunkNumber & 0xFF);
            chunkNumber >>>= 8;
        }
        output[18] = 0;
        System.arraycopy(Encoded.bytesFromUInt32(bufferFullness), 0, output, 19, 4);
        System.arraycopy(buffer, 0, output, 23, bufferFullness);
        return output;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public boolean equals(Object o) {
        return o instanceof Encoded && Arrays.equals(this.data, ((Encoded)o).getBytes());
    }

    public static Encoded fromLongerByteArray(byte[] bytes) throws DecodingException {
        if (bytes.length < 5) {
            throw new DecodingException();
        }
        int len = Encoded.uint32FromBytes(bytes, 1);
        if (bytes.length < len + 5) {
            throw new DecodingException();
        }
        return new Encoded(Arrays.copyOfRange(bytes, 0, 5 + len));
    }

    public static Encoded of(byte[] bytes) {
        byte[] data = new byte[bytes.length + 5];
        data[0] = 0;
        byte[] encodedLength = Encoded.bytesFromUInt32(bytes.length);
        System.arraycopy(encodedLength, 0, data, 1, 4);
        System.arraycopy(bytes, 0, data, 5, bytes.length);
        return new Encoded(data);
    }

    public static Encoded of(String string) {
        return Encoded.of(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Encoded of(String[] strings) {
        Encoded[] encodedStrings = new Encoded[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            encodedStrings[i] = Encoded.of(strings[i]);
        }
        return Encoded.of(encodedStrings);
    }

    public static Encoded of(long i) {
        byte[] data = new byte[13];
        data[0] = 1;
        data[1] = 0;
        data[2] = 0;
        data[3] = 0;
        data[4] = 8;
        for (int j = 0; j < 8; ++j) {
            data[12 - j] = (byte)(i & 0xFFL);
            i >>>= 8;
        }
        return new Encoded(data);
    }

    public static Encoded of(boolean b) {
        byte[] data = new byte[]{2, 0, 0, 0, 1, b ? (byte)1 : 0};
        return new Encoded(data);
    }

    public static Encoded of(SymmetricKey symmetricKey) {
        Encoded keyType = Encoded.of(new byte[]{symmetricKey.getAlgorithmClass(), symmetricKey.getAlgorithmImplementation()});
        Encoded encodedDict = Encoded.of(symmetricKey.getKey());
        return Encoded.pack((byte)-112, new Encoded[]{keyType, encodedDict});
    }

    public static Encoded of(BigInteger bigInt, int len) throws EncodingException {
        if (bigInt.signum() < 0 || bigInt.bitLength() > 8 * len) {
            throw new EncodingException();
        }
        byte[] data = new byte[len + 5];
        data[0] = -128;
        byte[] encodedLength = Encoded.bytesFromUInt32(len);
        System.arraycopy(encodedLength, 0, data, 1, 4);
        byte[] bytes = bigInt.toByteArray();
        int offset = len - bytes.length;
        if (offset == -1) {
            System.arraycopy(bytes, 1, data, 5, len);
        } else {
            System.arraycopy(bytes, 0, data, 5 + offset, bytes.length);
        }
        return new Encoded(data);
    }

    public static byte[] bytesFromBigUInt(BigInteger bigInt, int len) throws EncodingException {
        if (bigInt.signum() < 0 || bigInt.bitLength() > 8 * len) {
            throw new EncodingException();
        }
        byte[] data = new byte[len];
        byte[] bytes = bigInt.toByteArray();
        int offset = len - bytes.length;
        if (offset == -1) {
            System.arraycopy(bytes, 1, data, 0, len);
        } else {
            System.arraycopy(bytes, 0, data, offset, bytes.length);
        }
        return data;
    }

    public static Encoded of(Encoded[] list) {
        return Encoded.pack((byte)3, list);
    }

    private static Encoded pack(byte byteId, Encoded[] list) {
        int len = 0;
        for (Encoded encoded : list) {
            len += encoded.data.length;
        }
        byte[] data = new byte[len + 5];
        data[0] = byteId;
        byte[] encodedLength = Encoded.bytesFromUInt32(len);
        System.arraycopy(encodedLength, 0, data, 1, 4);
        int offset = 5;
        for (Encoded encoded : list) {
            System.arraycopy(encoded.data, 0, data, offset, encoded.data.length);
            offset += encoded.data.length;
        }
        return new Encoded(data);
    }

    public static Encoded of(HashMap<DictionaryKey, Encoded> dict) {
        int len = 0;
        for (Map.Entry<DictionaryKey, Encoded> entry : dict.entrySet()) {
            len += 5 + entry.getKey().data.length;
            len += entry.getValue().data.length;
        }
        byte[] data = new byte[len + 5];
        data[0] = 4;
        byte[] encodedLength = Encoded.bytesFromUInt32(len);
        System.arraycopy(encodedLength, 0, data, 1, 4);
        int offset = 5;
        for (Map.Entry<DictionaryKey, Encoded> entry : dict.entrySet()) {
            Encoded encodedKey = Encoded.of(entry.getKey().data);
            System.arraycopy(encodedKey.data, 0, data, offset, encodedKey.data.length);
            Encoded encodedValue = entry.getValue();
            System.arraycopy(encodedValue.data, 0, data, offset += encodedKey.data.length, encodedValue.data.length);
            offset += encodedValue.data.length;
        }
        return new Encoded(data);
    }

    public boolean isEncodedValue() {
        int len = Encoded.uint32FromBytes(this.data, 1);
        if (len + 5 != this.data.length) {
            return false;
        }
        switch (this.data[0]) {
            case -128: 
            case -112: 
            case -111: 
            case -110: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public byte[] decodeBytes() throws DecodingException {
        if (this.data[0] != 0) {
            throw new DecodingException();
        }
        if (!this.isEncodedValue()) {
            throw new DecodingException();
        }
        return Arrays.copyOfRange(this.data, 5, this.data.length);
    }

    public String decodeString() throws DecodingException {
        return new String(this.decodeBytes(), StandardCharsets.UTF_8);
    }

    public long decodeLong() throws DecodingException {
        if (this.data[0] != 1) {
            throw new DecodingException();
        }
        if (this.data.length != 13 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res <<= 8;
            res += (long)(this.data[i + 5] & 0xFF);
        }
        return res;
    }

    public boolean decodeBoolean() throws DecodingException {
        if (this.data[0] != 2) {
            throw new DecodingException();
        }
        if (this.data.length != 6 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        switch (this.data[5]) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new DecodingException();
    }

    public SymmetricKey decodeSymmetricKey() throws DecodingException {
        if (this.data[0] != -112 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        Encoded[] list = this.unpack();
        if (list.length != 2) {
            throw new DecodingException();
        }
        byte[] algoBytes = list[0].decodeBytes();
        if (algoBytes.length != 2) {
            throw new DecodingException();
        }
        HashMap<DictionaryKey, Encoded> key = list[1].decodeDictionary();
        return SymmetricKey.of(algoBytes[0], algoBytes[1], key);
    }

    public BigInteger decodeBigUInt() throws DecodingException {
        if (this.data[0] != -128 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        return new BigInteger(1, Arrays.copyOfRange(this.data, 5, this.data.length));
    }

    public static BigInteger bigUIntFromBytes(byte[] data) {
        return new BigInteger(1, data);
    }

    public Encoded[] decodeListWithPadding() throws DecodingException {
        if (this.data[0] != 3) {
            throw new DecodingException();
        }
        int totalLen = Encoded.uint32FromBytes(this.data, 1);
        if (totalLen + 5 > this.data.length) {
            throw new DecodingException();
        }
        ArrayList<Encoded> list = new ArrayList<Encoded>();
        int offset = 5;
        while (offset + 4 < totalLen + 5) {
            int len = Encoded.uint32FromBytes(this.data, offset + 1);
            if (offset + 5 + len > totalLen + 5) {
                throw new DecodingException();
            }
            Encoded elem = new Encoded(Arrays.copyOfRange(this.data, offset, offset + 5 + len));
            list.add(elem);
            offset += 5 + len;
        }
        return list.toArray(new Encoded[0]);
    }

    public Encoded[] decodeList() throws DecodingException {
        if (this.data[0] != 3 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        return this.unpack();
    }

    private Encoded[] unpack() throws DecodingException {
        ArrayList<Encoded> list = new ArrayList<Encoded>();
        int offset = 5;
        while (offset + 4 < this.data.length) {
            int len = Encoded.uint32FromBytes(this.data, offset + 1);
            if (offset + 5 + len > this.data.length) {
                throw new DecodingException();
            }
            Encoded elem = new Encoded(Arrays.copyOfRange(this.data, offset, offset + 5 + len));
            list.add(elem);
            offset += 5 + len;
        }
        return list.toArray(new Encoded[0]);
    }

    public HashMap<DictionaryKey, Encoded> decodeDictionary() throws DecodingException {
        if (this.data[0] != 4 || !this.isEncodedValue()) {
            throw new DecodingException();
        }
        HashMap<DictionaryKey, Encoded> dict = new HashMap<DictionaryKey, Encoded>();
        int offset = 5;
        while (offset + 4 < this.data.length) {
            int len = Encoded.uint32FromBytes(this.data, offset + 1);
            if (offset + 5 + len > this.data.length) {
                throw new DecodingException();
            }
            DictionaryKey key = new DictionaryKey(new Encoded(Arrays.copyOfRange(this.data, offset, offset + 5 + len)).decodeBytes());
            if ((offset += 5 + len) + 5 > this.data.length) {
                throw new DecodingException();
            }
            len = Encoded.uint32FromBytes(this.data, offset + 1);
            if (offset + 5 + len > this.data.length) {
                throw new DecodingException();
            }
            Encoded value = new Encoded(Arrays.copyOfRange(this.data, offset, offset + 5 + len));
            offset += 5 + len;
            dict.put(key, value);
        }
        return dict;
    }

    public String[] decodeStringArray() throws DecodingException {
        Encoded[] encodedStrings = this.decodeList();
        String[] strings = new String[encodedStrings.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = encodedStrings[i].decodeString();
        }
        return strings;
    }

    static byte[] bytesFromUInt32(int length) {
        byte[] res = new byte[4];
        for (int i = 0; i < 4; ++i) {
            res[3 - i] = (byte)(length & 0xFF);
            length >>>= 8;
        }
        return res;
    }

    static int uint32FromBytes(byte[] bytes) {
        return Encoded.uint32FromBytes(bytes, 0);
    }

    static int uint32FromBytes(byte[] bytes, int offset) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res += bytes[i + offset] & 0xFF;
        }
        return res;
    }
}

