/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.modelsDevices;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.users.CustomUserModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import jakarta.persistence.EntityManager;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserEntity;

public class OlvidUserDeviceModel {
    protected static final Logger logger = Logger.getLogger(OlvidUserDeviceModel.class);
    @JsonProperty(value="realmId")
    public String realmId;
    @JsonProperty(value="deviceUid")
    public String deviceUid;
    @JsonProperty(value="userId")
    public String userId;
    @JsonProperty(value="displayName")
    public String displayName;
    @JsonProperty(value="createDate")
    public Long createDate;
    @JsonProperty(value="lastSync")
    public Long lastSync;
    @JsonProperty(value="isKnown")
    public Boolean isKnown;
    @JsonProperty(value="isActive")
    public Boolean isActive;
    @JsonProperty(value="platform")
    public String platform;
    @JsonProperty(value="user")
    public CustomUserModel user;

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getDeviceUid() {
        return this.deviceUid;
    }

    public void setDeviceUid(String deviceUid) {
        this.deviceUid = deviceUid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Long createDate) {
        this.createDate = createDate;
    }

    public Long getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Long lastSync) {
        this.lastSync = lastSync;
    }

    public Boolean getIsKnown() {
        return this.isKnown;
    }

    public void setIsKnown(Boolean isKnown) {
        this.isKnown = isKnown;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public CustomUserModel getUser() {
        return this.user;
    }

    public void setUser(CustomUserModel user) {
        this.user = user;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlvidUserDeviceModel that = (OlvidUserDeviceModel)o;
        return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.deviceUid, that.deviceUid) && Objects.equals(this.userId, that.userId) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.createDate, that.createDate) && Objects.equals(this.lastSync, that.lastSync) && Objects.equals(this.isKnown, that.isKnown) && Objects.equals(this.isActive, that.isActive) && Objects.equals(this.platform, that.platform) && Objects.equals(this.user, that.user);
    }

    public String toString() {
        return "OlvidUserDeviceModel{realmId='" + this.realmId + "', deviceUid='" + this.deviceUid + "', userId='" + this.userId + "', displayName='" + this.displayName + "', createDate=" + this.createDate + ", lastSync=" + this.lastSync + ", isKnown=" + this.isKnown + ", isActive=" + this.isActive + ", platform='" + this.platform + "', user=" + String.valueOf(this.user) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.realmId, this.deviceUid, this.userId, this.displayName, this.createDate, this.lastSync, this.isKnown, this.isActive, this.platform, this.user);
    }

    public OlvidUserDeviceModel newOlvidUserDevice(EntityManager em, KeycloakSession session, RealmModel realm, Object[] data, OlvidCircleVisibility olvidCircleVisibility) {
        OlvidUserDeviceModel olvidUserDeviceModel = new OlvidUserDeviceModel();
        olvidUserDeviceModel.setDisplayName(((OlvidUserDevice)data[0]).getDisplayName());
        olvidUserDeviceModel.setDeviceUid(((OlvidUserDevice)data[0]).getDeviceUid());
        olvidUserDeviceModel.setUserId(((OlvidUserDevice)data[0]).getUserId());
        olvidUserDeviceModel.setCreateDate(((OlvidUserDevice)data[0]).getCreateDate());
        olvidUserDeviceModel.setLastSync(((OlvidUserDevice)data[0]).getLastSync());
        olvidUserDeviceModel.setRealmId(((OlvidUserDevice)data[0]).getRealmId());
        olvidUserDeviceModel.setIsActive(((OlvidUserDevice)data[0]).getIsActive());
        olvidUserDeviceModel.setIsKnown(((OlvidUserDevice)data[0]).getIsKnown());
        olvidUserDeviceModel.setPlatform(((OlvidUserDevice)data[0]).getPlatform());
        olvidUserDeviceModel.setUser(Configuration.createOlvidUserFromUserEntity(em, session, realm, (UserEntity)data[1], olvidCircleVisibility));
        return olvidUserDeviceModel;
    }
}

