/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.users;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.rest.Utils;
import java.util.Base64;
import java.util.Objects;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class UserModelAttributes {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="credential")
    Boolean credential;
    @JsonProperty(value="federatedIdentities")
    Boolean federatedIdentities;
    @JsonProperty(value="federatedUsers")
    Boolean federatedUsers;
    @JsonProperty(value="olvidIsBot")
    Boolean olvidIsBot;
    @JsonProperty(value="isActivated")
    Boolean isActivated;
    @JsonProperty(value="apiKey")
    String apiKey;
    @JsonProperty(value="olvidIdentity")
    String olvidIdentity;
    @JsonProperty(value="LDAP_ENTRY_DN")
    String ldapEntryDn;

    public String getLdapEntryDn() {
        return this.ldapEntryDn;
    }

    public void setLdapEntryDn(String ldapEntryDn) {
        this.ldapEntryDn = ldapEntryDn;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getOlvidIdentity() {
        return this.olvidIdentity;
    }

    public void setOlvidIdentity(String olvidIdentity) {
        this.olvidIdentity = olvidIdentity;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getCredential() {
        return this.credential;
    }

    public void setCredential(Boolean credential) {
        this.credential = credential;
    }

    public Boolean getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public void setFederatedIdentities(Boolean federatedIdentities) {
        this.federatedIdentities = federatedIdentities;
    }

    public Boolean getFederatedUsers() {
        return this.federatedUsers;
    }

    public void setFederatedUsers(Boolean federatedUsers) {
        this.federatedUsers = federatedUsers;
    }

    public Boolean getOlvidIsBot() {
        return this.olvidIsBot;
    }

    public void setOlvidIsBot(Boolean olvidIsBot) {
        this.olvidIsBot = olvidIsBot;
    }

    public Boolean getIsActivated() {
        return this.isActivated;
    }

    public void setIsActivated(Boolean activated) {
        this.isActivated = activated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserModelAttributes that = (UserModelAttributes)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.username, that.username) && Objects.equals(this.credential, that.credential) && Objects.equals(this.federatedIdentities, that.federatedIdentities) && Objects.equals(this.federatedUsers, that.federatedUsers) && Objects.equals(this.olvidIsBot, that.olvidIsBot) && Objects.equals(this.isActivated, that.isActivated) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.olvidIdentity, that.olvidIdentity) && Objects.equals(this.ldapEntryDn, that.ldapEntryDn);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.username, this.credential, this.federatedIdentities, this.federatedUsers, this.olvidIsBot, this.isActivated, this.apiKey, this.olvidIdentity, this.ldapEntryDn);
    }

    public String toString() {
        return "UserModelAttributes{id='" + this.id + "', username='" + this.username + "', credential=" + this.credential + ", federatedIdentities=" + this.federatedIdentities + ", federatedUsers=" + this.federatedUsers + ", olvidIsBot=" + this.olvidIsBot + ", isActivated=" + this.isActivated + ", apiKey='" + this.apiKey + "', olvidIdentity='" + this.olvidIdentity + "', ldapEntryDn='" + this.ldapEntryDn + "'}";
    }

    public UserModelAttributes initUserModelAttributes(KeycloakSession session, RealmModel realmModel, UserModelAttributes olvidUser, UserModel user, String stringSearched) {
        if (user != null) {
            olvidUser.setUsername(user.getUsername());
            olvidUser.setId(user.getId());
            String identityString = Utils.getUserAttribute(user, "olvid-identity");
            if (identityString != null) {
                try {
                    Base64.getDecoder().decode(identityString);
                    olvidUser.setOlvidIdentity(identityString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            olvidUser.setIsActivated(false);
            if (olvidUser.getOlvidIdentity() != null) {
                olvidUser.setIsActivated(true);
            }
            try {
                olvidUser.setFederatedUsers(Utils.getUserAttribute(user, "LDAP_ID") != null || Utils.getUserAttribute(user, "KERBEROS_PRINCIPAL") != null);
            }
            catch (Exception e) {
                olvidUser.setFederatedUsers(false);
            }
            try {
                olvidUser.setFederatedIdentities(session.users().getFederatedIdentitiesStream(realmModel, user).findAny().isPresent());
            }
            catch (Exception e) {
                olvidUser.setFederatedIdentities(false);
            }
            olvidUser.setCredential(user.credentialManager().getStoredCredentialsByTypeStream("password").findAny().isPresent());
            olvidUser.setOlvidIsBot(Utils.isBotUser(user));
            olvidUser.setApiKey(Utils.getUserAttribute(user, "olvid-api-key"));
            olvidUser.setLdapEntryDn(stringSearched);
            return olvidUser;
        }
        return null;
    }
}

