/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.users;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.classes.models.groups.GroupUserModel;
import io.olvid.keycloak.jpa.OlvidCircleVisibility;
import io.olvid.keycloak.jpa.OlvidCircleVisibilityUser;
import io.olvid.keycloak.jpa.OlvidUserDevice;
import io.olvid.keycloak.rest.Utils;
import io.olvid.keycloak.rest.api.configuration.Configuration;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class CustomUserModel {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="firstname")
    String firstname;
    @JsonProperty(value="lastname")
    String lastname;
    @JsonProperty(value="fullname")
    String fullname;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="email")
    String email;
    @JsonProperty(value="position")
    String position;
    @JsonProperty(value="company")
    String company;
    @JsonProperty(value="credential")
    Boolean credential;
    @JsonProperty(value="federatedIdentities")
    Boolean federatedIdentities;
    @JsonProperty(value="federatedUsers")
    Boolean federatedUsers;
    @JsonProperty(value="userGroups")
    List<GroupUserModel> userGroups;
    @JsonProperty(value="isUserGroup")
    Boolean isUserGroup;
    @JsonProperty(value="countUserOlvidGroups")
    long countUserOlvidGroups;
    @JsonProperty(value="countUserOlvidGroupsFiltered")
    long countUserOlvidGroupsFiltered;
    @JsonProperty(value="fullSearchString")
    String fullSearchString;
    @JsonProperty(value="olvidIsBot")
    Boolean olvidIsBot;
    @JsonProperty(value="isActivated")
    Boolean isActivated;
    @JsonProperty(value="isWithoutOlvidPassword")
    Boolean isWithoutOlvidPassword;
    @JsonProperty(value="lastSync")
    Long lastSync;
    @JsonProperty(value="userDevices")
    List<OlvidUserDevice> userDevices;
    @JsonProperty(value="userDevicesKnown")
    List<OlvidUserDevice> userDevicesKnown;
    @JsonProperty(value="userDevicesUnKnown")
    List<OlvidUserDevice> userDevicesUnKnown;
    @JsonProperty(value="userDevicesActivated")
    List<OlvidUserDevice> userDevicesActivated;
    @JsonProperty(value="visibilityCircleName")
    String visibilityCircleName;
    @JsonProperty(value="visibilityCircleId")
    String visibilityCircleId;
    @JsonProperty(value="apiKey")
    String apiKey;
    @JsonProperty(value="invitationLink")
    String invitationLink;
    @JsonProperty(value="olvidIdentity")
    String olvidIdentity;
    @JsonIgnoreProperties
    @JsonProperty(value="_rowVariant")
    String _rowVariant;

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String firstname, String lastname) {
        this.fullname = firstname + " " + lastname;
    }

    public String getOlvidIdentity() {
        return this.olvidIdentity;
    }

    public void setOlvidIdentity(String olvidIdentity) {
        this.olvidIdentity = olvidIdentity;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Boolean getCredential() {
        return this.credential;
    }

    public void setCredential(Boolean credential) {
        this.credential = credential;
    }

    public Boolean getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public void setFederatedIdentities(Boolean federatedIdentities) {
        this.federatedIdentities = federatedIdentities;
    }

    public Boolean getFederatedUsers() {
        return this.federatedUsers;
    }

    public void setFederatedUsers(Boolean federatedUsers) {
        this.federatedUsers = federatedUsers;
    }

    public List<GroupUserModel> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(List<GroupUserModel> userGroups) {
        this.userGroups = userGroups;
    }

    public long getCountUserOlvidGroups() {
        return this.countUserOlvidGroups;
    }

    public void setCountUserOlvidGroups(long countUserOlvidGroups) {
        this.countUserOlvidGroups = countUserOlvidGroups;
    }

    public String getFullSearchString() {
        return this.fullSearchString;
    }

    public void setFullSearchString(String fullSearchString) {
        this.fullSearchString = fullSearchString;
    }

    public Boolean getOlvidIsBot() {
        return this.olvidIsBot;
    }

    public void setOlvidIsBot(Boolean olvidIsBot) {
        this.olvidIsBot = olvidIsBot;
    }

    public Long getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Long lastSync) {
        this.lastSync = lastSync;
    }

    public List<OlvidUserDevice> getUserDevices() {
        return this.userDevices;
    }

    public List<OlvidUserDevice> sortUserDevices() {
        Collections.sort(this.userDevices, Comparator.comparing(OlvidUserDevice::getDeviceUid));
        return this.userDevices;
    }

    public void setUserDevices(List<OlvidUserDevice> userDevices) {
        this.userDevices = userDevices;
    }

    public List<OlvidUserDevice> getUserDevicesKnown() {
        return this.userDevicesKnown;
    }

    public String getInvitationLink() {
        return this.invitationLink;
    }

    public void setInvitationLink(String invitationLink) {
        this.invitationLink = invitationLink;
    }

    public void setUserDevicesKnown(List<OlvidUserDevice> userDevicesKnown) {
        this.userDevicesKnown = userDevicesKnown;
    }

    public List<OlvidUserDevice> getUserDevicesUnKnown() {
        return this.userDevicesUnKnown;
    }

    public void setUserDevicesUnKnown(List<OlvidUserDevice> userDevicesUnKnown) {
        this.userDevicesUnKnown = userDevicesUnKnown;
    }

    public List<OlvidUserDevice> getUserDevicesActivated() {
        return this.userDevicesActivated;
    }

    public void setUserDevicesActivated(List<OlvidUserDevice> userDevicesActivated) {
        this.userDevicesActivated = userDevicesActivated;
    }

    public long getCountUserOlvidGroupsFiltered() {
        return this.countUserOlvidGroupsFiltered;
    }

    public Boolean getIsUserGroup() {
        return this.isUserGroup;
    }

    public void setIsUserGroup(Boolean isUserGroup) {
        this.isUserGroup = isUserGroup;
    }

    public Boolean getUserGroup() {
        return this.isUserGroup;
    }

    public void setUserGroup(Boolean userGroup) {
        this.isUserGroup = userGroup;
    }

    public Boolean getIsActivated() {
        return this.isActivated;
    }

    public void setIsActivated(Boolean isActivated) {
        this.isActivated = isActivated;
    }

    public String getVisibilityCircleName() {
        return this.visibilityCircleName;
    }

    public void setVisibilityCircleName(String visibilityCircleName) {
        this.visibilityCircleName = visibilityCircleName;
    }

    public String getVisibilityCircleId() {
        return this.visibilityCircleId;
    }

    public void setVisibilityCircleId(String visibilityCircleId) {
        this.visibilityCircleId = visibilityCircleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomUserModel that = (CustomUserModel)o;
        return this.countUserOlvidGroups == that.countUserOlvidGroups && this.countUserOlvidGroupsFiltered == that.countUserOlvidGroupsFiltered && Objects.equals(this.id, that.id) && Objects.equals(this.firstname, that.firstname) && Objects.equals(this.lastname, that.lastname) && Objects.equals(this.fullname, that.fullname) && Objects.equals(this.username, that.username) && Objects.equals(this.email, that.email) && Objects.equals(this.position, that.position) && Objects.equals(this.company, that.company) && Objects.equals(this.credential, that.credential) && Objects.equals(this.federatedIdentities, that.federatedIdentities) && Objects.equals(this.federatedUsers, that.federatedUsers) && Objects.equals(this.userGroups, that.userGroups) && Objects.equals(this.isUserGroup, that.isUserGroup) && Objects.equals(this.fullSearchString, that.fullSearchString) && Objects.equals(this.olvidIsBot, that.olvidIsBot) && Objects.equals(this.isActivated, that.isActivated) && Objects.equals(this.isWithoutOlvidPassword, that.isWithoutOlvidPassword) && Objects.equals(this.lastSync, that.lastSync) && Objects.equals(this.userDevices, that.userDevices) && Objects.equals(this.userDevicesKnown, that.userDevicesKnown) && Objects.equals(this.userDevicesUnKnown, that.userDevicesUnKnown) && Objects.equals(this.userDevicesActivated, that.userDevicesActivated) && Objects.equals(this.visibilityCircleName, that.visibilityCircleName) && Objects.equals(this.visibilityCircleId, that.visibilityCircleId) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.invitationLink, that.invitationLink) && Objects.equals(this.olvidIdentity, that.olvidIdentity) && Objects.equals(this._rowVariant, that._rowVariant);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstname, this.lastname, this.fullname, this.username, this.email, this.position, this.company, this.credential, this.federatedIdentities, this.federatedUsers, this.userGroups, this.isUserGroup, this.countUserOlvidGroups, this.countUserOlvidGroupsFiltered, this.fullSearchString, this.olvidIsBot, this.isActivated, this.isWithoutOlvidPassword, this.lastSync, this.userDevices, this.userDevicesKnown, this.userDevicesUnKnown, this.userDevicesActivated, this.visibilityCircleName, this.visibilityCircleId, this.apiKey, this.invitationLink, this.olvidIdentity, this._rowVariant);
    }

    public String toString() {
        return "CustomUserModel{id='" + this.id + "', firstname='" + this.firstname + "', lastname='" + this.lastname + "', fullname='" + this.fullname + "', username='" + this.username + "', email='" + this.email + "', position='" + this.position + "', company='" + this.company + "', credential=" + this.credential + ", federatedIdentities=" + this.federatedIdentities + ", federatedUsers=" + this.federatedUsers + ", userGroups=" + String.valueOf(this.userGroups) + ", isUserGroup=" + this.isUserGroup + ", countUserOlvidGroups=" + this.countUserOlvidGroups + ", countUserOlvidGroupsFiltered=" + this.countUserOlvidGroupsFiltered + ", fullSearchString='" + this.fullSearchString + "', olvidIsBot=" + this.olvidIsBot + ", isActivated=" + this.isActivated + ", isWithoutOlvidPassword=" + this.isWithoutOlvidPassword + ", lastSync=" + this.lastSync + ", userDevices=" + String.valueOf(this.userDevices) + ", userDevicesKnown=" + String.valueOf(this.userDevicesKnown) + ", userDevicesUnKnown=" + String.valueOf(this.userDevicesUnKnown) + ", userDevicesActivated=" + String.valueOf(this.userDevicesActivated) + ", visibilityCircleName='" + this.visibilityCircleName + "', visibilityCircleId='" + this.visibilityCircleId + "', apiKey='" + this.apiKey + "', invitationLink='" + this.invitationLink + "', olvidIdentity='" + this.olvidIdentity + "', _rowVariant='" + this._rowVariant + "'}";
    }

    public CustomUserModel initCustomUserModel(EntityManager em, KeycloakSession session, RealmModel realmModel, CustomUserModel olvidUser, UserModel user, OlvidCircleVisibility userOlvidCircleVisibility) {
        if (user != null) {
            try {
                olvidUser.setFirstname(Utils.emptyStringOrTrim(user.getFirstName()));
            }
            catch (Exception e) {
                olvidUser.setFirstname("");
            }
            try {
                olvidUser.setLastname(Utils.emptyStringOrTrim(user.getLastName()));
            }
            catch (Exception e) {
                olvidUser.setLastname("");
            }
            olvidUser.setFullname(olvidUser.getFirstname(), olvidUser.getLastname());
            olvidUser.setUsername(user.getUsername());
            olvidUser.setEmail(user.getEmail());
            olvidUser.setId(user.getId());
            olvidUser.setIsUserGroup(false);
            OlvidCircleVisibilityUser olvidCircleVisibilityUser = new OlvidCircleVisibilityUser();
            if (userOlvidCircleVisibility == null) {
                olvidCircleVisibilityUser = Configuration.getUserOlvidCircleVisibility(em, realmModel, this.id);
            } else {
                olvidCircleVisibilityUser.setCircleVisibilityId(userOlvidCircleVisibility.getId());
                olvidCircleVisibilityUser.setRealmId(userOlvidCircleVisibility.getRealmId());
                olvidCircleVisibilityUser.setUserId(user.getId());
                olvidCircleVisibilityUser.setId(userOlvidCircleVisibility.getId());
            }
            olvidUser.setVisibilityCircleId(olvidCircleVisibilityUser != null ? olvidCircleVisibilityUser.getCircleVisibilityId() : "default");
            OlvidCircleVisibility olvidCircleVisibility = new OlvidCircleVisibility();
            olvidCircleVisibility = userOlvidCircleVisibility == null ? Configuration.getOlvidCircleVisibility(em, realmModel, olvidCircleVisibilityUser.getCircleVisibilityId()) : userOlvidCircleVisibility;
            olvidUser.setVisibilityCircleName(olvidCircleVisibility != null ? olvidCircleVisibility.getName() : "Default Circle");
            try {
                olvidUser.setUserDevicesKnown(olvidUser.getUserDevices().stream().filter(OlvidUserDevice::getIsKnown).collect(Collectors.toList()));
            }
            catch (Exception e) {
                olvidUser.setUserDevicesKnown(new ArrayList<OlvidUserDevice>());
            }
            try {
                olvidUser.setUserDevicesUnKnown(olvidUser.getUserDevices().stream().filter(device -> device.getIsKnown() == false).collect(Collectors.toList()));
            }
            catch (Exception e) {
                olvidUser.setUserDevicesUnKnown(new ArrayList<OlvidUserDevice>());
            }
            try {
                olvidUser.setUserDevicesActivated(olvidUser.getUserDevices().stream().filter(device -> device.getIsActive() == false).collect(Collectors.toList()));
            }
            catch (Exception e) {
                olvidUser.setUserDevicesActivated(new ArrayList<OlvidUserDevice>());
            }
            if (olvidUser.getEmail() == null) {
                olvidUser.setEmail("");
            }
            olvidUser.setPosition(Utils.getUserAttribute(user, "olvid-position"));
            olvidUser.setCompany(Utils.getUserAttribute(user, "olvid-company"));
            olvidUser.setApiKey(Utils.getUserAttribute(user, "olvid-api-key"));
            String identityString = Utils.getUserAttribute(user, "olvid-identity");
            if (identityString != null) {
                try {
                    Base64.getDecoder().decode(identityString);
                    olvidUser.setOlvidIdentity(identityString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            olvidUser.setIsActivated(false);
            if (olvidUser.getOlvidIdentity() != null) {
                olvidUser.setIsActivated(true);
            }
            olvidUser.setFederatedUsers(Utils.getUserAttribute(user, "LDAP_ID") != null || Utils.getUserAttribute(user, "KERBEROS_PRINCIPAL") != null);
            olvidUser.setCredential(user.credentialManager().getStoredCredentialsByTypeStream("password").findAny().isPresent());
            olvidUser.setFederatedIdentities(session.users().getFederatedIdentitiesStream(realmModel, user).findAny().isPresent());
            try {
                olvidUser.setCountUserOlvidGroups(olvidUser.getUserGroups().stream().filter(group -> group.olvidGroup).count());
            }
            catch (Exception e) {
                olvidUser.setCountUserOlvidGroups(0L);
            }
            olvidUser.setFullSearchString(Utils.unAccent((olvidUser.getFirstname() == null ? "" : olvidUser.getFirstname()) + " " + (olvidUser.getLastname() == null ? "" : olvidUser.getLastname()) + " " + (olvidUser.getPosition() == null ? "" : olvidUser.getPosition()) + " " + (olvidUser.getCompany() == null ? "" : olvidUser.getCompany())));
            olvidUser.setOlvidIsBot(Utils.isBotUser(user));
            return olvidUser;
        }
        return null;
    }
}

