/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.keycloak.classes.models.users;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.keycloak.rest.Utils;
import java.util.Objects;
import org.keycloak.models.jpa.entities.UserEntity;

public class CustomUserBasicModel {
    @JsonProperty(value="firstname")
    String firstname;
    @JsonProperty(value="lastname")
    String lastname;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="fullname")
    String fullname;
    @JsonProperty(value="email")
    String email;
    @JsonProperty(value="position")
    String position;
    @JsonProperty(value="company")
    String company;

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String firstname, String lastname) {
        this.fullname = firstname + " " + lastname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomUserBasicModel that = (CustomUserBasicModel)o;
        return Objects.equals(this.firstname, that.firstname) && Objects.equals(this.lastname, that.lastname) && Objects.equals(this.username, that.username) && Objects.equals(this.fullname, that.fullname) && Objects.equals(this.email, that.email) && Objects.equals(this.position, that.position) && Objects.equals(this.company, that.company);
    }

    public int hashCode() {
        return Objects.hash(this.firstname, this.lastname, this.username, this.fullname, this.email, this.position, this.company);
    }

    public String toString() {
        return "CustomUserBasicModel{firstname='" + this.firstname + "', lastname='" + this.lastname + "', username='" + this.username + "', fullname='" + this.fullname + "', email='" + this.email + "', position='" + this.position + "', company='" + this.company + "'}";
    }

    public CustomUserBasicModel initCustomUserBasicModel(UserEntity user) {
        CustomUserBasicModel olvidUser = new CustomUserBasicModel();
        if (user != null) {
            try {
                olvidUser.setFirstname(Utils.emptyStringOrTrim(user.getFirstName()));
            }
            catch (Exception e) {
                olvidUser.setFirstname("");
            }
            try {
                olvidUser.setLastname(Utils.emptyStringOrTrim(user.getLastName()));
            }
            catch (Exception e) {
                olvidUser.setLastname("");
            }
            olvidUser.setFullname(user.getFirstName(), user.getLastName());
            olvidUser.setUsername(user.getUsername());
            olvidUser.setEmail(user.getEmail());
            if (olvidUser.getEmail() == null) {
                olvidUser.setEmail("");
            }
            return olvidUser;
        }
        return null;
    }
}

